/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BigIntegerValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import java.math.BigInteger;
import java.util.Iterator;

public class MathModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(MathModule.class);
    public static final double M_PI = Math.PI;
    public static final double M_E = Math.E;
    public static final long RAND_MAX = Integer.MAX_VALUE;
    public static final double M_LOG2E = MathModule.log2(Math.E);
    public static final double M_LOG10E = Math.log10(Math.E);
    public static final double M_LN2 = Math.log(2.0);
    public static final double M_LN10 = Math.log(10.0);
    public static final double M_PI_2 = 1.5707963267948966;
    public static final double M_PI_4 = 0.7853981633974483;
    public static final double M_1_PI = 0.3183098861837907;
    public static final double M_2_PI = 0.6366197723675814;
    public static final double M_SQRTPI = Math.sqrt(Math.PI);
    public static final double M_2_SQRTPI = 2.0 / Math.sqrt(Math.PI);
    public static final double M_SQRT2 = Math.sqrt(2.0);
    public static final double M_SQRT3 = Math.sqrt(3.0);
    public static final double M_SQRT1_2 = 1.0 / Math.sqrt(2.0);
    public static final double M_LNPI = Math.log(Math.PI);
    public static final double M_EULER = 0.5772156649015329;

    private static double log2(double v) {
        return Math.log(v) / Math.log(2.0);
    }

    public static Value abs(Value value) {
        if (value.getValueType().isDoubleCmp()) {
            return DoubleValue.create(Math.abs(value.toDouble()));
        }
        return LongValue.create(Math.abs(value.toLong()));
    }

    public static double acos(double value) {
        return Math.acos(value);
    }

    public static double acosh(Env env, double value) {
        return Math.log(value + Math.sqrt(value * value - 1.0));
    }

    public static Value asin(Value value) {
        return new DoubleValue(Math.asin(value.toDouble()));
    }

    public static double asinh(double value) {
        return Math.log(value + Math.sqrt(value * value + 1.0));
    }

    public static double atan2(double yV, double xV) {
        return Math.atan2(yV, xV);
    }

    public static double atan(double value) {
        return Math.atan(value);
    }

    public static double atanh(double value) {
        return 0.5 * Math.log((1.0 + value) / (1.0 - value));
    }

    private static Value baseToValue(Env env, String number, int base) {
        boolean isLong = true;
        long cutoff = Long.MAX_VALUE / (long)base;
        long cutlim = Long.MAX_VALUE % (long)base;
        long num = 0L;
        BigInteger bigNum = null;
        BigInteger bigBase = BigInteger.valueOf(base);
        int len = number.length();
        for (int i = 0; i < len; ++i) {
            int value;
            char ch = number.charAt(i);
            if ('0' <= ch && ch <= '9') {
                value = ch - 48;
            } else if ('a' <= ch && ch <= 'z') {
                value = ch - 97 + 10;
            } else {
                if ('A' > ch || ch > 'Z') continue;
                value = ch - 65 + 10;
            }
            if (value >= base) continue;
            if (isLong) {
                if (num < cutoff || num == cutoff && (long)value <= cutlim) {
                    num = num * (long)base + (long)value;
                } else {
                    bigNum = BigInteger.valueOf(num);
                    isLong = false;
                }
            }
            if (isLong) continue;
            BigInteger tmp = bigNum.multiply(bigBase);
            BigInteger bigValue = BigInteger.valueOf(value);
            bigNum = tmp.add(bigValue);
        }
        if (!isLong) {
            JavaClassDef jClassDef = env.getJavaClassDefinition(BigInteger.class);
            if (jClassDef == null) {
                throw new NullPointerException("jClassDef returned by getJavaClassDefinition() is null");
            }
            return new BigIntegerValue(env, bigNum, jClassDef);
        }
        return LongValue.create(num);
    }

    private static StringValue valueToBase(Env env, Value value, int base) {
        if (value instanceof BigIntegerValue) {
            return MathModule.valueToBase(env, (BigIntegerValue)value, base);
        }
        if (value instanceof LongValue) {
            return MathModule.valueToBase(env, (LongValue)value, base);
        }
        return env.getEmptyString();
    }

    private static StringValue valueToBase(Env env, LongValue value, int base) {
        long val = value.toLong();
        if (val == 0L) {
            return env.createString("0");
        }
        StringBuilder sb = new StringBuilder();
        if (val < 0L) {
            val = -val;
        }
        do {
            int d = (int)(val % (long)base);
            val /= (long)base;
            if (d < 10) {
                sb.append((char)(d + 48));
                continue;
            }
            sb.append((char)(d - 10 + 97));
        } while (val != 0L);
        sb.reverse();
        return env.createString(sb.toString());
    }

    private static StringValue valueToBase(Env env, BigIntegerValue value, int base) {
        BigInteger bigNum = value.toBigInteger();
        BigInteger bigZero = BigInteger.valueOf(0L);
        BigInteger bigBase = BigInteger.valueOf(base);
        if (bigNum.equals(bigZero)) {
            return env.createString("0.0");
        }
        StringBuilder sb = new StringBuilder();
        if (bigNum.compareTo(bigZero) < 0) {
            bigNum = bigNum.negate();
        }
        do {
            BigInteger bigD = bigNum.mod(bigBase);
            int d = bigD.intValue();
            bigNum = bigNum.divide(bigBase);
            if (d < 10) {
                sb.append((char)(d + 48));
                continue;
            }
            sb.append((char)(d - 10 + 97));
        } while (bigNum.compareTo(bigZero) != 0);
        sb.reverse();
        return env.createString(sb.toString());
    }

    private static StringValue valueToBase2(Env env, long value) {
        if (value == 0L) {
            return env.createString("0");
        }
        StringBuilder sb = new StringBuilder();
        if (value < 0L) {
            value = -value;
        }
        do {
            int d = (int)(value & 1L);
            sb.append(d == 0 ? (char)'0' : '1');
        } while ((value >>= 1) != 0L);
        sb.reverse();
        return env.createString(sb.toString());
    }

    private static StringValue valueToBase8(Env env, long value) {
        if (value == 0L) {
            return env.createString("0");
        }
        StringBuilder sb = new StringBuilder();
        if (value < 0L) {
            value = -value;
        }
        do {
            int d = (int)(value & 7L);
            sb.append((char)(d + 48));
        } while ((value >>= 3) != 0L);
        sb.reverse();
        return env.createString(sb.toString());
    }

    private static StringValue valueToBase16(Env env, long value) {
        if (value == 0L) {
            return env.createString("0");
        }
        StringBuilder sb = new StringBuilder();
        if (value < 0L) {
            value = -value;
        }
        do {
            int d = (int)(value & 0xFL);
            value >>= 4;
            if (d < 10) {
                sb.append((char)(d + 48));
                continue;
            }
            sb.append((char)(d + 97 - 10));
        } while (value != 0L);
        sb.reverse();
        return env.createString(sb.toString());
    }

    public static Value base_convert(Env env, StringValue number, int fromBase, int toBase) {
        if (fromBase < 2 || fromBase > 36) {
            env.warning(L.l("invalid `{0}' ({1})", (Object)"from base", fromBase));
            return BooleanValue.FALSE;
        }
        if (toBase < 2 || toBase > 36) {
            env.warning(L.l("invalid `{0}' ({1})", (Object)"to base", toBase));
            return BooleanValue.FALSE;
        }
        Value val = MathModule.baseToValue(env, number.toString(), fromBase);
        return MathModule.valueToBase(env, val, toBase);
    }

    public static Value bindec(Env env, StringValue bin) {
        return MathModule.baseToValue(env, bin.toString(), 2);
    }

    public static double ceil(double value) {
        return Math.ceil(value);
    }

    public static double cos(double value) {
        return Math.cos(value);
    }

    public static double cosh(double value) {
        return Math.cosh(value);
    }

    public static StringValue decbin(Env env, long value) {
        return MathModule.valueToBase2(env, value);
    }

    public static StringValue dechex(Env env, long value) {
        return MathModule.valueToBase16(env, value);
    }

    public static StringValue decoct(Env env, long value) {
        return MathModule.valueToBase8(env, value);
    }

    public static double deg2rad(double value) {
        return value * Math.PI / 180.0;
    }

    public static Value exp(Value value) {
        return new DoubleValue(Math.exp(value.toDouble()));
    }

    public static Value expm1(Value value) {
        return new DoubleValue(Math.expm1(value.toDouble()));
    }

    public static Value floor(Value value) {
        return new DoubleValue(Math.floor(value.toDouble()));
    }

    public static double fmod(double xV, double yV) {
        return Math.IEEEremainder(xV, yV);
    }

    public static Value hexdec(Env env, StringValue s) {
        return MathModule.baseToValue(env, s.toString(), 16);
    }

    public static double hypot(double a, double b) {
        return Math.hypot(a, b);
    }

    public static boolean is_finite(Value value) {
        if (value instanceof LongValue) {
            return true;
        }
        if (value instanceof DoubleValue) {
            double v = value.toDouble();
            return !Double.isInfinite(v);
        }
        return false;
    }

    public static Value is_infinite(Value value) {
        if (value instanceof LongValue) {
            return BooleanValue.FALSE;
        }
        if (value instanceof DoubleValue) {
            double v = value.toDouble();
            return Double.isInfinite(v) ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        return BooleanValue.FALSE;
    }

    public static Value is_nan(Value value) {
        if (value instanceof LongValue) {
            return BooleanValue.FALSE;
        }
        if (value instanceof DoubleValue) {
            double v = value.toDouble();
            return Double.isNaN(v) ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        return BooleanValue.FALSE;
    }

    public static double log(double value) {
        return Math.log(value);
    }

    public static double log10(double value) {
        return Math.log10(value);
    }

    public static double log1p(double value) {
        return Math.log1p(value);
    }

    public static Value getrandmax() {
        return MathModule.mt_getrandmax();
    }

    public static Value max(Env env, Value[] args) {
        if (args.length == 1 && args[0] instanceof ArrayValue) {
            Value array = args[0];
            Value max = NullValue.NULL;
            double maxValue = Double.MIN_VALUE;
            Iterator<Value> iter = array.getValueIterator(env);
            while (iter.hasNext()) {
                Value value = iter.next();
                double dValue = value.toDouble();
                if (!(maxValue < dValue)) continue;
                maxValue = dValue;
                max = value;
            }
            return max;
        }
        double maxValue = -1.7976931348623157E308;
        Value max = NullValue.NULL;
        for (int i = 0; i < args.length; ++i) {
            double value = args[i].toDouble();
            if (!(maxValue < value)) continue;
            maxValue = value;
            max = args[i];
        }
        return max;
    }

    public static Value min(Env env, Value[] args) {
        if (args.length == 1 && args[0] instanceof ArrayValue) {
            Value array = args[0];
            Value min = NullValue.NULL;
            double minValue = Double.MAX_VALUE;
            Iterator<Value> iter = array.getValueIterator(env);
            while (iter.hasNext()) {
                Value value = iter.next();
                double dValue = value.toDouble();
                if (!(dValue < minValue)) continue;
                minValue = dValue;
                min = value;
            }
            return min;
        }
        double minValue = Double.MAX_VALUE;
        Value min = NullValue.NULL;
        for (int i = 0; i < args.length; ++i) {
            double value = args[i].toDouble();
            if (!(value < minValue)) continue;
            minValue = value;
            min = args[i];
        }
        return min;
    }

    public static Value mt_getrandmax() {
        return new LongValue(Integer.MAX_VALUE);
    }

    public static long mt_rand(@Optional(value="0") long min, @Optional(value="RAND_MAX") long max) {
        long range = max - min + 1L;
        if (range <= 0L) {
            return min;
        }
        long value = RandomUtil.getRandomLong();
        if (value < 0L) {
            value = -value;
        }
        return min + value % range;
    }

    public static Value mt_srand(@Optional long seed) {
        return NullValue.NULL;
    }

    public static Value octdec(Env env, StringValue oct) {
        return MathModule.baseToValue(env, oct.toString(), 8);
    }

    public static double pi() {
        return Math.PI;
    }

    public static double pow(double base, double exp) {
        return Math.pow(base, exp);
    }

    public static double rad2deg(double value) {
        return 180.0 * value / Math.PI;
    }

    public static long rand(@Optional int min, @Optional(value="RAND_MAX") int max) {
        return MathModule.mt_rand(min, max);
    }

    public static double round(double value, @Optional int precision) {
        if (precision > 0) {
            double exp = Math.pow(10.0, precision);
            return (double)Math.round(value * exp) / exp;
        }
        return Math.round(value);
    }

    public static double sin(double value) {
        return Math.sin(value);
    }

    public static Value sinh(Value value) {
        return new DoubleValue(Math.sinh(value.toDouble()));
    }

    public static double sqrt(double value) {
        return Math.sqrt(value);
    }

    public static Value srand(@Optional long seed) {
        return NullValue.NULL;
    }

    public static double tan(double value) {
        return Math.tan(value);
    }

    public static double tanh(double value) {
        return Math.tanh(value);
    }
}

