/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcColumnMetaData;
import com.caucho.quercus.lib.db.JdbcConnectionResource;
import com.caucho.quercus.lib.db.JdbcTableMetaData;
import com.caucho.quercus.lib.db.Mysqli;
import com.caucho.quercus.lib.db.MysqliResult;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MysqlModule
extends AbstractQuercusModule {
    private static final Logger log = Log.open(MysqlModule.class);
    private static final L10N L = new L10N(MysqlModule.class);
    public static final int MYSQL_ASSOC = 1;
    public static final int MYSQL_NUM = 2;
    public static final int MYSQL_BOTH = 3;
    public static final int MYSQL_USE_RESULT = 0;
    public static final int MYSQL_STORE_RESULT = 1;

    public String[] getLoadedExtensions() {
        return new String[]{"mysql"};
    }

    public static int mysql_affected_rows(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        return conn.affected_rows();
    }

    public static Value mysql_info(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        return conn.info(env);
    }

    public static boolean mysql_change_user(Env env, StringValue user, StringValue pass, @Optional StringValue database, @Optional Mysqli conn) {
        return false;
    }

    public static StringValue mysql_client_encoding(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        return conn.client_encoding(env);
    }

    public static boolean mysql_close(Env env, @Optional Mysqli conn) {
        boolean isEnvConn = false;
        if (conn == null) {
            conn = (Mysqli)env.getSpecialValue("caucho.mysql");
            isEnvConn = true;
        }
        if (conn == null) {
            env.warning(L.l("no MySQL-Link resource supplied"));
            return false;
        }
        if (isEnvConn || env.getSpecialValue("caucho.mysql") != null) {
            env.removeSpecialValue("caucho.mysql");
        }
        if (conn.isConnected()) {
            conn.close(env);
            return true;
        }
        env.warning(L.l("connection is either not connected or is already closed"));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean mysql_create_db(Env env, @NotNull StringValue name, @Optional Mysqli conn) {
        if (name.length() == 0) {
            return false;
        }
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        Statement stmt = null;
        try {
            try {
                Connection sqlConn = conn.validateConnection().getConnection(env);
                if (sqlConn == null) {
                    boolean bl = false;
                    return bl;
                }
                stmt = sqlConn.createStatement();
                stmt.setEscapeProcessing(false);
                stmt.executeUpdate("CREATE DATABASE " + name.toString());
                return true;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public static boolean mysql_data_seek(Env env, @NotNull MysqliResult result, int rowNumber) {
        if (result == null) {
            return false;
        }
        if (result.seek(env, rowNumber)) {
            return true;
        }
        env.warning(L.l("Offset {0} is invalid for MySQL (or the query data is unbuffered)", (long)rowNumber));
        return false;
    }

    public static Value mysql_db_name(Env env, @NotNull MysqliResult result, int row, @Optional(value="0") Value field) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return MysqlModule.mysql_result(env, result, row, field);
    }

    public static Value mysql_dbname(Env env, @NotNull MysqliResult result, int row) {
        return MysqlModule.mysql_db_name(env, result, row, env.createString("0"));
    }

    public static Value mysql_result(Env env, @NotNull MysqliResult result, int row, @Optional(value="0") Value field) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return result.getResultField(env, row, field);
    }

    public static boolean mysql_drop_db(Env env, @NotNull StringValue databaseName, @Optional Mysqli conn) {
        if (databaseName.length() == 0) {
            return false;
        }
        Value value = MysqlModule.mysql_query(env, env.createString("DROP DATABASE " + databaseName), conn);
        return value != null && value.toBoolean();
    }

    public static boolean mysql_dropdb(Env env, @NotNull StringValue databaseName, @Optional Mysqli conn) {
        return MysqlModule.mysql_drop_db(env, databaseName, conn);
    }

    public static int mysql_errno(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        StringValue error = conn.error(env);
        int errno = conn.errno();
        if (errno != 0) {
            return errno;
        }
        if (error.length() != 0) {
            return 2006;
        }
        return 0;
    }

    public static StringValue mysql_error(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        return conn.error(env);
    }

    public static StringValue mysql_escape_string(Env env, Value val) {
        StringValue unescapedString = val.toStringValue();
        StringValue sb = unescapedString.createStringBuilder();
        int len = unescapedString.length();
        block9: for (int i = 0; i < len; ++i) {
            char ch = unescapedString.charAt(i);
            switch (ch) {
                case '\u0000': {
                    sb.append('\\');
                    sb.append(0L);
                    continue block9;
                }
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    continue block9;
                }
                case '\r': {
                    sb.append('\\');
                    sb.append('r');
                    continue block9;
                }
                case '\\': {
                    sb.append('\\');
                    sb.append('\\');
                    continue block9;
                }
                case '\'': {
                    sb.append('\\');
                    sb.append('\'');
                    continue block9;
                }
                case '\"': {
                    sb.append('\\');
                    sb.append('\"');
                    continue block9;
                }
                case '\u001a': {
                    sb.append('\\');
                    sb.append('Z');
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb;
    }

    public static StringValue mysql_real_escape_string(Env env, Value val, @Optional Mysqli conn) {
        StringValue unescapedString = val.toStringValue();
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        return conn.real_escape_string(unescapedString);
    }

    public static Value mysql_fetch_array(Env env, @NotNull MysqliResult result, @Optional(value="MYSQL_BOTH") int type) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        ArrayValue value = result.fetch_array(env, type);
        if (value != null) {
            return value;
        }
        return BooleanValue.FALSE;
    }

    @ReturnNullAsFalse
    public static ArrayValue mysql_fetch_assoc(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return null;
        }
        return result.fetch_array(env, 1);
    }

    public static Value mysql_fetch_field(Env env, @NotNull MysqliResult result, @Optional(value="-1") int fieldOffset) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        try {
            int unsigned;
            ResultSetMetaData md;
            if (fieldOffset == -1) {
                fieldOffset = result.field_tell(env);
                result.setFieldOffset(fieldOffset + 1);
            }
            if ((md = result.getMetaData()).getColumnCount() <= fieldOffset || fieldOffset < 0) {
                return BooleanValue.FALSE;
            }
            int jdbcField = fieldOffset + 1;
            int jdbcColumnType = md.getColumnType(jdbcField);
            String catalogName = md.getCatalogName(jdbcField);
            String tableName = md.getTableName(jdbcField);
            String schemaName = md.getSchemaName(jdbcField);
            String columnName = md.getColumnName(jdbcField);
            String columnLabel = md.getColumnLabel(jdbcField);
            if (schemaName == null || "".equals(schemaName)) {
                schemaName = tableName;
            }
            if ((tableName == null || "".equals(tableName)) && result.isLastSqlDescribe()) {
                tableName = "COLUMNS";
            }
            JdbcColumnMetaData columnMd = null;
            JdbcConnectionResource conn = MysqlModule.getConnection(env).validateConnection();
            JdbcTableMetaData tableMd = conn.getTableMetaData(catalogName, null, tableName);
            if (tableMd != null) {
                columnMd = tableMd.getColumn(columnName);
            }
            int maxLength = 0;
            int notNull = md.isNullable(jdbcField) == 1 ? 0 : 1;
            int numeric = JdbcColumnMetaData.isNumeric(jdbcColumnType) ? 1 : 0;
            int blob = JdbcColumnMetaData.isBlob(jdbcColumnType) ? 1 : 0;
            String type = result.getFieldType(fieldOffset, jdbcColumnType);
            int n = unsigned = md.isSigned(jdbcField) ? 0 : numeric;
            if (jdbcColumnType == 16 || jdbcColumnType == -7) {
                unsigned = 0;
            } else if (jdbcColumnType == 3) {
                numeric = 1;
            }
            int zerofill = 0;
            int primaryKey = 0;
            int multipleKey = 0;
            int uniqueKey = 0;
            if (columnMd != null) {
                zerofill = columnMd.isZeroFill() ? 1 : 0;
                primaryKey = columnMd.isPrimaryKey() ? 1 : 0;
                uniqueKey = columnMd.isUnique() ? 1 : 0;
            } else {
                notNull = 1;
            }
            ObjectValue fieldResult = env.createObject();
            fieldResult.putField(env, "name", columnLabel);
            fieldResult.putField(env, "table", tableName);
            fieldResult.putField(env, "def", "");
            fieldResult.putField(env, "max_length", maxLength);
            fieldResult.putField(env, "not_null", notNull);
            fieldResult.putField(env, "primary_key", primaryKey);
            fieldResult.putField(env, "multiple_key", multipleKey);
            fieldResult.putField(env, "unique_key", uniqueKey);
            fieldResult.putField(env, "numeric", numeric);
            fieldResult.putField(env, "blob", blob);
            fieldResult.putField(env, "type", type);
            fieldResult.putField(env, "unsigned", unsigned);
            fieldResult.putField(env, "zerofill", zerofill);
            return fieldResult;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public static Value mysql_query(Env env, StringValue sql, @Optional Mysqli conn) {
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        return conn.query(env, sql, 1);
    }

    public static Value mysql_fetch_lengths(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return result.fetch_lengths();
    }

    public static Value mysql_fetch_object(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        Value value = result.fetch_object(env);
        if (value.isNull()) {
            value = BooleanValue.FALSE;
        }
        return value;
    }

    @ReturnNullAsFalse
    public static ArrayValue mysql_fetch_row(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return null;
        }
        return result.fetch_row(env);
    }

    public static Value mysql_field_flags(Env env, @NotNull MysqliResult result, int fieldOffset) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        Value fieldName = result.getFieldName(env, fieldOffset);
        if (fieldName == BooleanValue.FALSE) {
            return BooleanValue.FALSE;
        }
        Value fieldTable = result.getFieldTable(env, fieldOffset);
        Value fieldJdbcType = result.getJdbcType(fieldOffset);
        String fieldMysqlType = result.getMysqlType(fieldOffset);
        if (fieldTable == BooleanValue.FALSE || fieldJdbcType == BooleanValue.FALSE || fieldMysqlType == null) {
            return BooleanValue.FALSE;
        }
        String sql = "SHOW FULL COLUMNS FROM " + fieldTable.toString() + " LIKE '" + fieldName.toString() + "'";
        Mysqli conn = MysqlModule.getConnection(env);
        Value resultV = conn.validateConnection().realQuery(env, sql);
        Object metaResult = resultV.toJavaObject();
        if (metaResult instanceof MysqliResult) {
            return ((MysqliResult)metaResult).getFieldFlagsImproved(env, fieldJdbcType.toInt(), fieldMysqlType);
        }
        return BooleanValue.FALSE;
    }

    public static Value mysql_field_name(Env env, @NotNull MysqliResult result, int fieldOffset) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return result.getFieldName(env, fieldOffset);
    }

    public static Value mysql_fieldname(Env env, @NotNull MysqliResult result, int fieldOffset) {
        return MysqlModule.mysql_field_name(env, result, fieldOffset);
    }

    public static boolean mysql_field_seek(Env env, @NotNull MysqliResult result, int fieldOffset) {
        if (result == null) {
            return false;
        }
        return result.field_seek(env, fieldOffset);
    }

    public static Value mysql_field_table(Env env, @NotNull MysqliResult result, int fieldOffset) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return result.getFieldTable(env, fieldOffset);
    }

    public static Value mysql_fieldtable(Env env, @NotNull MysqliResult result, int fieldOffset) {
        return MysqlModule.mysql_field_table(env, result, fieldOffset);
    }

    public static Value mysql_field_type(Env env, @NotNull MysqliResult result, Value fieldOffset) {
        if (result == null) {
            return NullValue.NULL;
        }
        if (!fieldOffset.isset()) {
            return NullValue.NULL;
        }
        return result.getFieldType(env, fieldOffset.toInt());
    }

    public static Value mysql_fieldtype(Env env, @NotNull MysqliResult result, Value fieldOffset) {
        return MysqlModule.mysql_field_type(env, result, fieldOffset);
    }

    public static Value mysql_field_len(Env env, @NotNull MysqliResult result, @Optional(value="0") int fieldOffset) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return result.getFieldLength(env, fieldOffset);
    }

    public static boolean mysql_free_result(@NotNull MysqliResult result) {
        if (result == null) {
            return false;
        }
        result.close();
        return true;
    }

    public static boolean mysql_freeresult(@NotNull MysqliResult result) {
        return MysqlModule.mysql_free_result(result);
    }

    public static StringValue mysql_get_client_info(Env env) {
        return Mysqli.getClientInfo(env);
    }

    public static StringValue mysql_get_host_info(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        return conn.get_host_info(env);
    }

    public static int mysql_get_proto_info(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        return conn.get_proto_info();
    }

    public static Value mysql_get_server_info(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        if (conn != null && conn.isConnected()) {
            return conn.get_server_info(env);
        }
        return NullValue.NULL;
    }

    public static Value mysql_insert_id(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        return conn.insert_id(env);
    }

    public static Value mysql_list_dbs(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        return MysqlModule.mysql_query(env, env.createString("SELECT SCHEMA_NAME AS 'Database' FROM information_schema.SCHEMATA"), conn);
    }

    public static Value mysql_list_fields(Env env, String database, StringValue tableName, @Optional Mysqli conn) {
        if (database == null || database.length() == 0) {
            return BooleanValue.FALSE;
        }
        if (tableName.length() == 0) {
            return BooleanValue.FALSE;
        }
        return MysqlModule.mysql_db_query(env, database, env.createString("SELECT * FROM " + tableName + " WHERE NULL"), conn);
    }

    public static Value mysql_listfields(Env env, String databaseName, StringValue tableName, @Optional Mysqli conn) {
        return MysqlModule.mysql_list_fields(env, databaseName, tableName, conn);
    }

    public static Value mysql_db_query(Env env, String databaseName, StringValue query, @Optional Mysqli conn) {
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        if (!conn.select_db(databaseName)) {
            return BooleanValue.FALSE;
        }
        return conn.query(env, query, 1);
    }

    public static boolean mysql_select_db(Env env, String dbName, @Optional Mysqli conn) {
        if (dbName == null || dbName.length() == 0) {
            return false;
        }
        if (conn == null) {
            return MysqlModule.getConnection(env, dbName).select_db(dbName);
        }
        return conn.select_db(dbName);
    }

    public static Object mysql_list_tables(Env env, StringValue databaseName, @Optional Mysqli conn) {
        return MysqlModule.mysql_query(env, env.createString("SHOW TABLES FROM " + databaseName), conn);
    }

    public static Value mysql_num_fields(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(result.num_fields());
    }

    public static Value mysql_numfields(Env env, @NotNull MysqliResult result) {
        return MysqlModule.mysql_num_fields(env, result);
    }

    public static Value mysql_num_rows(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(result.num_rows());
    }

    public static Value mysql_numrows(Env env, @NotNull MysqliResult result) {
        return MysqlModule.mysql_num_rows(env, result);
    }

    public static Value mysql_pconnect(Env env, @Optional StringValue server, @Optional StringValue user, @Optional StringValue password, @Optional boolean newLink, @Optional int flags) {
        Value value = MysqlModule.mysql_connect(env, server, user, password, newLink, flags);
        Mysqli conn = (Mysqli)env.getSpecialValue("caucho.mysql");
        if (conn != null && conn.isConnected()) {
            conn.setPersistent();
        }
        return value;
    }

    public static Value mysql_connect(Env env, @Optional StringValue host, @Optional StringValue userName, @Optional StringValue password, @Optional boolean isNewLink, @Optional int flags) {
        Mysqli mysqli;
        int sepIndex;
        int port = 3306;
        String socketStr = "";
        String hostStr = host.toString();
        int length = host.length();
        if (length == 0 && (hostStr = env.getIniString("mysql.default_host")) == null) {
            hostStr = "localhost";
        }
        if ((sepIndex = hostStr.indexOf(58)) > -1) {
            String tmp = hostStr;
            if ((hostStr = tmp.substring(0, sepIndex)).length() == 0) {
                hostStr = "localhost";
            }
            if ((tmp = tmp.substring(++sepIndex)).length() > 0 && tmp.charAt(0) != '/') {
                String portStr;
                sepIndex = tmp.indexOf(58);
                if (sepIndex > -1) {
                    portStr = tmp.substring(0, sepIndex);
                    socketStr = tmp.substring(++sepIndex);
                } else {
                    portStr = tmp;
                }
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException ex) {}
            } else {
                socketStr = tmp;
            }
        }
        if (!(mysqli = new Mysqli(env, hostStr, userName.toString(), password.toString(), "", port, socketStr, flags, null, null, isNewLink)).isConnected()) {
            return BooleanValue.FALSE;
        }
        Value value = env.wrapJava(mysqli);
        env.setSpecialValue("caucho.mysql", mysqli);
        return value;
    }

    public static boolean mysql_ping(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        return conn.ping(env);
    }

    public static Value mysql_stat(Env env, @Optional Mysqli conn) {
        Value result;
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        return (result = conn.stat(env)) == BooleanValue.FALSE ? NullValue.NULL : result;
    }

    public static Value mysql_tablename(Env env, @NotNull MysqliResult result, int i) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return result.getResultField(env, i, LongValue.ZERO);
    }

    public static Object mysql_unbuffered_query(Env env, @NotNull StringValue name, @Optional Mysqli conn) {
        return MysqlModule.mysql_query(env, name, conn);
    }

    public static Value mysql_thread_id(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = MysqlModule.getConnection(env);
        }
        return conn.thread_id(env);
    }

    private static Mysqli getConnection(Env env) {
        return MysqlModule.getConnection(env, "");
    }

    private static Mysqli getConnection(Env env, String db) {
        Mysqli conn = (Mysqli)env.getSpecialValue("caucho.mysql");
        if (conn != null) {
            return conn;
        }
        conn = new Mysqli(env, env.getEmptyString(), env.getEmptyString(), env.getEmptyString(), db, 3306, env.getEmptyString());
        env.setSpecialValue("caucho.mysql", conn);
        return conn;
    }
}

