/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.gettext;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.gettext.GettextDomain;
import com.caucho.quercus.lib.gettext.GettextDomainMap;
import com.caucho.quercus.lib.gettext.GettextResource;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Logger;

public class GettextModule
extends AbstractQuercusModule {
    private LruCache<Object, GettextResource> _cache = new LruCache(16);
    private final Logger log = Logger.getLogger(GettextModule.class.getName());
    private final L10N L = new L10N(GettextModule.class);

    public String[] getLoadedExtensions() {
        return new String[]{"gettext"};
    }

    public String bind_textdomain_codeset(Env env, String domainName, String charset) {
        this.getDomain(env, domainName).setCharset(charset);
        return charset;
    }

    public Value bindtextdomain(Env env, String domainName, StringValue directory) {
        GettextDomain domain = this.getDomain(env, domainName);
        domain.setPath(env, directory);
        if (domain.getPath() == null) {
            return BooleanValue.FALSE;
        }
        return directory;
    }

    public StringValue dcgettext(Env env, String domainName, StringValue message, int category, Value[] args) {
        return this.translate(env, this.getDomain(env, domainName), this.getCategory(env, category), message, args);
    }

    public StringValue dcngettext(Env env, String domainName, StringValue msgid1, StringValue msgid2, int n, int category, Value[] args) {
        return this.translate(env, this.getDomain(env, domainName), this.getCategory(env, category), msgid1, msgid2, n, args);
    }

    public StringValue dgettext(Env env, String domainName, StringValue message, Value[] args) {
        return this.translate(env, this.getDomain(env, domainName), "LC_MESSAGES", message, args);
    }

    public StringValue dngettext(Env env, String domainName, StringValue msgid1, StringValue msgid2, int n, Value[] args) {
        return this.translate(env, this.getDomain(env, domainName), "LC_MESSAGES", msgid1, msgid2, n, args);
    }

    public StringValue _(Env env, StringValue message, Value[] args) {
        return this.gettext(env, message, args);
    }

    public StringValue gettext(Env env, StringValue message, Value[] args) {
        return this.translate(env, this.getCurrentDomain(env), "LC_MESSAGES", message, args);
    }

    public StringValue ngettext(Env env, StringValue msgid1, StringValue msgid2, int n, Value[] args) {
        return this.translate(env, this.getCurrentDomain(env), "LC_MESSAGES", msgid1, msgid2, n, args);
    }

    public String textdomain(Env env, @Optional Value domain) {
        if (!domain.isNull()) {
            String name = domain.toString();
            this.setCurrentDomain(env, name);
            return name;
        }
        return this.getCurrentDomain(env).getName();
    }

    private StringValue translate(Env env, GettextDomain domain, CharSequence category, StringValue message, Value[] args) {
        Locale locale = env.getLocaleInfo().getMessages().getLocale();
        GettextResource resource = this.getResource(env, domain.getPath(), locale, category, domain.getName());
        StringValue unicodeTranslation = resource.getTranslation(message);
        if (unicodeTranslation == null) {
            unicodeTranslation = message;
        }
        StringValue translation = message.create(env, unicodeTranslation, domain.getCharset());
        return GettextModule.format(env, translation, args);
    }

    private StringValue translate(Env env, GettextDomain domain, CharSequence category, StringValue msgid1, StringValue msgid2, int quantity, Value[] args) {
        Locale locale = env.getLocaleInfo().getMessages().getLocale();
        GettextResource resource = this.getResource(env, domain.getPath(), locale, category, domain.getName());
        StringValue unicodeTranslation = resource.getTranslation(msgid1, quantity);
        if (unicodeTranslation == null) {
            unicodeTranslation = GettextModule.errorReturn(msgid1, msgid2, quantity);
        }
        StringValue translation = msgid1.create(env, unicodeTranslation, domain.getCharset());
        return GettextModule.format(env, translation, args);
    }

    private GettextResource getResource(Env env, Path path, Locale locale, CharSequence category, String domain) {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(path.getFullPath());
        key.add(locale);
        key.add(category);
        key.add(domain);
        GettextResource resource = (GettextResource)this._cache.get(key);
        if (resource == null) {
            resource = new GettextResource(env, path, locale, category, domain);
            this._cache.put(key, (Object)resource);
        }
        return resource;
    }

    private GettextDomainMap getDomains(Env env) {
        Object val = env.getSpecialValue("caucho.gettext_domains");
        if (val == null) {
            val = new GettextDomainMap();
            env.setSpecialValue("caucho.gettext_domains", val);
        }
        return (GettextDomainMap)val;
    }

    private GettextDomain getDomain(Env env, String name) {
        return this.getDomains(env).getDomain(env, name);
    }

    private GettextDomain getCurrentDomain(Env env) {
        return this.getDomains(env).getCurrent(env);
    }

    private void setCurrentDomain(Env env, String name) {
        this.getDomains(env).setCurrent(name);
    }

    private String getCategory(Env env, int category) {
        switch (category) {
            case 7: {
                return "LC_MESSAGES";
            }
            case 6: {
                return "LC_ALL";
            }
            case 1: {
                return "LC_CTYPE";
            }
            case 2: {
                return "LC_NUMERIC";
            }
            case 3: {
                return "LC_TIME";
            }
            case 4: {
                return "LC_COLLATE";
            }
            case 5: {
                return "LC_MONETARY";
            }
        }
        env.warning(this.L.l("Invalid category. Please use named constants"));
        return "LC_MESSAGES";
    }

    private static StringValue errorReturn(StringValue msgid1, StringValue msgid2, int n) {
        if (n == 1) {
            return msgid1;
        }
        return msgid2;
    }

    private static StringValue format(Env env, StringValue msg, Value[] args) {
        if (args.length == 0) {
            return msg;
        }
        StringValue sb = msg.isUnicode() ? env.createUnicodeBuilder() : env.createBinaryBuilder();
        return GettextModule.formatImpl(env, msg, args, sb);
    }

    private static StringValue formatImpl(Env env, StringValue msg, Value[] args, StringValue sb) {
        int i = 0;
        int length = msg.length();
        while (i < length) {
            char ch = msg.charAt(i);
            if (ch != '[' || i + 4 > length) {
                sb.append(ch);
                ++i;
                continue;
            }
            if (msg.charAt(i + 1) != '_') {
                sb.append(ch);
                ++i;
                continue;
            }
            if (msg.charAt(i + 3) != ']') {
                sb.append(ch);
                ++i;
                continue;
            }
            ch = msg.charAt(i + 2);
            int argIndex = ch - 48;
            if (0 <= argIndex && argIndex < args.length) {
                sb.append(args[argIndex]);
                i += 4;
                continue;
            }
            sb.append('[');
            ++i;
        }
        return sb;
    }
}

