/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.mcrypt;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.mcrypt.Mcrypt;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import com.caucho.vfs.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public class McryptModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(McryptModule.class);
    private static final Logger log = Logger.getLogger(McryptModule.class.getName());
    public static final int MCRYPT_DEV_RANDOM = 0;
    public static final int MCRYPT_DEV_URANDOM = 1;
    public static final int MCRYPT_RAND = 2;
    public static final int MCRYPT_ENCRYPT = 0;
    public static final int MCRYPT_DECRYPT = 1;
    public static final String MCRYPT_MODE_ECB = "ecb";
    public static final String MCRYPT_MODE_CBC = "cbc";
    public static final String MCRYPT_MODE_CFB = "cfb";
    public static final String MCRYPT_MODE_OFB = "ofb";
    public static final String MCRYPT_MODE_NOFB = "nofb";
    public static final String MCRYPT_MODE_STREAM = "stream";
    public static final String MCRYPT_ARCFOUR = "arcfour";
    public static final String MCRYPT_BLOWFISH = "blowfish";
    public static final String MCRYPT_DES = "des";
    public static final String MCRYPT_3DES = "tripledes";
    public static final String MCRYPT_TRIPLEDES = "tripledes";
    public static final String MCRYPT_RC4 = "RC4";
    public static final String MCRYPT_RIJNDAEL_128 = "rijndael-128";
    public static final String MCRYPT_RIJNDAEL_192 = "rijndael-192";
    public static final String MCRYPT_RIJNDAEL_256 = "rijndael-256";
    private static final String[] ALGORITHMS = new String[]{"arcfour", "blowfish", "des", "tripledes", "RC4", "rijndael-128", "rijndael-192", "rijndael-256"};

    public String[] getLoadedExtensions() {
        return new String[]{"mcrypt"};
    }

    public static StringValue mcrypt_cbc(Env env, String cipher, byte[] key, byte[] data, int mode, @Optional byte[] iv) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, cipher, MCRYPT_MODE_CBC);
            mcrypt.init(key, iv);
            byte[] result = mode == 0 ? mcrypt.encrypt(data) : mcrypt.decrypt(data);
            return env.createBinaryBuilder(result, 0, result.length);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static StringValue mcrypt_cfb(Env env, String cipher, byte[] key, byte[] data, int mode, @Optional byte[] iv) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, cipher, MCRYPT_MODE_CFB);
            mcrypt.init(key, iv);
            byte[] result = mode == 0 ? mcrypt.encrypt(data) : mcrypt.decrypt(data);
            return env.createBinaryBuilder(result, 0, result.length);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static StringValue mcrypt_create_iv(Env env, int size, @Optional int randomMode) {
        StringValue bb = env.createBinaryBuilder(size);
        for (int i = 0; i < size; ++i) {
            bb.appendByte((byte)RandomUtil.nextInt((int)256));
        }
        return bb;
    }

    public static StringValue mcrypt_decrypt(Env env, String cipher, byte[] key, byte[] data, String mode, @Optional byte[] iv) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, cipher, mode);
            mcrypt.init(key, iv);
            byte[] result = mcrypt.decrypt(data);
            return env.createBinaryBuilder(result, 0, result.length);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static StringValue mcrypt_ecb(Env env, String cipher, byte[] key, byte[] data, int mode, @Optional byte[] iv) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, cipher, MCRYPT_MODE_ECB);
            mcrypt.init(key, iv);
            byte[] result = mode == 0 ? mcrypt.encrypt(data) : mcrypt.decrypt(data);
            return env.createBinaryBuilder(result, 0, result.length);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String mcrypt_enc_get_algorithms_name(Mcrypt mcrypt) {
        if (mcrypt != null) {
            return mcrypt.get_algorithms_name();
        }
        return "";
    }

    public static int mcrypt_enc_get_block_size(Mcrypt mcrypt) {
        if (mcrypt != null) {
            return mcrypt.get_iv_size();
        }
        return 0;
    }

    public static int mcrypt_enc_get_iv_size(Mcrypt mcrypt) {
        if (mcrypt != null) {
            return mcrypt.get_iv_size();
        }
        return 0;
    }

    public static int mcrypt_enc_get_key_size(Mcrypt mcrypt) {
        if (mcrypt != null) {
            return mcrypt.get_key_size();
        }
        return 0;
    }

    public static String mcrypt_enc_get_modes_name(Mcrypt mcrypt) {
        if (mcrypt != null) {
            return mcrypt.get_modes_name();
        }
        return null;
    }

    public static Value mcrypt_enc_get_supported_key_sizes(Mcrypt mcrypt) {
        if (mcrypt != null) {
            return mcrypt.get_supported_key_sizes();
        }
        return BooleanValue.FALSE;
    }

    public static boolean mcrypt_enc_is_block_algorithm(Mcrypt mcrypt) {
        if (mcrypt != null) {
            return mcrypt.is_block_algorithm();
        }
        return false;
    }

    public static boolean mcrypt_enc_is_block_algorithm_mode(Mcrypt mcrypt) {
        if (mcrypt != null) {
            return mcrypt.is_block_algorithm_mode();
        }
        return false;
    }

    public static boolean mcrypt_enc_is_block_mode(Mcrypt mcrypt) {
        if (mcrypt != null) {
            return mcrypt.is_block_mode();
        }
        return false;
    }

    public static boolean mcrypt_enc_self_test(Mcrypt mcrypt) {
        return mcrypt != null;
    }

    public static StringValue mcrypt_encrypt(Env env, String cipher, byte[] key, byte[] data, String mode, @Optional byte[] iv) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, cipher, mode);
            mcrypt.init(key, iv);
            return env.createBinaryBuilder(mcrypt.encrypt(data));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static StringValue mcrypt_generic(Env env, Mcrypt mcrypt, byte[] data) {
        if (mcrypt == null) {
            return null;
        }
        return env.createBinaryBuilder(mcrypt.encrypt(data));
    }

    public static boolean mcrypt_generic_deinit(Mcrypt mcrypt) {
        if (mcrypt == null) {
            return false;
        }
        return mcrypt.deinit();
    }

    public static Value mcrypt_generic_init(Mcrypt mcrypt, byte[] key, byte[] iv) {
        if (mcrypt == null) {
            return BooleanValue.FALSE;
        }
        return new LongValue(mcrypt.init(key, iv));
    }

    public static boolean mcrypt_generic_end(Mcrypt mcrypt) {
        if (mcrypt == null) {
            return false;
        }
        mcrypt.close();
        return true;
    }

    public static Value mcrypt_get_block_size(Env env, String cipher, String mode) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, cipher, mode);
            return LongValue.create(mcrypt.get_block_size());
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            return BooleanValue.FALSE;
        }
    }

    @ReturnNullAsFalse
    public static String mcrypt_get_cipher_name(Env env, String cipher) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, cipher, MCRYPT_MODE_CBC);
            return mcrypt.get_algorithms_name();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            return null;
        }
    }

    public static Value mcrypt_get_iv_size(Env env, String cipher, String mode) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, cipher, mode);
            return LongValue.create(mcrypt.get_iv_size());
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            return BooleanValue.FALSE;
        }
    }

    public static Value mcrypt_get_key_size(Env env, String cipher, String mode) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, cipher, mode);
            return LongValue.create(mcrypt.get_key_size());
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            return BooleanValue.FALSE;
        }
    }

    public static Value mcrypt_list_algorithms(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        for (int i = 0; i < ALGORITHMS.length; ++i) {
            try {
                Mcrypt mcrypt = new Mcrypt(env, ALGORITHMS[i], MCRYPT_MODE_CBC);
                array.put(mcrypt.get_algorithms_name());
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return array;
    }

    public static Value mcrypt_list_modes(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        array.put(MCRYPT_MODE_ECB);
        array.put(MCRYPT_MODE_CBC);
        array.put(MCRYPT_MODE_CFB);
        array.put(MCRYPT_MODE_OFB);
        array.put(MCRYPT_MODE_NOFB);
        return array;
    }

    public static boolean mcrypt_module_close(Mcrypt mcrypt) {
        if (mcrypt == null) {
            return false;
        }
        mcrypt.close();
        return true;
    }

    public static int mcrypt_module_get_algo_block_size(Env env, String cipher, @Optional String libDir) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, cipher, MCRYPT_MODE_CBC);
            return mcrypt.get_block_size();
        }
        catch (Exception e) {
            env.error(e);
            return -1;
        }
    }

    public static int mcrypt_module_get_algo_key_size(Env env, String cipher, @Optional String libDir) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, cipher, MCRYPT_MODE_CBC);
            return mcrypt.get_key_size();
        }
        catch (Exception e) {
            env.error(e);
            return -1;
        }
    }

    public static Value mcrypt_module_get_supported_key_sizes(Env env, String cipher, @Optional String libDir) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, cipher, MCRYPT_MODE_CBC);
            return mcrypt.get_supported_key_sizes();
        }
        catch (Exception e) {
            env.error(e);
            return BooleanValue.FALSE;
        }
    }

    public static boolean mcrypt_module_is_block_algorithm(Env env, String cipher, @Optional String libDir) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, cipher, MCRYPT_MODE_CBC);
            return mcrypt.is_block_algorithm();
        }
        catch (Exception e) {
            env.error(e);
            return false;
        }
    }

    public static boolean mcrypt_module_is_block_algorithm_mode(Env env, String mode, @Optional String libDir) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, MCRYPT_DES, mode);
            return mcrypt.is_block_algorithm_mode();
        }
        catch (Exception e) {
            env.error(e);
            return false;
        }
    }

    public static boolean mcrypt_module_is_block_mode(Env env, String mode, @Optional String libDir) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, MCRYPT_DES, mode);
            return mcrypt.is_block_mode();
        }
        catch (Exception e) {
            env.error(e);
            return false;
        }
    }

    public static boolean mcrypt_module_self_test(Env env, String algorithm, Path libDir) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, algorithm, MCRYPT_MODE_CBC);
            return true;
        }
        catch (Exception e) {
            env.error(e);
            return false;
        }
    }

    public static Value mcrypt_module_open(Env env, String algorithm, Path algorithm_directory, String mode, Path mode_directory) {
        try {
            return env.wrapJava(new Mcrypt(env, algorithm, mode));
        }
        catch (Exception e) {
            env.error(e);
            return BooleanValue.FALSE;
        }
    }

    public static StringValue mcrypt_ofb(Env env, String cipher, byte[] key, byte[] data, int mode, @Optional byte[] iv) {
        try {
            Mcrypt mcrypt = new Mcrypt(env, cipher, MCRYPT_MODE_OFB);
            mcrypt.init(key, iv);
            byte[] result = mode == 0 ? mcrypt.encrypt(data) : mcrypt.decrypt(data);
            return env.createBinaryBuilder(result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Value mdecrypt_generic(Env env, Mcrypt mcrypt, byte[] data) {
        if (mcrypt == null) {
            return BooleanValue.FALSE;
        }
        return env.createBinaryBuilder(mcrypt.decrypt(data));
    }
}

