/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.spl;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.TraversableDelegate;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.util.L10N;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorDelegate
implements TraversableDelegate {
    private static final L10N L = new L10N(IteratorDelegate.class);

    @Override
    public Iterator<Map.Entry<Value, Value>> getIterator(Env env, ObjectValue qThis) {
        return new EntryIterator(env, qThis);
    }

    @Override
    public Iterator<Value> getKeyIterator(Env env, ObjectValue qThis) {
        return new KeyIterator(env, qThis);
    }

    @Override
    public Iterator<Value> getValueIterator(Env env, ObjectValue qThis) {
        return new ValueIterator(env, qThis);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValueIterator<T>
    extends AbstractIteratorImpl<Value> {
        public ValueIterator(Env env, ObjectValue obj) {
            super(env, obj);
        }

        @Override
        protected Value getCurrent() {
            return this.getCurrentValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyIterator<T>
    extends AbstractIteratorImpl<Value> {
        public KeyIterator(Env env, ObjectValue obj) {
            super(env, obj);
        }

        @Override
        protected Value getCurrent() {
            return this.getCurrentKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EntryImpl
    implements Map.Entry<Value, Value> {
        private final Value _key;
        private final Value _value;

        public EntryImpl(Value key, Value value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public Value getKey() {
            return this._key;
        }

        @Override
        public Value getValue() {
            return this._value;
        }

        @Override
        public Value setValue(Value value) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EntryIterator<T>
    extends AbstractIteratorImpl<Map.Entry<Value, Value>> {
        public EntryIterator(Env env, ObjectValue obj) {
            super(env, obj);
        }

        @Override
        protected Map.Entry<Value, Value> getCurrent() {
            Value value = this.getCurrentValue();
            Value key = this.getCurrentKey();
            return new EntryImpl(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractIteratorImpl<T>
    implements Iterator<T> {
        protected final Env _env;
        protected final ObjectValue _obj;
        private final AbstractFunction _nextFun;
        private final AbstractFunction _currentFun;
        private final AbstractFunction _keyFun;
        private final AbstractFunction _rewindFun;
        private final AbstractFunction _validFun;
        private boolean _needNext;

        public AbstractIteratorImpl(Env env, ObjectValue obj) {
            this._env = env;
            this._obj = obj;
            this._currentFun = this._obj.findFunction("current");
            this._keyFun = this._obj.findFunction("key");
            this._nextFun = this._obj.findFunction("next");
            this._rewindFun = this._obj.findFunction("rewind");
            this._validFun = this._obj.findFunction("valid");
            this._rewindFun.callMethod(this._env, this._obj);
            this._needNext = false;
        }

        @Override
        public boolean hasNext() {
            if (this._needNext) {
                this._nextFun.callMethod(this._env, this._obj);
            }
            this._needNext = true;
            return this._validFun.callMethod(this._env, this._obj).toBoolean();
        }

        @Override
        public T next() {
            return this.getCurrent();
        }

        protected abstract T getCurrent();

        protected Value getCurrentKey() {
            return this._keyFun.callMethod(this._env, this._obj);
        }

        protected Value getCurrentValue() {
            return this._currentFun.callMethod(this._env, this._obj);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

