/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.xml;

import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.xml.XMLWriter;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.logging.Logger;

public class XMLWriterModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(XMLWriterModule.class.getName());
    private static final L10N L = new L10N(XMLWriterModule.class);

    public String[] getLoadedExtensions() {
        return new String[]{"XMLWriter"};
    }

    public static Value xmlwriter_flush(@NotNull XMLWriter w) {
        if (w == null) {
            return BooleanValue.FALSE;
        }
        return w.flush();
    }

    public static XMLWriter xmlwriter_open_memory(Env env) {
        XMLWriter w = new XMLWriter();
        w.openMemory(env);
        return w;
    }

    public static XMLWriter xmlwriter_open_uri(Env env, Path path) {
        XMLWriter w = new XMLWriter();
        w.openURI(env, path);
        return w;
    }

    public static Value xmlwriter_output_memory(@NotNull XMLWriter w) {
        if (w == null) {
            return NullValue.NULL;
        }
        return w.outputMemory();
    }

    public static boolean xmlwriter_end_attribute(@NotNull XMLWriter w) {
        if (w == null) {
            return false;
        }
        return w.endAttribute();
    }

    public static boolean xmlwriter_end_cdata(@NotNull XMLWriter w) {
        if (w == null) {
            return false;
        }
        return w.endCData();
    }

    public static boolean xmlwriter_end_comment(@NotNull XMLWriter w) {
        if (w == null) {
            return false;
        }
        return w.endComment();
    }

    public static boolean xmlwriter_end_pi(@NotNull XMLWriter w) {
        if (w == null) {
            return false;
        }
        return w.endPI();
    }

    public static boolean xmlwriter_end_document(@NotNull XMLWriter w) {
        if (w == null) {
            return false;
        }
        return w.endDocument();
    }

    public static boolean xmlwriter_end_dtd_attlist(@NotNull XMLWriter w) {
        if (w == null) {
            return false;
        }
        return w.endDTDAttlist();
    }

    public static boolean xmlwriter_end_dtd_element(@NotNull XMLWriter w) {
        if (w == null) {
            return false;
        }
        return w.endDTDElement();
    }

    public static boolean xmlwriter_end_dtd_entity(@NotNull XMLWriter w) {
        if (w == null) {
            return false;
        }
        return w.endDTDEntity();
    }

    public static boolean xmlwriter_end_dtd(@NotNull XMLWriter w) {
        if (w == null) {
            return false;
        }
        return w.endDTD();
    }

    public static boolean xmlwriter_end_element(Env env, @NotNull XMLWriter w) {
        if (w == null) {
            return false;
        }
        return w.endElement(env);
    }

    public static boolean xmlwriter_end_element_ns(Env env, @NotNull XMLWriter w) {
        if (w == null) {
            return false;
        }
        return w.endElement(env);
    }

    public static boolean xmlwriter_full_end_element(Env env, @NotNull XMLWriter w) {
        if (w == null) {
            return false;
        }
        return w.fullEndElement(env);
    }

    public static boolean xmlwriter_set_indent(@NotNull XMLWriter w, boolean isIndent) {
        if (w == null) {
            return false;
        }
        return w.setIndent(isIndent);
    }

    public static boolean xmlwriter_set_indent_string(@NotNull XMLWriter w, StringValue value) {
        if (w == null) {
            return false;
        }
        return w.setIndentString(value);
    }

    public static boolean xmlwriter_start_attribute(Env env, @NotNull XMLWriter w, StringValue name) {
        if (w == null) {
            return false;
        }
        return w.startAttribute(env, name);
    }

    public static boolean xmlwriter_start_attribute_ns(Env env, @NotNull XMLWriter w, StringValue prefix, StringValue name, StringValue uri) {
        if (w == null) {
            return false;
        }
        return w.startAttributeNS(env, prefix, name, uri);
    }

    public static boolean xmlwriter_start_cdata(@NotNull XMLWriter w) {
        if (w == null) {
            return false;
        }
        return w.startCData();
    }

    public static boolean xmlwriter_start_comment(@NotNull XMLWriter w) {
        if (w == null) {
            return false;
        }
        return w.startComment();
    }

    public static boolean xmlwriter_start_document(Env env, @NotNull XMLWriter w, @Optional StringValue version, @Optional StringValue encoding, @Optional StringValue standalone) {
        if (w == null) {
            return false;
        }
        return w.startDocument(env, version, encoding, standalone);
    }

    public static boolean xmlwriter_start_dtd_attlist(@NotNull XMLWriter w, StringValue name) {
        if (w == null) {
            return false;
        }
        return w.startDTDAttlist(name);
    }

    public static boolean xmlwriter_start_dtd_element(@NotNull XMLWriter w, StringValue name) {
        if (w == null) {
            return false;
        }
        return w.startDTDElement(name);
    }

    public static boolean xmlwriter_start_dtd_entity(@NotNull XMLWriter w, StringValue name) {
        if (w == null) {
            return false;
        }
        return w.startDTDEntity(name);
    }

    public static boolean xmlwriter_start_dtd(@NotNull XMLWriter w, StringValue name, @Optional StringValue publicId, @Optional StringValue systemId) {
        if (w == null) {
            return false;
        }
        return w.startDTD(name, publicId, systemId);
    }

    public static boolean xmlwriter_start_element(Env env, @NotNull XMLWriter w, StringValue name) {
        if (w == null) {
            return false;
        }
        return w.startElement(env, name);
    }

    public static boolean xmlwriter_start_element_ns(Env env, @NotNull XMLWriter w, StringValue prefix, StringValue name, StringValue uri) {
        if (w == null) {
            return false;
        }
        return w.startElementNS(env, prefix, name, uri);
    }

    public static boolean xmlwriter_start_pi(Env env, @NotNull XMLWriter w, StringValue target) {
        if (w == null) {
            return false;
        }
        return w.startPI(env, target);
    }

    public static boolean xmlwriter_text(Env env, @NotNull XMLWriter w, StringValue text) {
        if (w == null) {
            return false;
        }
        return w.text(env, text);
    }

    public static boolean xmlwriter_write_attribute(Env env, @NotNull XMLWriter w, StringValue name, StringValue value) {
        if (w == null) {
            return false;
        }
        return w.writeAttribute(env, name, value);
    }

    public static boolean xmlwriter_write_attribute_ns(Env env, @NotNull XMLWriter w, StringValue prefix, StringValue name, StringValue uri, StringValue value) {
        if (w == null) {
            return false;
        }
        return w.writeAttributeNS(env, prefix, name, uri, value);
    }

    public static boolean xmlwriter_write_cdata(Env env, @NotNull XMLWriter w, StringValue value) {
        if (w == null) {
            return false;
        }
        return w.writeCData(env, value);
    }

    public static boolean xmlwriter_write_comment(Env env, @NotNull XMLWriter w, StringValue value) {
        if (w == null) {
            return false;
        }
        return w.writeComment(env, value);
    }

    public static boolean xmlwriter_write_dtd_attlist(Env env, @NotNull XMLWriter w, StringValue name, StringValue content) {
        if (w == null) {
            return false;
        }
        return w.writeDTDAttlist(env, name, content);
    }

    public static boolean xmlwriter_write_dtd_element(Env env, @NotNull XMLWriter w, StringValue name, StringValue content) {
        if (w == null) {
            return false;
        }
        return w.writeDTDElement(env, name, content);
    }

    public static boolean xmlwriter_write_dtd_entity(Env env, @NotNull XMLWriter w, StringValue name, StringValue content) {
        if (w == null) {
            return false;
        }
        return w.writeDTDEntity(env, name, content);
    }

    public static boolean xmlwriter_write_dtd(Env env, @NotNull XMLWriter w, StringValue name, @Optional StringValue publicId, @Optional StringValue systemId, @Optional StringValue subset) {
        if (w == null) {
            return false;
        }
        return w.writeDTD(env, name, publicId, systemId, subset);
    }

    public static boolean xmlwriter_write_element(Env env, @NotNull XMLWriter w, StringValue name, @Optional StringValue content) {
        if (w == null) {
            return false;
        }
        return w.writeElement(env, name, content);
    }

    public static boolean xmlwriter_write_element_ns(Env env, @NotNull XMLWriter w, StringValue prefix, StringValue name, StringValue uri, @Optional StringValue content) {
        if (w == null) {
            return false;
        }
        return w.writeElementNS(env, prefix, name, uri, content);
    }

    public static boolean xmlwriter_write_pi(Env env, @NotNull XMLWriter w, StringValue name, StringValue value) {
        if (w == null) {
            return false;
        }
        return w.writePI(env, name, value);
    }

    public static boolean xmlwriter_write_raw(Env env, @NotNull XMLWriter w, StringValue value) {
        if (w == null) {
            return false;
        }
        return w.writeRaw(env, value);
    }
}

