/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.page;

import com.caucho.quercus.Quercus;
import com.caucho.quercus.page.InterpretedPage;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PageManager {
    private static final Logger log = Logger.getLogger(PageManager.class.getName());
    protected static final L10N L = new L10N(PageManager.class);
    private final Quercus _quercus;
    private boolean _isLazyCompile;
    private boolean _isCompile;
    private boolean _isCompileFailover = !Alarm.isTest();
    private boolean _isRequireSource = true;
    protected LruCache<Path, QuercusProgram> _programCache = new LruCache(1024);
    private boolean _isClosed;

    public PageManager(Quercus quercus) {
        this._quercus = quercus;
    }

    public Quercus getQuercus() {
        return this._quercus;
    }

    public Path getPwd() {
        return this._quercus.getPwd();
    }

    public boolean isCompile() {
        return this._isCompile;
    }

    public void setCompile(boolean isCompile) {
        this._isCompile = isCompile;
    }

    public boolean isLazyCompile() {
        return this._isLazyCompile;
    }

    public void setLazyCompile(boolean isCompile) {
        this._isLazyCompile = isCompile;
    }

    public boolean isCompileFailover() {
        return this._isCompileFailover;
    }

    public void setCompileFailover(boolean isCompileFailover) {
        this._isCompileFailover = isCompileFailover;
    }

    public void setRequireSource(boolean isRequireSource) {
        this._isRequireSource = isRequireSource;
    }

    public boolean isRequireSource() {
        return this._isRequireSource;
    }

    public int getPageCacheEntries() {
        return this._programCache.getCapacity();
    }

    public void setPageCacheEntries(int entries) {
        if (this._programCache.getCapacity() != entries) {
            this._programCache = new LruCache(entries);
        }
    }

    public boolean isActive() {
        return !this._isClosed;
    }

    public QuercusPage parse(Path path) throws IOException {
        return this.parse(path, null, -1);
    }

    public QuercusPage parse(Path path, String fileName, int line) throws IOException {
        try {
            QuercusProgram program = (QuercusProgram)this._programCache.get((Object)path);
            boolean isModified = false;
            if (program != null) {
                isModified = program.isModified();
                if (!program.isCompilable()) {
                    if (isModified) {
                        program.setCompilable(true);
                    } else {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine(L.l("Quercus[{0}] loading interpreted page", (Object)path));
                        }
                        return new InterpretedPage(program);
                    }
                }
            }
            if (program == null || isModified) {
                this.clearProgram(path, program);
                program = this.preloadProgram(path, fileName);
                if (program == null) {
                    program = QuercusParser.parse(this._quercus, path, this._quercus.getScriptEncoding(), fileName, line);
                }
                this._programCache.put((Object)path, (Object)program);
            }
            if (program.getCompiledPage() != null) {
                return program.getCompiledPage();
            }
            return this.compilePage(program, path);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOExceptionWrapper(e);
        }
    }

    public boolean precompileExists(Path path) {
        return false;
    }

    protected QuercusProgram preloadProgram(Path path, String fileName) {
        return null;
    }

    protected void clearProgram(Path path, QuercusProgram program) {
        this._programCache.remove((Object)path);
        if (program != null) {
            this._quercus.clearDefinitionCache();
        }
    }

    protected QuercusPage compilePage(QuercusProgram program, Path path) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(L.l("Quercus[{0}] loading interpreted page", (Object)path));
        }
        return new InterpretedPage(program);
    }

    public void close() {
        this._isClosed = true;
    }
}

