/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.FieldVisibility;
import com.caucho.quercus.env.ObjectExtValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.Function;
import com.caucho.quercus.program.InstanceInitializer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpretedClassDef
extends ClassDef
implements InstanceInitializer {
    protected boolean _isAbstract;
    protected boolean _isInterface;
    protected boolean _isFinal;
    protected boolean _hasNonPublicMethods;
    protected final HashMap<String, AbstractFunction> _functionMap = new HashMap();
    protected final HashMap<StringValue, ClassDef.FieldEntry> _fieldMap = new LinkedHashMap<StringValue, ClassDef.FieldEntry>();
    protected final HashMap<String, Expr> _staticFieldMap = new LinkedHashMap<String, Expr>();
    protected final HashMap<String, Expr> _constMap = new HashMap();
    protected AbstractFunction _constructor;
    protected AbstractFunction _destructor;
    protected AbstractFunction _getField;
    protected AbstractFunction _setField;
    protected AbstractFunction _call;
    protected int _index;

    public InterpretedClassDef(Location location, String name, String parentName, String[] ifaceList, int index) {
        super(location, name, parentName, ifaceList);
        this._index = index;
    }

    public InterpretedClassDef(String name, String parentName, String[] ifaceList) {
        this(null, name, parentName, ifaceList, 0);
    }

    public void setAbstract(boolean isAbstract) {
        this._isAbstract = isAbstract;
    }

    @Override
    public boolean isAbstract() {
        return this._isAbstract;
    }

    public void setInterface(boolean isInterface) {
        this._isInterface = isInterface;
    }

    @Override
    public boolean isInterface() {
        return this._isInterface;
    }

    public void setFinal(boolean isFinal) {
        this._isFinal = isFinal;
    }

    @Override
    public boolean isFinal() {
        return this._isFinal;
    }

    public boolean getHasNonPublicMethods() {
        return this._hasNonPublicMethods;
    }

    public String getCompilationName() {
        return this.getName() + "_" + this._index;
    }

    @Override
    public void initClass(QuercusClass cl) {
        if (this._constructor != null) {
            cl.setConstructor(this._constructor);
            cl.addMethod("__construct", this._constructor);
        }
        if (this._destructor != null) {
            cl.setDestructor(this._destructor);
            cl.addMethod("__destruct", this._destructor);
        }
        if (this._getField != null) {
            cl.setFieldGet(this._getField);
        }
        if (this._setField != null) {
            cl.setFieldSet(this._setField);
        }
        if (this._call != null) {
            cl.setCall(this._call);
        }
        cl.addInitializer(this);
        for (Map.Entry<String, AbstractFunction> entry : this._functionMap.entrySet()) {
            cl.addMethod(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<CharSequence, Object> entry : this._fieldMap.entrySet()) {
            ClassDef.FieldEntry fieldEntry = (ClassDef.FieldEntry)entry.getValue();
            cl.addField((StringValue)entry.getKey(), 0, fieldEntry.getValue(), fieldEntry.getVisibility());
        }
        String className = this.getName();
        for (Map.Entry<String, Expr> entry : this._staticFieldMap.entrySet()) {
            cl.addStaticFieldExpr(className, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Expr> entry : this._constMap.entrySet()) {
            cl.addConstant(entry.getKey(), entry.getValue());
        }
    }

    public void setConstructor(AbstractFunction fun) {
        this._constructor = fun;
    }

    public void addFunction(String name, Function fun) {
        this._functionMap.put(name.intern(), fun);
        if (!fun.isPublic()) {
            this._hasNonPublicMethods = true;
        }
        if (name.equals("__construct")) {
            this._constructor = fun;
        } else if (name.equals("__destruct")) {
            this._destructor = fun;
        } else if (name.equals("__get")) {
            this._getField = fun;
        } else if (name.equals("__set")) {
            this._setField = fun;
        } else if (name.equals("__call")) {
            this._call = fun;
        } else if (name.equalsIgnoreCase(this.getName()) && this._constructor == null) {
            this._constructor = fun;
        }
    }

    public void addStaticValue(Value name, Expr value) {
        this._staticFieldMap.put(name.toString(), value);
    }

    public void addConstant(String name, Expr value) {
        this._constMap.put(name.intern(), value);
    }

    @Override
    public Expr findConstant(String name) {
        return this._constMap.get(name);
    }

    public void addValue(Value name, Expr value, FieldVisibility visibility) {
        this._fieldMap.put(name.toStringValue(), new ClassDef.FieldEntry(value, visibility));
    }

    public Expr get(Value name) {
        ClassDef.FieldEntry entry = this._fieldMap.get(name.toStringValue());
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public boolean isDeclaredField(StringValue name) {
        return this._fieldMap.get(name) != null;
    }

    public void init(Env env) {
        for (Map.Entry<String, Expr> var : this._staticFieldMap.entrySet()) {
            String name = this.getName() + "::" + var.getKey();
            env.setGlobalValue(name.intern(), var.getValue().eval(env).copy());
        }
    }

    @Override
    public void initInstance(Env env, Value value) {
        ObjectValue object = (ObjectValue)value;
        for (Map.Entry<StringValue, ClassDef.FieldEntry> entry : this._fieldMap.entrySet()) {
            ClassDef.FieldEntry fieldEntry = entry.getValue();
            object.initField(entry.getKey(), fieldEntry.getValue().eval(env).copy(), fieldEntry.getVisibility());
        }
        if (this._destructor != null && value instanceof ObjectExtValue) {
            env.addObjectCleanup((ObjectExtValue)object);
        }
    }

    @Override
    public AbstractFunction findConstructor() {
        return this._constructor;
    }

    @Override
    public Set<Map.Entry<StringValue, ClassDef.FieldEntry>> fieldSet() {
        return this._fieldMap.entrySet();
    }

    @Override
    public Set<Map.Entry<String, AbstractFunction>> functionSet() {
        return this._functionMap.entrySet();
    }
}

