Feature: Spec and test together

  As an RSpec adopter with existing Test::Unit tests
  I want to run a few specs alongside my existing Test::Unit tests
  So that I can experience a smooth, gradual migration path

  Scenario: Run with ruby
    Given the file ../../resources/test/spec_and_test_together.rb

    When I run it with the ruby interpreter -fs

    Then the exit code should be 256
    And the stdout should match "ATest"
    And the stdout should match "Test::Unit::AssertionFailedError in 'An Example should fail with assert'"
    And the stdout should match "'An Example should fail with should' FAILED"
    And the stdout should match "10 examples, 6 failures"
    And the stdout should match /expected: 40,\s*got: 4/m
    And the stdout should match /expected: 50,\s*got: 5/m
    
  Scenario: Run with spec
    Given the file ../../resources/test/spec_and_test_together.rb

    When I run it with the spec command -fs

    Then the exit code should be 256
    And the stdout should match "ATest"
    And the stdout should match "Test::Unit::AssertionFailedError in 'An Example should fail with assert'"
    And the stdout should match "'An Example should fail with should' FAILED"
    And the stdout should match "10 examples, 6 failures"
    And the stdout should match /expected: 40,\s*got: 4/m
    And the stdout should match /expected: 50,\s*got: 5/m
