/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.InitialContext;
import org.atmosphere.util.AbstractBroadcasterProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSBroadcaster
extends AbstractBroadcasterProxy {
    private static final String JMS_TOPIC = JMSBroadcaster.class.getName() + ".topic";
    private static final String JNDI_NAMESPACE = JMSBroadcaster.class.getName() + ".JNDINamespace";
    private static final String JNDI_FACTORY_NAME = JMSBroadcaster.class.getName() + ".JNDIConnectionFactoryName";
    private static final String JNDI_TOPIC = JMSBroadcaster.class.getName() + ".JNDITopic";
    private static final Logger logger = LoggerFactory.getLogger(JMSBroadcaster.class);
    private Connection connection;
    private Session session;
    private MessageConsumer consumer;
    private MessageProducer publisher;
    private String topicId = "atmosphere";
    private String factoryName = "atmosphereFactory";
    private String namespace = "jms/";

    public void incomingBroadcast() {
        try {
            String id;
            if (this.bc.getAtmosphereConfig() != null) {
                if (this.bc.getAtmosphereConfig().getInitParameter(JMS_TOPIC) != null) {
                    this.topicId = this.bc.getAtmosphereConfig().getInitParameter(JMS_TOPIC);
                }
                if (this.bc.getAtmosphereConfig().getInitParameter(JNDI_NAMESPACE) != null) {
                    this.namespace = this.bc.getAtmosphereConfig().getInitParameter(JNDI_NAMESPACE);
                }
                if (this.bc.getAtmosphereConfig().getInitParameter(JNDI_FACTORY_NAME) != null) {
                    this.factoryName = this.bc.getAtmosphereConfig().getInitParameter(JNDI_FACTORY_NAME);
                }
                if (this.bc.getAtmosphereConfig().getInitParameter(JNDI_TOPIC) != null) {
                    this.topicId = this.bc.getAtmosphereConfig().getInitParameter(JNDI_TOPIC);
                }
            }
            if ((id = this.getID()).startsWith("/*")) {
                id = "atmosphere";
            }
            logger.info("Looking up Connection Factory {}", (Object)(this.namespace + this.factoryName));
            InitialContext ctx = new InitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup(this.namespace + this.factoryName);
            logger.info("Looking up topic: {}", (Object)this.topicId);
            Topic topic = (Topic)ctx.lookup(this.namespace + this.topicId);
            this.connection = connectionFactory.createConnection();
            this.session = this.connection.createSession(false, 1);
            logger.info("Create customer: {}", (Object)id);
            String selector = String.format("BroadcasterId = '%s'", id);
            this.consumer = this.session.createConsumer((Destination)topic, selector);
            this.consumer.setMessageListener(new MessageListener(){

                public void onMessage(Message msg) {
                    try {
                        TextMessage textMessage = (TextMessage)msg;
                        String message = textMessage.getText();
                        if (message != null && JMSBroadcaster.this.bc != null) {
                            JMSBroadcaster.this.broadcastReceivedMessage(message);
                        }
                    }
                    catch (JMSException ex) {
                        logger.warn("Failed to broadcast message", (Throwable)ex);
                    }
                }
            });
            this.publisher = this.session.createProducer((Destination)topic);
            this.connection.start();
            logger.info("JMS created for topic {}, with filter {}", (Object)this.topicId, (Object)selector);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Unable to initialize JMSBroadcaster", ex);
        }
    }

    public void outgoingBroadcast(Object message) {
        try {
            String id = this.getID();
            if (id.startsWith("/*")) {
                id = "atmosphere";
            }
            if (this.session == null) {
                throw new IllegalStateException("JMS Session is null");
            }
            TextMessage textMessage = this.session.createTextMessage(message.toString());
            textMessage.setStringProperty("BroadcasterId", id);
            this.publisher.send((Message)textMessage);
        }
        catch (JMSException ex) {
            logger.warn("Failed to send message over JMS", (Throwable)ex);
        }
    }

    public void releaseExternalResources() {
        try {
            this.connection.close();
            this.session.close();
            this.consumer.close();
            this.publisher.close();
        }
        catch (Throwable ex) {
            logger.warn("releaseExternalResources", ex);
        }
    }
}

