/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.UnsupportedEncodingException;
import org.atmosphere.container.version.Jetty8WebSocket;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponseImpl;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketProcessor;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketHandler
implements org.eclipse.jetty.websocket.WebSocket,
WebSocket.OnFrame,
WebSocket.OnBinaryMessage,
WebSocket.OnTextMessage,
WebSocket.OnControl {
    private static final Logger logger = LoggerFactory.getLogger(JettyWebSocketHandler.class);
    private final AtmosphereRequest request;
    private final AtmosphereFramework framework;
    private final WebSocketProcessor webSocketProcessor;
    private WebSocket webSocket;

    public JettyWebSocketHandler(AtmosphereRequest request, AtmosphereFramework framework, WebSocketProcessor webSocketProcessor) {
        this.request = request;
        this.framework = framework;
        this.webSocketProcessor = webSocketProcessor;
    }

    public void onMessage(byte[] data, int offset, int length) {
        logger.trace("WebSocket.onMessage (bytes)");
        this.webSocketProcessor.invokeWebSocketProtocol(this.webSocket, data, offset, length);
    }

    public boolean onControl(byte controlCode, byte[] data, int offset, int length) {
        logger.trace("WebSocket.onControl.");
        try {
            this.webSocketProcessor.notifyListener(this.webSocket, new WebSocketEventListener.WebSocketEvent<String>(new String(data, offset, length, "UTF-8"), WebSocketEventListener.WebSocketEvent.TYPE.CONTROL, this.webSocket));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException", e);
        }
        return false;
    }

    public boolean onFrame(byte flags, byte opcode, byte[] data, int offset, int length) {
        logger.trace("WebSocket.onFrame.");
        return false;
    }

    public void onHandshake(WebSocket.FrameConnection connection) {
        logger.trace("WebSocket.onHandshake");
        this.webSocket = new Jetty8WebSocket((WebSocket.Connection)connection, this.framework.getAtmosphereConfig());
        this.webSocketProcessor.notifyListener(this.webSocket, new WebSocketEventListener.WebSocketEvent<String>("", WebSocketEventListener.WebSocketEvent.TYPE.HANDSHAKE, this.webSocket));
    }

    public void onMessage(String data) {
        logger.trace("WebSocket.onMessage");
        this.webSocketProcessor.invokeWebSocketProtocol(this.webSocket, data);
    }

    public void onOpen(WebSocket.Connection connection) {
        logger.trace("WebSocket.onOpen {}", (Object)connection);
        try {
            this.webSocketProcessor.open(this.webSocket, this.request, AtmosphereResponseImpl.newInstance(this.framework.getAtmosphereConfig(), this.request, this.webSocket));
        }
        catch (Exception e) {
            logger.warn("Failed to connect to WebSocket", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(int closeCode, String message) {
        logger.trace("onClose {}:{}", (Object)closeCode, (Object)message);
        try {
            this.webSocketProcessor.close(this.webSocket, closeCode);
        }
        finally {
            this.request.destroy();
        }
    }
}

