/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastOnPostAtmosphereInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(BroadcastOnPostAtmosphereInterceptor.class);

    @Override
    public Action inspect(AtmosphereResource r) {
        return Action.CONTINUE;
    }

    @Override
    public void postInspect(AtmosphereResource r) {
        if (r.getRequest().getMethod().equalsIgnoreCase("POST")) {
            Object o;
            AtmosphereRequest request = r.getRequest();
            try {
                o = IOUtils.readEntirely(r);
            }
            catch (IOException e) {
                logger.warn("", e);
                return;
            }
            if (IOUtils.isBodyEmpty(o)) {
                logger.warn("{} received an empty body", (Object)request);
                return;
            }
            r.getBroadcaster().broadcast(o);
        }
    }
}

