/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.classindex;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;

public class ClassIndexTransformer
implements ResourceTransformer {
    public static final String SUBCLASS_INDEX_PREFIX = "META-INF/services/";
    public static final String ANNOTATED_INDEX_PREFIX = "META-INF/annotations/";
    public static final String PACKAGE_INDEX_NAME = "jaxb.index";
    private final Map<String, ByteArrayOutputStream> serviceEntries = new HashMap<String, ByteArrayOutputStream>();
    private List<Relocator> relocators;

    public boolean canTransformResource(String resource) {
        return resource.startsWith(SUBCLASS_INDEX_PREFIX) || resource.startsWith(ANNOTATED_INDEX_PREFIX) || resource.endsWith("/jaxb.index");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        ByteArrayOutputStream data;
        if (this.relocators == null) {
            this.relocators = relocators;
        }
        if ((data = this.serviceEntries.get(resource)) == null) {
            data = new ByteArrayOutputStream();
            this.serviceEntries.put(resource, data);
        }
        try {
            String line;
            String content = IOUtil.toString((InputStream)is, (String)StandardCharsets.UTF_8.name());
            StringReader reader = new StringReader(content);
            BufferedReader lineReader = new BufferedReader(reader);
            while ((line = lineReader.readLine()) != null) {
                String qualifiedClassName = this.relocateIfNeeded(line);
                data.write(qualifiedClassName.getBytes(StandardCharsets.UTF_8));
                data.write("\n".getBytes(StandardCharsets.UTF_8));
            }
        }
        finally {
            is.close();
        }
    }

    public boolean hasTransformedResource() {
        return this.serviceEntries.size() > 0;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        for (Map.Entry<String, ByteArrayOutputStream> entry : this.serviceEntries.entrySet()) {
            String key = entry.getKey();
            ByteArrayOutputStream stream = entry.getValue();
            jos.putNextEntry(new JarEntry(this.relocateFileName(key)));
            IOUtil.copy((InputStream)new ByteArrayInputStream(stream.toByteArray()), (OutputStream)jos);
            stream.reset();
        }
    }

    private String relocateFileName(String key) {
        String prefix = "";
        if (key.startsWith(SUBCLASS_INDEX_PREFIX)) {
            prefix = SUBCLASS_INDEX_PREFIX;
        } else if (key.startsWith(ANNOTATED_INDEX_PREFIX)) {
            prefix = ANNOTATED_INDEX_PREFIX;
        }
        return prefix + this.relocateIfNeeded(key.substring(prefix.length()));
    }

    private String relocateIfNeeded(String key) {
        if (this.relocators == null) {
            return key;
        }
        for (Relocator relocator : this.relocators) {
            if (!relocator.canRelocateClass(key)) continue;
            return relocator.relocateClass(key);
        }
        return key;
    }
}

