/*
 * Decompiled with CFR 0.152.
 */
package automorph.transport.amqp;

import automorph.log.LogProperties$;
import automorph.log.Logger;
import automorph.log.Logging;
import automorph.transport.amqp.AmqpContext;
import automorph.transport.amqp.AmqpContext$;
import automorph.transport.amqp.RabbitMq;
import automorph.transport.amqp.RabbitMq$Message$;
import automorph.transport.amqp.RabbitMq$Session$;
import automorph.util.Extensions$;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.DefaultConsumer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.util.Date;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

public final class RabbitMq$
implements Logging,
Serializable {
    private static Logger logger;
    public static final RabbitMq$Message$ Message;
    public static final RabbitMq$Session$ Session;
    private static final String defaultDirectExchange;
    private static final String routingKeyProperty;
    private static final String protocol;
    public static final RabbitMq$ MODULE$;

    private RabbitMq$() {
    }

    static {
        MODULE$ = new RabbitMq$();
        Logging.$init$((Logging)MODULE$);
        defaultDirectExchange = "";
        routingKeyProperty = "Routing Key";
        protocol = "AMQP";
        Statics.releaseFence();
    }

    public Logger logger() {
        return logger;
    }

    public void automorph$log$Logging$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RabbitMq$.class);
    }

    public String defaultDirectExchange() {
        return defaultDirectExchange;
    }

    public String routingKeyProperty() {
        return routingKeyProperty;
    }

    public String protocol() {
        return protocol;
    }

    public Connection connect(URI url, Seq<Address> addresses, String name, ConnectionFactory connectionFactory) {
        String urlText = url.toString();
        connectionFactory.setUri(url);
        this.logger().debug(() -> this.connect$$anonfun$1(urlText));
        return (Connection)Extensions$.MODULE$.TryOps(Try$.MODULE$.apply(() -> this.connect$$anonfun$2(addresses, name, connectionFactory)).map((Function1 & Serializable)connection -> {
            this.logger().info(() -> this.connect$$anonfun$3$$anonfun$1(urlText));
            return connection;
        })).onError((Function1)(JProcedure1 & Serializable)_$1 -> this.logger().error(() -> this.connect$$anonfun$4$$anonfun$1(urlText), () -> this.connect$$anonfun$4$$anonfun$2(_$1))).get();
    }

    public void declareExchange(String exchange, Connection connection) {
        String string = exchange;
        String string2 = this.defaultDirectExchange();
        Option$.MODULE$.when(string == null ? string2 != null : !string.equals(string2), (Function0 & Serializable)() -> {
            this.declareExchange$$anonfun$1(exchange, connection);
            return BoxedUnit.UNIT;
        }).getOrElse((Function0 & Serializable)() -> {
            this.declareExchange$$anonfun$2();
            return BoxedUnit.UNIT;
        });
    }

    public void close(Option<RabbitMq.Session> session) {
        session.fold((Function0 & Serializable)() -> {
            this.close$$anonfun$1();
            return BoxedUnit.UNIT;
        }, (Function1)(JProcedure1 & Serializable)activeSession -> activeSession.connection().close(320, "Terminated"));
    }

    public String applicationId(String applicationName) {
        return InetAddress.getLocalHost().getHostName() + "/" + applicationName;
    }

    public <T extends DefaultConsumer> ThreadLocal<T> threadLocalConsumer(Connection connection, Function1<Channel, T> createConsumer) {
        return ThreadLocal.withInitial(() -> {
            Channel channel = connection.createChannel();
            return (DefaultConsumer)createConsumer.apply(Option$.MODULE$.apply((Object)channel).getOrElse(this::threadLocalConsumer$$anonfun$1$$anonfun$1));
        });
    }

    public AMQP.BasicProperties amqpProperties(Option<AmqpContext<RabbitMq.Message>> messageContext, String contentType, String defaultReplyTo, String defaultRequestId, String defaultAppId, boolean useDefaultRequestId) {
        AmqpContext context = (AmqpContext)messageContext.getOrElse(this::$anonfun$1);
        AMQP.BasicProperties transportProperties = (AMQP.BasicProperties)context.message().map((Function1 & Serializable)_$2 -> _$2.properties()).getOrElse(this::$anonfun$3);
        return new AMQP.BasicProperties().builder().contentType(contentType).replyTo((String)context.replyTo().orElse(() -> this.amqpProperties$$anonfun$1(transportProperties)).getOrElse(() -> this.amqpProperties$$anonfun$2(defaultReplyTo))).correlationId((String)Option$.MODULE$.when(useDefaultRequestId, () -> this.amqpProperties$$anonfun$3(defaultRequestId)).getOrElse(() -> this.amqpProperties$$anonfun$4(defaultRequestId, context, transportProperties))).contentEncoding((String)context.contentEncoding().orElse(() -> this.amqpProperties$$anonfun$5(transportProperties)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).appId((String)context.appId().orElse(() -> this.amqpProperties$$anonfun$6(transportProperties)).getOrElse(() -> this.amqpProperties$$anonfun$7(defaultAppId))).headers(CollectionConverters$.MODULE$.MapHasAsJava((Map)context.headers().$plus$plus((IterableOnce)Option$.MODULE$.apply((Object)transportProperties.getHeaders()).map((Function1 & Serializable)_$3 -> CollectionConverters$.MODULE$.MapHasAsScala(_$3).asScala()).getOrElse(this::amqpProperties$$anonfun$9))).asJava()).deliveryMode((Integer)context.deliveryMode().map((Function1 & Serializable)x$0 -> this.amqpProperties$$anonfun$10(BoxesRunTime.unboxToInt((Object)x$0))).orElse(() -> this.amqpProperties$$anonfun$11(transportProperties)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).priority((Integer)context.priority().map((Function1 & Serializable)x$0 -> this.amqpProperties$$anonfun$12(BoxesRunTime.unboxToInt((Object)x$0))).orElse(() -> this.amqpProperties$$anonfun$13(transportProperties)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).expiration((String)context.expiration().orElse(() -> this.amqpProperties$$anonfun$14(transportProperties)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).messageId((String)context.messageId().orElse(() -> this.amqpProperties$$anonfun$15(transportProperties)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).timestamp((Date)context.timestamp().map((Function1 & Serializable)x$0 -> Date.from(x$0)).orElse(() -> this.amqpProperties$$anonfun$17(transportProperties)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).type((String)context.type().orElse(() -> this.amqpProperties$$anonfun$18(transportProperties)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).userId((String)context.userId().orElse(() -> this.amqpProperties$$anonfun$19(transportProperties)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).build();
    }

    public AmqpContext<RabbitMq.Message> messageContext(AMQP.BasicProperties properties) {
        return AmqpContext$.MODULE$.apply(Option$.MODULE$.apply((Object)properties.getContentType()), Option$.MODULE$.apply((Object)properties.getContentEncoding()), (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)properties.getHeaders()).map((Function1 & Serializable)headers -> Predef$.MODULE$.Map().from((IterableOnce)CollectionConverters$.MODULE$.MapHasAsScala(headers).asScala())).getOrElse(this::messageContext$$anonfun$2), Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(properties.getDeliveryMode()))), Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(properties.getPriority()))), Option$.MODULE$.apply((Object)properties.getCorrelationId()), Option$.MODULE$.apply((Object)properties.getReplyTo()), Option$.MODULE$.apply((Object)properties.getExpiration()), Option$.MODULE$.apply((Object)properties.getMessageId()), Option$.MODULE$.apply((Object)properties.getTimestamp()).map((Function1 & Serializable)_$4 -> _$4.toInstant()), Option$.MODULE$.apply((Object)properties.getType()), Option$.MODULE$.apply((Object)properties.getUserId()), Option$.MODULE$.apply((Object)properties.getAppId()), (Option)Some$.MODULE$.apply((Object)RabbitMq$Message$.MODULE$.apply(properties)));
    }

    public scala.collection.immutable.Map<String, String> messageProperties(Option<String> requestId, String routingKey, String url, Option<String> consumerTag) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.routingKeyProperty());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)routingKey);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"URL");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)url);
        return (scala.collection.immutable.Map)((MapOps)((MapOps)((MapOps)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))).$plus$plus((IterableOnce)requestId.map((Function1 & Serializable)_$5 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)LogProperties$.MODULE$.requestId());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$5);
        }))).$plus$plus((IterableOnce)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).$plus$plus((IterableOnce)consumerTag.map((Function1 & Serializable)_$6 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Consumer Tag");
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$6);
        }));
    }

    private final String connect$$anonfun$1(String urlText$1) {
        return "Connecting to " + this.protocol() + " broker: " + urlText$1;
    }

    private final Connection connect$$anonfun$2(Seq addresses$1, String name$1, ConnectionFactory connectionFactory$1) {
        if (addresses$1.nonEmpty()) {
            return connectionFactory$1.newConnection((Address[])addresses$1.toArray(ClassTag$.MODULE$.apply(Address.class)), name$1);
        }
        return connectionFactory$1.newConnection(name$1);
    }

    private final String connect$$anonfun$3$$anonfun$1(String urlText$3) {
        return "Connected to " + this.protocol() + " broker: " + urlText$3;
    }

    private final String connect$$anonfun$4$$anonfun$1(String urlText$5) {
        return "Failed to connect to " + this.protocol() + " broker: " + urlText$5;
    }

    private final Throwable connect$$anonfun$4$$anonfun$2(Throwable _$1$1) {
        return _$1$1;
    }

    private final Channel declareExchange$$anonfun$1$$anonfun$1(Connection connection$2) {
        return connection$2.createChannel();
    }

    private final void declareExchange$$anonfun$1(String exchange$1, Connection connection$1) {
        Using$.MODULE$.apply(() -> this.declareExchange$$anonfun$1$$anonfun$1(connection$1), (Function1)(JProcedure1 & Serializable)channel -> channel.exchangeDeclare(exchange$1, BuiltinExchangeType.DIRECT, false), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).get();
    }

    private final void declareExchange$$anonfun$2() {
    }

    private final void close$$anonfun$1() {
        throw new IllegalStateException(this.getClass().getSimpleName() + " already closed");
    }

    private final Channel threadLocalConsumer$$anonfun$1$$anonfun$1() {
        throw new IOException("No AMQP connection channel available");
    }

    private final AmqpContext $anonfun$1() {
        return AmqpContext$.MODULE$.apply(AmqpContext$.MODULE$.$lessinit$greater$default$1(), AmqpContext$.MODULE$.$lessinit$greater$default$2(), AmqpContext$.MODULE$.$lessinit$greater$default$3(), AmqpContext$.MODULE$.$lessinit$greater$default$4(), AmqpContext$.MODULE$.$lessinit$greater$default$5(), AmqpContext$.MODULE$.$lessinit$greater$default$6(), AmqpContext$.MODULE$.$lessinit$greater$default$7(), AmqpContext$.MODULE$.$lessinit$greater$default$8(), AmqpContext$.MODULE$.$lessinit$greater$default$9(), AmqpContext$.MODULE$.$lessinit$greater$default$10(), AmqpContext$.MODULE$.$lessinit$greater$default$11(), AmqpContext$.MODULE$.$lessinit$greater$default$12(), AmqpContext$.MODULE$.$lessinit$greater$default$13(), (Option)AmqpContext$.MODULE$.$lessinit$greater$default$14());
    }

    private final AMQP.BasicProperties $anonfun$3() {
        return new AMQP.BasicProperties();
    }

    private final Option amqpProperties$$anonfun$1(AMQP.BasicProperties transportProperties$1) {
        return Option$.MODULE$.apply((Object)transportProperties$1.getReplyTo());
    }

    private final String amqpProperties$$anonfun$2(String defaultReplyTo$1) {
        return defaultReplyTo$1;
    }

    private final String amqpProperties$$anonfun$3(String defaultRequestId$1) {
        return defaultRequestId$1;
    }

    private final Option amqpProperties$$anonfun$4$$anonfun$1(AMQP.BasicProperties transportProperties$3) {
        return Option$.MODULE$.apply((Object)transportProperties$3.getCorrelationId());
    }

    private final String amqpProperties$$anonfun$4$$anonfun$2(String defaultRequestId$3) {
        return defaultRequestId$3;
    }

    private final String amqpProperties$$anonfun$4(String defaultRequestId$2, AmqpContext context$1, AMQP.BasicProperties transportProperties$2) {
        return (String)context$1.correlationId().orElse(() -> this.amqpProperties$$anonfun$4$$anonfun$1(transportProperties$2)).getOrElse(() -> this.amqpProperties$$anonfun$4$$anonfun$2(defaultRequestId$2));
    }

    private final Option amqpProperties$$anonfun$5(AMQP.BasicProperties transportProperties$4) {
        return Option$.MODULE$.apply((Object)transportProperties$4.getContentEncoding());
    }

    private final Option amqpProperties$$anonfun$6(AMQP.BasicProperties transportProperties$5) {
        return Option$.MODULE$.apply((Object)transportProperties$5.getAppId());
    }

    private final String amqpProperties$$anonfun$7(String defaultAppId$1) {
        return defaultAppId$1;
    }

    private final Map amqpProperties$$anonfun$9() {
        return Predef$.MODULE$.Map().empty();
    }

    private final /* synthetic */ Integer amqpProperties$$anonfun$10(int x$0) {
        return x$0;
    }

    private final Option amqpProperties$$anonfun$11(AMQP.BasicProperties transportProperties$6) {
        return Option$.MODULE$.apply((Object)transportProperties$6.getDeliveryMode());
    }

    private final /* synthetic */ Integer amqpProperties$$anonfun$12(int x$0) {
        return x$0;
    }

    private final Option amqpProperties$$anonfun$13(AMQP.BasicProperties transportProperties$7) {
        return Option$.MODULE$.apply((Object)transportProperties$7.getPriority());
    }

    private final Option amqpProperties$$anonfun$14(AMQP.BasicProperties transportProperties$8) {
        return Option$.MODULE$.apply((Object)transportProperties$8.getExpiration());
    }

    private final Option amqpProperties$$anonfun$15(AMQP.BasicProperties transportProperties$9) {
        return Option$.MODULE$.apply((Object)transportProperties$9.getMessageId());
    }

    private final Option amqpProperties$$anonfun$17(AMQP.BasicProperties transportProperties$10) {
        return Option$.MODULE$.apply((Object)transportProperties$10.getTimestamp());
    }

    private final Option amqpProperties$$anonfun$18(AMQP.BasicProperties transportProperties$11) {
        return Option$.MODULE$.apply((Object)transportProperties$11.getType());
    }

    private final Option amqpProperties$$anonfun$19(AMQP.BasicProperties transportProperties$12) {
        return Option$.MODULE$.apply((Object)transportProperties$12.getUserId());
    }

    private final scala.collection.immutable.Map messageContext$$anonfun$2() {
        return Predef$.MODULE$.Map().empty();
    }
}

