/*
 * Decompiled with CFR 0.152.
 */
package automorph.transport.amqp.client;

import automorph.log.Logger;
import automorph.log.Logging;
import automorph.log.MessageLog;
import automorph.log.MessageLog$;
import automorph.spi.AsyncEffectSystem;
import automorph.spi.ClientTransport;
import automorph.spi.EffectSystem;
import automorph.transport.amqp.AmqpContext;
import automorph.transport.amqp.RabbitMq;
import automorph.transport.amqp.RabbitMq$;
import automorph.transport.amqp.RabbitMq$Message$;
import automorph.transport.amqp.RabbitMq$Session$;
import automorph.transport.amqp.client.RabbitMqClient$;
import automorph.util.Extensions$;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;

public final class RabbitMqClient<Effect>
implements Logging,
ClientTransport<Effect, AmqpContext<RabbitMq.Message>>,
Product,
Serializable {
    private Logger logger;
    private final URI url;
    private final String routingKey;
    private final AsyncEffectSystem effectSystem;
    private final String exchange;
    private final Seq addresses;
    private final ConnectionFactory connectionFactory;
    private Option<RabbitMq.Session> session;
    private final String directReplyToQueue;
    private final String clientId;
    public final String automorph$transport$amqp$client$RabbitMqClient$$urlText;
    public final TrieMap<String, AsyncEffectSystem.Completable<Effect, Tuple2<byte[], AmqpContext<RabbitMq.Message>>>> automorph$transport$amqp$client$RabbitMqClient$$responseHandlers;
    public final MessageLog automorph$transport$amqp$client$RabbitMqClient$$log;
    public final EffectSystem<Effect> automorph$transport$amqp$client$RabbitMqClient$$system;

    public static <Effect> RabbitMqClient<Effect> apply(URI uRI, String string, AsyncEffectSystem<Effect> asyncEffectSystem, String string2, Seq<Address> seq, ConnectionFactory connectionFactory) {
        return RabbitMqClient$.MODULE$.apply(uRI, string, asyncEffectSystem, string2, seq, connectionFactory);
    }

    public static RabbitMqClient<?> fromProduct(Product product) {
        return RabbitMqClient$.MODULE$.fromProduct(product);
    }

    public static <Effect> RabbitMqClient<Effect> unapply(RabbitMqClient<Effect> rabbitMqClient) {
        return RabbitMqClient$.MODULE$.unapply(rabbitMqClient);
    }

    public static <Effect> String $lessinit$greater$default$4() {
        return RabbitMqClient$.MODULE$.$lessinit$greater$default$4();
    }

    public static <Effect> Seq<Address> $lessinit$greater$default$5() {
        return RabbitMqClient$.MODULE$.$lessinit$greater$default$5();
    }

    public static <Effect> ConnectionFactory $lessinit$greater$default$6() {
        return RabbitMqClient$.MODULE$.$lessinit$greater$default$6();
    }

    public RabbitMqClient(URI url, String routingKey, AsyncEffectSystem<Effect> effectSystem, String exchange, Seq<Address> addresses, ConnectionFactory connectionFactory) {
        this.url = url;
        this.routingKey = routingKey;
        this.effectSystem = effectSystem;
        this.exchange = exchange;
        this.addresses = addresses;
        this.connectionFactory = connectionFactory;
        Logging.$init$((Logging)this);
        this.session = Option$.MODULE$.empty();
        this.directReplyToQueue = "amq.rabbitmq.reply-to";
        this.clientId = RabbitMq$.MODULE$.applicationId(this.getClass().getName());
        this.automorph$transport$amqp$client$RabbitMqClient$$urlText = url.toString();
        this.automorph$transport$amqp$client$RabbitMqClient$$responseHandlers = (TrieMap)TrieMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.automorph$transport$amqp$client$RabbitMqClient$$log = MessageLog$.MODULE$.apply(this.logger(), RabbitMq$.MODULE$.protocol());
        this.automorph$transport$amqp$client$RabbitMqClient$$system = effectSystem;
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void automorph$log$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof RabbitMqClient)) return false;
        RabbitMqClient rabbitMqClient = (RabbitMqClient)object;
        URI uRI = this.url();
        URI uRI2 = rabbitMqClient.url();
        if (uRI == null) {
            if (uRI2 != null) {
                return false;
            }
        } else if (!((Object)uRI).equals(uRI2)) return false;
        String string = this.routingKey();
        String string2 = rabbitMqClient.routingKey();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        AsyncEffectSystem<Effect> asyncEffectSystem = this.effectSystem();
        AsyncEffectSystem<Effect> asyncEffectSystem2 = rabbitMqClient.effectSystem();
        if (asyncEffectSystem == null) {
            if (asyncEffectSystem2 != null) {
                return false;
            }
        } else if (!asyncEffectSystem.equals(asyncEffectSystem2)) return false;
        String string3 = this.exchange();
        String string4 = rabbitMqClient.exchange();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Seq<Address> seq = this.addresses();
        Seq<Address> seq2 = rabbitMqClient.addresses();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        ConnectionFactory connectionFactory = this.connectionFactory();
        ConnectionFactory connectionFactory2 = rabbitMqClient.connectionFactory();
        if (connectionFactory == null) {
            if (connectionFactory2 == null) return true;
            return false;
        } else {
            if (!connectionFactory.equals(connectionFactory2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof RabbitMqClient;
    }

    public int productArity() {
        return 6;
    }

    public String productPrefix() {
        return "RabbitMqClient";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "url";
            }
            case 1: {
                return "routingKey";
            }
            case 2: {
                return "effectSystem";
            }
            case 3: {
                return "exchange";
            }
            case 4: {
                return "addresses";
            }
            case 5: {
                return "connectionFactory";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public URI url() {
        return this.url;
    }

    public String routingKey() {
        return this.routingKey;
    }

    public AsyncEffectSystem<Effect> effectSystem() {
        return this.effectSystem;
    }

    public String exchange() {
        return this.exchange;
    }

    public Seq<Address> addresses() {
        return this.addresses;
    }

    public ConnectionFactory connectionFactory() {
        return this.connectionFactory;
    }

    public Effect call(byte[] requestBody, AmqpContext<RabbitMq.Message> requestContext, String requestId, String mediaType) {
        return (Effect)Extensions$.MODULE$.EffectOps(this.effectSystem().completable()).flatMap((Function1 & Serializable)response -> Extensions$.MODULE$.EffectOps(this.send(requestBody, requestId, mediaType, requestContext, (Option<AsyncEffectSystem.Completable<Effect, Tuple2<byte[], AmqpContext<RabbitMq.Message>>>>)Some$.MODULE$.apply(response))).flatMap((Function1 & Serializable)_$2 -> response.effect(), this.automorph$transport$amqp$client$RabbitMqClient$$system), this.automorph$transport$amqp$client$RabbitMqClient$$system);
    }

    public Effect tell(byte[] requestBody, AmqpContext<RabbitMq.Message> requestContext, String requestId, String mediaType) {
        return this.send(requestBody, requestId, mediaType, requestContext, (Option<AsyncEffectSystem.Completable<Effect, Tuple2<byte[], AmqpContext<RabbitMq.Message>>>>)None$.MODULE$);
    }

    public AmqpContext<RabbitMq.Message> context() {
        return RabbitMq$Message$.MODULE$.defaultContext();
    }

    public Effect init() {
        return (Effect)this.automorph$transport$amqp$client$RabbitMqClient$$system.evaluate((Function0 & Serializable)() -> {
            this.init$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public Effect close() {
        return (Effect)this.effectSystem().evaluate((Function0 & Serializable)() -> {
            this.close$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    private Effect send(byte[] requestBody, String defaultRequestId, String mediaType, AmqpContext<RabbitMq.Message> requestContext, Option<AsyncEffectSystem.Completable<Effect, Tuple2<byte[], AmqpContext<RabbitMq.Message>>>> response) {
        LazyRef lazyRef = new LazyRef();
        AMQP.BasicProperties amqpProperties = RabbitMq$.MODULE$.amqpProperties((Option<AmqpContext<RabbitMq.Message>>)Some$.MODULE$.apply(requestContext), mediaType, this.directReplyToQueue, defaultRequestId, this.clientId, false);
        String requestId = amqpProperties.getCorrelationId();
        this.automorph$transport$amqp$client$RabbitMqClient$$log.sendingRequest(() -> this.send$$anonfun$1(requestId, lazyRef), this.automorph$transport$amqp$client$RabbitMqClient$$log.sendingRequest$default$2());
        response.foreach((Function1 & Serializable)_$4 -> this.automorph$transport$amqp$client$RabbitMqClient$$responseHandlers.put((Object)requestId, _$4));
        return (Effect)this.effectSystem().evaluate((Function0 & Serializable)() -> {
            this.send$$anonfun$3(requestBody, amqpProperties, requestId, lazyRef);
            return BoxedUnit.UNIT;
        });
    }

    private DefaultConsumer createConsumer(Channel channel) {
        DefaultConsumer consumer = new DefaultConsumer(channel, this){
            private final /* synthetic */ RabbitMqClient $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(channel$1);
            }

            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] responseBody) {
                LazyRef lazyRef = new LazyRef();
                this.$outer.automorph$transport$amqp$client$RabbitMqClient$$log.receivedResponse(() -> this.handleDelivery$$anonfun$1(properties, lazyRef), this.$outer.automorph$transport$amqp$client$RabbitMqClient$$log.receivedResponse$default$2());
                AmqpContext<RabbitMq.Message> responseContext = RabbitMq$.MODULE$.messageContext(properties);
                this.$outer.automorph$transport$amqp$client$RabbitMqClient$$responseHandlers.get((Object)properties.getCorrelationId()).foreach((Function1)(JProcedure1 & Serializable)response -> {
                    byte[] byArray = (byte[])Predef$.MODULE$.ArrowAssoc((Object)responseBody);
                    Extensions$.MODULE$.EffectOps(response.succeed((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)byArray, (Object)responseContext))).runAsync(this.$outer.automorph$transport$amqp$client$RabbitMqClient$$system);
                });
            }

            private final Map responseProperties$lzyINIT1$1(AMQP.BasicProperties properties$1, LazyRef responseProperties$lzy1$1) {
                Map map;
                LazyRef lazyRef = responseProperties$lzy1$1;
                synchronized (lazyRef) {
                    map = (Map)(responseProperties$lzy1$1.initialized() ? responseProperties$lzy1$1.value() : responseProperties$lzy1$1.initialize(RabbitMq$.MODULE$.messageProperties((Option<String>)Option$.MODULE$.apply((Object)properties$1.getCorrelationId()), this.$outer.routingKey(), this.$outer.automorph$transport$amqp$client$RabbitMqClient$$urlText, (Option<String>)None$.MODULE$)));
                }
                return map;
            }

            private final Map responseProperties$1(AMQP.BasicProperties properties$2, LazyRef responseProperties$lzy1$2) {
                return (Map)(responseProperties$lzy1$2.initialized() ? responseProperties$lzy1$2.value() : this.responseProperties$lzyINIT1$1(properties$2, responseProperties$lzy1$2));
            }

            private final Map handleDelivery$$anonfun$1(AMQP.BasicProperties properties$3, LazyRef responseProperties$lzy1$3) {
                return this.responseProperties$1(properties$3, responseProperties$lzy1$3);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{handleDelivery$$anonfun$1(com.rabbitmq.client.AMQP$BasicProperties scala.runtime.LazyRef ), handleDelivery$$anonfun$2(byte[] automorph.transport.amqp.AmqpContext automorph.spi.AsyncEffectSystem$Completable )}, serializedLambda);
            }
        };
        consumer.getChannel().basicConsume(this.directReplyToQueue, true, (Consumer)consumer);
        return consumer;
    }

    public <Effect> RabbitMqClient<Effect> copy(URI url, String routingKey, AsyncEffectSystem<Effect> effectSystem, String exchange, Seq<Address> addresses, ConnectionFactory connectionFactory) {
        return new RabbitMqClient<Effect>(url, routingKey, effectSystem, exchange, addresses, connectionFactory);
    }

    public <Effect> URI copy$default$1() {
        return this.url();
    }

    public <Effect> String copy$default$2() {
        return this.routingKey();
    }

    public <Effect> AsyncEffectSystem<Effect> copy$default$3() {
        return this.effectSystem();
    }

    public <Effect> String copy$default$4() {
        return this.exchange();
    }

    public <Effect> Seq<Address> copy$default$5() {
        return this.addresses();
    }

    public <Effect> ConnectionFactory copy$default$6() {
        return this.connectionFactory();
    }

    public URI _1() {
        return this.url();
    }

    public String _2() {
        return this.routingKey();
    }

    public AsyncEffectSystem<Effect> _3() {
        return this.effectSystem();
    }

    public String _4() {
        return this.exchange();
    }

    public Seq<Address> _5() {
        return this.addresses();
    }

    public ConnectionFactory _6() {
        return this.connectionFactory();
    }

    private final void init$$anonfun$1$$anonfun$1() {
        Connection connection = RabbitMq$.MODULE$.connect(this.url(), this.addresses(), this.clientId, this.connectionFactory());
        RabbitMq$.MODULE$.declareExchange(this.exchange(), connection);
        ThreadLocal<DefaultConsumer> consumer = RabbitMq$.MODULE$.threadLocalConsumer(connection, (Function1 & Serializable)channel -> this.createConsumer((Channel)channel));
        this.session = Some$.MODULE$.apply((Object)RabbitMq$Session$.MODULE$.apply(connection, consumer));
    }

    private final void init$$anonfun$1() {
        RabbitMqClient rabbitMqClient = this;
        synchronized (rabbitMqClient) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)this.session.fold((Function0 & Serializable)() -> {
                this.init$$anonfun$1$$anonfun$1();
                return BoxedUnit.UNIT;
            }, (Function1)(JProcedure1 & Serializable)_$3 -> {
                throw new IllegalStateException(this.getClass().getSimpleName() + " already initialized");
            });
        }
    }

    private final void close$$anonfun$1() {
        RabbitMqClient rabbitMqClient = this;
        synchronized (rabbitMqClient) {
            RabbitMq$.MODULE$.close(this.session);
            this.session = None$.MODULE$;
        }
    }

    private final Map requestProperties$lzyINIT1$1(String requestId$2, LazyRef requestProperties$lzy1$1) {
        Map map;
        LazyRef lazyRef = requestProperties$lzy1$1;
        synchronized (lazyRef) {
            map = (Map)(requestProperties$lzy1$1.initialized() ? requestProperties$lzy1$1.value() : requestProperties$lzy1$1.initialize(RabbitMq$.MODULE$.messageProperties((Option<String>)Some$.MODULE$.apply((Object)requestId$2), this.routingKey(), this.automorph$transport$amqp$client$RabbitMqClient$$urlText, (Option<String>)None$.MODULE$)));
        }
        return map;
    }

    private final Map requestProperties$1(String requestId$3, LazyRef requestProperties$lzy1$2) {
        return (Map)(requestProperties$lzy1$2.initialized() ? requestProperties$lzy1$2.value() : this.requestProperties$lzyINIT1$1(requestId$3, requestProperties$lzy1$2));
    }

    private final Map send$$anonfun$1(String requestId$7, LazyRef requestProperties$lzy1$5) {
        return this.requestProperties$1(requestId$7, requestProperties$lzy1$5);
    }

    private final Map send$$anonfun$3$$anonfun$1$$anonfun$1(String requestId$8, LazyRef requestProperties$lzy1$6) {
        return this.requestProperties$1(requestId$8, requestProperties$lzy1$6);
    }

    private final void send$$anonfun$3$$anonfun$1(byte[] requestBody$3, AMQP.BasicProperties amqpProperties$2, String requestId$6, LazyRef requestProperties$lzy1$4) {
        ((RabbitMq.Session)this.session.get()).consumer().get().getChannel().basicPublish(this.exchange(), this.routingKey(), true, false, amqpProperties$2, requestBody$3);
        this.automorph$transport$amqp$client$RabbitMqClient$$log.sentRequest(() -> this.send$$anonfun$3$$anonfun$1$$anonfun$1(requestId$6, requestProperties$lzy1$4), this.automorph$transport$amqp$client$RabbitMqClient$$log.sentRequest$default$2());
    }

    private final Map send$$anonfun$3$$anonfun$2$$anonfun$1(String requestId$11, LazyRef requestProperties$lzy1$9) {
        return this.requestProperties$1(requestId$11, requestProperties$lzy1$9);
    }

    private final void send$$anonfun$3(byte[] requestBody$2, AMQP.BasicProperties amqpProperties$1, String requestId$5, LazyRef requestProperties$lzy1$3) {
        Extensions$.MODULE$.TryOps(Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.send$$anonfun$3$$anonfun$1(requestBody$2, amqpProperties$1, requestId$5, requestProperties$lzy1$3);
            return BoxedUnit.UNIT;
        })).onError((Function1)(JProcedure1 & Serializable)error -> this.automorph$transport$amqp$client$RabbitMqClient$$log.failedSendRequest(error, () -> this.send$$anonfun$3$$anonfun$2$$anonfun$1(requestId$5, requestProperties$lzy1$3), this.automorph$transport$amqp$client$RabbitMqClient$$log.failedSendRequest$default$3())).get();
    }
}

