/*
 * Decompiled with CFR 0.152.
 */
package automorph.transport.amqp.server;

import automorph.log.Logger;
import automorph.log.Logging;
import automorph.log.MessageLog;
import automorph.log.MessageLog$;
import automorph.spi.EffectSystem;
import automorph.spi.RequestHandler;
import automorph.spi.ServerTransport;
import automorph.transport.amqp.AmqpContext;
import automorph.transport.amqp.RabbitMq;
import automorph.transport.amqp.RabbitMq$;
import automorph.transport.amqp.RabbitMq$Session$;
import automorph.transport.amqp.server.RabbitMqServer$;
import automorph.util.Extensions$;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.Map;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

public final class RabbitMqServer<Effect>
implements Logging,
ServerTransport<Effect, AmqpContext<RabbitMq.Message>>,
Product,
Serializable {
    private Logger logger;
    private final EffectSystem effectSystem;
    private final URI url;
    private final Seq queues;
    private final Seq addresses;
    private final ConnectionFactory connectionFactory;
    private final RequestHandler handler;
    private final String exchange;
    private Option<RabbitMq.Session> session;
    private final String serverId;
    public final String automorph$transport$amqp$server$RabbitMqServer$$urlText;
    public final MessageLog automorph$transport$amqp$server$RabbitMqServer$$log;
    public final EffectSystem<Effect> automorph$transport$amqp$server$RabbitMqServer$$system;

    public static <Effect> RabbitMqServer<Effect> apply(EffectSystem<Effect> effectSystem, URI uRI, Seq<String> seq, Seq<Address> seq2, ConnectionFactory connectionFactory, RequestHandler<Effect, AmqpContext<RabbitMq.Message>> requestHandler) {
        return RabbitMqServer$.MODULE$.apply(effectSystem, uRI, seq, seq2, connectionFactory, requestHandler);
    }

    public static RabbitMqServer<?> fromProduct(Product product) {
        return RabbitMqServer$.MODULE$.fromProduct(product);
    }

    public static <Effect> RabbitMqServer<Effect> unapply(RabbitMqServer<Effect> rabbitMqServer) {
        return RabbitMqServer$.MODULE$.unapply(rabbitMqServer);
    }

    public static <Effect> Seq<Address> $lessinit$greater$default$4() {
        return RabbitMqServer$.MODULE$.$lessinit$greater$default$4();
    }

    public static <Effect> ConnectionFactory $lessinit$greater$default$5() {
        return RabbitMqServer$.MODULE$.$lessinit$greater$default$5();
    }

    public static <Effect> RequestHandler<Effect, AmqpContext<RabbitMq.Message>> $lessinit$greater$default$6() {
        return RabbitMqServer$.MODULE$.$lessinit$greater$default$6();
    }

    public RabbitMqServer(EffectSystem<Effect> effectSystem, URI url, Seq<String> queues, Seq<Address> addresses, ConnectionFactory connectionFactory, RequestHandler<Effect, AmqpContext<RabbitMq.Message>> handler) {
        this.effectSystem = effectSystem;
        this.url = url;
        this.queues = queues;
        this.addresses = addresses;
        this.connectionFactory = connectionFactory;
        this.handler = handler;
        Logging.$init$((Logging)this);
        this.exchange = RabbitMq$.MODULE$.defaultDirectExchange();
        this.session = Option$.MODULE$.empty();
        this.serverId = RabbitMq$.MODULE$.applicationId(this.getClass().getName());
        this.automorph$transport$amqp$server$RabbitMqServer$$urlText = url.toString();
        this.automorph$transport$amqp$server$RabbitMqServer$$log = MessageLog$.MODULE$.apply(this.logger(), RabbitMq$.MODULE$.protocol());
        this.automorph$transport$amqp$server$RabbitMqServer$$system = effectSystem;
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void automorph$log$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof RabbitMqServer)) return false;
        RabbitMqServer rabbitMqServer = (RabbitMqServer)object;
        EffectSystem<Effect> effectSystem = this.effectSystem();
        EffectSystem<Effect> effectSystem2 = rabbitMqServer.effectSystem();
        if (effectSystem == null) {
            if (effectSystem2 != null) {
                return false;
            }
        } else if (!effectSystem.equals(effectSystem2)) return false;
        URI uRI = this.url();
        URI uRI2 = rabbitMqServer.url();
        if (uRI == null) {
            if (uRI2 != null) {
                return false;
            }
        } else if (!((Object)uRI).equals(uRI2)) return false;
        Seq<String> seq = this.queues();
        Seq<String> seq2 = rabbitMqServer.queues();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<Address> seq3 = this.addresses();
        Seq<Address> seq4 = rabbitMqServer.addresses();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        ConnectionFactory connectionFactory = this.connectionFactory();
        ConnectionFactory connectionFactory2 = rabbitMqServer.connectionFactory();
        if (connectionFactory == null) {
            if (connectionFactory2 != null) {
                return false;
            }
        } else if (!connectionFactory.equals(connectionFactory2)) return false;
        RequestHandler<Effect, AmqpContext<RabbitMq.Message>> requestHandler = this.handler();
        RequestHandler<Effect, AmqpContext<RabbitMq.Message>> requestHandler2 = rabbitMqServer.handler();
        if (requestHandler == null) {
            if (requestHandler2 == null) return true;
            return false;
        } else {
            if (!requestHandler.equals(requestHandler2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof RabbitMqServer;
    }

    public int productArity() {
        return 6;
    }

    public String productPrefix() {
        return "RabbitMqServer";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "effectSystem";
            }
            case 1: {
                return "url";
            }
            case 2: {
                return "queues";
            }
            case 3: {
                return "addresses";
            }
            case 4: {
                return "connectionFactory";
            }
            case 5: {
                return "handler";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public EffectSystem<Effect> effectSystem() {
        return this.effectSystem;
    }

    public URI url() {
        return this.url;
    }

    public Seq<String> queues() {
        return this.queues;
    }

    public Seq<Address> addresses() {
        return this.addresses;
    }

    public ConnectionFactory connectionFactory() {
        return this.connectionFactory;
    }

    public RequestHandler<Effect, AmqpContext<RabbitMq.Message>> handler() {
        return this.handler;
    }

    public RabbitMqServer<Effect> withHandler(RequestHandler<Effect, AmqpContext<RabbitMq.Message>> handler) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), handler);
    }

    public Effect init() {
        return (Effect)this.automorph$transport$amqp$server$RabbitMqServer$$system.evaluate((Function0 & Serializable)() -> {
            this.init$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public Effect close() {
        return (Effect)this.effectSystem().evaluate((Function0 & Serializable)() -> {
            this.close$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    private DefaultConsumer createConsumer(Channel channel) {
        DefaultConsumer consumer = new DefaultConsumer(channel, this){
            private final /* synthetic */ RabbitMqServer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(channel$2);
            }

            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties amqpProperties, byte[] requestBody) {
                LazyRef lazyRef = new LazyRef();
                Option requestId = Option$.MODULE$.apply((Object)amqpProperties.getCorrelationId());
                this.$outer.automorph$transport$amqp$server$RabbitMqServer$$log.receivedRequest(() -> this.handleDelivery$$anonfun$1(consumerTag, envelope, requestId, lazyRef), this.$outer.automorph$transport$amqp$server$RabbitMqServer$$log.receivedRequest$default$2());
                Option$.MODULE$.apply((Object)amqpProperties.getReplyTo()).map((Function1)(JProcedure1 & Serializable)replyTo -> requestId.map((Function1)(JProcedure1 & Serializable)actualRequestId -> Extensions$.MODULE$.TryOps(Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.handleDelivery$$anonfun$2$$anonfun$1$$anonfun$1(consumerTag, envelope, amqpProperties, requestBody, requestId, (String)replyTo, (String)actualRequestId, lazyRef);
                    return BoxedUnit.UNIT;
                })).foldError((Function1)(JProcedure1 & Serializable)error -> this.$outer.automorph$transport$amqp$server$RabbitMqServer$$sendErrorResponse((Throwable)error, (String)replyTo, (Function0<scala.collection.immutable.Map<String, String>>)((Function0 & Serializable)() -> this.handleDelivery$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(consumerTag, envelope, requestId, lazyRef)), (String)actualRequestId))).getOrElse((Function0 & Serializable)() -> {
                    this.handleDelivery$$anonfun$2$$anonfun$2(consumerTag, envelope, requestId, lazyRef);
                    return BoxedUnit.UNIT;
                })).getOrElse((Function0 & Serializable)() -> {
                    this.handleDelivery$$anonfun$3(consumerTag, envelope, requestId, lazyRef);
                    return BoxedUnit.UNIT;
                });
            }

            private final scala.collection.immutable.Map requestProperties$lzyINIT1$1(String consumerTag$1, Envelope envelope$1, Option requestId$1, LazyRef requestProperties$lzy1$1) {
                scala.collection.immutable.Map map;
                LazyRef lazyRef = requestProperties$lzy1$1;
                synchronized (lazyRef) {
                    map = (scala.collection.immutable.Map)(requestProperties$lzy1$1.initialized() ? requestProperties$lzy1$1.value() : requestProperties$lzy1$1.initialize(RabbitMq$.MODULE$.messageProperties((Option<String>)requestId$1, envelope$1.getRoutingKey(), this.$outer.automorph$transport$amqp$server$RabbitMqServer$$urlText, (Option<String>)Option$.MODULE$.apply((Object)consumerTag$1))));
                }
                return map;
            }

            private final scala.collection.immutable.Map requestProperties$9(String consumerTag$2, Envelope envelope$2, Option requestId$2, LazyRef requestProperties$lzy1$2) {
                return (scala.collection.immutable.Map)(requestProperties$lzy1$2.initialized() ? requestProperties$lzy1$2.value() : this.requestProperties$lzyINIT1$1(consumerTag$2, envelope$2, requestId$2, requestProperties$lzy1$2));
            }

            private final scala.collection.immutable.Map handleDelivery$$anonfun$1(String consumerTag$10, Envelope envelope$10, Option requestId$11, LazyRef requestProperties$lzy1$10) {
                return this.requestProperties$9(consumerTag$10, envelope$10, requestId$11, requestProperties$lzy1$10);
            }

            private final scala.collection.immutable.Map handleDelivery$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String consumerTag$11, Envelope envelope$11, Option requestId$12, LazyRef requestProperties$lzy1$11) {
                return this.requestProperties$9(consumerTag$11, envelope$11, requestId$12, requestProperties$lzy1$11);
            }

            private final scala.collection.immutable.Map handleDelivery$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(String consumerTag$12, Envelope envelope$12, Option requestId$13, LazyRef requestProperties$lzy1$12) {
                return this.requestProperties$9(consumerTag$12, envelope$12, requestId$13, requestProperties$lzy1$12);
            }

            private final void handleDelivery$$anonfun$2$$anonfun$1$$anonfun$1(String consumerTag$5, Envelope envelope$5, AMQP.BasicProperties amqpProperties$3, byte[] requestBody$3, Option requestId$5, String replyTo$2, String actualRequestId$1, LazyRef requestProperties$lzy1$5) {
                AmqpContext<RabbitMq.Message> requestContext = RabbitMq$.MODULE$.messageContext(amqpProperties$3);
                Object handlerResult = this.$outer.handler().processRequest(requestBody$3, requestContext, actualRequestId$1);
                Extensions$.MODULE$.EffectOps(Extensions$.MODULE$.EffectOps(Extensions$.MODULE$.EffectOps(handlerResult).either(this.$outer.automorph$transport$amqp$server$RabbitMqServer$$system)).map((Function1)(JProcedure1 & Serializable)_$3 -> _$3.fold((Function1)(JProcedure1 & Serializable)error -> this.$outer.automorph$transport$amqp$server$RabbitMqServer$$sendErrorResponse((Throwable)error, replyTo$2, (Function0<scala.collection.immutable.Map<String, String>>)((Function0 & Serializable)() -> this.handleDelivery$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(consumerTag$5, envelope$5, requestId$5, requestProperties$lzy1$5)), actualRequestId$1), (Function1)(JProcedure1 & Serializable)result -> {
                    byte[] responseBody = (byte[])result.map(RabbitMqServer::automorph$transport$amqp$server$RabbitMqServer$$anon$1$$_$_$$anonfun$2).getOrElse(RabbitMqServer::automorph$transport$amqp$server$RabbitMqServer$$anon$1$$_$_$$anonfun$3);
                    this.$outer.automorph$transport$amqp$server$RabbitMqServer$$sendResponse(responseBody, replyTo$2, (Option<AmqpContext<RabbitMq.Message>>)result.flatMap(RabbitMqServer::automorph$transport$amqp$server$RabbitMqServer$$anon$1$$_$handleDelivery$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1), (Function0<scala.collection.immutable.Map<String, String>>)((Function0 & Serializable)() -> this.handleDelivery$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(consumerTag$5, envelope$5, requestId$5, requestProperties$lzy1$5)), actualRequestId$1);
                }), this.$outer.automorph$transport$amqp$server$RabbitMqServer$$system)).runAsync(this.$outer.automorph$transport$amqp$server$RabbitMqServer$$system);
            }

            private final scala.collection.immutable.Map handleDelivery$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(String consumerTag$14, Envelope envelope$14, Option requestId$15, LazyRef requestProperties$lzy1$14) {
                return this.requestProperties$9(consumerTag$14, envelope$14, requestId$15, requestProperties$lzy1$14);
            }

            private final String handleDelivery$$anonfun$2$$anonfun$2$$anonfun$1() {
                return "Missing " + this.$outer.automorph$transport$amqp$server$RabbitMqServer$$log.defaultProtocol() + " request header: correlation-id";
            }

            private final scala.collection.immutable.Map handleDelivery$$anonfun$2$$anonfun$2$$anonfun$2(String consumerTag$16, Envelope envelope$16, Option requestId$17, LazyRef requestProperties$lzy1$16) {
                return this.requestProperties$9(consumerTag$16, envelope$16, requestId$17, requestProperties$lzy1$16);
            }

            private final void handleDelivery$$anonfun$2$$anonfun$2(String consumerTag$15, Envelope envelope$15, Option requestId$16, LazyRef requestProperties$lzy1$15) {
                this.$outer.logger().error(this::handleDelivery$$anonfun$2$$anonfun$2$$anonfun$1, () -> this.handleDelivery$$anonfun$2$$anonfun$2$$anonfun$2(consumerTag$15, envelope$15, requestId$16, requestProperties$lzy1$15), (.less.colon.less)$less$colon$less$.MODULE$.refl());
            }

            private final String handleDelivery$$anonfun$3$$anonfun$1() {
                return "Missing " + this.$outer.automorph$transport$amqp$server$RabbitMqServer$$log.defaultProtocol() + " request header: reply-to";
            }

            private final scala.collection.immutable.Map handleDelivery$$anonfun$3$$anonfun$2(String consumerTag$19, Envelope envelope$19, Option requestId$20, LazyRef requestProperties$lzy1$19) {
                return this.requestProperties$9(consumerTag$19, envelope$19, requestId$20, requestProperties$lzy1$19);
            }

            private final void handleDelivery$$anonfun$3(String consumerTag$18, Envelope envelope$18, Option requestId$19, LazyRef requestProperties$lzy1$18) {
                this.$outer.logger().error(this::handleDelivery$$anonfun$3$$anonfun$1, () -> this.handleDelivery$$anonfun$3$$anonfun$2(consumerTag$18, envelope$18, requestId$19, requestProperties$lzy1$18), (.less.colon.less)$less$colon$less$.MODULE$.refl());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{handleDelivery$$anonfun$1(java.lang.String com.rabbitmq.client.Envelope scala.Option scala.runtime.LazyRef ), handleDelivery$$anonfun$2(java.lang.String com.rabbitmq.client.Envelope com.rabbitmq.client.AMQP$BasicProperties byte[] scala.Option scala.runtime.LazyRef java.lang.String ), handleDelivery$$anonfun$adapted$1(java.lang.String com.rabbitmq.client.Envelope scala.Option scala.runtime.LazyRef ), handleDelivery$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(java.lang.String com.rabbitmq.client.Envelope scala.Option scala.runtime.LazyRef ), automorph$transport$amqp$server$RabbitMqServer$$anon$1$$_$_$$anonfun$2(automorph.spi.RequestHandler$Result ), automorph$transport$amqp$server$RabbitMqServer$$anon$1$$_$_$$anonfun$3(), automorph$transport$amqp$server$RabbitMqServer$$anon$1$$_$handleDelivery$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(automorph.spi.RequestHandler$Result ), handleDelivery$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(java.lang.String com.rabbitmq.client.Envelope scala.Option scala.runtime.LazyRef ), handleDelivery$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(java.lang.String com.rabbitmq.client.Envelope scala.Option java.lang.String java.lang.String scala.runtime.LazyRef java.lang.Throwable ), handleDelivery$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(java.lang.String com.rabbitmq.client.Envelope scala.Option java.lang.String java.lang.String scala.runtime.LazyRef scala.Option ), handleDelivery$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(java.lang.String com.rabbitmq.client.Envelope scala.Option java.lang.String java.lang.String scala.runtime.LazyRef scala.util.Either ), handleDelivery$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(java.lang.String com.rabbitmq.client.Envelope scala.Option scala.runtime.LazyRef ), handleDelivery$$anonfun$2$$anonfun$1$$anonfun$adapted$1(java.lang.String com.rabbitmq.client.Envelope com.rabbitmq.client.AMQP$BasicProperties byte[] scala.Option java.lang.String java.lang.String scala.runtime.LazyRef ), handleDelivery$$anonfun$2$$anonfun$1$$anonfun$2(java.lang.String com.rabbitmq.client.Envelope scala.Option java.lang.String java.lang.String scala.runtime.LazyRef java.lang.Throwable ), handleDelivery$$anonfun$2$$anonfun$2$$anonfun$1(), handleDelivery$$anonfun$2$$anonfun$2$$anonfun$2(java.lang.String com.rabbitmq.client.Envelope scala.Option scala.runtime.LazyRef ), handleDelivery$$anonfun$2$$anonfun$1(java.lang.String com.rabbitmq.client.Envelope com.rabbitmq.client.AMQP$BasicProperties byte[] scala.Option java.lang.String scala.runtime.LazyRef java.lang.String ), handleDelivery$$anonfun$2$$anonfun$adapted$1(java.lang.String com.rabbitmq.client.Envelope scala.Option scala.runtime.LazyRef ), handleDelivery$$anonfun$3$$anonfun$1(), handleDelivery$$anonfun$3$$anonfun$2(java.lang.String com.rabbitmq.client.Envelope scala.Option scala.runtime.LazyRef )}, serializedLambda);
            }
        };
        this.queues().foreach((Function1 & Serializable)queue -> consumer.getChannel().basicConsume(queue, true, (Consumer)consumer));
        return consumer;
    }

    public void automorph$transport$amqp$server$RabbitMqServer$$sendResponse(byte[] message, String replyTo, Option<AmqpContext<RabbitMq.Message>> responseContext, Function0<scala.collection.immutable.Map<String, String>> requestProperties, String requestId) {
        LazyRef lazyRef = new LazyRef();
        String actualReplyTo = (String)responseContext.flatMap((Function1 & Serializable)context -> context.replyTo().orElse(() -> RabbitMqServer.$anonfun$4$$anonfun$1(context))).getOrElse(() -> RabbitMqServer.$anonfun$5(replyTo));
        this.automorph$transport$amqp$server$RabbitMqServer$$log.sendingResponse(() -> RabbitMqServer.sendResponse$$anonfun$1(requestProperties, actualReplyTo, lazyRef), this.automorph$transport$amqp$server$RabbitMqServer$$log.sendingResponse$default$2());
        Extensions$.MODULE$.TryOps(Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.sendResponse$$anonfun$2(message, responseContext, requestProperties, requestId, actualReplyTo, lazyRef);
            return BoxedUnit.UNIT;
        })).onError((Function1)(JProcedure1 & Serializable)error -> this.automorph$transport$amqp$server$RabbitMqServer$$log.failedSendResponse(error, () -> RabbitMqServer.sendResponse$$anonfun$3$$anonfun$1(requestProperties, actualReplyTo, lazyRef), this.automorph$transport$amqp$server$RabbitMqServer$$log.failedSendResponse$default$3())).get();
    }

    public void automorph$transport$amqp$server$RabbitMqServer$$sendErrorResponse(Throwable error, String replyTo, Function0<scala.collection.immutable.Map<String, String>> requestProperties, String requestId) {
        this.automorph$transport$amqp$server$RabbitMqServer$$log.failedProcessRequest(error, requestProperties, this.automorph$transport$amqp$server$RabbitMqServer$$log.failedProcessRequest$default$3());
        byte[] message = Extensions$.MODULE$.StringOps(Extensions$.MODULE$.ThrowableOps(error).description()).toByteArray();
        this.automorph$transport$amqp$server$RabbitMqServer$$sendResponse(message, replyTo, (Option<AmqpContext<RabbitMq.Message>>)None$.MODULE$, requestProperties, requestId);
    }

    public <Effect> RabbitMqServer<Effect> copy(EffectSystem<Effect> effectSystem, URI url, Seq<String> queues, Seq<Address> addresses, ConnectionFactory connectionFactory, RequestHandler<Effect, AmqpContext<RabbitMq.Message>> handler) {
        return new RabbitMqServer<Effect>(effectSystem, url, queues, addresses, connectionFactory, handler);
    }

    public <Effect> EffectSystem<Effect> copy$default$1() {
        return this.effectSystem();
    }

    public <Effect> URI copy$default$2() {
        return this.url();
    }

    public <Effect> Seq<String> copy$default$3() {
        return this.queues();
    }

    public <Effect> Seq<Address> copy$default$4() {
        return this.addresses();
    }

    public <Effect> ConnectionFactory copy$default$5() {
        return this.connectionFactory();
    }

    public <Effect> RequestHandler<Effect, AmqpContext<RabbitMq.Message>> copy$default$6() {
        return this.handler();
    }

    public EffectSystem<Effect> _1() {
        return this.effectSystem();
    }

    public URI _2() {
        return this.url();
    }

    public Seq<String> _3() {
        return this.queues();
    }

    public Seq<Address> _4() {
        return this.addresses();
    }

    public ConnectionFactory _5() {
        return this.connectionFactory();
    }

    public RequestHandler<Effect, AmqpContext<RabbitMq.Message>> _6() {
        return this.handler();
    }

    private static final Channel init$$anonfun$1$$anonfun$1$$anonfun$1(Connection connection$1) {
        return connection$1.createChannel();
    }

    private final void init$$anonfun$1$$anonfun$1() {
        Connection connection = RabbitMq$.MODULE$.connect(this.url(), this.addresses(), this.serverId, this.connectionFactory());
        RabbitMq$.MODULE$.declareExchange(this.exchange, connection);
        Using$.MODULE$.apply(() -> RabbitMqServer.init$$anonfun$1$$anonfun$1$$anonfun$1(connection), (Function1)(JProcedure1 & Serializable)channel -> this.queues().foreach((Function1 & Serializable)queue -> channel.queueDeclare(queue, false, false, false, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava())), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        ThreadLocal<DefaultConsumer> consumer = RabbitMq$.MODULE$.threadLocalConsumer(connection, (Function1 & Serializable)channel -> this.createConsumer((Channel)channel));
        this.createConsumer(connection.createChannel());
        this.session = Some$.MODULE$.apply((Object)RabbitMq$Session$.MODULE$.apply(connection, consumer));
    }

    private final void init$$anonfun$1() {
        RabbitMqServer rabbitMqServer = this;
        synchronized (rabbitMqServer) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)this.session.fold((Function0 & Serializable)() -> {
                this.init$$anonfun$1$$anonfun$1();
                return BoxedUnit.UNIT;
            }, (Function1)(JProcedure1 & Serializable)_$2 -> {
                throw new IllegalStateException(this.getClass().getSimpleName() + " already initialized");
            });
        }
    }

    private final void close$$anonfun$1() {
        RabbitMqServer rabbitMqServer = this;
        synchronized (rabbitMqServer) {
            RabbitMq$.MODULE$.close(this.session);
            this.session = None$.MODULE$;
        }
    }

    public static final /* synthetic */ byte[] automorph$transport$amqp$server$RabbitMqServer$$anon$1$$_$_$$anonfun$2(RequestHandler.Result _$4) {
        return _$4.responseBody();
    }

    public static final byte[] automorph$transport$amqp$server$RabbitMqServer$$anon$1$$_$_$$anonfun$3() {
        return Array$.MODULE$.emptyByteArray();
    }

    public static final /* synthetic */ Option automorph$transport$amqp$server$RabbitMqServer$$anon$1$$_$handleDelivery$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(RequestHandler.Result _$5) {
        return _$5.context();
    }

    private static final Option $anonfun$4$$anonfun$1(AmqpContext context$1) {
        return context$1.message().flatMap((Function1 & Serializable)transport -> Option$.MODULE$.apply((Object)transport.properties().getReplyTo()));
    }

    private static final String $anonfun$5(String replyTo$7) {
        return replyTo$7;
    }

    private static final scala.collection.immutable.Map responseProperties$lzyINIT1$1(Function0 requestProperties$1, String actualReplyTo$1, LazyRef responseProperties$lzy1$1) {
        scala.collection.immutable.Map map;
        LazyRef lazyRef = responseProperties$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (responseProperties$lzy1$1.initialized()) {
                object = responseProperties$lzy1$1.value();
            } else {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)RabbitMq$.MODULE$.routingKeyProperty());
                object = responseProperties$lzy1$1.initialize((Object)((scala.collection.immutable.Map)((MapOps)requestProperties$1.apply()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)actualReplyTo$1))));
            }
            map = (scala.collection.immutable.Map)object;
        }
        return map;
    }

    private static final scala.collection.immutable.Map responseProperties$1(Function0 requestProperties$2, String actualReplyTo$2, LazyRef responseProperties$lzy1$2) {
        return (scala.collection.immutable.Map)(responseProperties$lzy1$2.initialized() ? responseProperties$lzy1$2.value() : RabbitMqServer.responseProperties$lzyINIT1$1(requestProperties$2, actualReplyTo$2, responseProperties$lzy1$2));
    }

    private static final scala.collection.immutable.Map sendResponse$$anonfun$1(Function0 requestProperties$4, String actualReplyTo$4, LazyRef responseProperties$lzy1$4) {
        return RabbitMqServer.responseProperties$1(requestProperties$4, actualReplyTo$4, responseProperties$lzy1$4);
    }

    private static final scala.collection.immutable.Map sendResponse$$anonfun$2$$anonfun$1(Function0 requestProperties$5, String actualReplyTo$5, LazyRef responseProperties$lzy1$5) {
        return RabbitMqServer.responseProperties$1(requestProperties$5, actualReplyTo$5, responseProperties$lzy1$5);
    }

    private final void sendResponse$$anonfun$2(byte[] message$1, Option responseContext$1, Function0 requestProperties$3, String requestId$10, String actualReplyTo$3, LazyRef responseProperties$lzy1$3) {
        String mediaType = this.handler().mediaType();
        AMQP.BasicProperties amqpProperties = RabbitMq$.MODULE$.amqpProperties((Option<AmqpContext<RabbitMq.Message>>)responseContext$1, mediaType, actualReplyTo$3, requestId$10, this.serverId, true);
        ((RabbitMq.Session)this.session.get()).consumer().get().getChannel().basicPublish(this.exchange, actualReplyTo$3, true, false, amqpProperties, message$1);
        this.automorph$transport$amqp$server$RabbitMqServer$$log.sentResponse(() -> RabbitMqServer.sendResponse$$anonfun$2$$anonfun$1(requestProperties$3, actualReplyTo$3, responseProperties$lzy1$3), this.automorph$transport$amqp$server$RabbitMqServer$$log.sentResponse$default$2());
    }

    private static final scala.collection.immutable.Map sendResponse$$anonfun$3$$anonfun$1(Function0 requestProperties$8, String actualReplyTo$8, LazyRef responseProperties$lzy1$8) {
        return RabbitMqServer.responseProperties$1(requestProperties$8, actualReplyTo$8, responseProperties$lzy1$8);
    }
}

