/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil;

import avail.anvil.AdaptiveColor;
import avail.anvil.AvailWorkbench;
import avail.anvil.StyleAttributeFlags;
import avail.anvil.SystemColors;
import avail.io.NybbleInputStream;
import avail.io.NybbleOutputStream;
import java.awt.Color;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.availlang.artifact.environment.project.Palette;
import org.availlang.artifact.environment.project.StyleAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a \u0010\f\u001a\u00020\r*\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002\u001aq\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00150\u0013j\u0002`\u0016*\"\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0013j\u0004\u0018\u0001`\u00162&\u0010\u0017\u001a\"\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0013j\u0004\u0018\u0001`\u0016H\u0086\u0004\u001a$\u0010\u0018\u001a\u00020\u0002*\u00020\u00142\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\b\b\u0002\u0010\u001b\u001a\u00020\u0003\u001a\n\u0010\u001c\u001a\u00020\b*\u00020\u001d\u001a\u0012\u0010\u001c\u001a\u00020\u0015*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b\u001a\f\u0010 \u001a\u00020\u0002*\u00020\tH\u0002\u001a\u0014\u0010!\u001a\u00020\t*\u00020\u00142\u0006\u0010\"\u001a\u00020\bH\u0002\u001a\n\u0010#\u001a\u00020\b*\u00020\u001d\u001a\u0012\u0010$\u001a\u00020\u0015*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b\"!\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b*:\u0010%\"\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00150\u00132\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00150\u0013\u00a8\u0006&"}, d2={"colors", "", "", "Ljava/awt/Color;", "Lorg/availlang/artifact/environment/project/Palette;", "getColors", "(Lorg/availlang/artifact/environment/project/Palette;)Ljava/util/Map;", "flags", "", "Lorg/availlang/artifact/environment/project/StyleAttributes;", "getFlags", "(Lorg/availlang/artifact/environment/project/StyleAttributes;)I", "appendSpanTransitionIfChangedFrom", "", "startAttribute", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "compose", "Lkotlin/Function3;", "Ljavax/swing/text/StyledDocument;", "", "Lavail/anvil/RenderingFunction;", "otherFunction", "copyAsHtml5", "start", "pastEnd", "codeBackground", "opcode", "Lavail/io/NybbleInputStream;", "Lavail/io/NybbleOutputStream;", "value", "startSpanHtml5", "styleAttributesAt", "position", "unvlq", "vlq", "RenderingFunction", "avail"})
@SourceDebugExtension(value={"SMAP\nStyles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Styles.kt\navail/anvil/StylesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,4091:1\n1#2:4092\n*E\n"})
public final class StylesKt {
    @NotNull
    public static final Map<String, Color> getColors(@NotNull Palette $this$colors) {
        Intrinsics.checkNotNullParameter($this$colors, "<this>");
        return AvailWorkbench.Companion.getDarkMode() ? $this$colors.getDarkColors() : $this$colors.getLightColors();
    }

    @NotNull
    public static final Function3<StyledDocument, Integer, Integer, Unit> compose(@Nullable Function3<? super StyledDocument, ? super Integer, ? super Integer, Unit> $this$compose, @Nullable Function3<? super StyledDocument, ? super Integer, ? super Integer, Unit> otherFunction) {
        Function3<StyledDocument, Integer, Integer, Unit> function3;
        if ($this$compose == null) {
            Function3<StyledDocument, Integer, Integer, Unit> function32 = otherFunction;
            function3 = function32;
            Intrinsics.checkNotNull(function32);
        } else {
            function3 = otherFunction == null ? $this$compose : (Function3<StyledDocument, Integer, Integer, Unit>)new Function3<StyledDocument, Integer, Integer, Unit>($this$compose, otherFunction){
                final /* synthetic */ Function3<StyledDocument, Integer, Integer, Unit> $this_compose;
                final /* synthetic */ Function3<StyledDocument, Integer, Integer, Unit> $otherFunction;
                {
                    this.$this_compose = $receiver;
                    this.$otherFunction = $otherFunction;
                    super(3);
                }

                public final void invoke(@NotNull StyledDocument document2, int start, int pastEnd) {
                    Intrinsics.checkNotNullParameter(document2, "document");
                    this.$this_compose.invoke(document2, start, pastEnd);
                    this.$otherFunction.invoke(document2, start, pastEnd);
                }
            };
        }
        return function3;
    }

    @NotNull
    public static final String copyAsHtml5(@NotNull StyledDocument $this$copyAsHtml5, int start, int pastEnd, @NotNull Color codeBackground) {
        StyleAttributes previous;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$copyAsHtml5, "<this>");
        Intrinsics.checkNotNullParameter(codeBackground, "codeBackground");
        StringBuilder $this$copyAsHtml5_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$copyAsHtml5_u24lambda_u240.append("<html>");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2.append('\n'), "append('\\n')");
        StringBuilder stringBuilder3 = $this$copyAsHtml5_u24lambda_u240.append("<body style=\"background-color: " + AdaptiveColor.Companion.getHex(codeBackground) + "\">");
        Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder3.append('\n'), "append('\\n')");
        StringBuilder stringBuilder4 = $this$copyAsHtml5_u24lambda_u240.append("<div style=\"white-space: pre;\">");
        Intrinsics.checkNotNullExpressionValue(stringBuilder4, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder4.append('\n'), "append('\\n')");
        StyleAttributes current = previous = StylesKt.styleAttributesAt($this$copyAsHtml5, start);
        $this$copyAsHtml5_u24lambda_u240.append(StylesKt.startSpanHtml5(previous));
        $this$copyAsHtml5_u24lambda_u240.append($this$copyAsHtml5.getText(start, 1));
        for (int position = start + 1; position < pastEnd; ++position) {
            current = StylesKt.styleAttributesAt($this$copyAsHtml5, position);
            if (StylesKt.appendSpanTransitionIfChangedFrom(current, previous, $this$copyAsHtml5_u24lambda_u240)) {
                previous = current;
            }
            $this$copyAsHtml5_u24lambda_u240.append($this$copyAsHtml5.getText(position, 1));
        }
        if (StylesKt.getFlags(current) != 0) {
            StringBuilder stringBuilder5 = $this$copyAsHtml5_u24lambda_u240.append("</span>");
            Intrinsics.checkNotNullExpressionValue(stringBuilder5, "append(value)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder5.append('\n'), "append('\\n')");
        }
        StringBuilder stringBuilder6 = $this$copyAsHtml5_u24lambda_u240.append("</div>\n</body>\n</html>");
        Intrinsics.checkNotNullExpressionValue(stringBuilder6, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder6.append('\n'), "append('\\n')");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public static /* synthetic */ String copyAsHtml5$default(StyledDocument styledDocument, int n, int n2, Color color, int n3, Object object) {
        if ((n3 & 4) != 0) {
            color = SystemColors.Companion.getActive().getCodeBackground();
        }
        return StylesKt.copyAsHtml5(styledDocument, n, n2, color);
    }

    private static final StyleAttributes styleAttributesAt(StyledDocument $this$styleAttributesAt, int position) {
        AttributeSet $this$styleAttributesAt_u24lambda_u241 = $this$styleAttributesAt.getCharacterElement(position).getAttributes();
        boolean bl = false;
        Object object = $this$styleAttributesAt_u24lambda_u241.getAttribute(StyleConstants.Foreground);
        Color color = object instanceof Color ? (Color)object : null;
        String string2 = color != null ? AdaptiveColor.Companion.getHex(color) : null;
        Object object2 = $this$styleAttributesAt_u24lambda_u241.getAttribute(StyleConstants.Background);
        Color color2 = object2 instanceof Color ? (Color)object2 : null;
        String string3 = color2 != null ? AdaptiveColor.Companion.getHex(color2) : null;
        object2 = $this$styleAttributesAt_u24lambda_u241.getAttribute(StyleConstants.FontFamily);
        object = object2 instanceof String ? (String)object2 : null;
        Object object3 = $this$styleAttributesAt_u24lambda_u241.getAttribute(StyleConstants.Bold);
        object2 = object3 instanceof Boolean ? (Boolean)object3 : null;
        Object object4 = $this$styleAttributesAt_u24lambda_u241.getAttribute(StyleConstants.Italic);
        object3 = object4 instanceof Boolean ? (Boolean)object4 : null;
        Object object5 = $this$styleAttributesAt_u24lambda_u241.getAttribute(StyleConstants.Underline);
        object4 = object5 instanceof Boolean ? (Boolean)object5 : null;
        Object object6 = $this$styleAttributesAt_u24lambda_u241.getAttribute(StyleConstants.Superscript);
        object5 = object6 instanceof Boolean ? (Boolean)object6 : null;
        Object object7 = $this$styleAttributesAt_u24lambda_u241.getAttribute(StyleConstants.Subscript);
        object6 = object7 instanceof Boolean ? (Boolean)object7 : null;
        Object object8 = $this$styleAttributesAt_u24lambda_u241.getAttribute(StyleConstants.StrikeThrough);
        object7 = object8 instanceof Boolean ? (Boolean)object8 : null;
        return new StyleAttributes((String)object, string2, string3, (Boolean)object2, (Boolean)object3, (Boolean)object4, (Boolean)object5, (Boolean)object6, (Boolean)object7);
    }

    private static final String startSpanHtml5(StyleAttributes $this$startSpanHtml5) {
        String it;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder $this$startSpanHtml5_u24lambda_u246 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        StringBuilder $this$startSpanHtml5_u24lambda_u246_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        String string2 = $this$startSpanHtml5.getForeground();
        if (string2 != null) {
            it = string2;
            boolean bl3 = false;
            $this$startSpanHtml5_u24lambda_u246_u24lambda_u245.append("color: " + it + "; ");
        }
        String string3 = $this$startSpanHtml5.getBackground();
        if (string3 != null) {
            it = string3;
            boolean bl4 = false;
            $this$startSpanHtml5_u24lambda_u246_u24lambda_u245.append("background-color: " + it + "; ");
        }
        String string4 = $this$startSpanHtml5.getFontFamily();
        if (string4 != null) {
            it = string4;
            boolean bl5 = false;
            String font = Intrinsics.areEqual(it, "Monospaced") ? "monospace" : it;
            $this$startSpanHtml5_u24lambda_u246_u24lambda_u245.append("font-family: " + font + "; ");
        }
        if (Intrinsics.areEqual($this$startSpanHtml5.getBold(), true)) {
            $this$startSpanHtml5_u24lambda_u246_u24lambda_u245.append("font-weight: bold; ");
        }
        if (Intrinsics.areEqual($this$startSpanHtml5.getItalic(), true)) {
            $this$startSpanHtml5_u24lambda_u246_u24lambda_u245.append("font-style: italic; ");
        }
        if (Intrinsics.areEqual($this$startSpanHtml5.getUnderline(), true)) {
            $this$startSpanHtml5_u24lambda_u246_u24lambda_u245.append("text-decoration: underline; ");
        }
        if (Intrinsics.areEqual($this$startSpanHtml5.getSuperscript(), true)) {
            $this$startSpanHtml5_u24lambda_u246_u24lambda_u245.append("vertical-align: super; ");
        }
        if (Intrinsics.areEqual($this$startSpanHtml5.getSubscript(), true)) {
            $this$startSpanHtml5_u24lambda_u246_u24lambda_u245.append("vertical-align: sub; ");
        }
        if (Intrinsics.areEqual($this$startSpanHtml5.getStrikethrough(), true)) {
            $this$startSpanHtml5_u24lambda_u246_u24lambda_u245.append("text-decoration: line-through;");
        }
        String string5 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string5, "StringBuilder().apply(builderAction).toString()");
        String style = ((Object)StringsKt.trim((CharSequence)string5)).toString();
        if (((CharSequence)style).length() > 0) {
            $this$startSpanHtml5_u24lambda_u246.append("<span style=\"");
            $this$startSpanHtml5_u24lambda_u246.append(style);
            $this$startSpanHtml5_u24lambda_u246.append("\">");
        }
        String string6 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string6, "StringBuilder().apply(builderAction).toString()");
        return string6;
    }

    /*
     * WARNING - void declaration
     */
    private static final int getFlags(StyleAttributes $this$flags) {
        void var3_3;
        String it;
        StyleAttributes $this$_get_flags__u24lambda_u2410 = $this$flags;
        boolean bl = false;
        int flags = 0;
        String string2 = $this$_get_flags__u24lambda_u2410.getForeground();
        if (string2 != null) {
            it = string2;
            boolean bl2 = false;
            flags |= StyleAttributeFlags.INSTANCE.getForeground();
        }
        String string3 = $this$_get_flags__u24lambda_u2410.getBackground();
        if (string3 != null) {
            it = string3;
            boolean bl3 = false;
            flags |= StyleAttributeFlags.INSTANCE.getBackground();
        }
        String string4 = $this$_get_flags__u24lambda_u2410.getFontFamily();
        if (string4 != null) {
            it = string4;
            boolean bl4 = false;
            flags |= StyleAttributeFlags.INSTANCE.getFontFamily();
        }
        if (Intrinsics.areEqual($this$_get_flags__u24lambda_u2410.getBold(), true)) {
            flags |= StyleAttributeFlags.INSTANCE.getBold();
        }
        if (Intrinsics.areEqual($this$_get_flags__u24lambda_u2410.getItalic(), true)) {
            flags |= StyleAttributeFlags.INSTANCE.getItalic();
        }
        if (Intrinsics.areEqual($this$_get_flags__u24lambda_u2410.getUnderline(), true)) {
            flags |= StyleAttributeFlags.INSTANCE.getUnderline();
        }
        if (Intrinsics.areEqual($this$_get_flags__u24lambda_u2410.getSuperscript(), true)) {
            flags |= StyleAttributeFlags.INSTANCE.getSuperscript();
        }
        if (Intrinsics.areEqual($this$_get_flags__u24lambda_u2410.getSubscript(), true)) {
            flags |= StyleAttributeFlags.INSTANCE.getSubscript();
        }
        if (Intrinsics.areEqual($this$_get_flags__u24lambda_u2410.getStrikethrough(), true)) {
            flags |= StyleAttributeFlags.INSTANCE.getStrikethrough();
        }
        return (int)var3_3;
    }

    private static final boolean appendSpanTransitionIfChangedFrom(StyleAttributes $this$appendSpanTransitionIfChangedFrom, StyleAttributes startAttribute, StringBuilder builder) {
        if (!Intrinsics.areEqual($this$appendSpanTransitionIfChangedFrom, startAttribute)) {
            if (StylesKt.getFlags($this$appendSpanTransitionIfChangedFrom) != 0) {
                builder.append("</span>");
            }
            String it = StylesKt.startSpanHtml5($this$appendSpanTransitionIfChangedFrom);
            boolean bl = false;
            if (((CharSequence)it).length() > 0) {
                builder.append(it);
            }
            return true;
        }
        return false;
    }

    public static final void opcode(@NotNull NybbleOutputStream $this$opcode, int value) {
        int residue;
        boolean bl;
        Intrinsics.checkNotNullParameter($this$opcode, "<this>");
        boolean bl2 = bl = value >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        for (residue = value; residue >= 15; residue -= 15) {
            $this$opcode.write(15);
        }
        $this$opcode.write(residue);
    }

    public static final int opcode(@NotNull NybbleInputStream $this$opcode) {
        int nybble;
        Intrinsics.checkNotNullParameter($this$opcode, "<this>");
        int value = 0;
        while ((nybble = $this$opcode.read()) == 15) {
            value += 15;
        }
        return value += nybble;
    }

    public static final void vlq(@NotNull NybbleOutputStream $this$vlq, int value) {
        int residue;
        boolean bl;
        Intrinsics.checkNotNullParameter($this$vlq, "<this>");
        boolean bl2 = bl = value >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        for (residue = value; residue >= 8; residue >>>= 3) {
            int nybble = residue & 7 | 8;
            $this$vlq.write(nybble);
        }
        $this$vlq.write(residue);
    }

    public static final int unvlq(@NotNull NybbleInputStream $this$unvlq) {
        int nybble;
        Intrinsics.checkNotNullParameter($this$unvlq, "<this>");
        int n = 0;
        int k = 0;
        while (true) {
            nybble = $this$unvlq.read();
            if ((nybble & 8) != 8) break;
            n |= (nybble & 7) << k;
            k += 3;
        }
        return n | nybble << k;
    }
}

