/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.text;

import avail.anvil.AvailWorkbench;
import avail.anvil.Stylesheet;
import avail.anvil.SystemStyleClassifier;
import avail.anvil.ValidatedRenderingContext;
import avail.anvil.shortcuts.CodePaneShortcut;
import avail.anvil.text.CodeKit;
import avail.anvil.text.CodePane;
import avail.anvil.text.JTextPaneKeyTypedAdapter;
import avail.anvil.text.JTextPaneKeyTypedOverride;
import avail.anvil.text.WrapInAngleBrackets;
import avail.anvil.text.WrapInBackticks;
import avail.anvil.text.WrapInBraces;
import avail.anvil.text.WrapInBrackets;
import avail.anvil.text.WrapInDoubleQuotes;
import avail.anvil.text.WrapInDoubleSmartQuotes;
import avail.anvil.text.WrapInGuillemets;
import avail.anvil.text.WrapInParenthesis;
import avail.anvil.text.WrapInSingleQuotes;
import avail.anvil.text.WrapInSingleSmartQuotes;
import avail.utility.PrefixTree;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 :2\u00020\u0001:\u0002:;B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010$\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b%J\u0016\u0010&\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)J\u0006\u0010+\u001a\u00020\u000fJ\u0015\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0000\u00a2\u0006\u0002\b0J\u0015\u00101\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0000\u00a2\u0006\u0002\b2J\r\u00103\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b4J\r\u00105\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b6J\b\u00107\u001a\u00020\u000fH\u0002J\r\u00108\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b9R5\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006<"}, d2={"Lavail/anvil/text/CodePane;", "Ljavax/swing/JTextPane;", "workbench", "Lavail/anvil/AvailWorkbench;", "isEditable", "", "kit", "Lavail/anvil/text/CodeKit;", "(Lavail/anvil/AvailWorkbench;ZLavail/anvil/text/CodeKit;)V", "clickHandler", "Lkotlin/Function1;", "Ljava/awt/event/MouseEvent;", "Lkotlin/ParameterName;", "name", "e", "", "getClickHandler$avail", "()Lkotlin/jvm/functions/Function1;", "setClickHandler$avail", "(Lkotlin/jvm/functions/Function1;)V", "currentEdit", "Ljavax/swing/undo/CompoundEdit;", "getCurrentEdit$avail", "()Ljavax/swing/undo/CompoundEdit;", "setCurrentEdit$avail", "(Ljavax/swing/undo/CompoundEdit;)V", "lastCaretPosition", "", "templateSelectionState", "Lavail/anvil/text/CodePane$TemplateSelectionState;", "undoManager", "Ljavax/swing/undo/UndoManager;", "getUndoManager$avail", "()Ljavax/swing/undo/UndoManager;", "getWorkbench$avail", "()Lavail/anvil/AvailWorkbench;", "cancelTemplateExpansion", "cancelTemplateExpansion$avail", "changeFont", "", "updatedSize", "", "changeFontSize", "clearStaleTemplateSelectionState", "computeBackground", "Ljava/awt/Color;", "stylesheet", "Lavail/anvil/Stylesheet;", "computeBackground$avail", "computeForeground", "computeForeground$avail", "expandTemplate", "expandTemplate$avail", "initializeStyles", "initializeStyles$avail", "installUndoSupport", "registerKeystrokes", "registerKeystrokes$avail", "Companion", "TemplateSelectionState", "avail"})
@SourceDebugExtension(value={"SMAP\nCodePane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodePane.kt\navail/anvil/text/CodePane\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 PrefixTree.kt\navail/utility/PrefixTree$Companion\n*L\n1#1,450:1\n1855#2,2:451\n287#3:453\n*S KotlinDebug\n*F\n+ 1 CodePane.kt\navail/anvil/text/CodePane\n*L\n299#1:451,2\n350#1:453\n*E\n"})
public final class CodePane
extends JTextPane {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AvailWorkbench workbench;
    private int lastCaretPosition;
    @Nullable
    private CompoundEdit currentEdit;
    @NotNull
    private final UndoManager undoManager;
    @NotNull
    private Function1<? super MouseEvent, Unit> clickHandler;
    @Nullable
    private TemplateSelectionState templateSelectionState;
    @NotNull
    private static final TabSet tabSet;

    /*
     * WARNING - void declaration
     */
    public CodePane(@NotNull AvailWorkbench workbench, boolean isEditable, @NotNull CodeKit kit) {
        void $this$undoManager_u24lambda_u240;
        JTextPaneKeyTypedOverride[] jTextPaneKeyTypedOverrideArray;
        Intrinsics.checkNotNullParameter(workbench, "workbench");
        Intrinsics.checkNotNullParameter(kit, "kit");
        this.workbench = workbench;
        this.lastCaretPosition = Integer.MIN_VALUE;
        JTextPaneKeyTypedOverride[] jTextPaneKeyTypedOverrideArray2 = jTextPaneKeyTypedOverrideArray = new UndoManager();
        CodePane codePane = this;
        boolean bl = false;
        $this$undoManager_u24lambda_u240.setLimit(isEditable ? 1000 : 1);
        codePane.undoManager = jTextPaneKeyTypedOverrideArray;
        this.clickHandler = clickHandler.1.INSTANCE;
        this.setEditorKit(kit);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setEditable(isEditable);
        this.setEnabled(true);
        this.setFocusable(true);
        this.setPreferredSize(new Dimension(0, 500));
        this.setFont(Font.decode(this.workbench.getGlobalSettings().getFont() + " 13").deriveFont(this.workbench.getGlobalSettings().getCodePaneFontSize()));
        this.setBackground(this.computeBackground$avail(this.workbench.getStylesheet()));
        this.setForeground(this.computeForeground$avail(this.workbench.getStylesheet()));
        this.initializeStyles$avail();
        this.registerKeystrokes$avail();
        jTextPaneKeyTypedOverrideArray = new JTextPaneKeyTypedOverride[]{WrapInDoubleQuotes.INSTANCE, WrapInSingleQuotes.INSTANCE, WrapInDoubleSmartQuotes.INSTANCE, WrapInSingleSmartQuotes.INSTANCE, WrapInGuillemets.INSTANCE, WrapInBackticks.INSTANCE, WrapInParenthesis.INSTANCE, WrapInAngleBrackets.INSTANCE, WrapInBrackets.INSTANCE, WrapInBraces.INSTANCE};
        this.addKeyListener(new JTextPaneKeyTypedAdapter(jTextPaneKeyTypedOverrideArray));
        if (isEditable) {
            this.installUndoSupport();
            this.putClientProperty("undoManager", this.undoManager);
            this.putClientProperty("currentEdit", this.currentEdit);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                this.getClickHandler$avail().invoke(e);
            }
        });
    }

    public /* synthetic */ CodePane(AvailWorkbench availWorkbench, boolean bl, CodeKit codeKit, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            codeKit = new CodeKit(availWorkbench);
        }
        this(availWorkbench, bl, codeKit);
    }

    @NotNull
    public final AvailWorkbench getWorkbench$avail() {
        return this.workbench;
    }

    @Nullable
    public final CompoundEdit getCurrentEdit$avail() {
        return this.currentEdit;
    }

    public final void setCurrentEdit$avail(@Nullable CompoundEdit compoundEdit) {
        this.currentEdit = compoundEdit;
    }

    @NotNull
    public final UndoManager getUndoManager$avail() {
        return this.undoManager;
    }

    @NotNull
    public final Function1<MouseEvent, Unit> getClickHandler$avail() {
        return this.clickHandler;
    }

    public final void setClickHandler$avail(@NotNull Function1<? super MouseEvent, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, "<set-?>");
        this.clickHandler = function1;
    }

    public final void clearStaleTemplateSelectionState() {
        TemplateSelectionState templateSelectionState = this.templateSelectionState;
        if (!(templateSelectionState != null ? templateSelectionState.getExpandingTemplate() : false)) {
            this.templateSelectionState = null;
        }
    }

    @NotNull
    public final Color computeBackground$avail(@NotNull Stylesheet stylesheet) {
        Intrinsics.checkNotNullParameter(stylesheet, "stylesheet");
        Object object = stylesheet.get(SystemStyleClassifier.CODE_BACKGROUND.getClassifier()).getDocumentAttributes().getAttribute(StyleConstants.Background);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type java.awt.Color");
        return (Color)object;
    }

    @NotNull
    public final Color computeForeground$avail(@NotNull Stylesheet stylesheet) {
        Intrinsics.checkNotNullParameter(stylesheet, "stylesheet");
        Object object = stylesheet.get(SystemStyleClassifier.CODE_TEXT.getClassifier()).getDocumentAttributes().getAttribute(StyleConstants.Foreground);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type java.awt.Color");
        return (Color)object;
    }

    public final void changeFontSize(float updatedSize) {
        this.setFont(this.getFont().deriveFont(updatedSize));
    }

    public final void changeFont(@NotNull String name, float updatedSize) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.setFont(Font.decode(name).deriveFont(updatedSize));
    }

    public final void initializeStyles$avail() {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setTabSet(attributes, tabSet);
        StyleConstants.setFontFamily(attributes, "Monospaced");
        StyledDocument $this$initializeStyles_u24lambda_u241 = this.getStyledDocument();
        boolean bl = false;
        $this$initializeStyles_u24lambda_u241.setParagraphAttributes(0, $this$initializeStyles_u24lambda_u241.getLength(), attributes, false);
        Style defaultStyle = ValidatedRenderingContext.Companion.getDefaultDocumentStyle();
        defaultStyle.addAttributes(attributes);
    }

    private final void installUndoSupport() {
        this.addCaretListener(arg_0 -> CodePane.installUndoSupport$lambda$3(this, arg_0));
        this.getDocument().addUndoableEditListener(arg_0 -> CodePane.installUndoSupport$lambda$4(this, arg_0));
    }

    public final void registerKeystrokes$avail() {
        Iterable $this$forEach$iv = Reflection.getOrCreateKotlinClass(CodePaneShortcut.class).getSealedSubclasses();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KClass it = (KClass)element$iv;
            boolean bl = false;
            CodePaneShortcut codePaneShortcut = (CodePaneShortcut)it.getObjectInstance();
            if (codePaneShortcut == null) continue;
            InputMap inputMap = this.getInputMap();
            Intrinsics.checkNotNullExpressionValue(inputMap, "getInputMap(...)");
            codePaneShortcut.addToInputMap(inputMap);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void expandTemplate$avail() {
        int startPosition2;
        StyledDocument document2 = this.getStyledDocument();
        int length = 0;
        TemplateSelectionState state2 = this.templateSelectionState;
        if (state2 == null) {
            List list2;
            int n;
            int caretPosition;
            block12: {
                caretPosition = this.getCaretPosition();
                CodePane $this$expandTemplate_u24lambda_u246 = this;
                boolean bl = false;
                for (int i2 = caretPosition - 1; i2 >= 0; --i2) {
                    String string2;
                    Intrinsics.checkNotNullExpressionValue(document2.getText(i2, 1), "getText(...)");
                    int n2 = 0;
                    int c = string2.codePointAt(n2);
                    if (!Character.isWhitespace(c)) continue;
                    n = i2 + 1;
                    break block12;
                }
                n = 0;
            }
            if ((length = caretPosition - (startPosition2 = n)) == 0) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            String prefix = null;
            List candidates = null;
            while (length > 0) {
                void $this$payloads$iv;
                Intrinsics.checkNotNullExpressionValue(document2.getText(startPosition2, length), "getText(...)");
                PrefixTree.Companion bl = PrefixTree.Companion;
                PrefixTree<Integer, Set<String>> i2 = this.workbench.getTemplates();
                String key$iv = prefix;
                boolean $i$f$payloads = false;
                IntStream intStream = key$iv.codePoints();
                Intrinsics.checkNotNullExpressionValue(intStream, "codePoints(...)");
                candidates = CollectionsKt.flatten($this$payloads$iv.payloads((Iterable)StreamsKt.toList(intStream)));
                List list3 = candidates;
                if (list3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("candidates");
                    list3 = null;
                }
                if (!((Collection)list3).isEmpty()) break;
                ++startPosition2;
                --length;
            }
            if ((list2 = candidates) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("candidates");
                list2 = null;
            }
            if (list2.isEmpty()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            String string3 = prefix;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("prefix");
                string3 = null;
            }
            state2 = this.templateSelectionState = new TemplateSelectionState(startPosition2, string3, candidates);
        } else {
            state2.setExpandingTemplate(true);
            String oldCandidate = state2.getCandidate();
            length = CodePane.Companion.getExpandedLength(oldCandidate);
            TemplateSelectionState startPosition2 = state2;
            int prefix = startPosition2.getCandidateIndex();
            startPosition2.setCandidateIndex(prefix + 1);
            if (state2.getCandidateIndex() == state2.getCandidateExpansions().size()) {
                state2.setCandidateIndex(0);
                Toolkit.getDefaultToolkit().beep();
            }
        }
        TemplateSelectionState templateSelectionState = state2;
        Intrinsics.checkNotNull(templateSelectionState);
        String candidate = templateSelectionState.getCandidate();
        startPosition2 = state2.getStartPosition();
        document2.remove(startPosition2, length);
        document2.insertString(startPosition2, candidate, null);
        int desiredCharacterPosition = StringsKt.indexOf$default((CharSequence)candidate, '\u2041', 0, false, 6, null);
        if (desiredCharacterPosition >= 0) {
            this.setCaretPosition(startPosition2 + desiredCharacterPosition);
            document2.remove(this.getCaretPosition(), 1);
        } else {
            this.setCaretPosition(startPosition2 + candidate.length());
        }
        state2.setExpandingTemplate(false);
    }

    public final void cancelTemplateExpansion$avail() {
        TemplateSelectionState state2 = this.templateSelectionState;
        if (state2 != null) {
            int startPosition = state2.getStartPosition();
            int length = CodePane.Companion.getExpandedLength(state2.getCandidate());
            Document document2 = this.getDocument();
            document2.remove(startPosition, length);
            String prefix = state2.getTemplatePrefix();
            document2.insertString(startPosition, prefix, null);
            this.setCaretPosition(startPosition + prefix.length());
            this.templateSelectionState = null;
        }
    }

    private static final void installUndoSupport$lambda$3(CodePane this$0, CaretEvent e) {
        CompoundEdit currentEdit;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.clearStaleTemplateSelectionState();
        int dot = e.getDot();
        CompoundEdit compoundEdit = currentEdit = this$0.currentEdit;
        if (compoundEdit != null) {
            CompoundEdit it = compoundEdit;
            boolean bl = false;
            if (dot != this$0.lastCaretPosition && dot != this$0.lastCaretPosition + 1) {
                currentEdit.end();
            }
        }
        this$0.lastCaretPosition = dot;
    }

    private static final void installUndoSupport$lambda$4(CodePane this$0, UndoableEditEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        CompoundEdit edit = this$0.currentEdit;
        if (edit == null || !edit.isInProgress()) {
            edit = new CompoundEdit();
            this$0.undoManager.addEdit(edit);
            this$0.currentEdit = edit;
            this$0.putClientProperty("currentEdit", this$0.currentEdit);
        }
        edit.addEdit(it.getEdit());
    }

    static {
        int n = 0;
        TabStop[] tabStopArray = new TabStop[500];
        while (n < 500) {
            int n2 = n++;
            tabStopArray[n2] = new TabStop(32.0f * (float)(n2 + 1));
        }
        TabStop[] tabStopArray2 = tabStopArray;
        tabSet = new TabSet(tabStopArray2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lavail/anvil/text/CodePane$Companion;", "", "()V", "tabSet", "Ljavax/swing/text/TabSet;", "codePane", "Lavail/anvil/text/CodePane;", "Ljava/awt/event/ActionEvent;", "getCodePane$avail", "(Ljava/awt/event/ActionEvent;)Lavail/anvil/text/CodePane;", "expandedLength", "", "", "getExpandedLength", "(Ljava/lang/String;)I", "avail"})
    @SourceDebugExtension(value={"SMAP\nCodePane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodePane.kt\navail/anvil/text/CodePane$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,450:1\n1099#2,3:451\n*S KotlinDebug\n*F\n+ 1 CodePane.kt\navail/anvil/text/CodePane$Companion\n*L\n444#1:451,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final int getExpandedLength(String $this$expandedLength) {
            void $this$count$iv;
            CharSequence charSequence = $this$expandedLength;
            int n = $this$expandedLength.length();
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int j = 0; j < $this$count$iv.length(); ++j) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(j);
                boolean bl = false;
                if (!(it == '\u2041')) continue;
                ++count$iv;
            }
            int n2 = count$iv;
            return n - n2;
        }

        @NotNull
        public final CodePane getCodePane$avail(@NotNull ActionEvent $this$codePane) {
            Intrinsics.checkNotNullParameter($this$codePane, "<this>");
            Object object = $this$codePane.getSource();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type avail.anvil.text.CodePane");
            return (CodePane)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J-\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00142\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000b\u00a8\u0006#"}, d2={"Lavail/anvil/text/CodePane$TemplateSelectionState;", "", "startPosition", "", "templatePrefix", "", "candidateExpansions", "", "(ILjava/lang/String;Ljava/util/List;)V", "candidate", "getCandidate", "()Ljava/lang/String;", "getCandidateExpansions", "()Ljava/util/List;", "candidateIndex", "getCandidateIndex", "()I", "setCandidateIndex", "(I)V", "expandingTemplate", "", "getExpandingTemplate", "()Z", "setExpandingTemplate", "(Z)V", "getStartPosition", "getTemplatePrefix", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "avail"})
    public static final class TemplateSelectionState {
        private final int startPosition;
        @NotNull
        private final String templatePrefix;
        @NotNull
        private final List<String> candidateExpansions;
        private int candidateIndex;
        private boolean expandingTemplate;

        public TemplateSelectionState(int startPosition, @NotNull String templatePrefix, @NotNull List<String> candidateExpansions) {
            Intrinsics.checkNotNullParameter(templatePrefix, "templatePrefix");
            Intrinsics.checkNotNullParameter(candidateExpansions, "candidateExpansions");
            this.startPosition = startPosition;
            this.templatePrefix = templatePrefix;
            this.candidateExpansions = candidateExpansions;
            this.expandingTemplate = true;
        }

        public final int getStartPosition() {
            return this.startPosition;
        }

        @NotNull
        public final String getTemplatePrefix() {
            return this.templatePrefix;
        }

        @NotNull
        public final List<String> getCandidateExpansions() {
            return this.candidateExpansions;
        }

        public final int getCandidateIndex() {
            return this.candidateIndex;
        }

        public final void setCandidateIndex(int n) {
            this.candidateIndex = n;
        }

        public final boolean getExpandingTemplate() {
            return this.expandingTemplate;
        }

        public final void setExpandingTemplate(boolean bl) {
            this.expandingTemplate = bl;
        }

        @NotNull
        public final String getCandidate() {
            return this.candidateExpansions.get(this.candidateIndex);
        }

        public final int component1() {
            return this.startPosition;
        }

        @NotNull
        public final String component2() {
            return this.templatePrefix;
        }

        @NotNull
        public final List<String> component3() {
            return this.candidateExpansions;
        }

        @NotNull
        public final TemplateSelectionState copy(int startPosition, @NotNull String templatePrefix, @NotNull List<String> candidateExpansions) {
            Intrinsics.checkNotNullParameter(templatePrefix, "templatePrefix");
            Intrinsics.checkNotNullParameter(candidateExpansions, "candidateExpansions");
            return new TemplateSelectionState(startPosition, templatePrefix, candidateExpansions);
        }

        public static /* synthetic */ TemplateSelectionState copy$default(TemplateSelectionState templateSelectionState, int n, String string2, List list2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = templateSelectionState.startPosition;
            }
            if ((n2 & 2) != 0) {
                string2 = templateSelectionState.templatePrefix;
            }
            if ((n2 & 4) != 0) {
                list2 = templateSelectionState.candidateExpansions;
            }
            return templateSelectionState.copy(n, string2, list2);
        }

        @NotNull
        public String toString() {
            return "TemplateSelectionState(startPosition=" + this.startPosition + ", templatePrefix=" + this.templatePrefix + ", candidateExpansions=" + this.candidateExpansions + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.startPosition);
            result2 = result2 * 31 + this.templatePrefix.hashCode();
            result2 = result2 * 31 + ((Object)this.candidateExpansions).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TemplateSelectionState)) {
                return false;
            }
            TemplateSelectionState templateSelectionState = (TemplateSelectionState)other;
            if (this.startPosition != templateSelectionState.startPosition) {
                return false;
            }
            if (!Intrinsics.areEqual(this.templatePrefix, templateSelectionState.templatePrefix)) {
                return false;
            }
            return Intrinsics.areEqual(this.candidateExpansions, templateSelectionState.candidateExpansions);
        }
    }
}

