/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.tuples;

import avail.annotations.HideFieldInDebugger;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.AvailObjectRepresentation;
import avail.descriptor.representation.BitField;
import avail.descriptor.representation.Descriptor;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.IntegerIntervalTupleDescriptor;
import avail.descriptor.tuples.NumericTupleDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.SmallIntegerIntervalTupleDescriptor;
import avail.descriptor.tuples.TreeTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 92\u00020\u0001:\u00039:;B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0000H\u0016J\b\u0010\u0006\u001a\u00020\u0000H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J0\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J \u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010!\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u0010H\u0016J(\u0010#\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010%\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u0010H\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u0010H\u0016J\u0010\u0010-\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J8\u0010/\u001a\u0002002\u0006\u0010\t\u001a\u00020\n2\n\u00101\u001a\u000602j\u0002`32\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u000206052\u0006\u00107\u001a\u00020\u0010H\u0016J\b\u00108\u001a\u00020\u0000H\u0016\u00a8\u0006<"}, d2={"Lavail/descriptor/tuples/IntegerIntervalTupleDescriptor;", "Lavail/descriptor/tuples/NumericTupleDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "(Lavail/descriptor/representation/Mutability;)V", "immutable", "mutable", "o_AppendCanDestroy", "Lavail/descriptor/tuples/A_Tuple;", "self", "Lavail/descriptor/representation/AvailObject;", "newElement", "Lavail/descriptor/representation/A_BasicObject;", "canDestroy", "", "o_BitsPerEntry", "", "o_CompareFromToWithIntegerIntervalTupleStartingAt", "startIndex1", "endIndex1", "anIntegerIntervalTuple", "startIndex2", "o_CompareFromToWithStartingAt", "anotherObject", "o_ConcatenateWith", "otherTuple", "o_CopyTupleFromToCanDestroy", "start", "end", "o_Equals", "another", "o_EqualsIntegerIntervalTuple", "o_IsIntegerIntervalTuple", "o_TupleAt", "index", "o_TupleAtPuttingCanDestroy", "newValueObject", "o_TupleElementsInRangeAreInstancesOf", "startIndex", "endIndex", "type", "Lavail/descriptor/types/A_Type;", "o_TupleIntAt", "o_TupleLongAt", "", "o_TupleReverse", "o_TupleSize", "printObjectOnAvoidingIndent", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursionMap", "Ljava/util/IdentityHashMap;", "Ljava/lang/Void;", "indent", "shared", "Companion", "IntegerSlots", "ObjectSlots", "avail"})
@SourceDebugExtension(value={"SMAP\nIntegerIntervalTupleDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntegerIntervalTupleDescriptor.kt\navail/descriptor/tuples/IntegerIntervalTupleDescriptor\n+ 2 Descriptor.kt\navail/descriptor/representation/Descriptor$Companion\n*L\n1#1,649:1\n2862#2,12:650\n*S KotlinDebug\n*F\n+ 1 IntegerIntervalTupleDescriptor.kt\navail/descriptor/tuples/IntegerIntervalTupleDescriptor\n*L\n166#1:650,12\n*E\n"})
public final class IntegerIntervalTupleDescriptor
extends NumericTupleDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int maximumCopySize = 4;
    @NotNull
    private static final IntegerIntervalTupleDescriptor mutable = new IntegerIntervalTupleDescriptor(Mutability.MUTABLE);
    @NotNull
    private static final IntegerIntervalTupleDescriptor immutable = new IntegerIntervalTupleDescriptor(Mutability.IMMUTABLE);
    @NotNull
    private static final IntegerIntervalTupleDescriptor shared = new IntegerIntervalTupleDescriptor(Mutability.SHARED);

    private IntegerIntervalTupleDescriptor(Mutability mutability) {
        super(mutability, ObjectSlots.class, IntegerSlots.class);
    }

    @Override
    public void printObjectOnAvoidingIndent(@NotNull AvailObject self, @NotNull StringBuilder builder, @NotNull IdentityHashMap<A_BasicObject, Void> recursionMap, int indent) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(recursionMap, "recursionMap");
        Descriptor.Companion companion = Descriptor.Companion;
        StringBuilder $this$brief$iv = builder;
        boolean $i$f$brief = false;
        StringBuilder builder$iv = new StringBuilder();
        boolean bl = false;
        StringBuilder $this$printObjectOnAvoidingIndent_u24lambda_u240 = builder$iv;
        boolean bl2 = false;
        self.get(ObjectSlots.START).printOnAvoidingIndent($this$printObjectOnAvoidingIndent_u24lambda_u240, recursionMap, indent);
        $this$printObjectOnAvoidingIndent_u24lambda_u240.append(" to ");
        self.get(ObjectSlots.END).printOnAvoidingIndent($this$printObjectOnAvoidingIndent_u24lambda_u240, recursionMap, indent);
        A_Number delta = self.get(ObjectSlots.DELTA);
        if (!A_Number.Companion.equalsInt(delta, 1)) {
            $this$printObjectOnAvoidingIndent_u24lambda_u240.append(" by ");
            delta.printOnAvoidingIndent($this$printObjectOnAvoidingIndent_u24lambda_u240, recursionMap, indent);
        }
        if (builder$iv.length() <= 60) {
            CharSequence charSequence = builder$iv;
            Regex regex = Descriptor.Companion.getCompressionRegex();
            String string2 = " ";
            $this$brief$iv.append(regex.replace(charSequence, string2));
        } else {
            $this$brief$iv.append((CharSequence)builder$iv);
        }
    }

    @Override
    @NotNull
    public A_Tuple o_AppendCanDestroy(@NotNull AvailObject self, @NotNull A_BasicObject newElement, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(newElement, "newElement");
        int originalSize = A_Tuple.Companion.getTupleSize(self);
        A_Number endValue = self.get(ObjectSlots.END);
        A_Number deltaValue = self.get(ObjectSlots.DELTA);
        A_Number nextValue = A_Number.Companion.plusCanDestroy(endValue, deltaValue, false);
        if (newElement.equals(nextValue)) {
            AvailObject result2 = canDestroy && this.isMutable() ? self : AvailObjectRepresentation.Companion.newLike(mutable, self, 0, 0);
            result2.set(ObjectSlots.END, newElement);
            result2.set(IntegerSlots.Companion.getSIZE(), originalSize + 1);
            result2.set(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return result2;
        }
        A_Tuple singleton2 = ObjectTupleDescriptor.Companion.tuple(newElement);
        return A_Tuple.Companion.concatenateWith(self, singleton2, canDestroy);
    }

    @Override
    public int o_BitsPerEntry(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return 0;
    }

    @Override
    public boolean o_CompareFromToWithIntegerIntervalTupleStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple anIntegerIntervalTuple, int startIndex2) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(anIntegerIntervalTuple, "anIntegerIntervalTuple");
        if (self.sameAddressAs(anIntegerIntervalTuple) && startIndex1 == startIndex2) {
            return true;
        }
        if (self.equals(anIntegerIntervalTuple)) {
            if (!this.isShared()) {
                anIntegerIntervalTuple.makeImmutable();
                self.becomeIndirectionTo(anIntegerIntervalTuple);
            } else if (!anIntegerIntervalTuple.descriptor().isShared()) {
                self.makeImmutable();
                anIntegerIntervalTuple.becomeIndirectionTo(self);
            }
            return startIndex1 == startIndex2;
        }
        A_Tuple first = A_Tuple.Companion.copyTupleFromToCanDestroy(self, startIndex1, endIndex1, false);
        A_Tuple second = A_Tuple.Companion.copyTupleFromToCanDestroy(anIntegerIntervalTuple, startIndex2, startIndex2 + endIndex1 - startIndex1, false);
        return first.equals(second);
    }

    @Override
    public boolean o_CompareFromToWithStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple anotherObject, int startIndex2) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(anotherObject, "anotherObject");
        return A_Tuple.Companion.compareFromToWithIntegerIntervalTupleStartingAt(anotherObject, startIndex2, startIndex2 + endIndex1 - startIndex1, self, startIndex1);
    }

    @Override
    @NotNull
    public A_Tuple o_CopyTupleFromToCanDestroy(@NotNull AvailObject self, int start, int end, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        int oldSize = self.get(IntegerSlots.Companion.getSIZE());
        boolean bl2 = bl = (1 <= start ? start <= end + 1 : false) && end <= oldSize;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int newSize = end - start + 1;
        if (newSize != oldSize) {
            AvailObject delta = self.get(ObjectSlots.DELTA).makeImmutable();
            AvailObject oldStartValue = self.get(ObjectSlots.START);
            A_Number a_Number = A_Number.Companion.plusCanDestroy(oldStartValue, A_Number.Companion.multiplyByIntegerCanDestroy(IntegerDescriptor.Companion.fromInt(start - 1), delta, true), canDestroy);
            Intrinsics.checkNotNull(a_Number, "null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
            AvailObject newStartValue = (AvailObject)a_Number;
            A_Number a_Number2 = A_Number.Companion.plusCanDestroy(newStartValue, A_Number.Companion.multiplyByIntegerCanDestroy(IntegerDescriptor.Companion.fromInt(newSize - 1), delta, true), false);
            Intrinsics.checkNotNull(a_Number2, "null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
            AvailObject newEndValue = (AvailObject)a_Number2;
            if (this.isMutable() && canDestroy) {
                self.set(ObjectSlots.START, newStartValue);
                self.set(ObjectSlots.END, newEndValue);
                self.set(IntegerSlots.Companion.getSIZE(), newSize);
                return self;
            }
            return Companion.createInterval(newStartValue, newEndValue, delta);
        }
        if (this.isMutable() && !canDestroy) {
            self.makeImmutable();
        }
        return self;
    }

    @Override
    @NotNull
    public A_Tuple o_ConcatenateWith(@NotNull AvailObject self, @NotNull A_Tuple otherTuple, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(otherTuple, "otherTuple");
        if (!canDestroy) {
            self.makeImmutable();
            otherTuple.makeImmutable();
        }
        if (A_Tuple.Companion.getTupleSize(otherTuple) == 0) {
            return self;
        }
        if (otherTuple.isIntegerIntervalTuple()) {
            AvailObject otherDirect = otherTuple.traversed();
            AvailObject delta = self.get(ObjectSlots.DELTA);
            if (delta.equals(otherDirect.get(ObjectSlots.DELTA)) && A_Number.Companion.plusCanDestroy(self.get(ObjectSlots.END), delta, false).equals(otherDirect.get(ObjectSlots.START))) {
                int newSize = self.get(IntegerSlots.Companion.getSIZE()) + otherDirect.get(IntegerSlots.Companion.getSIZE());
                if (this.isMutable()) {
                    self.set(ObjectSlots.END, otherDirect.get(ObjectSlots.END));
                    self.set(IntegerSlots.Companion.getSIZE(), newSize);
                    self.setHashOrZero(0);
                    return self;
                }
                if (otherTuple.descriptor().isMutable()) {
                    otherDirect.set(ObjectSlots.START, self.get(ObjectSlots.START));
                    otherDirect.set(IntegerSlots.Companion.getSIZE(), newSize);
                    otherDirect.setHashOrZero(0);
                    return otherDirect;
                }
                return Companion.createInterval(self.get(ObjectSlots.START), otherDirect.get(ObjectSlots.END), delta);
            }
        }
        if (A_Tuple.Companion.getTreeTupleLevel(otherTuple) == 0) {
            return TreeTupleDescriptor.Companion.createTwoPartTreeTuple(self, otherTuple, 1, 0);
        }
        return TreeTupleDescriptor.Companion.concatenateAtLeastOneTree(self, otherTuple, true);
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(another, "another");
        return another.equalsIntegerIntervalTuple(self);
    }

    @Override
    public boolean o_EqualsIntegerIntervalTuple(@NotNull AvailObject self, @NotNull A_Tuple anIntegerIntervalTuple) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(anIntegerIntervalTuple, "anIntegerIntervalTuple");
        if (self.sameAddressAs(anIntegerIntervalTuple)) {
            return true;
        }
        AvailObject firstTraversed = self.traversed();
        AvailObject secondTraversed = anIntegerIntervalTuple.traversed();
        int firstHash = firstTraversed.get(IntegerSlots.Companion.getHASH_OR_ZERO());
        int secondHash = secondTraversed.get(IntegerSlots.Companion.getHASH_OR_ZERO());
        if (firstHash != 0 && secondHash != 0 && firstHash != secondHash) {
            return false;
        }
        if (firstTraversed.get(IntegerSlots.Companion.getSIZE()) != secondTraversed.get(IntegerSlots.Companion.getSIZE())) {
            return false;
        }
        if (!firstTraversed.get(ObjectSlots.DELTA).equals(secondTraversed.get(ObjectSlots.DELTA))) {
            return false;
        }
        if (!firstTraversed.get(ObjectSlots.START).equals(secondTraversed.get(ObjectSlots.START))) {
            return false;
        }
        if (!this.isShared()) {
            anIntegerIntervalTuple.makeImmutable();
            self.becomeIndirectionTo(anIntegerIntervalTuple);
        } else if (!anIntegerIntervalTuple.descriptor().isShared()) {
            self.makeImmutable();
            anIntegerIntervalTuple.becomeIndirectionTo(self);
        }
        return true;
    }

    @Override
    public boolean o_IsIntegerIntervalTuple(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return true;
    }

    @Override
    @NotNull
    public AvailObject o_TupleAt(@NotNull AvailObject self, int index2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        boolean bl2 = bl = index2 >= 1 && index2 <= A_Tuple.Companion.getTupleSize(self);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Number temp = IntegerDescriptor.Companion.fromInt(index2 - 1);
        temp = A_Number.Companion.timesCanDestroy(temp, self.get(ObjectSlots.DELTA), false);
        A_Number a_Number = temp = A_Number.Companion.plusCanDestroy(temp, self.get(ObjectSlots.START), false);
        Intrinsics.checkNotNull(a_Number, "null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
        return (AvailObject)a_Number;
    }

    @Override
    @NotNull
    public A_Tuple o_TupleAtPuttingCanDestroy(@NotNull AvailObject self, int index2, @NotNull A_BasicObject newValueObject, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(newValueObject, "newValueObject");
        boolean bl2 = bl = index2 >= 1 && index2 <= A_Tuple.Companion.getTupleSize(self);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailObject newValueStrong = (AvailObject)newValueObject;
        if (A_Number.Companion.isInt(newValueStrong) && A_Tuple.Companion.tupleIntAt(self, index2) == A_Number.Companion.getExtractInt(newValueStrong)) {
            if (!canDestroy) {
                self.makeImmutable();
            }
            return self;
        }
        A_Tuple result2 = A_Tuple.Companion.tupleAtPuttingCanDestroy(A_Tuple.Companion.copyAsMutableObjectTuple(self), index2, newValueObject, true);
        if (!canDestroy) {
            self.makeImmutable();
        }
        return result2;
    }

    @Override
    public boolean o_TupleElementsInRangeAreInstancesOf(@NotNull AvailObject self, int startIndex, int endIndex, @NotNull A_Type type2) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(type2, "type");
        A_Number start = A_Tuple.Companion.tupleAt(self, startIndex);
        A_Number end = A_Tuple.Companion.tupleAt(self, endIndex);
        A_Number low = null;
        A_Number high = null;
        if (A_Number.Companion.lessThan(start, end)) {
            low = start;
            high = end;
        } else {
            low = end;
            high = start;
        }
        return A_Type.Companion.isSupertypeOfIntegerRangeType(type2, IntegerRangeTypeDescriptor.Companion.inclusive(low, high)) || super.o_TupleElementsInRangeAreInstancesOf(self, startIndex, endIndex, type2);
    }

    @Override
    public int o_TupleIntAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter(self, "self");
        return A_Number.Companion.getExtractInt(A_Tuple.Companion.tupleAt(self, index2));
    }

    @Override
    public long o_TupleLongAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter(self, "self");
        return A_Number.Companion.getExtractLong(A_Tuple.Companion.tupleAt(self, index2));
    }

    @Override
    @NotNull
    public A_Tuple o_TupleReverse(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        if (A_Tuple.Companion.getTupleSize(self) < 4 || !this.isMutable()) {
            A_Number newDelta = A_Number.Companion.timesCanDestroy(self.get(ObjectSlots.DELTA), IntegerDescriptor.Companion.fromInt(-1), true);
            return IntegerIntervalTupleDescriptor.Companion.forceCreate(self.get(ObjectSlots.END), self.get(ObjectSlots.START), newDelta, this.o_TupleSize(self));
        }
        A_Number newStart = self.get(ObjectSlots.END);
        A_Number newEnd = self.get(ObjectSlots.START);
        A_Number newDelta = A_Number.Companion.timesCanDestroy(self.get(ObjectSlots.DELTA), IntegerDescriptor.Companion.fromInt(-1), true);
        self.set(ObjectSlots.START, newStart);
        self.set(ObjectSlots.END, newEnd);
        self.set(ObjectSlots.DELTA, newDelta);
        return self;
    }

    @Override
    public int o_TupleSize(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.get(IntegerSlots.Companion.getSIZE());
    }

    @Override
    @NotNull
    public IntegerIntervalTupleDescriptor mutable() {
        return mutable;
    }

    @Override
    @NotNull
    public IntegerIntervalTupleDescriptor immutable() {
        return immutable;
    }

    @Override
    @NotNull
    public IntegerIntervalTupleDescriptor shared() {
        return shared;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eJ(\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lavail/descriptor/tuples/IntegerIntervalTupleDescriptor$Companion;", "", "()V", "immutable", "Lavail/descriptor/tuples/IntegerIntervalTupleDescriptor;", "maximumCopySize", "", "mutable", "getMutable", "()Lavail/descriptor/tuples/IntegerIntervalTupleDescriptor;", "shared", "createInterval", "Lavail/descriptor/tuples/A_Tuple;", "start", "Lavail/descriptor/representation/AvailObject;", "end", "delta", "forceCreate", "Lavail/descriptor/numbers/A_Number;", "normalizedEnd", "size", "avail"})
    @SourceDebugExtension(value={"SMAP\nIntegerIntervalTupleDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntegerIntervalTupleDescriptor.kt\navail/descriptor/tuples/IntegerIntervalTupleDescriptor$Companion\n+ 2 AbstractDescriptor.kt\navail/descriptor/representation/AbstractDescriptor\n*L\n1#1,649:1\n571#2,4:650\n*S KotlinDebug\n*F\n+ 1 IntegerIntervalTupleDescriptor.kt\navail/descriptor/tuples/IntegerIntervalTupleDescriptor$Companion\n*L\n629#1:650,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final A_Tuple createInterval(@NotNull AvailObject start, @NotNull AvailObject end, @NotNull AvailObject delta) {
            boolean bl;
            Intrinsics.checkNotNullParameter(start, "start");
            Intrinsics.checkNotNullParameter(end, "end");
            Intrinsics.checkNotNullParameter(delta, "delta");
            boolean bl2 = bl = !A_Number.Companion.equalsInt(delta, 0);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            A_Number difference = A_Number.Companion.minusCanDestroy(end, start, false);
            A_Number zero2 = IntegerDescriptor.Companion.getZero();
            if (A_Number.Companion.equalsInt(difference, 0)) {
                return ObjectTupleDescriptor.Companion.tuple(start);
            }
            if (A_Number.Companion.greaterThan(difference, zero2) != A_Number.Companion.greaterThan(delta, zero2)) {
                return TupleDescriptor.Companion.getEmptyTuple();
            }
            int size = 1 + A_Number.Companion.getExtractInt(A_Number.Companion.divideCanDestroy(difference, delta, false));
            if (size < 4) {
                List members2 = new ArrayList();
                A_Number newMember = start;
                for (int i2 = 0; i2 < size; ++i2) {
                    members2.add(newMember);
                    newMember = A_Number.Companion.addToIntegerCanDestroy(newMember, delta, false);
                }
                return ObjectTupleDescriptor.Companion.tupleFromList(members2);
            }
            if (SmallIntegerIntervalTupleDescriptor.Companion.isSmallIntervalCandidate(start, end, delta)) {
                return SmallIntegerIntervalTupleDescriptor.Companion.createSmallInterval(A_Number.Companion.getExtractInt(start), A_Number.Companion.getExtractInt(end), A_Number.Companion.getExtractInt(delta));
            }
            A_Number adjustedEnd = A_Number.Companion.plusCanDestroy(start, A_Number.Companion.timesCanDestroy(delta, IntegerDescriptor.Companion.fromInt(size - 1), false), false);
            return this.forceCreate(start, adjustedEnd, delta, size);
        }

        private final A_Tuple forceCreate(A_Number start, A_Number normalizedEnd, A_Number delta, int size) {
            AvailObject availObject;
            AbstractDescriptor $this$iv = this.getMutable();
            int indexedSlotCount$iv = 0;
            boolean $i$f$create = false;
            AvailObject $this$forceCreate_u24lambda_u240 = availObject = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, $this$iv);
            boolean bl = false;
            $this$forceCreate_u24lambda_u240.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            $this$forceCreate_u24lambda_u240.setSlot(ObjectSlots.START, start.makeImmutable());
            $this$forceCreate_u24lambda_u240.setSlot(ObjectSlots.END, normalizedEnd.makeImmutable());
            $this$forceCreate_u24lambda_u240.setSlot(ObjectSlots.DELTA, delta.makeImmutable());
            $this$forceCreate_u24lambda_u240.setSlot(IntegerSlots.Companion.getSIZE(), size);
            return availObject;
        }

        @NotNull
        public final IntegerIntervalTupleDescriptor getMutable() {
            return mutable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u0000 \u00052\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0006"}, d2={"Lavail/descriptor/tuples/IntegerIntervalTupleDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "HASH_AND_MORE", "Companion", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final BitField SIZE;
        @NotNull
        private static final BitField HASH_OR_ZERO;
        @HideFieldInDebugger
        public static final /* enum */ IntegerSlots HASH_AND_MORE;
        private static final /* synthetic */ IntegerSlots[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        @NotNull
        public static EnumEntries<IntegerSlots> getEntries() {
            return $ENTRIES;
        }

        static {
            boolean bl;
            HASH_AND_MORE = new IntegerSlots();
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.HASH_AND_MORE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            SIZE = new BitField(HASH_AND_MORE, 32, 32, Companion.SIZE.1.INSTANCE);
            HASH_OR_ZERO = new BitField(HASH_AND_MORE, 0, 32, Companion.HASH_OR_ZERO.1.INSTANCE);
            boolean bl2 = bl = TupleDescriptor.IntegerSlots.HASH_AND_MORE.ordinal() == HASH_AND_MORE.ordinal();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            bl = TupleDescriptor.IntegerSlots.Companion.getHASH_OR_ZERO().isSamePlaceAs(HASH_OR_ZERO);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lavail/descriptor/tuples/IntegerIntervalTupleDescriptor$IntegerSlots$Companion;", "", "()V", "HASH_OR_ZERO", "Lavail/descriptor/representation/BitField;", "getHASH_OR_ZERO", "()Lavail/descriptor/representation/BitField;", "SIZE", "getSIZE", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BitField getSIZE() {
                return SIZE;
            }

            @NotNull
            public final BitField getHASH_OR_ZERO() {
                return HASH_OR_ZERO;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/tuples/IntegerIntervalTupleDescriptor$ObjectSlots;", "", "Lavail/descriptor/representation/ObjectSlotsEnum;", "(Ljava/lang/String;I)V", "START", "END", "DELTA", "avail"})
    public static final class ObjectSlots
    extends Enum<ObjectSlots>
    implements ObjectSlotsEnum {
        public static final /* enum */ ObjectSlots START = new ObjectSlots();
        public static final /* enum */ ObjectSlots END = new ObjectSlots();
        public static final /* enum */ ObjectSlots DELTA = new ObjectSlots();
        private static final /* synthetic */ ObjectSlots[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ObjectSlots[] values() {
            return (ObjectSlots[])$VALUES.clone();
        }

        public static ObjectSlots valueOf(String value) {
            return Enum.valueOf(ObjectSlots.class, value);
        }

        @NotNull
        public static EnumEntries<ObjectSlots> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = objectSlotsArray = new ObjectSlots[]{ObjectSlots.START, ObjectSlots.END, ObjectSlots.DELTA};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

