/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operand;

import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.objects.ObjectLayoutVariant;
import avail.descriptor.objects.ObjectTypeDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TypeDescriptor;
import avail.descriptor.types.TypeTag;
import avail.interpreter.levelTwo.register.L2Register;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 T2\u00020\u0001:\u0003TUVB7\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0014J\u000e\u0010%\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0014J\u0010\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\fJ\u0013\u0010)\u001a\u00020\u00062\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010+\u001a\u00020\u0000J\u0006\u0010,\u001a\u00020\u0000J\u0006\u0010-\u001a\u00020\u0000J\u000e\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u00020\fH\u0016J\u000e\u00102\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0000J\u000e\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u00020\u00002\u0006\u00104\u001a\u000205J\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0014J\u000e\u00109\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0014J\u000e\u0010:\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0000J\f\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<J\u0006\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u00020\u0000J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u000205J\u000e\u0010C\u001a\u00020\u00002\u0006\u0010B\u001a\u000205J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u0014J\u000e\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u0018J\u0014\u0010H\u001a\u00020\u00002\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00180JJ\u0014\u0010K\u001a\u00020\u00002\f\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\fJ\u0006\u0010M\u001a\u00020NJ\b\u0010O\u001a\u00020NH\u0016J\u000e\u0010P\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0000J\u000e\u0010Q\u001a\u00020\u00002\u0006\u0010R\u001a\u000200J\u000e\u0010S\u001a\u00020\u00002\u0006\u0010R\u001a\u000200R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0007\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u001cR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u001cR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u001cR\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0011\u0010 \u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006W"}, d2={"Lavail/interpreter/levelTwo/operand/TypeRestriction;", "", "positiveGroup", "Lavail/interpreter/levelTwo/operand/TypeRestriction$RestrictionGroup;", "negativeGroup", "isImmutable", "", "isBoxed", "isUnboxedInt", "isUnboxedFloat", "(Lavail/interpreter/levelTwo/operand/TypeRestriction$RestrictionGroup;Lavail/interpreter/levelTwo/operand/TypeRestriction$RestrictionGroup;ZZZZ)V", "flags", "", "(Lavail/interpreter/levelTwo/operand/TypeRestriction$RestrictionGroup;Lavail/interpreter/levelTwo/operand/TypeRestriction$RestrictionGroup;I)V", "constantOrNull", "Lavail/descriptor/representation/AvailObject;", "getConstantOrNull", "()Lavail/descriptor/representation/AvailObject;", "excludedTypes", "", "Lavail/descriptor/types/A_Type;", "getExcludedTypes", "()Ljava/util/Set;", "excludedValues", "Lavail/descriptor/representation/A_BasicObject;", "getExcludedValues", "getFlags", "()I", "()Z", "getNegativeGroup", "()Lavail/interpreter/levelTwo/operand/TypeRestriction$RestrictionGroup;", "getPositiveGroup", "type", "getType", "()Lavail/descriptor/types/A_Type;", "containedByType", "testType", "containsEntireType", "enumerationValuesOrNull", "Lavail/descriptor/sets/A_Set;", "maximumCount", "equals", "other", "forBoxed", "forUnboxedFloat", "forUnboxedInt", "hasFlag", "restrictionFlag", "Lavail/interpreter/levelTwo/operand/TypeRestriction$RestrictionFlagEncoding;", "hashCode", "intersection", "intersectionWithObjectTypeVariant", "variantToIntersect", "Lavail/descriptor/objects/ObjectLayoutVariant;", "intersectionWithObjectVariant", "intersectionWithType", "typeToIntersect", "intersectsType", "isStrongerThan", "kinds", "Ljava/util/EnumSet;", "Lavail/interpreter/levelTwo/register/L2Register$RegisterKind;", "makeShared", "", "metaRestriction", "minusObjectTypeVariant", "variantToRemove", "minusObjectVariant", "minusType", "typeToExclude", "minusValue", "valueToExclude", "minusValues", "valuesToExclude", "", "restrictingKindsTo", "kindFlagEncoding", "suffixString", "", "toString", "union", "withFlag", "flagEncoding", "withoutFlag", "Companion", "RestrictionFlagEncoding", "RestrictionGroup", "avail"})
@SourceDebugExtension(value={"SMAP\nTypeRestriction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeRestriction.kt\navail/interpreter/levelTwo/operand/TypeRestriction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Casts.kt\navail/utility/CastsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1890:1\n1#2:1891\n46#3:1892\n857#4:1893\n1747#4,3:1894\n858#4:1897\n857#4:1898\n1747#4,3:1899\n858#4:1902\n1747#4,3:1903\n2624#4,3:1906\n1747#4,3:1909\n2624#4,3:1914\n2624#4,3:1917\n4307#5,2:1912\n*S KotlinDebug\n*F\n+ 1 TypeRestriction.kt\navail/interpreter/levelTwo/operand/TypeRestriction\n*L\n331#1:1892\n436#1:1893\n438#1:1894,3\n436#1:1897\n440#1:1898\n441#1:1899,3\n440#1:1902\n756#1:1903,3\n759#1:1906,3\n804#1:1909,3\n1060#1:1914,3\n1069#1:1917,3\n1018#1:1912,2\n*E\n"})
public final class TypeRestriction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RestrictionGroup positiveGroup;
    @NotNull
    private final RestrictionGroup negativeGroup;
    private final int flags;
    @NotNull
    private static final TypeRestriction nilRestriction = new TypeRestriction(new RestrictionGroup(SetsKt.setOf(NilDescriptor.Companion.getNil()), SetsKt.setOf(PrimitiveTypeDescriptor.Types.TOP.getO()), null, null, SetsKt.setOf(TypeTag.NIL_TAG)), new RestrictionGroup(SetsKt.emptySet(), SetsKt.setOf(PrimitiveTypeDescriptor.Types.ANY.getO()), null, null, null), true, true, false, false);
    @NotNull
    private static final TypeRestriction topRestriction = new TypeRestriction(new RestrictionGroup(null, SetsKt.setOf(PrimitiveTypeDescriptor.Types.TOP.getO()), null, null, null), new RestrictionGroup(SetsKt.emptySet(), SetsKt.emptySet(), null, null, null), false, true, false, false);
    @NotNull
    private static final TypeRestriction topRestrictionImmutable = new TypeRestriction(new RestrictionGroup(null, SetsKt.setOf(PrimitiveTypeDescriptor.Types.TOP.getO()), null, null, null), new RestrictionGroup(SetsKt.emptySet(), SetsKt.emptySet(), null, null, null), true, true, false, false);
    @NotNull
    private static final TypeRestriction anyRestriction = new TypeRestriction(new RestrictionGroup(null, SetsKt.setOf(PrimitiveTypeDescriptor.Types.ANY.getO()), null, null, null), new RestrictionGroup(SetsKt.emptySet(), SetsKt.emptySet(), null, null, null), false, true, false, false);
    @NotNull
    private static final TypeRestriction anyRestrictionImmutable = new TypeRestriction(new RestrictionGroup(null, SetsKt.setOf(PrimitiveTypeDescriptor.Types.ANY.getO()), null, null, null), new RestrictionGroup(SetsKt.emptySet(), SetsKt.emptySet(), null, null, null), true, true, false, false);
    @NotNull
    private static final TypeRestriction bottomRestriction = new TypeRestriction(new RestrictionGroup(null, SetsKt.setOf(BottomTypeDescriptor.Companion.getBottom()), null, null, null), new RestrictionGroup(SetsKt.emptySet(), SetsKt.emptySet(), null, null, null), true, true, false, false);
    @NotNull
    private static final TypeRestriction bottomTypeRestriction = new TypeRestriction(new RestrictionGroup(SetsKt.setOf(BottomTypeDescriptor.Companion.getBottom()), SetsKt.setOf(BottomTypeDescriptor.Companion.getBottomMeta()), null, null, null), new RestrictionGroup(SetsKt.emptySet(), SetsKt.emptySet(), null, null, null), true, true, false, false);

    private TypeRestriction(RestrictionGroup positiveGroup, RestrictionGroup negativeGroup, int flags) {
        boolean bl;
        this.positiveGroup = positiveGroup;
        this.negativeGroup = negativeGroup;
        this.flags = flags;
        boolean bl2 = bl = this.negativeGroup.getConstants() != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = this.flags == RestrictionFlagEncoding.BOXED_FLAG.getMask() || this.flags == RestrictionFlagEncoding.BOXED_FLAG.getMask() + RestrictionFlagEncoding.IMMUTABLE_FLAG.getMask() || this.flags == RestrictionFlagEncoding.UNBOXED_INT_FLAG.getMask() || this.flags == RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG.getMask();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        Set<A_BasicObject> set2 = this.positiveGroup.getConstants();
        if (set2 != null) {
            boolean bl4;
            Set<A_BasicObject> $this$_init__u24lambda_u240 = set2;
            boolean bl5 = false;
            boolean bl6 = bl4 = $this$_init__u24lambda_u240.size() == 1;
            if (_Assertions.ENABLED && !bl4) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
        }
        boolean bl7 = bl = this.positiveGroup.getTypes().size() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string5 = "Assertion failed";
            throw new AssertionError((Object)string5);
        }
        this.positiveGroup.makeImmutable();
        this.negativeGroup.makeImmutable();
    }

    @NotNull
    public final RestrictionGroup getPositiveGroup() {
        return this.positiveGroup;
    }

    @NotNull
    public final RestrictionGroup getNegativeGroup() {
        return this.negativeGroup;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final boolean isImmutable() {
        return (this.flags & RestrictionFlagEncoding.IMMUTABLE_FLAG.getMask()) != 0;
    }

    public final boolean isBoxed() {
        return (this.flags & RestrictionFlagEncoding.BOXED_FLAG.getMask()) != 0;
    }

    public final boolean isUnboxedInt() {
        return (this.flags & RestrictionFlagEncoding.UNBOXED_INT_FLAG.getMask()) != 0;
    }

    public final boolean isUnboxedFloat() {
        return (this.flags & RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG.getMask()) != 0;
    }

    public final boolean hasFlag(@NotNull RestrictionFlagEncoding restrictionFlag) {
        Intrinsics.checkNotNullParameter((Object)restrictionFlag, "restrictionFlag");
        return (this.flags & restrictionFlag.getMask()) != 0;
    }

    private TypeRestriction(RestrictionGroup positiveGroup, RestrictionGroup negativeGroup, boolean isImmutable, boolean isBoxed, boolean isUnboxedInt, boolean isUnboxedFloat) {
        this(positiveGroup, negativeGroup, (isImmutable ? RestrictionFlagEncoding.IMMUTABLE_FLAG.getMask() : 0) | (isBoxed ? RestrictionFlagEncoding.BOXED_FLAG.getMask() : 0) | (isUnboxedInt ? RestrictionFlagEncoding.UNBOXED_INT_FLAG.getMask() : 0) | (isUnboxedFloat ? RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG.getMask() : 0));
    }

    @Nullable
    public final AvailObject getConstantOrNull() {
        Set<A_BasicObject> set2 = this.positiveGroup.getConstants();
        A_BasicObject $this$cast$iv = set2 != null ? (A_BasicObject)CollectionsKt.firstOrNull((Iterable)set2) : null;
        boolean $i$f$cast = false;
        return (AvailObject)$this$cast$iv;
    }

    @NotNull
    public final A_Type getType() {
        return (A_Type)CollectionsKt.single((Iterable)this.positiveGroup.getTypes());
    }

    @NotNull
    public final Set<A_Type> getExcludedTypes() {
        return this.negativeGroup.getTypes();
    }

    @NotNull
    public final Set<A_BasicObject> getExcludedValues() {
        Set<A_BasicObject> set2 = this.negativeGroup.getConstants();
        Intrinsics.checkNotNull(set2);
        return set2;
    }

    @NotNull
    public final TypeRestriction metaRestriction() {
        if (this.getConstantOrNull() != null) {
            return Companion.restrictionForConstant(this.getType(), RestrictionFlagEncoding.BOXED_FLAG);
        }
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{PrimitiveTypeDescriptor.Types.TOP.getO(), BottomTypeDescriptor.Companion.getBottom()};
        Set<A_BasicObject> resultExcludedValues = SetsKt.mutableSetOf(a_BasicObjectArray);
        for (A_BasicObject v : this.getExcludedValues()) {
            resultExcludedValues.add(AbstractEnumerationTypeDescriptor.Companion.instanceTypeOrMetaOn(v));
        }
        A_Type[] a_TypeArray = new A_Type[]{BottomTypeDescriptor.Companion.getBottomMeta()};
        Set<A_Type> resultExcludedTypes = SetsKt.mutableSetOf(a_TypeArray);
        for (A_Type t : this.getExcludedTypes()) {
            resultExcludedTypes.add(InstanceMetaDescriptor.Companion.instanceMeta(t));
        }
        return Companion.restriction(InstanceMetaDescriptor.Companion.instanceMeta(this.getType()), null, resultExcludedTypes, resultExcludedValues, null, null, null, null, RestrictionFlagEncoding.BOXED_FLAG.getMask());
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @NotNull
    public final TypeRestriction union(@NotNull TypeRestriction other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (this.getType().isBottom()) {
            return other;
        }
        if (other.getType().isBottom()) {
            return this;
        }
        if (this.getConstantOrNull() != null && other.getConstantOrNull() != null) {
            v0 = this.getConstantOrNull();
            Intrinsics.checkNotNull(v0);
            v1 = other.getConstantOrNull();
            Intrinsics.checkNotNull(v1);
            if (v0.equals(v1) && this.flags == other.flags) {
                return this;
            }
        }
        mutualTypeIntersections = new LinkedHashSet<E>();
        for (A_Type t1 : this.getExcludedTypes()) {
            for (Object t2 : other.getExcludedTypes()) {
                intersection = A_Type.Companion.typeIntersection(t1, (A_Type)t2);
                if (intersection.isBottom()) continue;
                mutualTypeIntersections.add(intersection);
            }
        }
        newExcludedValues = new LinkedHashSet<E>();
        $this$filterTo$iv = this.getExcludedValues();
        $i$f$filterTo = false;
        for (E element$iv : $this$filterTo$iv) {
            block35: {
                it = (A_BasicObject)element$iv /* !! */ ;
                $i$a$-filterTo-TypeRestriction$union$1 = false;
                if (other.getExcludedValues().contains(it)) ** GOTO lbl-1000
                $this$any$iv = other.getExcludedTypes();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        p0 = (A_Type)element$iv;
                        $i$a$-any-TypeRestriction$union$1$1 = false;
                        if (!it.isInstanceOf(p0)) continue;
                        v2 = true;
                        break block35;
                    }
                    v2 = false;
                }
            }
            if (v2) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            if (!v3) continue;
            ((Collection)newExcludedValues).add(element$iv /* !! */ );
        }
        (Collection)newExcludedValues;
        $this$filterTo$iv = other.getExcludedValues();
        $i$f$filterTo = false;
        for (E element$iv : $this$filterTo$iv) {
            block36: {
                it = (A_BasicObject)element$iv /* !! */ ;
                $i$a$-filterTo-TypeRestriction$union$2 = false;
                $this$any$iv = this.getExcludedTypes();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v4 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        p0 = (A_Type)element$iv;
                        $i$a$-any-TypeRestriction$union$2$1 = false;
                        if (!it.isInstanceOf(p0)) continue;
                        v4 = true;
                        break block36;
                    }
                    v4 = false;
                }
            }
            if (!v4) continue;
            ((Collection)newExcludedValues).add(element$iv /* !! */ );
        }
        (Collection)newExcludedValues;
        v5 = this.positiveGroup.getObjectVariants();
        if (v5 != null) {
            v1 = v5;
            $i$a$-let-TypeRestriction$union$positiveVariants$1 = false;
            v6 = other.positiveGroup.getObjectVariants();
            if (v6 != null) {
                p0 = v6;
                $i$a$-let-TypeRestriction$union$positiveVariants$1$1 = false;
                v7 = CollectionsKt.union((Iterable)v1, p0);
            } else {
                v7 = null;
            }
        } else {
            v7 = null;
        }
        positiveVariants = v7;
        v8 = this.positiveGroup.getObjectTypeVariants();
        if (v8 != null) {
            v1 = v8;
            $i$a$-let-TypeRestriction$union$positiveTypeVariants$1 = false;
            v9 = other.positiveGroup.getObjectTypeVariants();
            if (v9 != null) {
                p0 = v9;
                $i$a$-let-TypeRestriction$union$positiveTypeVariants$1$1 = false;
                v10 = CollectionsKt.union((Iterable)v1, p0);
            } else {
                v10 = null;
            }
        } else {
            v10 = null;
        }
        positiveTypeVariants = v10;
        v1 = this.negativeGroup.getObjectVariants();
        if (v1 == null) ** GOTO lbl-1000
        v1 = v1;
        $i$a$-let-TypeRestriction$union$excludedVariants$1 = false;
        v11 = other.negativeGroup.getObjectVariants();
        if (v11 != null) {
            p0 = v11;
            $i$a$-let-TypeRestriction$union$excludedVariants$1$1 = false;
            v12 = CollectionsKt.intersect((Iterable)v1, p0);
        } else {
            v12 = null;
        }
        if ((var8_13 = v12) != null) {
            var9_18 = var8_13;
            if (var9_18.isEmpty()) {
                $i$a$-ifEmpty-TypeRestriction$union$excludedVariants$2 = false;
                return TypeRestriction.bottomRestriction;
            }
            v13 = (Set)var9_18;
        } else lbl-1000:
        // 2 sources

        {
            v13 = null;
        }
        excludedVariants = v13;
        var8_14 = this.negativeGroup.getObjectTypeVariants();
        if (var8_14 == null) ** GOTO lbl-1000
        v1 = var8_14;
        $i$a$-let-TypeRestriction$union$excludedTypeVariants$1 = false;
        v14 = other.negativeGroup.getObjectTypeVariants();
        if (v14 != null) {
            p0 = v14;
            $i$a$-let-TypeRestriction$union$excludedTypeVariants$1$1 = false;
            v15 = CollectionsKt.intersect((Iterable)v1, p0);
        } else {
            v15 = null;
        }
        if ((var9_19 = v15) != null) {
            var10_25 = var9_19;
            if (var10_25.isEmpty()) {
                $i$a$-ifEmpty-TypeRestriction$union$excludedTypeVariants$2 = false;
                v16 = null;
            } else {
                v16 = var10_25;
            }
            v17 = (Set)v16;
        } else lbl-1000:
        // 2 sources

        {
            v17 = null;
        }
        excludedTypeVariants = v17;
        return TypeRestriction.Companion.restriction(A_Type.Companion.typeUnion(this.getType(), other.getType()), null, mutualTypeIntersections, newExcludedValues, positiveVariants, excludedVariants, positiveTypeVariants, excludedTypeVariants, this.flags & other.flags);
    }

    @NotNull
    public final TypeRestriction intersection(@NotNull TypeRestriction other) {
        Set<ObjectLayoutVariant> set2;
        Set<ObjectLayoutVariant> set3;
        Set set4;
        Set set5;
        Intrinsics.checkNotNullParameter(other, "other");
        AvailObject c1 = this.getConstantOrNull();
        AvailObject c2 = other.getConstantOrNull();
        if (c1 != null && c2 != null && !c1.equals(c2)) {
            return bottomRestriction;
        }
        Set v1 = this.positiveGroup.getObjectVariants();
        boolean bl = false;
        Set<ObjectLayoutVariant> v2 = other.positiveGroup.getObjectVariants();
        boolean bl2 = false;
        if (v1 == null || v2 == null) {
            set5 = v1;
            if (set5 == null) {
                set5 = v2;
            }
        } else {
            Collection collection2 = CollectionsKt.intersect((Iterable)v2, (Iterable)v2);
            if (collection2.isEmpty()) {
                boolean bl3 = false;
                return bottomRestriction;
            }
            set5 = (Set)collection2;
        }
        Set positiveVariants = set5;
        Set v12 = this.positiveGroup.getObjectTypeVariants();
        boolean bl4 = false;
        Set<ObjectLayoutVariant> v22 = other.positiveGroup.getObjectTypeVariants();
        boolean bl5 = false;
        if (v12 == null || v22 == null) {
            set4 = v12;
            if (set4 == null) {
                set4 = v22;
            }
        } else {
            Collection bl3 = CollectionsKt.intersect((Iterable)v22, (Iterable)v22);
            if (bl3.isEmpty()) {
                boolean bl6 = false;
                return bottomRestriction;
            }
            set4 = (Set)bl3;
        }
        Set positiveTypeVariants = set4;
        Set<ObjectLayoutVariant> v13 = this.negativeGroup.getObjectVariants();
        boolean bl7 = false;
        Set<ObjectLayoutVariant> v23 = other.negativeGroup.getObjectVariants();
        boolean bl8 = false;
        if (v13 == null || v23 == null) {
            set3 = v13;
            if (set3 == null) {
                set3 = v23;
            }
        } else {
            set3 = CollectionsKt.union((Iterable)v13, (Iterable)v23);
        }
        Set<ObjectLayoutVariant> excludedVariants = set3;
        Set<ObjectLayoutVariant> v14 = this.negativeGroup.getObjectTypeVariants();
        boolean bl9 = false;
        Set<ObjectLayoutVariant> v24 = other.negativeGroup.getObjectTypeVariants();
        boolean bl10 = false;
        if (v14 == null || v24 == null) {
            set2 = v14;
            if (set2 == null) {
                set2 = v24;
            }
        } else {
            set2 = CollectionsKt.union((Iterable)v14, (Iterable)v24);
        }
        Set<ObjectLayoutVariant> excludedTypeVariants = set2;
        A_Type a_Type = A_Type.Companion.typeIntersection(this.getType(), other.getType());
        AvailObject availObject = c1;
        if (availObject == null) {
            availObject = c2;
        }
        return Companion.restriction(a_Type, availObject, SetsKt.plus(this.getExcludedTypes(), (Iterable)other.getExcludedTypes()), SetsKt.plus(this.getExcludedValues(), (Iterable)other.getExcludedValues()), positiveVariants, excludedVariants, positiveTypeVariants, excludedTypeVariants, this.flags | other.flags);
    }

    @NotNull
    public final TypeRestriction intersectionWithType(@NotNull A_Type typeToIntersect) {
        Intrinsics.checkNotNullParameter(typeToIntersect, "typeToIntersect");
        return Companion.restriction(A_Type.Companion.typeIntersection(this.getType(), typeToIntersect), this.getConstantOrNull(), this.getExcludedTypes(), this.getExcludedValues(), this.positiveGroup.getObjectVariants(), this.negativeGroup.getObjectVariants(), this.positiveGroup.getObjectTypeVariants(), this.negativeGroup.getObjectTypeVariants(), this.flags);
    }

    @NotNull
    public final TypeRestriction minusType(@NotNull A_Type typeToExclude) {
        Intrinsics.checkNotNullParameter(typeToExclude, "typeToExclude");
        return Companion.restriction(this.getType(), this.getConstantOrNull(), SetsKt.plus(this.getExcludedTypes(), typeToExclude), this.getExcludedValues(), this.positiveGroup.getObjectVariants(), this.negativeGroup.getObjectVariants(), this.positiveGroup.getObjectTypeVariants(), this.negativeGroup.getObjectTypeVariants(), this.flags);
    }

    @NotNull
    public final TypeRestriction minusValue(@NotNull A_BasicObject valueToExclude) {
        Intrinsics.checkNotNullParameter(valueToExclude, "valueToExclude");
        return Companion.restriction(this.getType(), this.getConstantOrNull(), this.getExcludedTypes(), SetsKt.plus(this.getExcludedValues(), valueToExclude), this.positiveGroup.getObjectVariants(), this.negativeGroup.getObjectVariants(), this.positiveGroup.getObjectTypeVariants(), this.negativeGroup.getObjectTypeVariants(), this.flags);
    }

    @NotNull
    public final TypeRestriction minusValues(@NotNull Iterable<? extends A_BasicObject> valuesToExclude) {
        Intrinsics.checkNotNullParameter(valuesToExclude, "valuesToExclude");
        return Companion.restriction(this.getType(), this.getConstantOrNull(), this.getExcludedTypes(), SetsKt.plus(this.getExcludedValues(), valuesToExclude), this.positiveGroup.getObjectVariants(), this.negativeGroup.getObjectVariants(), this.positiveGroup.getObjectTypeVariants(), this.negativeGroup.getObjectTypeVariants(), this.flags);
    }

    @NotNull
    public final TypeRestriction intersectionWithObjectVariant(@NotNull ObjectLayoutVariant variantToIntersect) {
        Intrinsics.checkNotNullParameter(variantToIntersect, "variantToIntersect");
        return this.intersection(new TypeRestriction(new RestrictionGroup(null, SetsKt.setOf(variantToIntersect.getMostGeneralObjectType()), SetsKt.setOf(variantToIntersect), null, SetsKt.setOf(TypeTag.OBJECT_TAG)), new RestrictionGroup(SetsKt.emptySet(), SetsKt.emptySet(), null, null, null), this.flags));
    }

    @NotNull
    public final TypeRestriction intersectionWithObjectTypeVariant(@NotNull ObjectLayoutVariant variantToIntersect) {
        Intrinsics.checkNotNullParameter(variantToIntersect, "variantToIntersect");
        return this.intersection(new TypeRestriction(new RestrictionGroup(null, SetsKt.setOf(variantToIntersect.getMostGeneralObjectMeta()), null, SetsKt.setOf(variantToIntersect), SetsKt.setOf(TypeTag.OBJECT_TYPE_TAG)), new RestrictionGroup(SetsKt.emptySet(), SetsKt.emptySet(), null, null, null), this.flags));
    }

    @NotNull
    public final TypeRestriction minusObjectVariant(@NotNull ObjectLayoutVariant variantToRemove) {
        TypeRestriction typeRestriction;
        Intrinsics.checkNotNullParameter(variantToRemove, "variantToRemove");
        if (this.positiveGroup.getObjectVariants() == null) {
            Set<ObjectLayoutVariant> set2 = this.negativeGroup.getObjectVariants();
            if (set2 == null) {
                set2 = SetsKt.emptySet();
            }
            typeRestriction = new TypeRestriction(this.positiveGroup, RestrictionGroup.copy$default(this.negativeGroup, null, null, SetsKt.plus(set2, variantToRemove), null, null, 27, null), this.flags);
        } else if (this.positiveGroup.getObjectVariants().contains(variantToRemove)) {
            Collection collection2 = SetsKt.minus(this.positiveGroup.getObjectVariants(), variantToRemove);
            if (collection2.isEmpty()) {
                boolean bl = false;
                return bottomRestriction;
            }
            int n = this.flags;
            RestrictionGroup restrictionGroup = this.negativeGroup;
            RestrictionGroup restrictionGroup2 = RestrictionGroup.copy$default(this.positiveGroup, null, null, (Set)collection2, null, null, 27, null);
            typeRestriction = new TypeRestriction(restrictionGroup2, restrictionGroup, n);
        } else {
            typeRestriction = this;
        }
        return typeRestriction;
    }

    @NotNull
    public final TypeRestriction minusObjectTypeVariant(@NotNull ObjectLayoutVariant variantToRemove) {
        TypeRestriction typeRestriction;
        Intrinsics.checkNotNullParameter(variantToRemove, "variantToRemove");
        if (this.positiveGroup.getObjectTypeVariants() == null) {
            Set<ObjectLayoutVariant> set2 = this.negativeGroup.getObjectTypeVariants();
            if (set2 == null) {
                set2 = SetsKt.emptySet();
            }
            typeRestriction = new TypeRestriction(this.positiveGroup, RestrictionGroup.copy$default(this.negativeGroup, null, null, null, SetsKt.plus(set2, variantToRemove), null, 23, null), this.flags);
        } else if (this.positiveGroup.getObjectTypeVariants().contains(variantToRemove)) {
            Collection collection2 = SetsKt.minus(this.positiveGroup.getObjectTypeVariants(), variantToRemove);
            if (collection2.isEmpty()) {
                boolean bl = false;
                return bottomRestriction;
            }
            int n = this.flags;
            RestrictionGroup restrictionGroup = this.negativeGroup;
            RestrictionGroup restrictionGroup2 = RestrictionGroup.copy$default(this.positiveGroup, null, null, null, (Set)collection2, null, 23, null);
            typeRestriction = new TypeRestriction(restrictionGroup2, restrictionGroup, n);
        } else {
            typeRestriction = this;
        }
        return typeRestriction;
    }

    public final boolean containsEntireType(@NotNull A_Type testType) {
        boolean bl;
        block13: {
            Intrinsics.checkNotNullParameter(testType, "testType");
            AvailObject constant = this.getConstantOrNull();
            if (constant == null) {
                if (!A_Type.Companion.isSubtypeOf(testType, this.getType())) {
                    bl = false;
                } else {
                    A_BasicObject it;
                    boolean bl2;
                    block12: {
                        Iterable $this$any$iv = this.getExcludedTypes();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (A_Type)element$iv;
                                boolean bl3 = false;
                                if (!(!A_Type.Companion.typeIntersection((A_Type)it, testType).isBottom())) continue;
                                bl2 = true;
                                break block12;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        bl = false;
                    } else {
                        Iterable $this$none$iv = this.getExcludedValues();
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                it = (A_BasicObject)element$iv;
                                boolean bl4 = false;
                                if (!it.isInstanceOf(testType)) continue;
                                bl = false;
                                break block13;
                            }
                            bl = true;
                        }
                    }
                }
            } else {
                bl = constant.isType() && !constant.isBottom() ? false : testType.equals(AbstractEnumerationTypeDescriptor.Companion.instanceTypeOrMetaOn(constant));
            }
        }
        return bl;
    }

    public final boolean containedByType(@NotNull A_Type testType) {
        Intrinsics.checkNotNullParameter(testType, "testType");
        return A_Type.Companion.isSubtypeOf(this.getType(), testType);
    }

    public final boolean intersectsType(@NotNull A_Type testType) {
        boolean bl;
        A_Type intersectedType;
        block6: {
            Intrinsics.checkNotNullParameter(testType, "testType");
            AvailObject availObject = this.getConstantOrNull();
            if (availObject != null) {
                AvailObject $this$intersectsType_u24lambda_u2428 = availObject;
                boolean bl2 = false;
                return $this$intersectsType_u24lambda_u2428.isInstanceOf(testType);
            }
            intersectedType = A_Type.Companion.typeIntersection(testType, this.getType());
            if (intersectedType.isVacuousType()) {
                return false;
            }
            Iterable $this$any$iv = this.getExcludedTypes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    A_Type it = (A_Type)element$iv;
                    boolean bl3 = false;
                    if (!A_Type.Companion.isSubtypeOf(intersectedType, it)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        return !(!((Collection)this.getExcludedValues()).isEmpty()) || !intersectedType.isEnumeration() || intersectedType.isInstanceMeta() || !A_Set.Companion.isSubsetOf(A_Type.Companion.getInstances(intersectedType), SetDescriptor.Companion.setFromCollection((Collection<? extends A_BasicObject>)this.getExcludedValues()));
    }

    @NotNull
    public final TypeRestriction withFlag(@NotNull RestrictionFlagEncoding flagEncoding) {
        Intrinsics.checkNotNullParameter((Object)flagEncoding, "flagEncoding");
        return (this.flags & flagEncoding.getMask()) != 0 ? this : Companion.restriction(this.getType(), this.getConstantOrNull(), this.getExcludedTypes(), this.getExcludedValues(), this.positiveGroup.getObjectVariants(), this.negativeGroup.getObjectVariants(), this.positiveGroup.getObjectTypeVariants(), this.negativeGroup.getObjectTypeVariants(), this.flags | flagEncoding.getMask());
    }

    @NotNull
    public final TypeRestriction forBoxed() {
        return this.hasFlag(RestrictionFlagEncoding.BOXED_FLAG) ? this : Companion.restriction(this.getType(), this.getConstantOrNull(), this.getExcludedTypes(), this.getExcludedValues(), this.positiveGroup.getObjectVariants(), this.negativeGroup.getObjectVariants(), this.positiveGroup.getObjectTypeVariants(), this.negativeGroup.getObjectTypeVariants(), RestrictionFlagEncoding.BOXED_FLAG.getMask());
    }

    @NotNull
    public final TypeRestriction forUnboxedInt() {
        return this.hasFlag(RestrictionFlagEncoding.UNBOXED_INT_FLAG) ? this : Companion.restriction(A_Type.Companion.typeIntersection(this.getType(), IntegerRangeTypeDescriptor.Companion.getI32()), this.getConstantOrNull(), this.getExcludedTypes(), this.getExcludedValues(), null, null, null, null, RestrictionFlagEncoding.UNBOXED_INT_FLAG.getMask());
    }

    @NotNull
    public final TypeRestriction forUnboxedFloat() {
        return this.hasFlag(RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG) ? this : Companion.restriction(A_Type.Companion.typeIntersection(this.getType(), PrimitiveTypeDescriptor.Types.DOUBLE.getO()), this.getConstantOrNull(), this.getExcludedTypes(), this.getExcludedValues(), null, null, null, null, RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG.getMask());
    }

    @NotNull
    public final TypeRestriction withoutFlag(@NotNull RestrictionFlagEncoding flagEncoding) {
        Intrinsics.checkNotNullParameter((Object)flagEncoding, "flagEncoding");
        return (this.flags & flagEncoding.getMask()) == 0 ? this : Companion.restriction(this.getType(), this.getConstantOrNull(), this.getExcludedTypes(), this.getExcludedValues(), this.positiveGroup.getObjectVariants(), this.negativeGroup.getObjectVariants(), this.positiveGroup.getObjectTypeVariants(), this.negativeGroup.getObjectTypeVariants(), this.flags & ~flagEncoding.getMask());
    }

    @NotNull
    public final TypeRestriction restrictingKindsTo(int kindFlagEncoding) {
        boolean bl;
        boolean bl2 = bl = (kindFlagEncoding & ~RestrictionFlagEncoding.Companion.getAllKindsMask()) == 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int newFlags = this.flags & ~RestrictionFlagEncoding.Companion.getAllKindsMask() | kindFlagEncoding;
        if ((newFlags & RestrictionFlagEncoding.IMMUTABLE_FLAG.getMask()) != 0 && (newFlags & RestrictionFlagEncoding.BOXED_FLAG.getMask()) == 0) {
            newFlags &= ~RestrictionFlagEncoding.IMMUTABLE_FLAG.getMask();
        }
        if (newFlags == this.flags) {
            return this;
        }
        return Companion.restriction(this.getType(), this.getConstantOrNull(), this.getExcludedTypes(), this.getExcludedValues(), this.positiveGroup.getObjectVariants(), this.negativeGroup.getObjectVariants(), this.positiveGroup.getObjectTypeVariants(), this.negativeGroup.getObjectTypeVariants(), newFlags);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeRestriction restrictingKindsTo(@NotNull EnumSet<L2Register.RegisterKind> kinds) {
        int n;
        Intrinsics.checkNotNullParameter(kinds, "kinds");
        Iterable iterable = kinds;
        TypeRestriction typeRestriction = this;
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            L2Register.RegisterKind registerKind = (L2Register.RegisterKind)((Object)t);
            n = n2;
            boolean bl = false;
            int n3 = it.getRestrictionFlag().getMask();
            n2 = n + n3;
        }
        n = n2;
        return typeRestriction.restrictingKindsTo(n);
    }

    @Nullable
    public final A_Set enumerationValuesOrNull(int maximumCount) {
        A_Set a_Set;
        if (maximumCount >= 0 && this == bottomRestriction) {
            a_Set = SetDescriptor.Companion.getEmptySet();
        } else if (maximumCount >= 1 && this.getConstantOrNull() != null) {
            A_BasicObject[] a_BasicObjectArray = new A_BasicObject[1];
            Intrinsics.checkNotNull(this.getConstantOrNull());
            a_Set = SetDescriptor.Companion.set(a_BasicObjectArray);
        } else {
            a_Set = this.getType().isEnumeration() && !this.getType().isInstanceMeta() && A_Number.Companion.lessOrEqual(A_Type.Companion.getInstanceCount(this.getType()), IntegerDescriptor.Companion.fromInt(maximumCount)) ? A_Type.Companion.getInstances(this.getType()) : null;
        }
        return a_Set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EnumSet<L2Register.RegisterKind> kinds() {
        void var2_2;
        void $this$filterTo$iv;
        L2Register.RegisterKind[] registerKindArray = L2Register.RegisterKind.Companion.getAll();
        Collection destination$iv = EnumSet.noneOf(L2Register.RegisterKind.class);
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv;
            void it = element$iv = $this$filterTo$iv[j];
            boolean bl = false;
            if (!((this.flags & it.getRestrictionFlag().getMask()) != 0)) continue;
            destination$iv.add(element$iv);
        }
        void v0 = var2_2;
        Intrinsics.checkNotNullExpressionValue(v0, "filterTo(...)");
        return (EnumSet)v0;
    }

    public boolean equals(@Nullable Object other) {
        return !(other instanceof TypeRestriction) ? false : (this == other ? true : this.getType().equals(((TypeRestriction)other).getType()) && this.getConstantOrNull() == ((TypeRestriction)other).getConstantOrNull() && Intrinsics.areEqual(this.getExcludedTypes(), ((TypeRestriction)other).getExcludedTypes()) && Intrinsics.areEqual(this.getExcludedValues(), ((TypeRestriction)other).getExcludedValues()) && this.flags == ((TypeRestriction)other).flags);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getType(), this.getConstantOrNull(), this.getExcludedTypes(), this.getExcludedValues(), this.flags};
        return Objects.hash(objectArray);
    }

    public final boolean isStrongerThan(@NotNull TypeRestriction other) {
        boolean $i$f$none;
        Iterable $this$none$iv;
        Intrinsics.checkNotNullParameter(other, "other");
        if ((~this.flags & other.flags) != 0) {
            return false;
        }
        if (!A_Type.Companion.isSubtypeOf(this.getType(), other.getType())) {
            return false;
        }
        for (A_Type otherExcludedType : other.getExcludedTypes()) {
            boolean bl;
            block10: {
                $this$none$iv = this.getExcludedTypes();
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        A_Type it = (A_Type)element$iv;
                        boolean bl2 = false;
                        if (!A_Type.Companion.isSubtypeOf(otherExcludedType, it)) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            return false;
        }
        for (A_BasicObject otherExcludedValue : other.getExcludedValues()) {
            boolean bl;
            block11: {
                if (this.getExcludedValues().contains(otherExcludedValue)) continue;
                $this$none$iv = this.getExcludedTypes();
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        A_Type p0 = (A_Type)element$iv;
                        boolean bl3 = false;
                        if (!otherExcludedValue.isInstanceOf(p0)) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final String suffixString() {
        Object object;
        AvailObject constant = this.getConstantOrNull();
        if (constant != null) {
            return "=" + StringsKt.replace$default(constant.getTypeTag().name(), "_TAG", "", false, 4, null);
        }
        if (!this.getType().equals(PrimitiveTypeDescriptor.Types.TOP.getO())) {
            A_Type a_Type = this.getType();
            Intrinsics.checkNotNull(a_Type, "null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
            object = ":" + StringsKt.replace$default(((AvailObject)a_Type).getTypeTag().name(), "_TAG", "", false, 4, null);
        } else {
            object = "";
        }
        return object;
    }

    @NotNull
    public String toString() {
        Set<ObjectLayoutVariant> it;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2438 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u2438.append("restriction(");
        if (this.getConstantOrNull() != null) {
            $this$toString_u24lambda_u2438.append("c=");
            Object valueString = String.valueOf(this.getConstantOrNull());
            if (((String)valueString).length() > 50) {
                String string2 = ((String)valueString).substring(0, 50);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                valueString = string2 + "\u2026";
            }
            valueString = StringsKt.replace$default(StringsKt.replace$default((String)valueString, "\n", "\\n", false, 4, null), "\t", "\\t", false, 4, null);
            $this$toString_u24lambda_u2438.append((String)valueString);
        } else {
            $this$toString_u24lambda_u2438.append("t=");
            Object typeString2 = this.getType().toString();
            if (((String)typeString2).length() > 50) {
                String string3 = ((String)typeString2).substring(0, 50);
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                typeString2 = string3 + "\u2026";
            }
            $this$toString_u24lambda_u2438.append((String)typeString2);
            if (!((Collection)this.getExcludedTypes()).isEmpty()) {
                $this$toString_u24lambda_u2438.append(", ex.t=" + this.getExcludedTypes());
            }
            if (!((Collection)this.getExcludedValues()).isEmpty()) {
                $this$toString_u24lambda_u2438.append(", ex.v=" + this.getExcludedValues());
            }
        }
        Set<ObjectLayoutVariant> set2 = this.positiveGroup.getObjectTypeVariants();
        if (set2 != null) {
            it = set2;
            boolean bl2 = false;
            $this$toString_u24lambda_u2438.append(", typeVariants=" + it);
        }
        Set<ObjectLayoutVariant> set3 = this.positiveGroup.getObjectVariants();
        if (set3 != null) {
            it = set3;
            boolean bl3 = false;
            $this$toString_u24lambda_u2438.append(", variants=" + it);
        }
        Set<ObjectLayoutVariant> set4 = this.negativeGroup.getObjectTypeVariants();
        if (set4 != null) {
            it = set4;
            boolean bl4 = false;
            $this$toString_u24lambda_u2438.append(", ex.typeVariants=" + it);
        }
        Set<ObjectLayoutVariant> set5 = this.negativeGroup.getObjectVariants();
        if (set5 != null) {
            it = set5;
            boolean bl5 = false;
            $this$toString_u24lambda_u2438.append(", ex.variants=" + it);
        }
        if (this.isImmutable()) {
            $this$toString_u24lambda_u2438.append(", imm");
        }
        if (this.isBoxed()) {
            $this$toString_u24lambda_u2438.append(", box");
        }
        if (this.isUnboxedInt()) {
            $this$toString_u24lambda_u2438.append(", int");
        }
        if (this.isUnboxedFloat()) {
            $this$toString_u24lambda_u2438.append(", float");
        }
        $this$toString_u24lambda_u2438.append(")");
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    public final void makeShared() {
        this.positiveGroup.makeShared();
        this.negativeGroup.makeShared();
    }

    public /* synthetic */ TypeRestriction(RestrictionGroup positiveGroup, RestrictionGroup negativeGroup, int flags, DefaultConstructorMarker $constructor_marker) {
        this(positiveGroup, negativeGroup, flags);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J~\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00152\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00152\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00152\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u00a8\u0001\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00112\b\u0010 \u001a\u0004\u0018\u00010\u00132\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0010\b\u0002\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00152\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00152\u0010\b\u0002\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00152\u0010\b\u0002\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00152\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\"2\b\b\u0002\u0010$\u001a\u00020\"2\b\b\u0002\u0010%\u001a\u00020\"J|\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00112\b\u0010 \u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00152\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00152\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00152\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)J\u0016\u0010*\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0006R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lavail/interpreter/levelTwo/operand/TypeRestriction$Companion;", "", "()V", "anyRestriction", "Lavail/interpreter/levelTwo/operand/TypeRestriction;", "getAnyRestriction", "()Lavail/interpreter/levelTwo/operand/TypeRestriction;", "anyRestrictionImmutable", "bottomRestriction", "getBottomRestriction", "bottomTypeRestriction", "nilRestriction", "getNilRestriction", "topRestriction", "topRestrictionImmutable", "fromCanonical", "givenType", "Lavail/descriptor/types/A_Type;", "givenConstantOrNull", "Lavail/descriptor/representation/A_BasicObject;", "givenExcludedTypes", "", "givenExcludedValues", "possibleVariants", "Lavail/descriptor/objects/ObjectLayoutVariant;", "excludedVariants", "possibleTypeVariants", "excludedTypeVariants", "flags", "", "restriction", "type", "constantOrNull", "isImmutable", "", "isBoxed", "isUnboxedInt", "isUnboxedFloat", "restrictionForConstant", "constant", "encoding", "Lavail/interpreter/levelTwo/operand/TypeRestriction$RestrictionFlagEncoding;", "restrictionForType", "avail"})
    @SourceDebugExtension(value={"SMAP\nTypeRestriction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeRestriction.kt\navail/interpreter/levelTwo/operand/TypeRestriction$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 CollectionExtensions.kt\navail/utility/CollectionExtensionsKt\n*L\n1#1,1890:1\n1#2:1891\n1855#3,2:1892\n1855#3,2:1894\n1855#3,2:1896\n1855#3,2:1898\n2624#3,3:1900\n1855#3,2:1903\n1855#3,2:1905\n1747#3,3:1907\n1747#3,3:1910\n1620#3,3:1917\n79#4,4:1913\n*S KotlinDebug\n*F\n+ 1 TypeRestriction.kt\navail/interpreter/levelTwo/operand/TypeRestriction$Companion\n*L\n1368#1:1892,2\n1369#1:1894,2\n1388#1:1896,2\n1391#1:1898,2\n1433#1:1900,3\n1653#1:1903,2\n1654#1:1905,2\n1715#1:1907,3\n1756#1:1910,3\n1767#1:1917,3\n1767#1:1913,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TypeRestriction getNilRestriction() {
            return nilRestriction;
        }

        @NotNull
        public final TypeRestriction getAnyRestriction() {
            return anyRestriction;
        }

        @NotNull
        public final TypeRestriction getBottomRestriction() {
            return bottomRestriction;
        }

        private final TypeRestriction fromCanonical(A_Type givenType, A_BasicObject givenConstantOrNull, Set<? extends A_Type> givenExcludedTypes, Set<? extends A_BasicObject> givenExcludedValues, Set<ObjectLayoutVariant> possibleVariants, Set<ObjectLayoutVariant> excludedVariants, Set<ObjectLayoutVariant> possibleTypeVariants, Set<ObjectLayoutVariant> excludedTypeVariants, int flags) {
            TypeRestriction typeRestriction;
            boolean anyTrimsThisPass2;
            A_BasicObject p0;
            boolean bl;
            boolean bl2 = bl = possibleVariants == null || excludedVariants == null;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            boolean bl3 = bl = possibleTypeVariants == null || excludedTypeVariants == null;
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            boolean bl4 = bl = !givenExcludedTypes.contains(BottomTypeDescriptor.Companion.getBottom());
            if (_Assertions.ENABLED && !bl) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            A_BasicObject a_BasicObject = givenConstantOrNull;
            if (a_BasicObject != null) {
                A_BasicObject p02 = a_BasicObject;
                boolean bl5 = false;
                p02.makeImmutable();
            }
            A_Type type2 = null;
            type2 = givenType.makeImmutable();
            Iterable $this$forEach$iv = givenExcludedTypes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (A_Type)element$iv;
                boolean bl6 = false;
                p0.makeImmutable();
            }
            $this$forEach$iv = givenExcludedValues;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (A_BasicObject)element$iv;
                boolean bl7 = false;
                p0.makeImmutable();
            }
            boolean anyVariantsMentioned = possibleVariants != null || excludedVariants != null || possibleTypeVariants != null || excludedTypeVariants != null;
            boolean anyTrimsAtAll = false;
            do {
                AvailObject typeBefore = ((A_Type)type2).makeImmutable();
                Iterable $this$forEach$iv2 = givenExcludedTypes;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    A_Type excludedType = (A_Type)element$iv;
                    boolean bl8 = false;
                    type2 = A_Type.Companion.trimType(type2, excludedType);
                }
                $this$forEach$iv2 = givenExcludedValues;
                $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    A_BasicObject excludedValue = (A_BasicObject)element$iv;
                    boolean bl9 = false;
                    if (excludedValue.isType()) {
                        Intrinsics.checkNotNull(excludedValue, "null cannot be cast to non-null type avail.descriptor.types.A_Type");
                        if (!((A_Type)excludedValue).isBottom()) continue;
                    }
                    type2 = A_Type.Companion.trimType(type2, AbstractEnumerationTypeDescriptor.Companion.instanceTypeOrMetaOn(excludedValue)).makeImmutable();
                }
                anyTrimsThisPass2 = !((A_Type)type2).equals(typeBefore);
                anyTrimsAtAll |= anyTrimsThisPass2;
            } while (anyTrimsThisPass2);
            if (anyTrimsAtAll) {
                typeRestriction = this.restriction(type2, givenConstantOrNull, givenExcludedTypes, givenExcludedValues, possibleVariants, excludedVariants, possibleTypeVariants, excludedTypeVariants, flags);
            } else if (givenConstantOrNull != null) {
                if (givenConstantOrNull.isNil()) {
                    typeRestriction = this.getNilRestriction();
                } else {
                    boolean $this$none$iv2;
                    block30: {
                        boolean typeBefore = givenConstantOrNull.isInstanceOf(type2);
                        if (_Assertions.ENABLED && !typeBefore) {
                            String anyTrimsThisPass2 = "Assertion failed";
                            throw new AssertionError((Object)anyTrimsThisPass2);
                        }
                        boolean bl10 = typeBefore = !givenExcludedValues.contains(givenConstantOrNull);
                        if (_Assertions.ENABLED && !typeBefore) {
                            String anyTrimsThisPass2 = "Assertion failed";
                            throw new AssertionError((Object)anyTrimsThisPass2);
                        }
                        Iterable $this$none$iv2 = givenExcludedTypes;
                        boolean $i$f$none = false;
                        if ($this$none$iv2 instanceof Collection && ((Collection)$this$none$iv2).isEmpty()) {
                            v6 = true;
                        } else {
                            for (Object element$iv : $this$none$iv2) {
                                A_Type p03 = (A_Type)element$iv;
                                boolean bl11 = false;
                                if (!givenConstantOrNull.isInstanceOf(p03)) continue;
                                v6 = false;
                                break block30;
                            }
                            v6 = $this$none$iv2 = true;
                        }
                    }
                    if (_Assertions.ENABLED && !$this$none$iv2) {
                        String string5 = "Assertion failed";
                        throw new AssertionError((Object)string5);
                    }
                    typeRestriction = new TypeRestriction(new RestrictionGroup(SetsKt.setOf(givenConstantOrNull), SetsKt.setOf(AbstractEnumerationTypeDescriptor.Companion.instanceTypeOrMetaOn(givenConstantOrNull)), possibleVariants, possibleTypeVariants, null), new RestrictionGroup(SetsKt.emptySet(), SetsKt.emptySet(), excludedVariants, excludedTypeVariants, null), flags, null);
                }
            } else if (givenExcludedTypes.isEmpty() && givenExcludedValues.isEmpty()) {
                if (!anyVariantsMentioned && ((A_Type)type2).equals(PrimitiveTypeDescriptor.Types.TOP.getO())) {
                    typeRestriction = (flags & RestrictionFlagEncoding.IMMUTABLE_FLAG.getMask()) != 0 ? topRestrictionImmutable : topRestriction;
                } else if (!anyVariantsMentioned && ((A_Type)type2).equals(PrimitiveTypeDescriptor.Types.ANY.getO())) {
                    typeRestriction = (flags & RestrictionFlagEncoding.IMMUTABLE_FLAG.getMask()) != 0 ? anyRestrictionImmutable : this.getAnyRestriction();
                } else if (A_Number.Companion.equalsInt(A_Type.Companion.getInstanceCount(type2), 1) && !((A_Type)type2).isInstanceMeta()) {
                    AvailObject instance = A_Type.Companion.getInstance(type2);
                    typeRestriction = instance.isBottom() ? bottomTypeRestriction : new TypeRestriction(new RestrictionGroup(SetsKt.setOf(instance), SetsKt.setOf(type2), possibleVariants, possibleTypeVariants, null), new RestrictionGroup(SetsKt.emptySet(), SetsKt.emptySet(), excludedVariants, excludedTypeVariants, null), flags, null);
                } else {
                    typeRestriction = new TypeRestriction(new RestrictionGroup(null, SetsKt.setOf(type2), possibleVariants, possibleTypeVariants, null), new RestrictionGroup(givenExcludedValues, givenExcludedTypes, excludedVariants, excludedTypeVariants, null), flags, null);
                }
            } else {
                typeRestriction = new TypeRestriction(new RestrictionGroup(null, SetsKt.setOf(type2), possibleVariants, possibleTypeVariants, null), new RestrictionGroup(givenExcludedValues, givenExcludedTypes, excludedVariants, excludedTypeVariants, null), flags, null);
            }
            return typeRestriction;
        }

        @NotNull
        public final TypeRestriction restriction(@NotNull A_Type type2, @Nullable A_BasicObject constantOrNull, @NotNull Set<? extends A_Type> givenExcludedTypes, @NotNull Set<? extends A_BasicObject> givenExcludedValues, @Nullable Set<ObjectLayoutVariant> possibleVariants, @Nullable Set<ObjectLayoutVariant> excludedVariants, @Nullable Set<ObjectLayoutVariant> possibleTypeVariants, @Nullable Set<ObjectLayoutVariant> excludedTypeVariants, boolean isImmutable, boolean isBoxed, boolean isUnboxedInt, boolean isUnboxedFloat) {
            Intrinsics.checkNotNullParameter(type2, "type");
            Intrinsics.checkNotNullParameter(givenExcludedTypes, "givenExcludedTypes");
            Intrinsics.checkNotNullParameter(givenExcludedValues, "givenExcludedValues");
            int flags = (isImmutable ? RestrictionFlagEncoding.IMMUTABLE_FLAG.getMask() : 0) | (isBoxed ? RestrictionFlagEncoding.BOXED_FLAG.getMask() : 0) | (isUnboxedInt ? RestrictionFlagEncoding.UNBOXED_INT_FLAG.getMask() : 0) | (isUnboxedFloat ? RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG.getMask() : 0);
            return this.restriction(type2, constantOrNull, givenExcludedTypes, givenExcludedValues, possibleVariants, excludedVariants, possibleTypeVariants, excludedTypeVariants, flags);
        }

        public static /* synthetic */ TypeRestriction restriction$default(Companion companion, A_Type a_Type, A_BasicObject a_BasicObject, Set set2, Set set3, Set set4, Set set5, Set set6, Set set7, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 4) != 0) {
                set2 = SetsKt.emptySet();
            }
            if ((n & 8) != 0) {
                set3 = SetsKt.emptySet();
            }
            if ((n & 0x10) != 0) {
                set4 = null;
            }
            if ((n & 0x20) != 0) {
                set5 = null;
            }
            if ((n & 0x40) != 0) {
                set6 = null;
            }
            if ((n & 0x80) != 0) {
                set7 = null;
            }
            if ((n & 0x100) != 0) {
                bl = false;
            }
            if ((n & 0x200) != 0) {
                bl2 = true;
            }
            if ((n & 0x400) != 0) {
                bl3 = false;
            }
            if ((n & 0x800) != 0) {
                bl4 = false;
            }
            return companion.restriction(a_Type, a_BasicObject, set2, set3, set4, set5, set6, set7, bl, bl2, bl3, bl4);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TypeRestriction restriction(@NotNull A_Type type2, @Nullable A_BasicObject constantOrNull, @NotNull Set<? extends A_Type> givenExcludedTypes, @NotNull Set<? extends A_BasicObject> givenExcludedValues, @Nullable Set<ObjectLayoutVariant> possibleVariants, @Nullable Set<ObjectLayoutVariant> excludedVariants, @Nullable Set<ObjectLayoutVariant> possibleTypeVariants, @Nullable Set<ObjectLayoutVariant> excludedTypeVariants, int flags) {
            boolean bl;
            block22: {
                boolean $i$f$any;
                Iterable $this$any$iv;
                block23: {
                    block25: {
                        block24: {
                            boolean bl2;
                            block21: {
                                A_BasicObject p0;
                                Intrinsics.checkNotNullParameter(type2, "type");
                                Intrinsics.checkNotNullParameter(givenExcludedTypes, "givenExcludedTypes");
                                Intrinsics.checkNotNullParameter(givenExcludedValues, "givenExcludedValues");
                                type2.makeImmutable();
                                A_BasicObject a_BasicObject = constantOrNull;
                                if (a_BasicObject != null) {
                                    A_BasicObject p02 = a_BasicObject;
                                    boolean bl3 = false;
                                    p02.makeImmutable();
                                }
                                Iterable $this$forEach$iv = givenExcludedTypes;
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    p0 = (A_BasicObject)element$iv;
                                    boolean bl4 = false;
                                    p0.makeImmutable();
                                }
                                $this$forEach$iv = givenExcludedValues;
                                $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    p0 = (A_BasicObject)element$iv;
                                    boolean bl5 = false;
                                    p0.makeImmutable();
                                }
                                if (constantOrNull == null && type2.isEnumeration() && (!type2.isInstanceMeta() || A_Type.Companion.getInstance(type2).isBottom())) {
                                    Set instances = CollectionsKt.toMutableSet(A_Type.Companion.getInstances(type2));
                                    TypeIntrinsics.asMutableCollection(instances).removeAll((Collection)givenExcludedValues);
                                    instances.removeIf(arg_0 -> Companion.restriction$lambda$7(new Function1<AvailObject, Boolean>(givenExcludedTypes){
                                        final /* synthetic */ Set<A_Type> $givenExcludedTypes;
                                        {
                                            this.$givenExcludedTypes = $givenExcludedTypes;
                                            super(1);
                                        }

                                        /*
                                         * WARNING - void declaration
                                         */
                                        @NotNull
                                        public final Boolean invoke(@NotNull AvailObject it) {
                                            boolean bl;
                                            block3: {
                                                void $this$any$iv;
                                                Intrinsics.checkNotNullParameter(it, "it");
                                                Iterable iterable = this.$givenExcludedTypes;
                                                AvailObject availObject = it;
                                                boolean $i$f$any = false;
                                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                                    bl = false;
                                                } else {
                                                    for (T element$iv : $this$any$iv) {
                                                        A_Type p0 = (A_Type)element$iv;
                                                        boolean bl2 = false;
                                                        if (!availObject.isInstanceOf(p0)) continue;
                                                        bl = true;
                                                        break block3;
                                                    }
                                                    bl = false;
                                                }
                                            }
                                            return bl;
                                        }
                                    }, arg_0));
                                    return switch (instances.size()) {
                                        case 0 -> this.getBottomRestriction();
                                        case 1 -> {
                                            AvailObject instance = (AvailObject)CollectionsKt.single(instances);
                                            boolean $i$a$-let-TypeRestriction$Companion$restriction$5 = false;
                                            yield Companion.fromCanonical(AbstractEnumerationTypeDescriptor.Companion.instanceTypeOrMetaOn(instance), instance, SetsKt.emptySet(), SetsKt.emptySet(), possibleVariants, excludedVariants, possibleTypeVariants, excludedTypeVariants, flags);
                                        }
                                        default -> new TypeRestriction(new RestrictionGroup(null, SetsKt.setOf(AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.setFromCollection(instances))), possibleVariants, possibleTypeVariants, null), new RestrictionGroup(SetsKt.emptySet(), SetsKt.emptySet(), excludedVariants, excludedTypeVariants, null), flags, null);
                                    };
                                }
                                if (constantOrNull == null) break block23;
                                if (constantOrNull.isNil()) {
                                    return this.getNilRestriction();
                                }
                                if (!constantOrNull.isInstanceOf(type2) || givenExcludedValues.contains(constantOrNull)) break block24;
                                $this$any$iv = givenExcludedTypes;
                                $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        p0 = (A_Type)element$iv;
                                        boolean bl6 = false;
                                        if (!constantOrNull.isInstanceOf((A_Type)p0)) continue;
                                        bl2 = true;
                                        break block21;
                                    }
                                    bl2 = false;
                                }
                            }
                            if (!bl2) break block25;
                        }
                        return this.getBottomRestriction();
                    }
                    constantOrNull.makeImmutable();
                    return new TypeRestriction(new RestrictionGroup(SetsKt.setOf(constantOrNull), SetsKt.setOf(AbstractEnumerationTypeDescriptor.Companion.instanceTypeOrMetaOn(constantOrNull)), constantOrNull.isInstanceOf(ObjectTypeDescriptor.Companion.getMostGeneralObjectType()) ? SetsKt.setOf(A_BasicObject.Companion.getObjectVariant(constantOrNull)) : null, constantOrNull.equals(BottomTypeDescriptor.Companion.getBottom()) ? null : (constantOrNull.isInstanceOf(ObjectTypeDescriptor.Companion.getMostGeneralObjectMeta()) ? SetsKt.setOf(A_Type.Companion.getObjectTypeVariant((A_Type)constantOrNull)) : null), SetsKt.setOf(((AvailObject)constantOrNull).getTypeTag())), new RestrictionGroup(SetsKt.emptySet(), SetsKt.emptySet(), null, null, null), flags, null);
                }
                $this$any$iv = givenExcludedTypes;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        A_Type it = (A_Type)element$iv;
                        boolean bl7 = false;
                        if (!A_Type.Companion.isSubtypeOf(type2, it)) continue;
                        bl = true;
                        break block22;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return this.getBottomRestriction();
            }
            Set<A_BasicObject> excludedValues = CollectionsKt.toMutableSet((Iterable)givenExcludedValues);
            Iterable $this$mapToSet_u24default$iv = givenExcludedTypes;
            Set destination$iv = new LinkedHashSet();
            boolean $i$f$mapToSet = false;
            Iterable $this$mapTo$iv$iv = $this$mapToSet_u24default$iv;
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                A_Type a_Type = (A_Type)item$iv$iv;
                Collection collection2 = destination$iv;
                boolean bl8 = false;
                collection2.add(A_Type.Companion.typeIntersection(type2, (A_Type)it));
            }
            Set excludedTypes = (Set)((Collection)destination$iv);
            excludedTypes.remove(BottomTypeDescriptor.Companion.getBottom());
            Iterator<Object> iterator2 = excludedTypes.iterator();
            iterator2.forEachRemaining(arg_0 -> Companion.restriction$lambda$12(new Function1<A_Type, Unit>(excludedValues, (Set<A_Type>)excludedTypes, iterator2){
                final /* synthetic */ Set<A_BasicObject> $excludedValues;
                final /* synthetic */ Set<A_Type> $excludedTypes;
                final /* synthetic */ Iterator<A_Type> $iterator;
                {
                    this.$excludedValues = $excludedValues;
                    this.$excludedTypes = $excludedTypes;
                    this.$iterator = $iterator;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull A_Type t) {
                    Intrinsics.checkNotNullParameter(t, "t");
                    if (t.isEnumeration() && !t.isInstanceMeta()) {
                        void $this$forEach$iv;
                        Iterable iterable = A_Type.Companion.getInstances(t);
                        Set<A_BasicObject> set2 = this.$excludedValues;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            A_BasicObject p0 = (A_BasicObject)element$iv;
                            boolean bl = false;
                            set2.add(p0);
                        }
                    } else {
                        boolean bl;
                        block7: {
                            Iterable $this$any$iv = this.$excludedTypes;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    A_Type it = (A_Type)element$iv;
                                    boolean bl2 = false;
                                    if (!TypeDescriptor.Companion.isProperSubtype(t, it)) continue;
                                    bl = true;
                                    break block7;
                                }
                                bl = false;
                            }
                        }
                        if (bl) {
                            this.$iterator.remove();
                        }
                    }
                }
            }, arg_0));
            excludedValues.removeIf(arg_0 -> Companion.restriction$lambda$13(new Function1<A_BasicObject, Boolean>(type2, (Set<A_Type>)excludedTypes){
                final /* synthetic */ A_Type $type;
                final /* synthetic */ Set<A_Type> $excludedTypes;
                {
                    this.$type = $type;
                    this.$excludedTypes = $excludedTypes;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final Boolean invoke(@NotNull A_BasicObject v) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter(v, "v");
                    if (v.isInstanceOf(this.$type)) {
                        boolean bl2;
                        block5: {
                            Iterable $this$any$iv = this.$excludedTypes;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    A_Type p0 = (A_Type)element$iv;
                                    boolean bl3 = false;
                                    if (!v.isInstanceOf(p0)) continue;
                                    bl2 = true;
                                    break block5;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) {
                            bl = false;
                            return bl;
                        }
                    }
                    bl = true;
                    return bl;
                }
            }, arg_0));
            return type2.equals(PrimitiveTypeDescriptor.Types.TOP.getO()) && excludedTypes.isEmpty() && excludedValues.isEmpty() ? topRestriction : this.fromCanonical(type2, null, excludedTypes, excludedValues, possibleVariants, excludedVariants, possibleTypeVariants, excludedTypeVariants, flags);
        }

        @NotNull
        public final TypeRestriction restrictionForType(@NotNull A_Type type2, @NotNull RestrictionFlagEncoding encoding) {
            Intrinsics.checkNotNullParameter(type2, "type");
            Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
            return this.restriction(type2, null, SetsKt.emptySet(), SetsKt.emptySet(), null, null, null, null, encoding.getMask());
        }

        @NotNull
        public final TypeRestriction restrictionForConstant(@NotNull A_BasicObject constant, @NotNull RestrictionFlagEncoding encoding) {
            boolean bl;
            Intrinsics.checkNotNullParameter(constant, "constant");
            Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
            boolean bl2 = bl = encoding == RestrictionFlagEncoding.BOXED_FLAG || encoding == RestrictionFlagEncoding.UNBOXED_INT_FLAG || encoding == RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            AvailObject strongConstant = constant.makeImmutable();
            return this.restriction(constant.isNil() ? (A_Type)PrimitiveTypeDescriptor.Types.TOP.getO() : AbstractEnumerationTypeDescriptor.Companion.instanceTypeOrMetaOn(constant), constant, SetsKt.emptySet(), SetsKt.emptySet(), strongConstant.getTypeTag().isSubtagOf(TypeTag.OBJECT_TAG) ? SetsKt.setOf(A_BasicObject.Companion.getObjectVariant(constant)) : null, null, constant.equals(BottomTypeDescriptor.Companion.getBottom()) ? null : (strongConstant.getTypeTag().isSubtagOf(TypeTag.OBJECT_TYPE_TAG) ? SetsKt.setOf(A_Type.Companion.getObjectTypeVariant(strongConstant)) : null), null, WhenMappings.$EnumSwitchMapping$0[encoding.ordinal()] == 1 ? encoding.getMask() | RestrictionFlagEncoding.IMMUTABLE_FLAG.getMask() : encoding.getMask());
        }

        private static final boolean restriction$lambda$7(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void restriction$lambda$12(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            $tmp0.invoke(p0);
        }

        private static final boolean restriction$lambda$13(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[RestrictionFlagEncoding.values().length];
                try {
                    nArray[RestrictionFlagEncoding.BOXED_FLAG.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Lavail/interpreter/levelTwo/operand/TypeRestriction$RestrictionFlagEncoding;", "", "(Ljava/lang/String;I)V", "mask", "", "getMask", "()I", "IMMUTABLE_FLAG", "BOXED_FLAG", "UNBOXED_INT_FLAG", "UNBOXED_FLOAT_FLAG", "Companion", "avail"})
    public static final class RestrictionFlagEncoding
    extends Enum<RestrictionFlagEncoding> {
        @NotNull
        public static final Companion Companion;
        private final int mask = 1 << this.ordinal();
        private static final int allKindsMask;
        public static final /* enum */ RestrictionFlagEncoding IMMUTABLE_FLAG;
        public static final /* enum */ RestrictionFlagEncoding BOXED_FLAG;
        public static final /* enum */ RestrictionFlagEncoding UNBOXED_INT_FLAG;
        public static final /* enum */ RestrictionFlagEncoding UNBOXED_FLOAT_FLAG;
        private static final /* synthetic */ RestrictionFlagEncoding[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final int getMask() {
            return this.mask;
        }

        public static RestrictionFlagEncoding[] values() {
            return (RestrictionFlagEncoding[])$VALUES.clone();
        }

        public static RestrictionFlagEncoding valueOf(String value) {
            return Enum.valueOf(RestrictionFlagEncoding.class, value);
        }

        @NotNull
        public static EnumEntries<RestrictionFlagEncoding> getEntries() {
            return $ENTRIES;
        }

        static {
            IMMUTABLE_FLAG = new RestrictionFlagEncoding();
            BOXED_FLAG = new RestrictionFlagEncoding();
            UNBOXED_INT_FLAG = new RestrictionFlagEncoding();
            UNBOXED_FLOAT_FLAG = new RestrictionFlagEncoding();
            $VALUES = restrictionFlagEncodingArray = new RestrictionFlagEncoding[]{RestrictionFlagEncoding.IMMUTABLE_FLAG, RestrictionFlagEncoding.BOXED_FLAG, RestrictionFlagEncoding.UNBOXED_INT_FLAG, RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            allKindsMask = RestrictionFlagEncoding.BOXED_FLAG.mask | RestrictionFlagEncoding.UNBOXED_INT_FLAG.mask | RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG.mask;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/interpreter/levelTwo/operand/TypeRestriction$RestrictionFlagEncoding$Companion;", "", "()V", "allKindsMask", "", "getAllKindsMask", "()I", "avail"})
        public static final class Companion {
            private Companion() {
            }

            public final int getAllKindsMask() {
                return allKindsMask;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BS\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0003H\u00c6\u0003Ja\u0010\u0018\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00032\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00032\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006#"}, d2={"Lavail/interpreter/levelTwo/operand/TypeRestriction$RestrictionGroup;", "", "constants", "", "Lavail/descriptor/representation/A_BasicObject;", "types", "Lavail/descriptor/types/A_Type;", "objectVariants", "Lavail/descriptor/objects/ObjectLayoutVariant;", "objectTypeVariants", "tags", "Lavail/descriptor/types/TypeTag;", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "getConstants", "()Ljava/util/Set;", "getObjectTypeVariants", "getObjectVariants", "getTags", "getTypes", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "makeImmutable", "", "makeShared", "toString", "", "avail"})
    @SourceDebugExtension(value={"SMAP\nTypeRestriction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeRestriction.kt\navail/interpreter/levelTwo/operand/TypeRestriction$RestrictionGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1890:1\n1855#2,2:1891\n1855#2,2:1893\n1855#2,2:1895\n1855#2,2:1897\n*S KotlinDebug\n*F\n+ 1 TypeRestriction.kt\navail/interpreter/levelTwo/operand/TypeRestriction$RestrictionGroup\n*L\n202#1:1891,2\n203#1:1893,2\n209#1:1895,2\n210#1:1897,2\n*E\n"})
    public static final class RestrictionGroup {
        @Nullable
        private final Set<A_BasicObject> constants;
        @NotNull
        private final Set<A_Type> types;
        @Nullable
        private final Set<ObjectLayoutVariant> objectVariants;
        @Nullable
        private final Set<ObjectLayoutVariant> objectTypeVariants;
        @Nullable
        private final Set<TypeTag> tags;

        public RestrictionGroup(@Nullable Set<? extends A_BasicObject> constants, @NotNull Set<? extends A_Type> types, @Nullable Set<ObjectLayoutVariant> objectVariants, @Nullable Set<ObjectLayoutVariant> objectTypeVariants, @Nullable Set<? extends TypeTag> tags) {
            Intrinsics.checkNotNullParameter(types, "types");
            this.constants = constants;
            this.types = types;
            this.objectVariants = objectVariants;
            this.objectTypeVariants = objectTypeVariants;
            this.tags = tags;
        }

        @Nullable
        public final Set<A_BasicObject> getConstants() {
            return this.constants;
        }

        @NotNull
        public final Set<A_Type> getTypes() {
            return this.types;
        }

        @Nullable
        public final Set<ObjectLayoutVariant> getObjectVariants() {
            return this.objectVariants;
        }

        @Nullable
        public final Set<ObjectLayoutVariant> getObjectTypeVariants() {
            return this.objectTypeVariants;
        }

        @Nullable
        public final Set<TypeTag> getTags() {
            return this.tags;
        }

        public final void makeImmutable() {
            Set<A_BasicObject> set2 = this.constants;
            if (set2 != null) {
                Iterable $this$forEach$iv = set2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    A_BasicObject p0 = (A_BasicObject)element$iv;
                    boolean bl = false;
                    p0.makeImmutable();
                }
            }
            Iterable $this$forEach$iv = this.types;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                A_Type p0 = (A_Type)element$iv;
                boolean bl = false;
                p0.makeImmutable();
            }
        }

        public final void makeShared() {
            Set<A_BasicObject> set2 = this.constants;
            if (set2 != null) {
                Iterable $this$forEach$iv = set2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    A_BasicObject p0 = (A_BasicObject)element$iv;
                    boolean bl = false;
                    p0.makeShared();
                }
            }
            Iterable $this$forEach$iv = this.types;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                A_Type p0 = (A_Type)element$iv;
                boolean bl = false;
                p0.makeShared();
            }
        }

        @Nullable
        public final Set<A_BasicObject> component1() {
            return this.constants;
        }

        @NotNull
        public final Set<A_Type> component2() {
            return this.types;
        }

        @Nullable
        public final Set<ObjectLayoutVariant> component3() {
            return this.objectVariants;
        }

        @Nullable
        public final Set<ObjectLayoutVariant> component4() {
            return this.objectTypeVariants;
        }

        @Nullable
        public final Set<TypeTag> component5() {
            return this.tags;
        }

        @NotNull
        public final RestrictionGroup copy(@Nullable Set<? extends A_BasicObject> constants, @NotNull Set<? extends A_Type> types, @Nullable Set<ObjectLayoutVariant> objectVariants, @Nullable Set<ObjectLayoutVariant> objectTypeVariants, @Nullable Set<? extends TypeTag> tags) {
            Intrinsics.checkNotNullParameter(types, "types");
            return new RestrictionGroup(constants, types, objectVariants, objectTypeVariants, tags);
        }

        public static /* synthetic */ RestrictionGroup copy$default(RestrictionGroup restrictionGroup, Set set2, Set set3, Set set4, Set set5, Set set6, int n, Object object) {
            if ((n & 1) != 0) {
                set2 = restrictionGroup.constants;
            }
            if ((n & 2) != 0) {
                set3 = restrictionGroup.types;
            }
            if ((n & 4) != 0) {
                set4 = restrictionGroup.objectVariants;
            }
            if ((n & 8) != 0) {
                set5 = restrictionGroup.objectTypeVariants;
            }
            if ((n & 0x10) != 0) {
                set6 = restrictionGroup.tags;
            }
            return restrictionGroup.copy(set2, set3, set4, set5, set6);
        }

        @NotNull
        public String toString() {
            return "RestrictionGroup(constants=" + this.constants + ", types=" + this.types + ", objectVariants=" + this.objectVariants + ", objectTypeVariants=" + this.objectTypeVariants + ", tags=" + this.tags + ")";
        }

        public int hashCode() {
            int result2 = this.constants == null ? 0 : ((Object)this.constants).hashCode();
            result2 = result2 * 31 + ((Object)this.types).hashCode();
            result2 = result2 * 31 + (this.objectVariants == null ? 0 : ((Object)this.objectVariants).hashCode());
            result2 = result2 * 31 + (this.objectTypeVariants == null ? 0 : ((Object)this.objectTypeVariants).hashCode());
            result2 = result2 * 31 + (this.tags == null ? 0 : ((Object)this.tags).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RestrictionGroup)) {
                return false;
            }
            RestrictionGroup restrictionGroup = (RestrictionGroup)other;
            if (!Intrinsics.areEqual(this.constants, restrictionGroup.constants)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.types, restrictionGroup.types)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.objectVariants, restrictionGroup.objectVariants)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.objectTypeVariants, restrictionGroup.objectTypeVariants)) {
                return false;
            }
            return Intrinsics.areEqual(this.tags, restrictionGroup.tags);
        }
    }
}

