/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operation.L2_CONCATENATE_TUPLES;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2Generator;
import avail.optimizer.jvm.JVMTranslator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u001c"}, d2={"Lavail/interpreter/levelTwo/operation/L2_CONCATENATE_TUPLES;", "Lavail/interpreter/levelTwo/L2Operation;", "()V", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "", "extractTupleElement", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "tupleReg", "index", "", "generator", "Lavail/optimizer/L2Generator;", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_CONCATENATE_TUPLES
extends L2Operation {
    @NotNull
    public static final L2_CONCATENATE_TUPLES INSTANCE = new L2_CONCATENATE_TUPLES();

    private L2_CONCATENATE_TUPLES() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_BOXED_VECTOR.named("tuples to concatenate"), L2OperandType.WRITE_BOXED.named("concatenated tuple")};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, "desiredTypes");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, "warningStyleChange");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedVectorOperand tuples = (L2ReadBoxedVectorOperand)instruction2.operand(0);
        L2WriteBoxedOperand output = (L2WriteBoxedOperand)instruction2.operand(1);
        this.renderPreamble(instruction2, builder);
        builder.append(' ');
        builder.append(output.registerString());
        builder.append(" \u2190 ");
        CollectionsKt.joinTo$default(tuples.getElements(), builder, " ++ ", null, null, 0, null, appendToWithWarnings.1.INSTANCE, 60, null);
    }

    @Override
    @NotNull
    public L2ReadBoxedOperand extractTupleElement(@NotNull L2ReadBoxedOperand tupleReg, int index2, @NotNull L2Generator generator) {
        Intrinsics.checkNotNullParameter(tupleReg, "tupleReg");
        Intrinsics.checkNotNullParameter(generator, "generator");
        L2Instruction instruction2 = tupleReg.definition().getInstruction();
        L2ReadBoxedVectorOperand values2 = (L2ReadBoxedVectorOperand)instruction2.operand(0);
        int residualIndex = index2;
        for (L2ReadBoxedOperand elementRead : values2.getElements()) {
            boolean bl;
            boolean bl2 = bl = residualIndex >= 1;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            A_Type sizeRange = elementRead.type();
            A_Number lowerBound = A_Type.Companion.getLowerBound(sizeRange);
            if (!A_Number.Companion.isInt(lowerBound)) break;
            int lowerBoundInt = A_Number.Companion.getExtractInt(lowerBound);
            if (residualIndex <= lowerBoundInt) {
                return generator.extractTupleElement(elementRead, residualIndex);
            }
            if (!lowerBound.equals(A_Type.Companion.getUpperBound(sizeRange))) break;
            residualIndex -= lowerBoundInt;
        }
        return super.extractTupleElement(tupleReg, index2, generator);
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        L2ReadBoxedVectorOperand tuples = (L2ReadBoxedVectorOperand)instruction2.operand(0);
        L2WriteBoxedOperand output = (L2WriteBoxedOperand)instruction2.operand(1);
        List elements = tuples.getElements();
        int tupleCount = elements.size();
        boolean bl2 = bl = tupleCount > 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        translator.load(method, (L2Register)((L2ReadBoxedOperand)elements.get(0)).register());
        for (int i2 = 1; i2 < tupleCount; ++i2) {
            translator.load(method, (L2Register)((L2ReadBoxedOperand)elements.get(i2)).register());
            TupleDescriptor.Companion.getConcatenateTupleMethod().generateCall(method);
        }
        method.visitTypeInsn(192, Type.getInternalName(AvailObject.class));
        translator.store(method, (L2Register)output.register());
    }
}

