/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.general;

import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ByteArrayTupleDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lavail/interpreter/primitive/general/P_ComputeDigest;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_ComputeDigest
extends Primitive {
    @NotNull
    public static final P_ComputeDigest INSTANCE = new P_ComputeDigest();

    private P_ComputeDigest() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject algorithm = interpreter.argument(0);
        AvailObject bytes2 = interpreter.argument(1);
        MessageDigest digest = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-" + algorithm);
            Intrinsics.checkNotNullExpressionValue(messageDigest, "getInstance(...)");
            digest = messageDigest;
        }
        catch (NoSuchAlgorithmException e) {
            if (_Assertions.ENABLED) {
                boolean $i$a$-assert-P_ComputeDigest$attempt$22 = false;
                String $i$a$-assert-P_ComputeDigest$attempt$22 = "these are standard digest algorithm available in all Java implementations";
                throw new AssertionError((Object)$i$a$-assert-P_ComputeDigest$attempt$22);
            }
            throw new RuntimeException(e);
        }
        int size = A_Tuple.Companion.getTupleSize(bytes2);
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        A_Tuple a_Tuple = bytes2;
        Intrinsics.checkNotNull(buffer);
        A_Tuple.Companion.transferIntoByteBuffer(a_Tuple, 1, size, buffer);
        buffer.flip();
        digest.update(buffer);
        byte[] digestBytes = digest.digest();
        Intrinsics.checkNotNull(digestBytes);
        AvailObject digestTuple = ByteArrayTupleDescriptor.Companion.tupleForByteArray(digestBytes);
        return interpreter.primitiveSuccess(digestTuple);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        Integer[] integerArray = new Integer[]{1, 256, 384, 512};
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(AbstractEnumerationTypeDescriptor.Companion.enumerationWith(A_Tuple.Companion.getAsSet(TupleDescriptor.Companion.tupleFromIntegerList(CollectionsKt.listOf(integerArray)))), TupleTypeDescriptor.Companion.zeroOrMoreOf(IntegerRangeTypeDescriptor.Companion.getU8())), TupleTypeDescriptor.Companion.oneOrMoreOf(IntegerRangeTypeDescriptor.Companion.getU8()), null, 4, null);
    }
}

