/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.methods;

import avail.descriptor.functions.A_Function;
import avail.descriptor.methods.A_Method;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/methods/P_SemanticRestrictions;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_SemanticRestrictions
extends Primitive {
    @NotNull
    public static final P_SemanticRestrictions INSTANCE = new P_SemanticRestrictions();

    private P_SemanticRestrictions() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject method = interpreter.argument(0);
        AvailObject argTypes2 = interpreter.argument(1);
        if (A_Method.Companion.getNumArgs(method) != A_Tuple.Companion.getTupleSize(argTypes2)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
        }
        A_Set restrictions = A_Method.Companion.getSemanticRestrictions(method);
        List applicable = new ArrayList();
        for (AvailObject restriction2 : restrictions) {
            A_Function function = restriction2.function();
            if (!A_Type.Companion.acceptsTupleOfArguments(function.kind(), argTypes2)) continue;
            applicable.add(function);
        }
        return interpreter.primitiveSuccess(ObjectTupleDescriptor.Companion.tupleFromList(applicable));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.METHOD.getO(), TupleTypeDescriptor.Companion.zeroOrMoreOf(InstanceMetaDescriptor.Companion.anyMeta())), TupleTypeDescriptor.Companion.zeroOrMoreOf(FunctionTypeDescriptor.Companion.functionTypeReturning(InstanceMetaDescriptor.Companion.topMeta())), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

