/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.processes;

import avail.descriptor.maps.A_Map;
import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.MapTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/processes/P_ExecuteDetachedExternalProcess;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
@SourceDebugExtension(value={"SMAP\nP_ExecuteDetachedExternalProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P_ExecuteDetachedExternalProcess.kt\navail/interpreter/primitive/processes/P_ExecuteDetachedExternalProcess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1549#2:143\n1620#2,3:144\n1179#2,2:147\n1253#2,4:149\n*S KotlinDebug\n*F\n+ 1 P_ExecuteDetachedExternalProcess.kt\navail/interpreter/primitive/processes/P_ExecuteDetachedExternalProcess\n*L\n78#1:143\n78#1:144,3\n99#1:147,2\n99#1:149,4\n*E\n"})
public final class P_ExecuteDetachedExternalProcess
extends Primitive {
    @NotNull
    public static final P_ExecuteDetachedExternalProcess INSTANCE = new P_ExecuteDetachedExternalProcess();

    private P_ExecuteDetachedExternalProcess() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(6, flagArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(6);
        AvailObject processArgsTuple = interpreter.argument(0);
        AvailObject optDir = interpreter.argument(1);
        AvailObject optIn = interpreter.argument(2);
        AvailObject optOut = interpreter.argument(3);
        AvailObject optError = interpreter.argument(4);
        AvailObject optEnvironment = interpreter.argument(5);
        Iterable $this$map$iv = processArgsTuple;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AvailObject availObject = (AvailObject)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(A_String.Companion.asNativeString((A_String)it));
        }
        List processArgs = (List)destination$iv$iv;
        ProcessBuilder builder = new ProcessBuilder(processArgs);
        if (A_Tuple.Companion.getTupleSize(optDir) == 1) {
            builder.directory(new File(A_String.Companion.asNativeString(A_Tuple.Companion.tupleAt(optDir, 1))));
        }
        if (A_Tuple.Companion.getTupleSize(optIn) == 1) {
            builder.redirectInput(new File(A_String.Companion.asNativeString(A_Tuple.Companion.tupleAt(optIn, 1))));
        }
        if (A_Tuple.Companion.getTupleSize(optOut) == 1) {
            builder.redirectOutput(new File(A_String.Companion.asNativeString(A_Tuple.Companion.tupleAt(optOut, 1))));
        }
        if (A_Tuple.Companion.getTupleSize(optError) == 1) {
            builder.redirectError(new File(A_String.Companion.asNativeString(A_Tuple.Companion.tupleAt(optError, 1))));
        }
        if (A_Tuple.Companion.getTupleSize(optEnvironment) == 1) {
            void $this$associateTo$iv$iv;
            Iterable<MapDescriptor.Entry> $this$associate$iv = A_Map.Companion.getMapIterable(A_Tuple.Companion.tupleAt(optEnvironment, 1));
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            Iterable<MapDescriptor.Entry> iterable2 = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                Object object = (MapDescriptor.Entry)element$iv$iv;
                boolean bl = false;
                AvailObject k = ((MapDescriptor.Entry)object).component1();
                AvailObject v = ((MapDescriptor.Entry)object).component2();
                object = TuplesKt.to(A_String.Companion.asNativeString(k), A_String.Companion.asNativeString(v));
                map.put(((Pair)object).getFirst(), ((Pair)object).getSecond());
            }
            Map newEnvironmentMap = destination$iv$iv2;
            Map<String, String> environmentMap = builder.environment();
            environmentMap.clear();
            environmentMap.putAll(newEnvironmentMap);
        }
        try {
            builder.start();
        }
        catch (SecurityException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
        }
        catch (IOException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_NO_EXTERNAL_PROCESS);
        }
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{TupleTypeDescriptor.Companion.oneOrMoreOf(TupleTypeDescriptor.Companion.getStringType()), TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.getStringType()), TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.getStringType()), TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.getStringType()), TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.getStringType()), TupleTypeDescriptor.Companion.zeroOrOneOf(MapTypeDescriptor.Companion.mapTypeForSizesKeyTypeValueType(IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), TupleTypeDescriptor.Companion.getStringType(), TupleTypeDescriptor.Companion.getStringType()))};
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tupleFromArray(a_BasicObjectArray), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_PERMISSION_DENIED, AvailErrorCode.E_NO_EXTERNAL_PROCESS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

