/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.sets;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.SetTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016\u00a8\u0006\u000e"}, d2={"Lavail/interpreter/primitive/sets/P_SetUnion;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "avail"})
public final class P_SetUnion
extends Primitive {
    @NotNull
    public static final P_SetUnion INSTANCE = new P_SetUnion();

    private P_SetUnion() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject set1 = interpreter.argument(0);
        AvailObject set2 = interpreter.argument(1);
        return interpreter.primitiveSuccess(A_Set.Companion.setUnionCanDestroy(set1, set2, true));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(SetTypeDescriptor.Companion.mostGeneralSetType(), SetTypeDescriptor.Companion.mostGeneralSetType()), SetTypeDescriptor.Companion.mostGeneralSetType(), null, 4, null);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type setType1 = argumentTypes.get(0);
        A_Type setType2 = argumentTypes.get(1);
        A_Type sizes1 = A_Type.Companion.getSizeRange(setType1);
        A_Type sizes2 = A_Type.Companion.getSizeRange(setType2);
        A_Number min1 = A_Type.Companion.getLowerBound(sizes1);
        A_Number min2 = A_Type.Companion.getLowerBound(sizes2);
        A_Number minSize = A_Number.Companion.numericCompare(min1, min2).isMore() ? min1 : min2;
        A_Number maxSize = A_Number.Companion.plusCanDestroy(A_Type.Companion.getUpperBound(sizes1), A_Type.Companion.getUpperBound(sizes2), false);
        A_Type unionSize = IntegerRangeTypeDescriptor.Companion.integerRangeType(minSize, true, A_Number.Companion.plusCanDestroy(maxSize, IntegerDescriptor.Companion.getOne(), false), false);
        A_Type unionType = SetTypeDescriptor.Companion.setTypeForSizesContentType(unionSize, A_Type.Companion.typeUnion(A_Type.Companion.getContentType(setType1), A_Type.Companion.getContentType(setType2)));
        return unionType.makeImmutable();
    }
}

