/*
 * Decompiled with CFR 0.152.
 */
package avail.io;

import avail.io.TextInputChannel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J9\u0010\u000e\u001a\u00020\b\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u0001H\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\u000f0\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lavail/io/ConsoleInputChannel;", "Lavail/io/TextInputChannel;", "stream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "input", "Ljava/io/Reader;", "close", "", "isOpen", "", "mark", "readAhead", "", "read", "A", "buffer", "Ljava/nio/CharBuffer;", "attachment", "handler", "Ljava/nio/channels/CompletionHandler;", "(Ljava/nio/CharBuffer;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V", "reset", "avail"})
public final class ConsoleInputChannel
implements TextInputChannel {
    @NotNull
    private final Reader input;

    public ConsoleInputChannel(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.input = new BufferedReader(new InputStreamReader(stream, decoder));
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public <A> void read(@NotNull CharBuffer buffer, @Nullable A attachment, @NotNull CompletionHandler<Integer, A> handler) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(handler, "handler");
        int charsRead = 0;
        try {
            charsRead = this.input.read(buffer);
            if (charsRead == -1) {
                throw new IOException("end of stream");
            }
        }
        catch (IOException e) {
            handler.failed(e, attachment);
            return;
        }
        handler.completed(charsRead, attachment);
    }

    @Override
    public void mark(int readAhead) throws IOException {
        this.input.mark(readAhead);
    }

    @Override
    public void reset() throws IOException {
        this.input.reset();
    }

    @Override
    public void close() {
    }
}

