/*
 * Decompiled with CFR 0.152.
 */
package avail.io;

import avail.io.NybbleInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.CharRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0006H\u0086\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\r\u001a\u00020\u0006J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0096\u0002J\u0019\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0002H\u0086\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lavail/io/NybbleArray;", "", "", "bytes", "", "size", "", "([BI)V", "getBytes", "()[B", "getSize", "()I", "get", "index", "inputStream", "Lavail/io/NybbleInputStream;", "isEmpty", "", "isNotEmpty", "iterator", "", "set", "", "value", "toString", "", "Companion", "avail"})
@SourceDebugExtension(value={"SMAP\nNybbleStreams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NybbleStreams.kt\navail/io/NybbleArray\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,372:1\n1#2:373\n1855#3,2:374\n1549#3:376\n1620#3,3:377\n*S KotlinDebug\n*F\n+ 1 NybbleStreams.kt\navail/io/NybbleArray\n*L\n204#1:374,2\n213#1:376\n213#1:377,3\n*E\n"})
public final class NybbleArray
implements Iterable<Byte>,
KMappedMarker {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final byte[] bytes;
    private final int size;
    @NotNull
    private static final List<String> nybbleStrings;

    public NybbleArray(@NotNull byte[] bytes2, int size) {
        Intrinsics.checkNotNullParameter(bytes2, "bytes");
        this.bytes = bytes2;
        this.size = size;
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final boolean isNotEmpty() {
        return this.size != 0;
    }

    public final byte get(int index2) {
        if (!(0 <= index2 ? index2 < this.size : false)) {
            throw new IndexOutOfBoundsException(index2);
        }
        byte by = this.bytes[index2 >>> 1];
        int nybble = by >>> ((index2 & 1) << 2) & 0xF;
        return (byte)nybble;
    }

    public final void set(int index2, byte value) {
        byte by = value;
        byte by2 = 0 <= by ? (by < 16 ? (byte)1 : 0) : (by = 0);
        if (_Assertions.ENABLED && by == 0) {
            boolean $i$a$-assert-NybbleArray$set$22 = false;
            String $i$a$-assert-NybbleArray$set$22 = "value must be in [0..15]";
            throw new AssertionError((Object)$i$a$-assert-NybbleArray$set$22);
        }
        if (!(0 <= index2 ? index2 < this.size : false)) {
            throw new IndexOutOfBoundsException(index2);
        }
        int byteIndex = index2 >>> 1;
        byte by3 = this.bytes[byteIndex];
        int newByte = (index2 & 1) == 1 ? by3 & 0xF | value >>> 4 : by3 & 0xF0 | value;
        this.bytes[byteIndex] = (byte)newByte;
    }

    @NotNull
    public final NybbleInputStream inputStream(int index2) {
        return new NybbleInputStream(this, index2);
    }

    public static /* synthetic */ NybbleInputStream inputStream$default(NybbleArray nybbleArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return nybbleArray.inputStream(n);
    }

    @Override
    @NotNull
    public Iterator<Byte> iterator() {
        return new Companion.NybbleIterator(this, 0, 2, null);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte it = ((Number)element$iv).byteValue();
            boolean bl2 = false;
            $this$toString_u24lambda_u242.append(nybbleStrings.get(it));
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$map$iv = CollectionsKt.plus((Iterable)new CharRange('0', '9'), (Iterable)new CharRange('A', 'F'));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            char c = ((Character)item$iv$iv).charValue();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(String.valueOf((char)it));
        }
        nybbleStrings = (List)var3_3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lavail/io/NybbleArray$Companion;", "", "()V", "nybbleStrings", "", "", "getNybbleStrings", "()Ljava/util/List;", "NybbleIterator", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getNybbleStrings() {
            return nybbleStrings;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\n\u001a\u00020\u000bH\u0096\u0002J\u000e\u0010\f\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lavail/io/NybbleArray$Companion$NybbleIterator;", "", "", "nybbles", "Lavail/io/NybbleArray;", "nybbleIndex", "", "(Lavail/io/NybbleArray;I)V", "getNybbles", "()Lavail/io/NybbleArray;", "hasNext", "", "next", "()Ljava/lang/Byte;", "avail"})
        private static final class NybbleIterator
        implements Iterator<Byte>,
        KMappedMarker {
            @NotNull
            private final NybbleArray nybbles;
            private int nybbleIndex;

            public NybbleIterator(@NotNull NybbleArray nybbles2, int nybbleIndex) {
                Intrinsics.checkNotNullParameter(nybbles2, "nybbles");
                this.nybbles = nybbles2;
                this.nybbleIndex = nybbleIndex;
            }

            public /* synthetic */ NybbleIterator(NybbleArray nybbleArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 2) != 0) {
                    n = 0;
                }
                this(nybbleArray, n);
            }

            @NotNull
            public final NybbleArray getNybbles() {
                return this.nybbles;
            }

            @Override
            public boolean hasNext() {
                return this.nybbleIndex < this.nybbles.getSize();
            }

            @Override
            @NotNull
            public Byte next() {
                int n = this.nybbleIndex;
                this.nybbleIndex = n + 1;
                return this.nybbles.get(n);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        }
    }
}

