/*
 * Decompiled with CFR 0.152.
 */
package avail.io;

import avail.AvailRuntime;
import avail.io.TextOutputChannel;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J9\u0010\r\u001a\u00020\n\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u0001H\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u0002H\u000e0\u0013H\u0016\u00a2\u0006\u0002\u0010\u0015J9\u0010\r\u001a\u00020\n\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u0001H\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u0002H\u000e0\u0013H\u0016\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lavail/io/ProcessOutputChannel;", "Lavail/io/TextOutputChannel;", "stream", "Ljava/io/PrintStream;", "(Ljava/io/PrintStream;)V", "out", "Ljava/io/Writer;", "getOut$avail", "()Ljava/io/Writer;", "close", "", "isOpen", "", "write", "A", "buffer", "Ljava/nio/CharBuffer;", "attachment", "handler", "Ljava/nio/channels/CompletionHandler;", "", "(Ljava/nio/CharBuffer;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V", "data", "", "(Ljava/lang/String;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V", "avail"})
public final class ProcessOutputChannel
implements TextOutputChannel {
    @NotNull
    private final Writer out;

    public ProcessOutputChannel(@NotNull PrintStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.REPLACE);
        encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, encoder));
    }

    @NotNull
    public final Writer getOut$avail() {
        return this.out;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public <A> void write(@NotNull CharBuffer buffer, @Nullable A attachment, @NotNull CompletionHandler<Integer, A> handler) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(handler, "handler");
        AvailRuntime runtime = AvailRuntime.Companion.currentRuntime();
        runtime.getIoSystem().executeFileTask(() -> ProcessOutputChannel.write$lambda$0(this, buffer, handler, attachment));
    }

    @Override
    public <A> void write(@NotNull String data2, @Nullable A attachment, @NotNull CompletionHandler<Integer, A> handler) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(handler, "handler");
        AvailRuntime runtime = AvailRuntime.Companion.currentRuntime();
        runtime.getIoSystem().executeFileTask(() -> ProcessOutputChannel.write$lambda$1(this, data2, handler, attachment));
    }

    @Override
    public void close() {
    }

    private static final void write$lambda$0(ProcessOutputChannel this$0, CharBuffer $buffer, CompletionHandler $handler, Object $attachment) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($buffer, "$buffer");
        Intrinsics.checkNotNullParameter($handler, "$handler");
        try {
            this$0.out.write($buffer.toString());
            this$0.out.flush();
        }
        catch (IOException e) {
            $handler.failed(e, $attachment);
            return;
        }
        $handler.completed($buffer.limit(), $attachment);
    }

    private static final void write$lambda$1(ProcessOutputChannel this$0, String $data, CompletionHandler $handler, Object $attachment) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($data, "$data");
        Intrinsics.checkNotNullParameter($handler, "$handler");
        try {
            this$0.out.write($data);
            this$0.out.flush();
        }
        catch (IOException e) {
            $handler.failed(e, $attachment);
            return;
        }
        $handler.completed($data.length(), $attachment);
    }
}

