/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer.jvm;

import avail.interpreter.execution.Interpreter;
import avail.optimizer.jvm.CheckedField;
import avail.optimizer.jvm.JVMChunk;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import avail.utility.Strings;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u000fR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lavail/optimizer/jvm/JVMChunkClassLoader;", "Ljava/lang/ClassLoader;", "()V", "parameters", "", "", "[Ljava/lang/Object;", "newJVMChunkFrom", "Lavail/optimizer/jvm/JVMChunk;", "chunkName", "", "className", "classBytes", "", "params", "(Ljava/lang/String;Ljava/lang/String;[B[Ljava/lang/Object;)Lavail/optimizer/jvm/JVMChunk;", "Companion", "avail"})
public final class JVMChunkClassLoader
extends ClassLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @ReferencedInGeneratedCode
    @JvmField
    @NotNull
    public Object[] parameters = new Object[0];
    @NotNull
    private static final CheckedField parametersField = CheckedField.Companion.instanceField(JVMChunkClassLoader.class, "parameters", Object[].class);

    public JVMChunkClassLoader() {
        super(JVMChunk.class.getClassLoader());
    }

    @Nullable
    public final JVMChunk newJVMChunkFrom(@NotNull String chunkName, @NotNull String className, @NotNull byte[] classBytes, @NotNull Object[] params) {
        Intrinsics.checkNotNullParameter(chunkName, "chunkName");
        Intrinsics.checkNotNullParameter(className, "className");
        Intrinsics.checkNotNullParameter(classBytes, "classBytes");
        Intrinsics.checkNotNullParameter(params, "params");
        this.parameters = params;
        Class<?> cl = this.defineClass(className, classBytes, 0, classBytes.length);
        try {
            Constructor<?> constructor = cl.getConstructor(new Class[0]);
            Object o = constructor.newInstance(new Object[0]);
            Intrinsics.checkNotNull(o, "null cannot be cast to non-null type avail.optimizer.jvm.JVMChunk");
            return (JVMChunk)o;
        }
        catch (NoSuchMethodException e) {
            Logger logger = Interpreter.Companion.getLoggerDebugJVM();
            Level level = Level.SEVERE;
            Intrinsics.checkNotNullExpressionValue(level, "SEVERE");
            Object[] objectArray = new Object[]{className, chunkName, Strings.INSTANCE.traceFor(e)};
            Interpreter.Companion.log(logger, level, "Failed to load JVMChunk ({0}) from L2Chunk ({1}): {2}", objectArray);
        }
        catch (InstantiationException e) {
            Logger logger = Interpreter.Companion.getLoggerDebugJVM();
            Level level = Level.SEVERE;
            Intrinsics.checkNotNullExpressionValue(level, "SEVERE");
            Object[] objectArray = new Object[]{className, chunkName, Strings.INSTANCE.traceFor(e)};
            Interpreter.Companion.log(logger, level, "Failed to load JVMChunk ({0}) from L2Chunk ({1}): {2}", objectArray);
        }
        catch (IllegalAccessException e) {
            Logger logger = Interpreter.Companion.getLoggerDebugJVM();
            Level level = Level.SEVERE;
            Intrinsics.checkNotNullExpressionValue(level, "SEVERE");
            Object[] objectArray = new Object[]{className, chunkName, Strings.INSTANCE.traceFor(e)};
            Interpreter.Companion.log(logger, level, "Failed to load JVMChunk ({0}) from L2Chunk ({1}): {2}", objectArray);
        }
        catch (InvocationTargetException e) {
            Logger logger = Interpreter.Companion.getLoggerDebugJVM();
            Level level = Level.SEVERE;
            Intrinsics.checkNotNullExpressionValue(level, "SEVERE");
            Object[] objectArray = new Object[]{className, chunkName, Strings.INSTANCE.traceFor(e)};
            Interpreter.Companion.log(logger, level, "Failed to load JVMChunk ({0}) from L2Chunk ({1}): {2}", objectArray);
        }
        catch (ClassCastException e) {
            Logger logger = Interpreter.Companion.getLoggerDebugJVM();
            Level level = Level.SEVERE;
            Intrinsics.checkNotNullExpressionValue(level, "SEVERE");
            Object[] objectArray = new Object[]{className, chunkName, Strings.INSTANCE.traceFor(e)};
            Interpreter.Companion.log(logger, level, "Failed to load JVMChunk ({0}) from L2Chunk ({1}): {2}", objectArray);
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/optimizer/jvm/JVMChunkClassLoader$Companion;", "", "()V", "parametersField", "Lavail/optimizer/jvm/CheckedField;", "getParametersField", "()Lavail/optimizer/jvm/CheckedField;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CheckedField getParametersField() {
            return parametersField;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

