/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer.reoptimizer;

import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2OperandDispatcher;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2ArbitraryConstantOperand;
import avail.interpreter.levelTwo.operand.L2CommentOperand;
import avail.interpreter.levelTwo.operand.L2ConstantOperand;
import avail.interpreter.levelTwo.operand.L2FloatImmediateOperand;
import avail.interpreter.levelTwo.operand.L2IntImmediateOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2PcVectorOperand;
import avail.interpreter.levelTwo.operand.L2PrimitiveOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2ReadFloatOperand;
import avail.interpreter.levelTwo.operand.L2ReadFloatVectorOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntVectorOperand;
import avail.interpreter.levelTwo.operand.L2ReadOperand;
import avail.interpreter.levelTwo.operand.L2SelectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteFloatOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operand.L2WriteOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_MOVE_CONSTANT;
import avail.interpreter.levelTwo.register.L2BoxedRegister;
import avail.interpreter.levelTwo.register.L2FloatRegister;
import avail.interpreter.levelTwo.register.L2IntRegister;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Entity;
import avail.optimizer.L2EntityAndKind;
import avail.optimizer.L2Generator;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.values.L2SemanticUnboxedFloat;
import avail.optimizer.values.L2SemanticUnboxedInt;
import avail.optimizer.values.L2SemanticValue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001:\u0003123B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ'\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f\"\u00020 \u00a2\u0006\u0002\u0010!J\u0006\u0010\"\u001a\u00020\u0018J\u0016\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010(\u001a\u00020)J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u001aJ\u001d\u0010-\u001a\u0002H.\"\b\b\u0000\u0010.*\u00020 2\u0006\u0010/\u001a\u0002H.\u00a2\u0006\u0002\u00100R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00060\u0014R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00064"}, d2={"Lavail/optimizer/reoptimizer/L2Regenerator;", "", "targetGenerator", "Lavail/optimizer/L2Generator;", "generatePhis", "", "(Lavail/optimizer/L2Generator;Z)V", "backEdgeVisitQueue", "Ljava/util/ArrayDeque;", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "completedSourceBlocks", "", "Lavail/optimizer/L2BasicBlock;", "edgeVisitQueue", "inverseSpecialBlockMap", "", "Lavail/optimizer/L2Generator$SpecialBlock;", "getInverseSpecialBlockMap", "()Ljava/util/Map;", "operandInlineTransformer", "Lavail/optimizer/reoptimizer/L2Regenerator$AbstractOperandTransformer;", "getTargetGenerator", "()Lavail/optimizer/L2Generator;", "basicProcessInstruction", "", "sourceInstruction", "Lavail/interpreter/levelTwo/L2Instruction;", "emitInstruction", "operation", "Lavail/interpreter/levelTwo/L2Operation;", "operands", "", "Lavail/interpreter/levelTwo/operand/L2Operand;", "(Lavail/interpreter/levelTwo/L2Operation;[Lavail/interpreter/levelTwo/operand/L2Operand;)V", "forceAllPostponedTranslationsExceptConstantMoves", "forcePostponedTranslationBeforeEdge", "edge", "semanticValue", "Lavail/optimizer/values/L2SemanticValue;", "forcePostponedTranslationNow", "nextUnique", "", "processInstruction", "processSourceGraphStartingAt", "startingInstruction", "transformOperand", "O", "operand", "(Lavail/interpreter/levelTwo/operand/L2Operand;)Lavail/interpreter/levelTwo/operand/L2Operand;", "AbstractOperandTransformer", "OperandRegisterTransformer", "OperandSemanticTransformer", "avail"})
@SourceDebugExtension(value={"SMAP\nL2Regenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 L2Regenerator.kt\navail/optimizer/reoptimizer/L2Regenerator\n+ 2 Casts.kt\navail/utility/CastsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,703:1\n46#2:704\n1747#3,3:705\n1855#3,2:708\n1855#3,2:712\n215#4,2:710\n*S KotlinDebug\n*F\n+ 1 L2Regenerator.kt\navail/optimizer/reoptimizer/L2Regenerator\n*L\n430#1:704\n499#1:705,3\n528#1:708,2\n654#1:712,2\n641#1:710,2\n*E\n"})
public abstract class L2Regenerator {
    @NotNull
    private final L2Generator targetGenerator;
    private final boolean generatePhis;
    @NotNull
    private final AbstractOperandTransformer operandInlineTransformer;
    @NotNull
    private final Map<L2BasicBlock, L2Generator.SpecialBlock> inverseSpecialBlockMap;
    @NotNull
    private final Set<L2BasicBlock> completedSourceBlocks;
    @NotNull
    private final ArrayDeque<L2PcOperand> edgeVisitQueue;
    @NotNull
    private final ArrayDeque<L2PcOperand> backEdgeVisitQueue;

    public L2Regenerator(@NotNull L2Generator targetGenerator, boolean generatePhis) {
        Intrinsics.checkNotNullParameter(targetGenerator, "targetGenerator");
        this.targetGenerator = targetGenerator;
        this.generatePhis = generatePhis;
        this.operandInlineTransformer = this.generatePhis ? (AbstractOperandTransformer)new OperandSemanticTransformer() : (AbstractOperandTransformer)new OperandRegisterTransformer();
        this.inverseSpecialBlockMap = new LinkedHashMap();
        this.completedSourceBlocks = new LinkedHashSet();
        this.edgeVisitQueue = new ArrayDeque();
        this.backEdgeVisitQueue = new ArrayDeque();
    }

    @NotNull
    public final L2Generator getTargetGenerator() {
        return this.targetGenerator;
    }

    @NotNull
    public final Map<L2BasicBlock, L2Generator.SpecialBlock> getInverseSpecialBlockMap() {
        return this.inverseSpecialBlockMap;
    }

    @NotNull
    public final <O extends L2Operand> O transformOperand(@NotNull O operand) {
        Intrinsics.checkNotNullParameter(operand, "operand");
        this.operandInlineTransformer.setCurrentOperand(operand);
        operand.dispatchOperand(this.operandInlineTransformer);
        L2Operand l2Operand = this.operandInlineTransformer.getCurrentOperand();
        Intrinsics.checkNotNull(l2Operand);
        L2Operand $this$cast$iv = l2Operand;
        boolean $i$f$cast = false;
        return (O)((L2Operand)((Object)$this$cast$iv));
    }

    public final void processSourceGraphStartingAt(@NotNull L2Instruction startingInstruction) {
        Object object;
        boolean bl;
        Intrinsics.checkNotNullParameter(startingInstruction, "startingInstruction");
        boolean bl2 = this.edgeVisitQueue.isEmpty();
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        bl2 = this.backEdgeVisitQueue.isEmpty();
        if (_Assertions.ENABLED && !bl2) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        bl2 = this.targetGenerator.currentlyReachable();
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-L2Regenerator$processSourceGraphStartingAt$22 = false;
            String $i$a$-assert-L2Regenerator$processSourceGraphStartingAt$22 = "Caller should have set up starting block, or other starting state";
            throw new AssertionError((Object)$i$a$-assert-L2Regenerator$processSourceGraphStartingAt$22);
        }
        L2BasicBlock startBlock = startingInstruction.basicBlock();
        int startIndex = startBlock.instructions().indexOf(startingInstruction);
        boolean bl3 = bl = startIndex >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        int n = startBlock.instructions().size();
        for (int i2 = startIndex; i2 < n; ++i2) {
            this.processInstruction(startBlock.instructions().get(i2));
        }
        this.completedSourceBlocks.add(startBlock);
        while (!((Collection)this.edgeVisitQueue).isEmpty()) {
            boolean bl4;
            L2BasicBlock block;
            block14: {
                block = this.edgeVisitQueue.remove().targetBlock();
                if (this.completedSourceBlocks.contains(block)) continue;
                Iterable $this$any$iv = block.predecessorEdges();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl4 = false;
                } else {
                    object = $this$any$iv.iterator();
                    while (object.hasNext()) {
                        Object element$iv = object.next();
                        L2PcOperand it = (L2PcOperand)element$iv;
                        boolean bl5 = false;
                        boolean bl6 = !it.isBackward() && !this.completedSourceBlocks.contains(it.sourceBlock());
                        if (!bl6) continue;
                        bl4 = true;
                        break block14;
                    }
                    bl4 = false;
                }
            }
            if (bl4) continue;
            this.targetGenerator.startBlock(this.operandInlineTransformer.mapBlock(block), this.generatePhis, this);
            for (L2Instruction instruction2 : block.instructions()) {
                if (!this.targetGenerator.currentlyReachable()) {
                    Iterable $this$forEach$iv = block.successorEdges();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        L2PcOperand p0 = (L2PcOperand)element$iv;
                        boolean bl7 = false;
                        this.transformOperand((L2Operand)p0);
                    }
                    break;
                }
                this.processInstruction(instruction2);
            }
            this.completedSourceBlocks.add(block);
        }
        while (!((Collection)this.backEdgeVisitQueue).isEmpty()) {
            L2PcOperand backEdge = this.backEdgeVisitQueue.remove();
            L2BasicBlock block = backEdge.targetBlock();
            boolean bl8 = this.completedSourceBlocks.contains(block);
            if (_Assertions.ENABLED && !bl8) {
                object = "Assertion failed";
                throw new AssertionError(object);
            }
            Intrinsics.checkNotNull(backEdge);
            block.addPredecessorEdge(backEdge);
        }
    }

    public void processInstruction(@NotNull L2Instruction sourceInstruction) {
        Intrinsics.checkNotNullParameter(sourceInstruction, "sourceInstruction");
        this.basicProcessInstruction(sourceInstruction);
    }

    public final void basicProcessInstruction(@NotNull L2Instruction sourceInstruction) {
        boolean bl;
        Intrinsics.checkNotNullParameter(sourceInstruction, "sourceInstruction");
        boolean bl2 = bl = !sourceInstruction.getOperation().isPhi();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        sourceInstruction.transformAndEmitOn(this);
    }

    public final void emitInstruction(@NotNull L2Operation operation, L2Operand ... operands) {
        Intrinsics.checkNotNullParameter(operation, "operation");
        Intrinsics.checkNotNullParameter(operands, "operands");
        this.targetGenerator.addInstruction(operation, Arrays.copyOf(operands, operands.length));
    }

    public final void forcePostponedTranslationNow(@NotNull L2Instruction sourceInstruction) {
        Intrinsics.checkNotNullParameter(sourceInstruction, "sourceInstruction");
        L2ValueManifest manifest2 = this.targetGenerator.getCurrentManifest();
        for (L2ReadOperand<?> read2 : sourceInstruction.getReadOperands()) {
            L2SemanticValue semanticValue = read2.semanticValue();
            if (!manifest2.getPostponedInstructions().containsKey(semanticValue)) continue;
            this.forcePostponedTranslationNow(manifest2.removePostponedSourceInstruction(semanticValue));
        }
        this.basicProcessInstruction(sourceInstruction);
    }

    public final void forceAllPostponedTranslationsExceptConstantMoves() {
        block0: while (true) {
            Map.Entry<L2SemanticValue, List<L2Instruction>> element$iv;
            Set postponedSet = new LinkedHashSet();
            Object $this$forEach$iv = this.targetGenerator.getCurrentManifest().getPostponedInstructions();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<L2SemanticValue, List<L2Instruction>>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<L2SemanticValue, List<L2Instruction>> entry = element$iv = iterator2.next();
                boolean bl = false;
                List<L2Instruction> instructions2 = entry.getValue();
                L2Instruction instruction2 = CollectionsKt.last(instructions2);
                if (instruction2.getOperation() instanceof L2_MOVE_CONSTANT) continue;
                postponedSet.add(instruction2);
            }
            if (postponedSet.isEmpty()) {
                return;
            }
            $this$forEach$iv = postponedSet;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block0;
                element$iv = iterator2.next();
                L2Instruction sourceInstruction = (L2Instruction)((Object)element$iv);
                boolean bl = false;
                L2WriteOperand<?> someWrite = sourceInstruction.getWriteOperands().get(0);
                L2SemanticValue sv2 = someWrite.pickSemanticValue();
                L2ValueManifest manifest2 = this.targetGenerator.getCurrentManifest();
                List<L2Instruction> list2 = manifest2.getPostponedInstructions().get(sv2);
                boolean bl2 = list2 != null ? !((Collection)list2).isEmpty() : false;
                if (!bl2) continue;
                this.forcePostponedTranslationNow(manifest2.removePostponedSourceInstruction(sv2));
            }
            break;
        }
    }

    public final void forcePostponedTranslationBeforeEdge(@NotNull L2PcOperand edge2, @NotNull L2SemanticValue semanticValue) {
        Intrinsics.checkNotNullParameter(edge2, "edge");
        Intrinsics.checkNotNullParameter(semanticValue, "semanticValue");
        this.targetGenerator.generateRetroactivelyBeforeEdge(edge2, (Function1<? super L2Generator, Unit>)new Function1<L2Generator, Unit>(this, semanticValue){
            final /* synthetic */ L2Regenerator this$0;
            final /* synthetic */ L2SemanticValue $semanticValue;
            {
                this.this$0 = $receiver;
                this.$semanticValue = $semanticValue;
                super(1);
            }

            public final void invoke(@NotNull L2Generator $this$generateRetroactivelyBeforeEdge) {
                Intrinsics.checkNotNullParameter($this$generateRetroactivelyBeforeEdge, "$this$generateRetroactivelyBeforeEdge");
                this.this$0.forcePostponedTranslationNow(this.this$0.getTargetGenerator().getCurrentManifest().removePostponedSourceInstruction(this.$semanticValue));
            }
        });
    }

    public final int nextUnique() {
        return this.targetGenerator.nextUnique();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a6\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0010H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0013H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0014H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0015H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0016H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0017H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0018H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0019H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lavail/optimizer/reoptimizer/L2Regenerator$AbstractOperandTransformer;", "Lavail/interpreter/levelTwo/L2OperandDispatcher;", "(Lavail/optimizer/reoptimizer/L2Regenerator;)V", "blockMap", "", "Lavail/optimizer/L2BasicBlock;", "currentOperand", "Lavail/interpreter/levelTwo/operand/L2Operand;", "getCurrentOperand", "()Lavail/interpreter/levelTwo/operand/L2Operand;", "setCurrentOperand", "(Lavail/interpreter/levelTwo/operand/L2Operand;)V", "doOperand", "", "operand", "Lavail/interpreter/levelTwo/operand/L2ArbitraryConstantOperand;", "Lavail/interpreter/levelTwo/operand/L2CommentOperand;", "Lavail/interpreter/levelTwo/operand/L2ConstantOperand;", "Lavail/interpreter/levelTwo/operand/L2FloatImmediateOperand;", "Lavail/interpreter/levelTwo/operand/L2IntImmediateOperand;", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "Lavail/interpreter/levelTwo/operand/L2PcVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2PrimitiveOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadFloatVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadIntVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2SelectorOperand;", "mapBlock", "block", "mapSemanticValue", "Lavail/optimizer/values/L2SemanticValue;", "oldSemanticValue", "avail"})
    @SourceDebugExtension(value={"SMAP\nL2Regenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 L2Regenerator.kt\navail/optimizer/reoptimizer/L2Regenerator$AbstractOperandTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,703:1\n1855#2,2:704\n1549#2:706\n1620#2,3:707\n1549#2:710\n1620#2,3:711\n1549#2:714\n1620#2,3:715\n1549#2:718\n1620#2,3:719\n*S KotlinDebug\n*F\n+ 1 L2Regenerator.kt\navail/optimizer/reoptimizer/L2Regenerator$AbstractOperandTransformer\n*L\n202#1:704,2\n229#1:706\n229#1:707,3\n236#1:710\n236#1:711,3\n243#1:714\n243#1:715,3\n251#1:718\n251#1:719,3\n*E\n"})
    public abstract class AbstractOperandTransformer
    implements L2OperandDispatcher {
        @Nullable
        private L2Operand currentOperand;
        @NotNull
        private final Map<L2BasicBlock, L2BasicBlock> blockMap = new LinkedHashMap();

        @Nullable
        public final L2Operand getCurrentOperand() {
            return this.currentOperand;
        }

        public final void setCurrentOperand(@Nullable L2Operand l2Operand) {
            this.currentOperand = l2Operand;
        }

        @NotNull
        public L2BasicBlock mapBlock(@NotNull L2BasicBlock block) {
            Intrinsics.checkNotNullParameter(block, "block");
            L2BasicBlock l2BasicBlock = this.blockMap.computeIfAbsent(block, arg_0 -> AbstractOperandTransformer.mapBlock$lambda$0(new Function1<L2BasicBlock, L2BasicBlock>(L2Regenerator.this){
                final /* synthetic */ L2Regenerator this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final L2BasicBlock invoke(@NotNull L2BasicBlock oldBlock) {
                    L2BasicBlock newBlock;
                    block1: {
                        Intrinsics.checkNotNullParameter(oldBlock, "oldBlock");
                        newBlock = new L2BasicBlock(oldBlock.name(), oldBlock.isLoopHead(), oldBlock.getZone());
                        if (oldBlock.isIrremovable()) {
                            newBlock.makeIrremovable();
                        }
                        L2Generator.SpecialBlock specialBlock = this.this$0.getInverseSpecialBlockMap().get(oldBlock);
                        if (specialBlock == null) break block1;
                        L2Generator.SpecialBlock specialBlock2 = specialBlock;
                        L2Regenerator l2Regenerator = this.this$0;
                        L2Generator.SpecialBlock special = specialBlock2;
                        boolean bl = false;
                        l2Regenerator.getTargetGenerator().getSpecialBlocks().set((L2Generator.SpecialBlock)((Enum)special), newBlock);
                    }
                    return newBlock;
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue(l2BasicBlock, "computeIfAbsent(...)");
            return l2BasicBlock;
        }

        @NotNull
        public L2SemanticValue mapSemanticValue(@NotNull L2SemanticValue oldSemanticValue) {
            Intrinsics.checkNotNullParameter(oldSemanticValue, "oldSemanticValue");
            return oldSemanticValue;
        }

        @Override
        public void doOperand(@NotNull L2ArbitraryConstantOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2CommentOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2ConstantOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2IntImmediateOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2FloatImmediateOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2PcOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            if (operand.isBackward()) {
                L2Regenerator.this.backEdgeVisitQueue.add(operand);
            } else {
                L2Regenerator.this.edgeVisitQueue.add(operand);
            }
            L2PcOperand edge2 = new L2PcOperand(this.mapBlock(operand.targetBlock()), operand.isBackward(), L2Regenerator.this.getTargetGenerator().getCurrentManifest(), operand.getOptionalName());
            Set<L2EntityAndKind> set2 = operand.getForcedClampedEntities();
            if (set2 != null) {
                Set<L2EntityAndKind> set3 = set2;
                L2Regenerator l2Regenerator = L2Regenerator.this;
                Set<L2EntityAndKind> oldClamped = set3;
                boolean bl = false;
                L2ValueManifest manifest2 = l2Regenerator.getTargetGenerator().getCurrentManifest();
                Set newClamped = new LinkedHashSet();
                Iterable $this$forEach$iv = oldClamped;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    L2EntityAndKind entityAndKind = (L2EntityAndKind)element$iv;
                    boolean bl2 = false;
                    L2Entity entity = entityAndKind.component1();
                    L2Register.RegisterKind kind2 = entityAndKind.component2();
                    if (!(entity instanceof L2SemanticValue)) continue;
                    newClamped.add(entityAndKind);
                    newClamped.add(new L2EntityAndKind((L2Entity)manifest2.getDefinition((L2SemanticValue)entity, kind2), kind2));
                }
                edge2.setForcedClampedEntities(newClamped);
            }
            this.currentOperand = edge2;
        }

        @Override
        public void doOperand(@NotNull L2PrimitiveOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doOperand(@NotNull L2ReadBoxedVectorOperand operand) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(operand, "operand");
            Iterable iterable = operand.getElements();
            L2Regenerator l2Regenerator = L2Regenerator.this;
            AbstractOperandTransformer abstractOperandTransformer = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                L2ReadBoxedOperand l2ReadBoxedOperand = (L2ReadBoxedOperand)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add((L2ReadBoxedOperand)l2Regenerator.transformOperand((L2Operand)p0));
            }
            List list2 = (List)destination$iv$iv;
            abstractOperandTransformer.currentOperand = new L2ReadBoxedVectorOperand(list2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doOperand(@NotNull L2ReadIntVectorOperand operand) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(operand, "operand");
            Iterable iterable = operand.getElements();
            L2Regenerator l2Regenerator = L2Regenerator.this;
            AbstractOperandTransformer abstractOperandTransformer = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                L2ReadIntOperand l2ReadIntOperand = (L2ReadIntOperand)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add((L2ReadIntOperand)l2Regenerator.transformOperand((L2Operand)p0));
            }
            List list2 = (List)destination$iv$iv;
            abstractOperandTransformer.currentOperand = new L2ReadIntVectorOperand(list2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doOperand(@NotNull L2ReadFloatVectorOperand operand) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(operand, "operand");
            Iterable iterable = operand.getElements();
            L2Regenerator l2Regenerator = L2Regenerator.this;
            AbstractOperandTransformer abstractOperandTransformer = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                L2ReadFloatOperand l2ReadFloatOperand = (L2ReadFloatOperand)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add((L2ReadFloatOperand)l2Regenerator.transformOperand((L2Operand)p0));
            }
            List list2 = (List)destination$iv$iv;
            abstractOperandTransformer.currentOperand = new L2ReadFloatVectorOperand(list2);
        }

        @Override
        public void doOperand(@NotNull L2SelectorOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doOperand(@NotNull L2PcVectorOperand operand) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(operand, "operand");
            Iterable iterable = operand.getEdges();
            L2Regenerator l2Regenerator = L2Regenerator.this;
            AbstractOperandTransformer abstractOperandTransformer = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                L2PcOperand l2PcOperand = (L2PcOperand)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add((L2PcOperand)l2Regenerator.transformOperand((L2Operand)p0));
            }
            List list2 = (List)destination$iv$iv;
            abstractOperandTransformer.currentOperand = new L2PcVectorOperand(list2);
        }

        private static final L2BasicBlock mapBlock$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (L2BasicBlock)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\rH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lavail/optimizer/reoptimizer/L2Regenerator$OperandRegisterTransformer;", "Lavail/optimizer/reoptimizer/L2Regenerator$AbstractOperandTransformer;", "Lavail/optimizer/reoptimizer/L2Regenerator;", "(Lavail/optimizer/reoptimizer/L2Regenerator;)V", "registerMap", "", "Lavail/interpreter/levelTwo/register/L2Register;", "doOperand", "", "operand", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadFloatOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadIntOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteBoxedOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteFloatOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteIntOperand;", "avail"})
    @SourceDebugExtension(value={"SMAP\nL2Regenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 L2Regenerator.kt\navail/optimizer/reoptimizer/L2Regenerator$OperandRegisterTransformer\n+ 2 Casts.kt\navail/utility/CastsKt\n*L\n1#1,703:1\n46#2:704\n46#2:705\n*S KotlinDebug\n*F\n+ 1 L2Regenerator.kt\navail/optimizer/reoptimizer/L2Regenerator$OperandRegisterTransformer\n*L\n369#1:704\n382#1:705\n*E\n"})
    public final class OperandRegisterTransformer
    extends AbstractOperandTransformer {
        @NotNull
        private final Map<L2Register, L2Register> registerMap = new LinkedHashMap();

        @Override
        public void doOperand(@NotNull L2ReadIntOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            L2SemanticValue l2SemanticValue = operand.semanticValue();
            TypeRestriction typeRestriction = L2Regenerator.this.getTargetGenerator().getCurrentManifest().restrictionFor(operand.semanticValue());
            L2Register l2Register = this.registerMap.get(operand.register());
            Intrinsics.checkNotNull(l2Register, "null cannot be cast to non-null type avail.interpreter.levelTwo.register.L2IntRegister");
            this.setCurrentOperand(new L2ReadIntOperand(l2SemanticValue, typeRestriction, (L2IntRegister)l2Register));
        }

        @Override
        public void doOperand(@NotNull L2ReadFloatOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            L2SemanticValue l2SemanticValue = operand.semanticValue();
            TypeRestriction typeRestriction = L2Regenerator.this.getTargetGenerator().getCurrentManifest().restrictionFor(operand.semanticValue());
            L2Register l2Register = this.registerMap.get(operand.register());
            Intrinsics.checkNotNull(l2Register, "null cannot be cast to non-null type avail.interpreter.levelTwo.register.L2FloatRegister");
            this.setCurrentOperand(new L2ReadFloatOperand(l2SemanticValue, typeRestriction, (L2FloatRegister)l2Register));
        }

        @Override
        public void doOperand(@NotNull L2ReadBoxedOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            L2SemanticValue l2SemanticValue = operand.semanticValue();
            TypeRestriction typeRestriction = L2Regenerator.this.getTargetGenerator().getCurrentManifest().restrictionFor(operand.semanticValue());
            L2Register l2Register = this.registerMap.get(operand.register());
            Intrinsics.checkNotNull(l2Register, "null cannot be cast to non-null type avail.interpreter.levelTwo.register.L2BoxedRegister");
            this.setCurrentOperand(new L2ReadBoxedOperand(l2SemanticValue, typeRestriction, (L2BoxedRegister)l2Register));
        }

        @Override
        public void doOperand(@NotNull L2WriteIntOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            L2Register l2Register = this.registerMap.computeIfAbsent((L2Register)operand.register(), (Function<L2Register, L2Register>)((Function<Object, L2Register>)arg_0 -> OperandRegisterTransformer.doOperand$lambda$0(new Function1<L2Register, L2Register>(L2Regenerator.this){
                final /* synthetic */ L2Regenerator this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final L2Register invoke(@NotNull L2Register it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    int unique = this.this$0.getTargetGenerator().nextUnique();
                    return new L2IntRegister(unique);
                }
            }, arg_0)));
            Intrinsics.checkNotNullExpressionValue(l2Register, "computeIfAbsent(...)");
            L2Register newRegister2 = l2Register;
            Set<L2SemanticValue> $this$cast$iv = operand.semanticValues();
            boolean $i$f$cast = false;
            this.setCurrentOperand(new L2WriteIntOperand((Set)((Object)$this$cast$iv), operand.restriction().restrictingKindsTo(TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG.getMask()), (L2IntRegister)newRegister2));
        }

        @Override
        public void doOperand(@NotNull L2WriteFloatOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            L2Register l2Register = this.registerMap.computeIfAbsent((L2Register)operand.register(), (Function<L2Register, L2Register>)((Function<Object, L2Register>)arg_0 -> OperandRegisterTransformer.doOperand$lambda$1(new Function1<L2Register, L2Register>(L2Regenerator.this){
                final /* synthetic */ L2Regenerator this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final L2Register invoke(@NotNull L2Register it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    int unique = this.this$0.getTargetGenerator().nextUnique();
                    return new L2FloatRegister(unique);
                }
            }, arg_0)));
            Intrinsics.checkNotNullExpressionValue(l2Register, "computeIfAbsent(...)");
            L2Register newRegister2 = l2Register;
            Set<L2SemanticValue> $this$cast$iv = operand.semanticValues();
            boolean $i$f$cast = false;
            this.setCurrentOperand(new L2WriteFloatOperand((Set)((Object)$this$cast$iv), operand.restriction().restrictingKindsTo(TypeRestriction.RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG.getMask()), (L2FloatRegister)newRegister2));
        }

        @Override
        public void doOperand(@NotNull L2WriteBoxedOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            L2Register l2Register = this.registerMap.computeIfAbsent((L2Register)operand.register(), (Function<L2Register, L2Register>)((Function<Object, L2Register>)arg_0 -> OperandRegisterTransformer.doOperand$lambda$2(new Function1<L2Register, L2Register>(L2Regenerator.this){
                final /* synthetic */ L2Regenerator this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final L2Register invoke(@NotNull L2Register it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    int unique = this.this$0.getTargetGenerator().nextUnique();
                    return new L2BoxedRegister(unique);
                }
            }, arg_0)));
            Intrinsics.checkNotNullExpressionValue(l2Register, "computeIfAbsent(...)");
            L2Register newRegister2 = l2Register;
            this.setCurrentOperand(new L2WriteBoxedOperand(operand.semanticValues(), operand.restriction().restrictingKindsTo(TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG.getMask()), (L2BoxedRegister)newRegister2));
        }

        private static final L2Register doOperand$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (L2Register)$tmp0.invoke(p0);
        }

        private static final L2Register doOperand$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (L2Register)$tmp0.invoke(p0);
        }

        private static final L2Register doOperand$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (L2Register)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\bH\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lavail/optimizer/reoptimizer/L2Regenerator$OperandSemanticTransformer;", "Lavail/optimizer/reoptimizer/L2Regenerator$AbstractOperandTransformer;", "Lavail/optimizer/reoptimizer/L2Regenerator;", "(Lavail/optimizer/reoptimizer/L2Regenerator;)V", "doOperand", "", "operand", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadFloatOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadIntOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteBoxedOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteFloatOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteIntOperand;", "avail"})
    @SourceDebugExtension(value={"SMAP\nL2Regenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 L2Regenerator.kt\navail/optimizer/reoptimizer/L2Regenerator$OperandSemanticTransformer\n+ 2 CollectionExtensions.kt\navail/utility/CollectionExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,703:1\n79#2,4:704\n79#2,4:711\n79#2,4:718\n1620#3,3:708\n1620#3,3:715\n1620#3,3:722\n*S KotlinDebug\n*F\n+ 1 L2Regenerator.kt\navail/optimizer/reoptimizer/L2Regenerator$OperandSemanticTransformer\n*L\n293#1:704,4\n303#1:711,4\n314#1:718,4\n293#1:708,3\n303#1:715,3\n314#1:722,3\n*E\n"})
    public final class OperandSemanticTransformer
    extends AbstractOperandTransformer {
        @Override
        public void doOperand(@NotNull L2ReadIntOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            this.setCurrentOperand(new L2ReadIntOperand(this.mapSemanticValue(operand.semanticValue()), L2Regenerator.this.getTargetGenerator().getCurrentManifest().restrictionFor(operand.semanticValue()), L2Regenerator.this.getTargetGenerator().getCurrentManifest()));
        }

        @Override
        public void doOperand(@NotNull L2ReadFloatOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            this.setCurrentOperand(new L2ReadFloatOperand(this.mapSemanticValue(operand.semanticValue()), L2Regenerator.this.getTargetGenerator().getCurrentManifest().restrictionFor(operand.semanticValue()), L2Regenerator.this.getTargetGenerator().getCurrentManifest()));
        }

        @Override
        public void doOperand(@NotNull L2ReadBoxedOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            this.setCurrentOperand(new L2ReadBoxedOperand(this.mapSemanticValue(operand.semanticValue()), L2Regenerator.this.getTargetGenerator().getCurrentManifest().restrictionFor(operand.semanticValue()), L2Regenerator.this.getTargetGenerator().getCurrentManifest()));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doOperand(@NotNull L2WriteIntOperand operand) {
            void $this$mapToSet_u24default$iv;
            Intrinsics.checkNotNullParameter(operand, "operand");
            Iterable iterable = operand.semanticValues();
            OperandSemanticTransformer operandSemanticTransformer = this;
            Set destination$iv = new LinkedHashSet();
            boolean $i$f$mapToSet = false;
            void $this$mapTo$iv$iv = $this$mapToSet_u24default$iv;
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                L2SemanticValue l2SemanticValue = (L2SemanticValue)item$iv$iv;
                Collection collection2 = destination$iv;
                boolean bl = false;
                L2SemanticValue l2SemanticValue2 = this.mapSemanticValue((L2SemanticValue)it);
                Intrinsics.checkNotNull(l2SemanticValue2, "null cannot be cast to non-null type avail.optimizer.values.L2SemanticUnboxedInt");
                collection2.add((L2SemanticUnboxedInt)l2SemanticValue2);
            }
            L2IntRegister l2IntRegister = new L2IntRegister(L2Regenerator.this.getTargetGenerator().nextUnique());
            TypeRestriction typeRestriction = operand.restriction().restrictingKindsTo(TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG.getMask());
            Set set2 = (Set)((Collection)destination$iv);
            operandSemanticTransformer.setCurrentOperand(new L2WriteIntOperand(set2, typeRestriction, l2IntRegister));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doOperand(@NotNull L2WriteFloatOperand operand) {
            void $this$mapToSet_u24default$iv;
            Intrinsics.checkNotNullParameter(operand, "operand");
            Iterable iterable = operand.semanticValues();
            OperandSemanticTransformer operandSemanticTransformer = this;
            Set destination$iv = new LinkedHashSet();
            boolean $i$f$mapToSet = false;
            void $this$mapTo$iv$iv = $this$mapToSet_u24default$iv;
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                L2SemanticValue l2SemanticValue = (L2SemanticValue)item$iv$iv;
                Collection collection2 = destination$iv;
                boolean bl = false;
                L2SemanticValue l2SemanticValue2 = this.mapSemanticValue((L2SemanticValue)it);
                Intrinsics.checkNotNull(l2SemanticValue2, "null cannot be cast to non-null type avail.optimizer.values.L2SemanticUnboxedFloat");
                collection2.add((L2SemanticUnboxedFloat)l2SemanticValue2);
            }
            L2FloatRegister l2FloatRegister = new L2FloatRegister(L2Regenerator.this.getTargetGenerator().nextUnique());
            TypeRestriction typeRestriction = operand.restriction().restrictingKindsTo(TypeRestriction.RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG.getMask());
            Set set2 = (Set)((Collection)destination$iv);
            operandSemanticTransformer.setCurrentOperand(new L2WriteFloatOperand(set2, typeRestriction, l2FloatRegister));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doOperand(@NotNull L2WriteBoxedOperand operand) {
            void $this$mapToSet_u24default$iv;
            Intrinsics.checkNotNullParameter(operand, "operand");
            Iterable iterable = operand.semanticValues();
            OperandSemanticTransformer operandSemanticTransformer = this;
            Set destination$iv = new LinkedHashSet();
            boolean $i$f$mapToSet = false;
            void $this$mapTo$iv$iv = $this$mapToSet_u24default$iv;
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                L2SemanticValue l2SemanticValue = (L2SemanticValue)item$iv$iv;
                Collection collection2 = destination$iv;
                boolean bl = false;
                collection2.add(this.mapSemanticValue((L2SemanticValue)it));
            }
            L2BoxedRegister l2BoxedRegister = new L2BoxedRegister(L2Regenerator.this.getTargetGenerator().nextUnique());
            TypeRestriction typeRestriction = operand.restriction().restrictingKindsTo(TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG.getMask());
            Set set2 = (Set)((Collection)destination$iv);
            operandSemanticTransformer.setCurrentOperand(new L2WriteBoxedOperand((Set<? extends L2SemanticValue>)set2, typeRestriction, l2BoxedRegister));
        }
    }
}

