/*
 * Decompiled with CFR 0.152.
 */
package avail.resolver;

import avail.builder.ModuleRootErrorCode;
import avail.error.ErrorCode;
import avail.error.StandardErrorCode;
import avail.files.AvailFile;
import avail.files.FileErrorCode;
import avail.files.FileManager;
import avail.io.IOSystem;
import avail.io.SimpleCompletionHandler;
import avail.resolver.FileSystemModuleRootResolver;
import avail.resolver.ModuleRootResolver;
import avail.resolver.ResolverReference;
import avail.utility.DirectoryWatcherExtensionsKt;
import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryWatcher;
import io.methvin.watcher.hashing.FileHasher;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.availlang.artifact.ResourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.helpers.NOPLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 B2\u00020\u0001:\u0002BCB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J:\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00100\u0016H\u0016JB\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00100\u0016H\u0016J:\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00100\u0016H\u0016J:\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00100\u0016H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002JP\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$2\u001a\u0010%\u001a\u0016\u0012\u0004\u0012\u00020&\u0012\u0006\u0012\u0004\u0018\u00010'\u0012\u0004\u0012\u00020\u00100\u00162\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00100\u0016H\u0016J@\u0010(\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00100*2\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00100\u0016H\u0016JF\u0010,\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0018\u0010)\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00100\u00162\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00100\u0016H\u0016J8\u0010-\u001a\u00020\u00102\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00100*2\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00100\u0016H\u0016J \u0010.\u001a\u00020$2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0012\u001a\u00020\u00032\b\u00101\u001a\u0004\u0018\u00010\u001eJ\b\u00102\u001a\u00020\nH\u0016JF\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u00020\n2\u0018\u00105\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020$06\u0012\u0004\u0012\u00020\u00100*2\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00100\u0016H\u0016J<\u00107\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020+2\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00100\u0016H\u0002JB\u0010<\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010=\u001a\u00020&2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00100\u0016H\u0016J\u0010\u0010>\u001a\u00020\n2\u0006\u0010/\u001a\u000200H\u0002J\u000e\u0010?\u001a\b\u0012\u0004\u0012\u0002000@H\u0002J\b\u0010A\u001a\u00020\u0003H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lavail/resolver/FileSystemModuleRootResolver;", "Lavail/resolver/ModuleRootResolver;", "name", "", "uri", "Ljava/net/URI;", "fileManager", "Lavail/files/FileManager;", "(Ljava/lang/String;Ljava/net/URI;Lavail/files/FileManager;)V", "canSave", "", "getCanSave", "()Z", "fileSystemWatcher", "Lavail/resolver/FileSystemModuleRootResolver$FileSystemWatcher;", "close", "", "createDirectory", "qualifiedName", "completion", "Lkotlin/Function0;", "failureHandler", "Lkotlin/Function2;", "Lavail/error/ErrorCode;", "", "createFile", "mimeType", "createPackage", "deleteResource", "determineResourceType", "Lorg/availlang/artifact/ResourceType;", "file", "Ljava/io/File;", "readFile", "bypassFileManager", "reference", "Lavail/resolver/ResolverReference;", "withContents", "", "Ljava/util/UUID;", "refreshResolverMetaData", "successHandler", "Lkotlin/Function1;", "", "refreshResolverReferenceDigest", "resolve", "resolverReference", "path", "Ljava/nio/file/Path;", "type", "resolvesToValidModuleRoot", "rootManifest", "forceRefresh", "withList", "", "save", "Ljava/nio/channels/AsynchronousFileChannel;", "data", "Ljava/nio/ByteBuffer;", "writePosition", "saveFile", "fileContents", "shouldIgnorePath", "sourceModuleVisitor", "Ljava/nio/file/FileVisitor;", "toString", "Companion", "FileSystemWatcher", "avail"})
public final class FileSystemModuleRootResolver
extends ModuleRootResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystemWatcher fileSystemWatcher;

    public FileSystemModuleRootResolver(@NotNull String name, @NotNull URI uri, @NotNull FileManager fileManager) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(uri, "uri");
        Intrinsics.checkNotNullParameter(fileManager, "fileManager");
        super(name, uri, fileManager);
        this.fileSystemWatcher = new FileSystemWatcher();
    }

    @Override
    public boolean getCanSave() {
        return true;
    }

    @Override
    public void close() {
        this.fileSystemWatcher.close();
    }

    @Override
    public boolean resolvesToValidModuleRoot() {
        return new File(this.getUri()).isDirectory();
    }

    @Override
    public void resolve(@NotNull Function1<? super ResolverReference, Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(successHandler, "successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        this.executeTask(new Function0<Unit>(this, successHandler, failureHandler){
            final /* synthetic */ FileSystemModuleRootResolver this$0;
            final /* synthetic */ Function1<ResolverReference, Unit> $successHandler;
            final /* synthetic */ Function2<ErrorCode, Throwable, Unit> $failureHandler;
            {
                this.this$0 = $receiver;
                this.$successHandler = $successHandler;
                this.$failureHandler = $failureHandler;
                super(0);
            }

            public final void invoke() {
                File directory = Paths.get(this.this$0.getUri()).toFile();
                if (directory.isDirectory()) {
                    try {
                        Files.walkFileTree(Paths.get(directory.getAbsolutePath(), new String[0]), (Set<FileVisitOption>)EnumSet.of((Enum)FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, FileSystemModuleRootResolver.access$sourceModuleVisitor(this.this$0));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ResolverReference tree = this.this$0.getModuleRootTree$avail();
                    if (tree != null) {
                        this.$successHandler.invoke(tree);
                        return;
                    }
                }
                this.$failureHandler.invoke(ModuleRootErrorCode.MODULE_ROOT_RESOLUTION_FAILED, null);
            }
        });
    }

    @Override
    public void rootManifest(boolean forceRefresh, @NotNull Function1<? super List<ResolverReference>, Unit> withList, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(withList, "withList");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        if (!this.getReferenceMap().isEmpty() && !forceRefresh) {
            withList.invoke(CollectionsKt.toList((Iterable)this.getReferenceMap().values()));
            return;
        }
        this.executeTask(new Function0<Unit>(this, failureHandler, withList){
            final /* synthetic */ FileSystemModuleRootResolver this$0;
            final /* synthetic */ Function2<ErrorCode, Throwable, Unit> $failureHandler;
            final /* synthetic */ Function1<List<ResolverReference>, Unit> $withList;
            {
                this.this$0 = $receiver;
                this.$failureHandler = $failureHandler;
                this.$withList = $withList;
                super(0);
            }

            public final void invoke() {
                this.this$0.resolve((Function1<? super ResolverReference, Unit>)new Function1<ResolverReference, Unit>(this.$withList, this.this$0){
                    final /* synthetic */ Function1<List<ResolverReference>, Unit> $withList;
                    final /* synthetic */ FileSystemModuleRootResolver this$0;
                    {
                        this.$withList = $withList;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ResolverReference it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        this.$withList.invoke(CollectionsKt.toList((Iterable)this.this$0.getReferenceMap().values()));
                    }
                }, this.$failureHandler);
            }
        });
    }

    @NotNull
    public final ResolverReference resolverReference(@NotNull Path path, @NotNull String qualifiedName2, @Nullable ResourceType type2) {
        String string2;
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        File file2 = path.toFile();
        if (!file2.exists()) {
            Intrinsics.checkNotNull(file2);
            throw new NoSuchFileException(file2, null, path + " not found", 2, null);
        }
        ResourceType resourceType = type2;
        if (resourceType == null) {
            Intrinsics.checkNotNull(file2);
            resourceType = this.determineResourceType(file2);
        }
        ResourceType resourceType2 = resourceType;
        boolean isPackage = file2.isDirectory();
        long lastModified = file2.lastModified();
        long size = isPackage ? 0L : file2.length();
        if (isPackage) {
            string2 = "";
        } else {
            Intrinsics.checkNotNull(file2);
            string2 = Intrinsics.areEqual(FilesKt.getExtension(file2), "avail") ? "text/plain" : AvailFile.Companion.mimeType(path);
        }
        String mimeType = string2;
        String qname = StringsKt.replace$default(qualifiedName2, ".avail", "", false, 4, null);
        ModuleRootResolver moduleRootResolver = this;
        URI uRI = path.toUri();
        Intrinsics.checkNotNullExpressionValue(uRI, "toUri(...)");
        return new ResolverReference(moduleRootResolver, uRI, qname, resourceType2, mimeType, lastModified, size, null, null, 384, null);
    }

    private final ResourceType determineResourceType(File file2) {
        ResourceType resourceType;
        String fileName = file2.getAbsolutePath();
        Intrinsics.checkNotNull(fileName);
        boolean endsWithExtension = StringsKt.endsWith$default(fileName, ".avail", false, 2, null);
        boolean isDirectory = file2.isDirectory();
        if (!endsWithExtension && isDirectory) {
            resourceType = ResourceType.DIRECTORY;
        } else if (!endsWithExtension) {
            resourceType = ResourceType.RESOURCE;
        } else if (isDirectory) {
            resourceType = ResourceType.PACKAGE;
        } else {
            String localName2 = StringsKt.substringAfterLast$default(fileName, '/', null, 2, null);
            String parent = StringsKt.substringBeforeLast(fileName, '/', "");
            String parentLocal = StringsKt.substringAfterLast(parent, '/', "");
            resourceType = Intrinsics.areEqual(parentLocal, localName2) ? ResourceType.REPRESENTATIVE : ResourceType.MODULE;
        }
        return resourceType;
    }

    @Override
    public void refreshResolverMetaData(@NotNull ResolverReference reference, @NotNull Function1<? super Long, Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        Intrinsics.checkNotNullParameter(successHandler, "successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        this.executeTask(new Function0<Unit>(reference, successHandler, failureHandler){
            final /* synthetic */ ResolverReference $reference;
            final /* synthetic */ Function1<Long, Unit> $successHandler;
            final /* synthetic */ Function2<ErrorCode, Throwable, Unit> $failureHandler;
            {
                this.$reference = $reference;
                this.$successHandler = $successHandler;
                this.$failureHandler = $failureHandler;
                super(0);
            }

            public final void invoke() {
                try {
                    File file2 = Paths.get(this.$reference.getUri()).toFile();
                    long modified = file2.lastModified();
                    this.$reference.refresh(modified, file2.length());
                    this.$successHandler.invoke(modified);
                }
                catch (Throwable e) {
                    this.$failureHandler.invoke(StandardErrorCode.IO_EXCEPTION, new IOException("Could not refresh file metadata for " + this.$reference.getQualifiedName(), e));
                }
            }
        });
    }

    @Override
    public void refreshResolverReferenceDigest(@NotNull ResolverReference reference, @NotNull Function2<? super byte[], ? super Long, Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        Intrinsics.checkNotNullParameter(successHandler, "successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        try {
            File f = Paths.get(reference.getUri()).toFile();
            long initialModified = f.lastModified();
            this.readFile(false, reference, (Function2<? super byte[], ? super UUID, Unit>)new Function2<byte[], UUID, Unit>(f, initialModified, reference, successHandler){
                final /* synthetic */ File $f;
                final /* synthetic */ long $initialModified;
                final /* synthetic */ ResolverReference $reference;
                final /* synthetic */ Function2<byte[], Long, Unit> $successHandler;
                {
                    this.$f = $f;
                    this.$initialModified = $initialModified;
                    this.$reference = $reference;
                    this.$successHandler = $successHandler;
                    super(2);
                }

                public final void invoke(@NotNull byte[] bytes2, @Nullable UUID uUID) {
                    Intrinsics.checkNotNullParameter(bytes2, "bytes");
                    long modified = this.$f.lastModified();
                    if (modified != this.$initialModified) {
                        System.err.println("(" + this.$reference.getQualifiedName() + ") File changed during digest calculation: modified timestamp at file read start " + this.$initialModified + ", at finish " + modified);
                    }
                    MessageDigest hasher = MessageDigest.getInstance("SHA-256");
                    hasher.update(bytes2, 0, bytes2.length);
                    byte[] newDigest = hasher.digest();
                    this.$reference.refresh(modified, this.$f.length());
                    Intrinsics.checkNotNull(newDigest);
                    this.$successHandler.invoke(newDigest, modified);
                }
            }, failureHandler);
        }
        catch (NoSuchFileException e) {
            failureHandler.invoke(FileErrorCode.FILE_NOT_FOUND, e);
        }
        catch (SecurityException e) {
            failureHandler.invoke(FileErrorCode.PERMISSIONS, e);
        }
    }

    @Override
    public void createFile(@NotNull String qualifiedName2, @NotNull String mimeType, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        Intrinsics.checkNotNullParameter(mimeType, "mimeType");
        Intrinsics.checkNotNullParameter(completion, "completion");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    public void createPackage(@NotNull String qualifiedName2, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        Intrinsics.checkNotNullParameter(completion, "completion");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    public void createDirectory(@NotNull String qualifiedName2, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        Intrinsics.checkNotNullParameter(completion, "completion");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    public void deleteResource(@NotNull String qualifiedName2, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        Intrinsics.checkNotNullParameter(completion, "completion");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    private final void save(AsynchronousFileChannel file2, ByteBuffer data2, long writePosition, Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        file2.write(data2, writePosition, null, (CompletionHandler)new CompletionHandler<Integer, ErrorCode>(data2, this, file2, failureHandler){
            final /* synthetic */ ByteBuffer $data;
            final /* synthetic */ FileSystemModuleRootResolver this$0;
            final /* synthetic */ AsynchronousFileChannel $file;
            final /* synthetic */ Function2<ErrorCode, Throwable, Unit> $failureHandler;
            {
                this.$data = $data;
                this.this$0 = $receiver;
                this.$file = $file;
                this.$failureHandler = $failureHandler;
            }

            public void completed(@Nullable Integer result2, @Nullable ErrorCode attachment) {
                if (this.$data.hasRemaining()) {
                    FileSystemModuleRootResolver.access$save(this.this$0, this.$file, this.$data, this.$data.position(), this.$failureHandler);
                }
            }

            public void failed(@Nullable Throwable exc, @Nullable ErrorCode attachment) {
                ErrorCode errorCode = attachment;
                if (errorCode == null) {
                    errorCode = FileErrorCode.UNSPECIFIED;
                }
                this.$failureHandler.invoke(errorCode, exc);
            }
        });
    }

    @Override
    public void saveFile(@NotNull ResolverReference reference, @NotNull byte[] fileContents2, @NotNull Function0<Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        AsynchronousFileChannel asynchronousFileChannel;
        Intrinsics.checkNotNullParameter(reference, "reference");
        Intrinsics.checkNotNullParameter(fileContents2, "fileContents");
        Intrinsics.checkNotNullParameter(successHandler, "successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        ByteBuffer data2 = ByteBuffer.wrap(fileContents2);
        Path path = Path.of(reference.getUri());
        Path tempPath = path.getParent().resolve(FileSystemModuleRootResolver.Companion.tempFilePrefix() + path.getFileName());
        try {
            IOSystem iOSystem = this.getFileManager().getIoSystem();
            Intrinsics.checkNotNull(tempPath);
            EnumSet<Enum> enumSet = EnumSet.of((Enum)StandardOpenOption.CREATE, (Enum)StandardOpenOption.TRUNCATE_EXISTING, (Enum)StandardOpenOption.WRITE);
            Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
            asynchronousFileChannel = iOSystem.openFile(tempPath, (Set<? extends OpenOption>)enumSet, new FileAttribute[0]);
        }
        catch (IOException e) {
            failureHandler.invoke(StandardErrorCode.IO_EXCEPTION, e);
            return;
        }
        catch (IllegalArgumentException e) {
            failureHandler.invoke(StandardErrorCode.IO_EXCEPTION, e);
            return;
        }
        catch (UnsupportedOperationException e) {
            failureHandler.invoke(StandardErrorCode.IO_EXCEPTION, e);
            return;
        }
        catch (SecurityException e) {
            failureHandler.invoke(FileErrorCode.PERMISSIONS, e);
            return;
        }
        AsynchronousFileChannel tempFile = asynchronousFileChannel;
        tempFile.write(data2, 0L, null, (CompletionHandler)new CompletionHandler<Integer, ErrorCode>(data2, this, tempFile, failureHandler, path, tempPath, reference, fileContents2, successHandler){
            final /* synthetic */ ByteBuffer $data;
            final /* synthetic */ FileSystemModuleRootResolver this$0;
            final /* synthetic */ AsynchronousFileChannel $tempFile;
            final /* synthetic */ Function2<ErrorCode, Throwable, Unit> $failureHandler;
            final /* synthetic */ Path $path;
            final /* synthetic */ Path $tempPath;
            final /* synthetic */ ResolverReference $reference;
            final /* synthetic */ byte[] $fileContents;
            final /* synthetic */ Function0<Unit> $successHandler;
            {
                this.$data = $data;
                this.this$0 = $receiver;
                this.$tempFile = $tempFile;
                this.$failureHandler = $failureHandler;
                this.$path = $path;
                this.$tempPath = $tempPath;
                this.$reference = $reference;
                this.$fileContents = $fileContents;
                this.$successHandler = $successHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(@Nullable Integer result2, @Nullable ErrorCode attachment) {
                if (this.$data.hasRemaining()) {
                    ByteBuffer byteBuffer = this.$data;
                    Intrinsics.checkNotNullExpressionValue(byteBuffer, "$data");
                    FileSystemModuleRootResolver.access$save(this.this$0, this.$tempFile, byteBuffer, this.$data.position(), this.$failureHandler);
                } else {
                    Path path = this.$path;
                    Intrinsics.checkNotNullExpressionValue(path, "$path");
                    Files.deleteIfExists(path);
                    Path path2 = this.$tempPath;
                    Intrinsics.checkNotNullExpressionValue(path2, "$tempPath");
                    Path path3 = path2;
                    Path path4 = this.$path;
                    Intrinsics.checkNotNullExpressionValue(path4, "$path");
                    Path path5 = path4;
                    CopyOption[] copyOptionArray = new CopyOption[]{};
                    Intrinsics.checkNotNullExpressionValue(Files.move(path3, path5, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), "move(this, target, *options)");
                    this.$reference.refresh(System.currentTimeMillis(), this.$fileContents.length);
                    try {
                        this.$tempFile.close();
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        this.$successHandler.invoke();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void failed(@Nullable Throwable exc, @Nullable ErrorCode attachment) {
                ErrorCode errorCode;
                try {
                    this.$tempFile.close();
                    errorCode = attachment;
                }
                catch (IOException iOException) {
                    ErrorCode errorCode2 = attachment;
                    if (errorCode2 == null) {
                        errorCode2 = FileErrorCode.UNSPECIFIED;
                    }
                    this.$failureHandler.invoke(errorCode2, exc);
                    return;
                    catch (Throwable throwable) {
                        ErrorCode errorCode3 = attachment;
                        if (errorCode3 == null) {
                            errorCode3 = FileErrorCode.UNSPECIFIED;
                        }
                        this.$failureHandler.invoke(errorCode3, exc);
                        throw throwable;
                    }
                }
                ErrorCode errorCode4 = errorCode;
                if (errorCode == null) {
                    errorCode4 = FileErrorCode.UNSPECIFIED;
                }
                this.$failureHandler.invoke(errorCode4, exc);
            }
        });
    }

    @Override
    public void readFile(boolean bypassFileManager, @NotNull ResolverReference reference, @NotNull Function2<? super byte[], ? super UUID, Unit> withContents, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        boolean handled2;
        Intrinsics.checkNotNullParameter(reference, "reference");
        Intrinsics.checkNotNullParameter(withContents, "withContents");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        ResourceType[] resourceTypeArray = new ResourceType[]{ResourceType.ROOT, ResourceType.DIRECTORY, ResourceType.PACKAGE};
        if (SetsKt.setOf(resourceTypeArray).contains((Object)reference.getType())) {
            failureHandler.invoke(StandardErrorCode.IO_EXCEPTION, new IOException(reference.getQualifiedName() + " is a directory, not a file", null));
            return;
        }
        if (!bypassFileManager && (handled2 = this.getFileManager().optionallyProvideExistingFile(reference, (Function2<? super UUID, ? super AvailFile, Unit>)new Function2<UUID, AvailFile, Unit>(reference, withContents){
            final /* synthetic */ ResolverReference $reference;
            final /* synthetic */ Function2<byte[], UUID, Unit> $withContents;
            {
                this.$reference = $reference;
                this.$withContents = $withContents;
                super(2);
            }

            public final void invoke(@NotNull UUID uuid, @NotNull AvailFile availFile) {
                Intrinsics.checkNotNullParameter(uuid, "uuid");
                Intrinsics.checkNotNullParameter(availFile, "availFile");
                this.$reference.refresh(availFile.getLastModified(), availFile.getRawContent().length);
                this.$withContents.invoke(availFile.getRawContent(), uuid);
            }
        }, failureHandler))) {
            return;
        }
        AsynchronousFileChannel file2 = null;
        try {
            IOSystem iOSystem = this.getFileManager().getIoSystem();
            Path path = Paths.get(reference.getUri());
            Intrinsics.checkNotNullExpressionValue(path, "get(...)");
            EnumSet<Enum> enumSet = EnumSet.of((Enum)StandardOpenOption.READ);
            Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
            file2 = iOSystem.openFile(path, (Set<? extends OpenOption>)enumSet, new FileAttribute[0]);
        }
        catch (IOException e) {
            IOException ex = new IOException("Failed to read source: " + reference.getUri(), e);
            failureHandler.invoke(StandardErrorCode.IO_EXCEPTION, ex);
            return;
        }
        Ref.LongRef filePosition = new Ref.LongRef();
        ByteBuffer buffer = ByteBuffer.allocateDirect(4096);
        Ref.ObjectRef<byte[]> content = new Ref.ObjectRef<byte[]>();
        content.element = new byte[0];
        new SimpleCompletionHandler((Function1)new Function1<SimpleCompletionHandler.Companion.SuccessHelper<Integer>, Unit>(filePosition, buffer, content, file2, withContents, failureHandler){
            final /* synthetic */ Ref.LongRef $filePosition;
            final /* synthetic */ ByteBuffer $buffer;
            final /* synthetic */ Ref.ObjectRef<byte[]> $content;
            final /* synthetic */ AsynchronousFileChannel $file;
            final /* synthetic */ Function2<byte[], UUID, Unit> $withContents;
            final /* synthetic */ Function2<ErrorCode, Throwable, Unit> $failureHandler;
            {
                this.$filePosition = $filePosition;
                this.$buffer = $buffer;
                this.$content = $content;
                this.$file = $file;
                this.$withContents = $withContents;
                this.$failureHandler = $failureHandler;
                super(1);
            }

            public final void invoke(@NotNull SimpleCompletionHandler.Companion.SuccessHelper<Integer> $this$$receiver) {
                Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                try {
                    boolean moreInput = true;
                    if (((Number)$this$$receiver.getValue()).intValue() == -1) {
                        moreInput = false;
                    } else {
                        long pos = ((Number)$this$$receiver.getValue()).intValue();
                        this.$filePosition.element += pos;
                    }
                    if (moreInput) {
                        this.$buffer.flip();
                        byte[] data2 = new byte[this.$buffer.limit()];
                        this.$buffer.get(data2);
                        this.$content.element = (T)ArraysKt.plus((byte[])this.$content.element, data2);
                        this.$buffer.clear();
                        $this$$receiver.getHandler().guardedDo(new Function1<SimpleCompletionHandler.Companion.GuardHelper<Integer>, Unit>(this.$file, this.$buffer, this.$filePosition){
                            final /* synthetic */ AsynchronousFileChannel $file;
                            final /* synthetic */ ByteBuffer $buffer;
                            final /* synthetic */ Ref.LongRef $filePosition;
                            {
                                this.$file = $file;
                                this.$buffer = $buffer;
                                this.$filePosition = $filePosition;
                                super(1);
                            }

                            public final void invoke(@NotNull SimpleCompletionHandler.Companion.GuardHelper<Integer> $this$guardedDo) {
                                Intrinsics.checkNotNullParameter($this$guardedDo, "$this$guardedDo");
                                this.$file.read(this.$buffer, this.$filePosition.element, Unit.INSTANCE, (CompletionHandler)$this$guardedDo.getHandler());
                            }
                        });
                    } else {
                        this.$file.close();
                        this.$withContents.invoke((byte[])this.$content.element, (UUID)null);
                    }
                }
                catch (IOException e) {
                    try {
                        this.$file.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.$failureHandler.invoke(StandardErrorCode.IO_EXCEPTION, e);
                }
            }
        }, (Function1)new Function1<SimpleCompletionHandler.Companion.FailureHelper<Integer>, Unit>(file2, reference, failureHandler){
            final /* synthetic */ AsynchronousFileChannel $file;
            final /* synthetic */ ResolverReference $reference;
            final /* synthetic */ Function2<ErrorCode, Throwable, Unit> $failureHandler;
            {
                this.$file = $file;
                this.$reference = $reference;
                this.$failureHandler = $failureHandler;
                super(1);
            }

            public final void invoke(@NotNull SimpleCompletionHandler.Companion.FailureHelper<Integer> $this$$receiver) {
                Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                try {
                    this.$file.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                IOException ex = new IOException("Failed to read: " + this.$reference.getUri(), $this$$receiver.getThrowable());
                ex.printStackTrace();
                this.$failureHandler.invoke(StandardErrorCode.IO_EXCEPTION, ex);
            }
        }).guardedDo((Function1)new Function1<SimpleCompletionHandler.Companion.GuardHelper<Integer>, Unit>(file2, buffer){
            final /* synthetic */ AsynchronousFileChannel $file;
            final /* synthetic */ ByteBuffer $buffer;
            {
                this.$file = $file;
                this.$buffer = $buffer;
                super(1);
            }

            public final void invoke(@NotNull SimpleCompletionHandler.Companion.GuardHelper<Integer> $this$guardedDo) {
                Intrinsics.checkNotNullParameter($this$guardedDo, "$this$guardedDo");
                this.$file.read(this.$buffer, 0L, Unit.INSTANCE, (CompletionHandler)$this$guardedDo.getHandler());
            }
        });
    }

    private final FileVisitor<Path> sourceModuleVisitor() {
        Ref.BooleanRef isRoot = new Ref.BooleanRef();
        isRoot.element = true;
        ArrayDeque<ResolverReference> stack = new ArrayDeque<ResolverReference>();
        return new FileVisitor<Path>(isRoot, this, stack){
            final /* synthetic */ Ref.BooleanRef $isRoot;
            final /* synthetic */ FileSystemModuleRootResolver this$0;
            final /* synthetic */ ArrayDeque<ResolverReference> $stack;
            {
                this.$isRoot = $isRoot;
                this.this$0 = $receiver;
                this.$stack = $stack;
            }

            @NotNull
            public FileVisitResult preVisitDirectory(@NotNull Path dir, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter(dir, "dir");
                Intrinsics.checkNotNullParameter(attrs, "attrs");
                if (this.$isRoot.element) {
                    URI dirURI = dir.toUri();
                    if (dirURI.getScheme() == null) {
                        dirURI = new URI("file://" + dir);
                    }
                    this.$isRoot.element = false;
                    String qualifiedName2 = "/" + this.this$0.getModuleRoot().getName();
                    ModuleRootResolver moduleRootResolver = this.this$0;
                    URI uRI = dirURI;
                    Intrinsics.checkNotNull(uRI);
                    ResolverReference reference = new ResolverReference(moduleRootResolver, uRI, qualifiedName2, ResourceType.ROOT, "", 0L, 0L, this.this$0.getModuleRoot().getName(), null, 256, null);
                    this.this$0.getReferenceMap().put(qualifiedName2, reference);
                    this.this$0.setModuleRootTree$avail(reference);
                    this.$stack.add(reference);
                    return FileVisitResult.CONTINUE;
                }
                ResolverReference resolverReference = this.$stack.peekFirst();
                Intrinsics.checkNotNull(resolverReference);
                ResolverReference parent = resolverReference;
                String fileName = ((Object)dir.getFileName()).toString();
                if (StringsKt.endsWith$default(fileName, ".avail", false, 2, null)) {
                    String localName2 = StringsKt.removeSuffix(fileName, (CharSequence)".avail");
                    String qualifiedName3 = parent.getQualifiedName() + "/" + localName2;
                    URI dirURI = dir.toUri();
                    if (dirURI.getScheme() == null) {
                        dirURI = new URI("file://" + dir);
                    }
                    ModuleRootResolver moduleRootResolver = this.this$0;
                    URI uRI = dirURI;
                    Intrinsics.checkNotNull(uRI);
                    ResolverReference reference = new ResolverReference(moduleRootResolver, uRI, qualifiedName3, ResourceType.PACKAGE, "", 0L, 0L, null, null, 384, null);
                    this.this$0.getReferenceMap().put(qualifiedName3, reference);
                    this.$stack.addFirst(reference);
                    parent.getModules().add(reference);
                    return FileVisitResult.CONTINUE;
                }
                String qualifiedName4 = parent.getQualifiedName() + "/" + fileName;
                URI dirURI = dir.toUri();
                if (dirURI.getScheme() == null) {
                    dirURI = new URI("file://" + dir);
                }
                ModuleRootResolver moduleRootResolver = this.this$0;
                URI uRI = dirURI;
                Intrinsics.checkNotNull(uRI);
                ResolverReference reference = new ResolverReference(moduleRootResolver, uRI, qualifiedName4, ResourceType.DIRECTORY, "", 0L, 0L, null, null, 384, null);
                this.this$0.getReferenceMap().put(qualifiedName4, reference);
                this.$stack.addFirst(reference);
                parent.getResources().add(reference);
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException e) {
                Intrinsics.checkNotNullParameter(dir, "dir");
                this.$stack.removeFirst();
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file2, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter(file2, "file");
                Intrinsics.checkNotNullParameter(attrs, "attrs");
                if (this.$isRoot.element) {
                    throw new IOException("alleged root is not a directory");
                }
                if (FileSystemModuleRootResolver.access$shouldIgnorePath(this.this$0, file2)) {
                    return FileVisitResult.CONTINUE;
                }
                String fileName = ((Object)file2.getFileName()).toString();
                ResolverReference resolverReference = this.$stack.peekFirst();
                Intrinsics.checkNotNull(resolverReference);
                ResolverReference parent = resolverReference;
                if (StringsKt.endsWith$default(fileName, ".avail", false, 2, null)) {
                    String string2 = fileName.substring(0, fileName.length() - 6);
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String localName2 = string2;
                    ResourceType type2 = parent.isPackage() && Intrinsics.areEqual(parent.getLocalName(), localName2) ? ResourceType.REPRESENTATIVE : ResourceType.MODULE;
                    String qualifiedName2 = parent.getQualifiedName() + "/" + localName2;
                    ResolverReference reference = this.this$0.resolverReference(file2, qualifiedName2, type2);
                    this.this$0.getReferenceMap().put(qualifiedName2, reference);
                    parent.getModules().add(reference);
                } else {
                    String qualifiedName3 = parent.getQualifiedName() + "/" + fileName;
                    ResolverReference reference = this.this$0.resolverReference(file2, qualifiedName3, ResourceType.RESOURCE);
                    this.this$0.getReferenceMap().put(qualifiedName3, reference);
                    parent.getResources().add(reference);
                }
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult visitFileFailed(@NotNull Path file2, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter(file2, "file");
                Intrinsics.checkNotNullParameter(e, "e");
                return FileVisitResult.CONTINUE;
            }
        };
    }

    private final boolean shouldIgnorePath(Path path) {
        String fileName = ((Object)path.getFileName()).toString();
        String string2 = fileName.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toUpperCase(Locale.ROOT)");
        return Intrinsics.areEqual(string2, ".DS_STORE") ? true : StringsKt.startsWith$default(fileName, FileSystemModuleRootResolver.Companion.tempFilePrefix(), false, 2, null);
    }

    @NotNull
    public String toString() {
        return this.getName() + " - " + this.getUri();
    }

    public static final /* synthetic */ FileVisitor access$sourceModuleVisitor(FileSystemModuleRootResolver $this) {
        return $this.sourceModuleVisitor();
    }

    public static final /* synthetic */ void access$save(FileSystemModuleRootResolver $this, AsynchronousFileChannel file2, ByteBuffer data2, long writePosition, Function2 failureHandler) {
        $this.save(file2, data2, writePosition, failureHandler);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lavail/resolver/FileSystemModuleRootResolver$Companion;", "", "()V", "tempFilePrefix", "", "avail"})
    public static final class Companion {
        private Companion() {
        }

        private final String tempFilePrefix() {
            return "$$$TEMPFILE$$$-";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lavail/resolver/FileSystemModuleRootResolver$FileSystemWatcher;", "", "(Lavail/resolver/FileSystemModuleRootResolver;)V", "directoryWatcher", "Lio/methvin/watcher/DirectoryWatcher;", "close", "", "resolveEvent", "event", "Lio/methvin/watcher/DirectoryChangeEvent;", "avail"})
    @SourceDebugExtension(value={"SMAP\nFileSystemModuleRootResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemModuleRootResolver.kt\navail/resolver/FileSystemModuleRootResolver$FileSystemWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,931:1\n1855#2,2:932\n1855#2:934\n1855#2,2:935\n1856#2:937\n*S KotlinDebug\n*F\n+ 1 FileSystemModuleRootResolver.kt\navail/resolver/FileSystemModuleRootResolver$FileSystemWatcher\n*L\n847#1:932,2\n910#1:934\n911#1:935,2\n910#1:937\n*E\n"})
    public final class FileSystemWatcher {
        @NotNull
        private final DirectoryWatcher directoryWatcher;

        public FileSystemWatcher() {
            DirectoryWatcher directoryWatcher = DirectoryWatcher.builder().logger(NOPLogger.NOP_LOGGER).fileHasher(FileHasher.LAST_MODIFIED_TIME).listener(arg_0 -> FileSystemWatcher.directoryWatcher$lambda$0(this, arg_0)).path(Path.of(new File(FileSystemModuleRootResolver.this.getModuleRoot().getResolver().getUri()).getPath(), new String[0])).build();
            Intrinsics.checkNotNullExpressionValue(directoryWatcher, "build(...)");
            this.directoryWatcher = DirectoryWatcherExtensionsKt.launch(directoryWatcher, "module root observer");
        }

        public final void close() {
            this.directoryWatcher.close();
        }

        /*
         * WARNING - void declaration
         */
        private final void resolveEvent(DirectoryChangeEvent event) {
            Path path = event.path();
            Intrinsics.checkNotNull(path);
            if (FileSystemModuleRootResolver.this.shouldIgnorePath(path)) {
                return;
            }
            URI base = FileSystemModuleRootResolver.this.getModuleRoot().getResolver().getUri();
            URI uRI = path.toUri();
            if (uRI == null) {
                return;
            }
            URI uri = uRI;
            File file2 = new File(base.resolve(uri));
            boolean isDirectory = file2.isDirectory();
            DirectoryChangeEvent.EventType eventType = event.eventType();
            if (isDirectory && (eventType == DirectoryChangeEvent.EventType.MODIFY || eventType == DirectoryChangeEvent.EventType.CREATE)) {
                return;
            }
            String string2 = file2.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            String qualifiedName2 = FileSystemModuleRootResolver.this.getQualifiedName(string2);
            DirectoryChangeEvent.EventType eventType2 = eventType;
            switch (eventType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[eventType2.ordinal()]) {
                case 1: {
                    ResolverReference resolverReference = FileSystemModuleRootResolver.this.getReferenceMap().remove(qualifiedName2);
                    if (resolverReference == null) {
                        return;
                    }
                    ResolverReference ref = resolverReference;
                    ResolverReference parent = FileSystemModuleRootResolver.this.getReferenceMap().get(ref.getParentName());
                    if (parent != null) {
                        List<ResolverReference> list2;
                        boolean bl = ref.isResource();
                        if (bl) {
                            list2 = parent.getResources();
                        } else if (!bl) {
                            list2 = parent.getModules();
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        List<ResolverReference> children2 = list2;
                        children2.remove(ref);
                    }
                    Iterable $this$forEach$iv = FileSystemModuleRootResolver.this.getWatchEventSubscriptions().values();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Function2 subscriber = (Function2)element$iv;
                        boolean bl = false;
                        subscriber.invoke(ModuleRootResolver.WatchEventType.DELETE, ref);
                    }
                    break;
                }
                case 2: {
                    ResolverReference resolverReference = FileSystemModuleRootResolver.this.getReferenceMap().get(qualifiedName2);
                    if (resolverReference == null) {
                        return;
                    }
                    ResolverReference ref = resolverReference;
                    FileSystemModuleRootResolver.this.refreshResolverMetaData(ref, (Function1<? super Long, Unit>)new Function1<Long, Unit>(FileSystemModuleRootResolver.this, ref){
                        final /* synthetic */ FileSystemModuleRootResolver this$0;
                        final /* synthetic */ ResolverReference $ref;
                        {
                            this.this$0 = $receiver;
                            this.$ref = $ref;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(long it) {
                            void $this$forEach$iv;
                            Iterable iterable = this.this$0.getWatchEventSubscriptions().values();
                            ResolverReference resolverReference = this.$ref;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                Function2 subscriber = (Function2)element$iv;
                                boolean bl = false;
                                subscriber.invoke(ModuleRootResolver.WatchEventType.MODIFY, resolverReference);
                            }
                        }
                    }, resolveEvent.3.INSTANCE);
                    break;
                }
                case 3: {
                    void $this$forEach$iv;
                    Object parent;
                    boolean parentExisted;
                    if (FileSystemModuleRootResolver.this.getReferenceMap().get(qualifiedName2) != null) {
                        return;
                    }
                    ResourceType type2 = FileSystemModuleRootResolver.this.determineResourceType(file2);
                    LinkedList<Object> added = new LinkedList<Object>();
                    Path path2 = file2.toPath();
                    Intrinsics.checkNotNullExpressionValue(path2, "toPath(...)");
                    ResolverReference ref = FileSystemModuleRootResolver.this.resolverReference(path2, qualifiedName2, type2);
                    added.addFirst(ref);
                    FileSystemModuleRootResolver.this.getReferenceMap().put(qualifiedName2, ref);
                    do {
                        List<ResolverReference> list3;
                        boolean bl = parentExisted = (parent = FileSystemModuleRootResolver.this.getReferenceMap().get(ref.getParentName())) != null;
                        if (!parentExisted) {
                            File parentFile = new File(ref.getUri()).getParentFile();
                            Intrinsics.checkNotNull(parentFile);
                            ResourceType parentType = FileSystemModuleRootResolver.this.determineResourceType(parentFile);
                            Path path3 = parentFile.toPath();
                            Intrinsics.checkNotNullExpressionValue(path3, "toPath(...)");
                            parent = FileSystemModuleRootResolver.this.resolverReference(path3, ref.getParentName(), parentType);
                            added.addFirst(parent);
                            FileSystemModuleRootResolver.this.getReferenceMap().put(((ResolverReference)parent).getQualifiedName(), (ResolverReference)parent);
                        }
                        Intrinsics.checkNotNull(parent);
                        boolean bl2 = ref.isResource();
                        if (bl2) {
                            list3 = ((ResolverReference)parent).getResources();
                        } else if (!bl2) {
                            list3 = ((ResolverReference)parent).getModules();
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        List<ResolverReference> children3 = list3;
                        children3.add(ref);
                        ref = parent;
                    } while (!parentExisted);
                    parent = added;
                    FileSystemModuleRootResolver fileSystemModuleRootResolver = FileSystemModuleRootResolver.this;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ResolverReference newRef = (ResolverReference)element$iv;
                        boolean bl = false;
                        Iterable $this$forEach$iv2 = fileSystemModuleRootResolver.getWatchEventSubscriptions().values();
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            Function2 subscriber = (Function2)element$iv2;
                            boolean bl3 = false;
                            subscriber.invoke(ModuleRootResolver.WatchEventType.CREATE, newRef);
                        }
                    }
                    break;
                }
            }
        }

        private static final void directoryWatcher$lambda$0(FileSystemWatcher this$0, DirectoryChangeEvent event) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            try {
                Intrinsics.checkNotNull(event);
                this$0.resolveEvent(event);
            }
            catch (Throwable t) {
                String string2 = "Processing " + event.eventType() + ": " + event.path() + ", encountered error: " + t + "\n" + ExceptionsKt.stackTraceToString(t);
                System.out.println((Object)string2);
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DirectoryChangeEvent.EventType.values().length];
                try {
                    nArray[DirectoryChangeEvent.EventType.DELETE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DirectoryChangeEvent.EventType.MODIFY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DirectoryChangeEvent.EventType.CREATE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

