/*
 * Decompiled with CFR 0.152.
 */
package avail.stacks.comment;

import avail.stacks.LinkingFileMap;
import avail.stacks.StacksDescription;
import avail.stacks.comment.AvailComment;
import avail.stacks.comment.ClassComment;
import avail.stacks.comment.GlobalComment;
import avail.stacks.comment.GrammaticalRestrictionComment;
import avail.stacks.comment.MacroComment;
import avail.stacks.comment.MethodComment;
import avail.stacks.comment.ModuleComment;
import avail.stacks.comment.SemanticRestrictionComment;
import avail.stacks.comment.signature.CommentSignature;
import avail.stacks.comment.signature.GlobalCommentSignature;
import avail.stacks.comment.signature.MethodCommentSignature;
import avail.stacks.comment.signature.SemanticRestrictionCommentSignature;
import avail.stacks.exceptions.StacksCommentBuilderException;
import avail.stacks.tags.StacksAliasTag;
import avail.stacks.tags.StacksAuthorTag;
import avail.stacks.tags.StacksCategoryTag;
import avail.stacks.tags.StacksFieldTag;
import avail.stacks.tags.StacksForbidsTag;
import avail.stacks.tags.StacksGlobalTag;
import avail.stacks.tags.StacksMacroTag;
import avail.stacks.tags.StacksMethodTag;
import avail.stacks.tags.StacksModuleTag;
import avail.stacks.tags.StacksParameterTag;
import avail.stacks.tags.StacksRaisesTag;
import avail.stacks.tags.StacksRestrictsTag;
import avail.stacks.tags.StacksReturnTag;
import avail.stacks.tags.StacksSeeTag;
import avail.stacks.tags.StacksStickyTag;
import avail.stacks.tags.StacksSuperTypeTag;
import avail.stacks.tags.StacksTypeTag;
import avail.stacks.tokens.AbstractStacksToken;
import avail.stacks.tokens.QuotedStacksToken;
import avail.stacks.tokens.RegionStacksToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 L2\u00020\u0001:\u0001LB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u00107\u001a\u00020\u0007J\u0014\u00108\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u001c\u00109\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u00107\u001a\u00020\u0007J\u0014\u0010:\u001a\u0002032\f\u0010;\u001a\b\u0012\u0004\u0012\u00020605J\u0014\u0010<\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u0014\u0010=\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u0014\u0010>\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u0014\u0010?\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u0014\u0010@\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u0014\u0010A\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u0014\u0010B\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u0014\u0010C\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u0014\u0010D\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u0014\u0010E\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u0014\u0010F\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u0014\u0010G\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u0014\u0010H\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u0014\u0010I\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\b\u0010J\u001a\u0004\u0018\u00010KR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u0002010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lavail/stacks/comment/CommentBuilder;", "", "moduleName", "", "commentStartLine", "", "linkingFileMap", "Lavail/stacks/LinkingFileMap;", "(Ljava/lang/String;ILavail/stacks/LinkingFileMap;)V", "aliases", "", "Lavail/stacks/tags/StacksAliasTag;", "authors", "Lavail/stacks/tags/StacksAuthorTag;", "categories", "Lavail/stacks/tags/StacksCategoryTag;", "description", "Lavail/stacks/StacksDescription;", "fields", "Lavail/stacks/tags/StacksFieldTag;", "forbids", "Ljava/util/TreeMap;", "Lavail/stacks/tags/StacksForbidsTag;", "globalVariables", "Lavail/stacks/tags/StacksGlobalTag;", "macros", "Lavail/stacks/tags/StacksMacroTag;", "methods", "Lavail/stacks/tags/StacksMethodTag;", "moduleLeafName", "getModuleName", "()Ljava/lang/String;", "modules", "Lavail/stacks/tags/StacksModuleTag;", "parameters", "Lavail/stacks/tags/StacksParameterTag;", "raises", "Lavail/stacks/tags/StacksRaisesTag;", "restricts", "Lavail/stacks/tags/StacksRestrictsTag;", "returns", "Lavail/stacks/tags/StacksReturnTag;", "sees", "Lavail/stacks/tags/StacksSeeTag;", "stickies", "Lavail/stacks/tags/StacksStickyTag;", "supertypes", "Lavail/stacks/tags/StacksSuperTypeTag;", "types", "Lavail/stacks/tags/StacksTypeTag;", "addStacksAliasTag", "", "tagContentTokens", "", "Lavail/stacks/tokens/AbstractStacksToken;", "fileMap", "addStacksAuthorTag", "addStacksCategoryTag", "addStacksCommentDescription", "list", "addStacksFieldTag", "addStacksForbidTag", "addStacksGlobalTag", "addStacksMacroTag", "addStacksMethodTag", "addStacksModuleTag", "addStacksParameterTag", "addStacksRaisesTag", "addStacksRestrictsTag", "addStacksReturnsTag", "addStacksSeesTag", "addStacksStickyTag", "addStacksSupertypeTag", "addStacksTypeTag", "createStacksComment", "Lavail/stacks/comment/AvailComment;", "Companion", "avail"})
public final class CommentBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String moduleName;
    private final int commentStartLine;
    @NotNull
    private final LinkingFileMap linkingFileMap;
    @NotNull
    private final List<StacksAliasTag> aliases;
    @NotNull
    private final List<StacksAuthorTag> authors;
    @NotNull
    private final List<StacksCategoryTag> categories;
    @NotNull
    private StacksDescription description;
    @NotNull
    private final List<StacksFieldTag> fields;
    @NotNull
    private final TreeMap<Integer, StacksForbidsTag> forbids;
    @NotNull
    private final List<StacksGlobalTag> globalVariables;
    @NotNull
    private final List<StacksMethodTag> methods;
    @NotNull
    private final List<StacksModuleTag> modules;
    @NotNull
    private final List<StacksMacroTag> macros;
    @NotNull
    private final List<StacksParameterTag> parameters;
    @NotNull
    private final List<StacksRaisesTag> raises;
    @NotNull
    private final List<StacksRestrictsTag> restricts;
    @NotNull
    private final List<StacksReturnTag> returns;
    @NotNull
    private final List<StacksSeeTag> sees;
    @NotNull
    private final List<StacksStickyTag> stickies;
    @NotNull
    private final List<StacksSuperTypeTag> supertypes;
    @NotNull
    private final List<StacksTypeTag> types;
    @NotNull
    private final String moduleLeafName;

    private CommentBuilder(String moduleName2, int commentStartLine, LinkingFileMap linkingFileMap) {
        this.moduleName = moduleName2;
        this.commentStartLine = commentStartLine;
        this.linkingFileMap = linkingFileMap;
        this.aliases = new ArrayList();
        this.authors = new ArrayList();
        this.categories = new ArrayList();
        this.description = new StacksDescription(CollectionsKt.emptyList());
        this.fields = new ArrayList();
        this.forbids = new TreeMap();
        this.globalVariables = new ArrayList();
        this.methods = new ArrayList();
        this.modules = new ArrayList();
        this.macros = new ArrayList();
        this.parameters = new ArrayList();
        this.raises = new ArrayList();
        this.restricts = new ArrayList();
        this.returns = new ArrayList();
        this.sees = new ArrayList();
        this.stickies = new ArrayList();
        this.supertypes = new ArrayList();
        this.types = new ArrayList();
        String string2 = this.moduleName.substring(StringsKt.lastIndexOf$default((CharSequence)this.moduleName, '/', 0, false, 6, null) + 1);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
        this.moduleLeafName = string2;
        List tempTokens = new ArrayList();
        tempTokens.add(QuotedStacksToken.Companion.create("Unclassified", 0, 0, 0, this.moduleName));
        this.categories.add(new StacksCategoryTag(tempTokens));
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    public final void addStacksAliasTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens, @NotNull LinkingFileMap fileMap) throws ClassCastException, StacksCommentBuilderException {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        Intrinsics.checkNotNullParameter(fileMap, "fileMap");
        List tempTokens = new ArrayList();
        for (AbstractStacksToken abstractStacksToken : tagContentTokens) {
            try {
                Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.QuotedStacksToken");
                tempTokens.add((QuotedStacksToken)abstractStacksToken);
            }
            catch (ClassCastException e) {
                String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @category tag section; expected a series of quoted category names immediately following the @category tag, however does not start with a quoted category is listed.</li>";
                Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
                String errorMessage2 = string3;
                throw new StacksCommentBuilderException(errorMessage2, this);
            }
        }
        if (!((Collection)tempTokens).isEmpty()) {
            this.aliases.clear();
        }
        this.aliases.add(new StacksAliasTag(tempTokens));
    }

    public final void addStacksAuthorTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens) {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        this.authors.add(new StacksAuthorTag(tagContentTokens));
    }

    public final void addStacksCategoryTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens, @NotNull LinkingFileMap fileMap) throws ClassCastException, StacksCommentBuilderException {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        Intrinsics.checkNotNullParameter(fileMap, "fileMap");
        List tempTokens = new ArrayList();
        for (AbstractStacksToken abstractStacksToken : tagContentTokens) {
            try {
                Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.QuotedStacksToken");
                tempTokens.add((QuotedStacksToken)abstractStacksToken);
            }
            catch (ClassCastException e) {
                String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @category tag section; expected a series of quoted category names immediately following the @category tag, however does not start with a quoted category is listed.</li>";
                Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
                String errorMessage2 = string3;
                throw new StacksCommentBuilderException(errorMessage2, this);
            }
        }
        if (!((Collection)tempTokens).isEmpty()) {
            this.categories.clear();
        }
        this.categories.add(new StacksCategoryTag(tempTokens));
    }

    public final void addStacksCommentDescription(@NotNull List<? extends AbstractStacksToken> list2) throws ClassCastException {
        Intrinsics.checkNotNullParameter(list2, "list");
        this.description = new StacksDescription(list2);
    }

    public final void addStacksFieldTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens) throws ClassCastException, StacksCommentBuilderException {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        int tokenCount = tagContentTokens.size();
        if (tokenCount < 2) {
            String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @field tag section; too few components.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            String errorMessage2 = string3;
            throw new StacksCommentBuilderException(errorMessage2, this);
        }
        QuotedStacksToken tempName = null;
        try {
            AbstractStacksToken abstractStacksToken = tagContentTokens.get(0);
            Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.QuotedStacksToken");
            tempName = (QuotedStacksToken)abstractStacksToken;
        }
        catch (ClassCastException e) {
            String string4 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @field tag section; expected quoted field name.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
            String errorMessage3 = string5;
            throw new StacksCommentBuilderException(errorMessage3, this);
        }
        QuotedStacksToken tempType = null;
        try {
            AbstractStacksToken abstractStacksToken = tagContentTokens.get(1);
            Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.QuotedStacksToken");
            tempType = (QuotedStacksToken)abstractStacksToken;
        }
        catch (ClassCastException e) {
            String string6 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @field tag section; expected a quoted field type\n.";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string7, "format(format, *args)");
            String errorMessage4 = string7;
            throw new StacksCommentBuilderException(errorMessage4, this);
        }
        if (tokenCount == 2) {
            this.fields.add(new StacksFieldTag(tempName, tempType, new StacksDescription(new ArrayList())));
        } else {
            List<? extends AbstractStacksToken> rest = tagContentTokens.subList(2, tokenCount);
            this.fields.add(new StacksFieldTag(tempName, tempType, new StacksDescription(rest)));
        }
    }

    public final void addStacksForbidTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens) throws ClassCastException, StacksCommentBuilderException {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        int arity = 0;
        try {
            arity = Integer.parseInt(tagContentTokens.get(0).getLexeme$avail());
        }
        catch (NumberFormatException e) {
            String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @forbids tag section; expected a number immediately the @forbids tag, but did not receive one.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            String errorMessage2 = string3;
            throw new StacksCommentBuilderException(errorMessage2, this);
        }
        try {
            List tempTokens = new ArrayList();
            int n = tagContentTokens.size();
            for (int i2 = 1; i2 < n; ++i2) {
                AbstractStacksToken abstractStacksToken = tagContentTokens.get(i2);
                Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.QuotedStacksToken");
                tempTokens.add((QuotedStacksToken)abstractStacksToken);
            }
            Integer n2 = arity;
            ((Map)this.forbids).put(n2, new StacksForbidsTag(tagContentTokens.get(0), tempTokens));
        }
        catch (ClassCastException e) {
            String string4 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @forbids tag section; expected a series of quoted method names immediately following the @forbids tag arity number, however the first argument following the @forbids tag is not quoted.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
            String errorMessage3 = string5;
            throw new StacksCommentBuilderException(errorMessage3, this);
        }
    }

    public final void addStacksGlobalTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens) throws ClassCastException, StacksCommentBuilderException {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        int tokenCount = tagContentTokens.size();
        if (tokenCount < 2) {
            String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @global tag section; has too few components.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            String errorMessage2 = string3;
            throw new StacksCommentBuilderException(errorMessage2, this);
        }
        QuotedStacksToken tempName = null;
        try {
            AbstractStacksToken abstractStacksToken = tagContentTokens.get(0);
            Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.QuotedStacksToken");
            tempName = (QuotedStacksToken)abstractStacksToken;
        }
        catch (ClassCastException e) {
            String string4 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @global tag section; expected a quoted module variable name immediately following the @global tag, however no such quoted name is listed.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
            String errorMessage3 = string5;
            throw new StacksCommentBuilderException(errorMessage3, this);
        }
        QuotedStacksToken tempType = null;
        try {
            AbstractStacksToken abstractStacksToken = tagContentTokens.get(1);
            Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.QuotedStacksToken");
            tempType = (QuotedStacksToken)abstractStacksToken;
        }
        catch (ClassCastException e) {
            String string6 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @global tag section; expected a quoted type immediately following the @global tag, however no such quoted type is listed.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string7, "format(format, *args)");
            String errorMessage4 = string7;
            throw new StacksCommentBuilderException(errorMessage4, this);
        }
        this.globalVariables.add(new StacksGlobalTag(tempName, tempType));
    }

    public final void addStacksMethodTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens) throws ClassCastException, StacksCommentBuilderException {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        if (tagContentTokens.size() == 1) {
            try {
                AbstractStacksToken abstractStacksToken = tagContentTokens.get(0);
                Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.QuotedStacksToken");
                this.methods.add(new StacksMethodTag((QuotedStacksToken)abstractStacksToken));
            }
            catch (ClassCastException e) {
                String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @method tag section; expected a quoted method name immediately following the @method tag.</li>";
                Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
                String errorMessage2 = string3;
                throw new StacksCommentBuilderException(errorMessage2, this);
            }
        } else {
            String string4 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @method tag section; has wrong # of @method components.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
            String errorMessage3 = string5;
            throw new StacksCommentBuilderException(errorMessage3, this);
        }
    }

    public final void addStacksModuleTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens) throws ClassCastException, StacksCommentBuilderException {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        if (!tagContentTokens.isEmpty()) {
            String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @module tag section; expected no tokens to follow @module tag.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            String errorMessage2 = string3;
            throw new StacksCommentBuilderException(errorMessage2, this);
        }
        this.modules.add(new StacksModuleTag());
    }

    public final void addStacksMacroTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens) throws ClassCastException, StacksCommentBuilderException {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        if (tagContentTokens.size() == 1) {
            try {
                AbstractStacksToken abstractStacksToken = tagContentTokens.get(0);
                Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.QuotedStacksToken");
                this.macros.add(new StacksMacroTag((QuotedStacksToken)abstractStacksToken));
            }
            catch (ClassCastException e) {
                String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @macro tag section; expected a quoted method name immediately following the @macro tag.</li>";
                Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
                String errorMessage2 = string3;
                throw new StacksCommentBuilderException(errorMessage2, this);
            }
        } else {
            String string4 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @macro tag section; has wrong # of @macro components.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
            String errorMessage3 = string5;
            throw new StacksCommentBuilderException(errorMessage3, this);
        }
    }

    public final void addStacksParameterTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens) throws ClassCastException, StacksCommentBuilderException {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        int tokenCount = tagContentTokens.size();
        if (tokenCount < 2) {
            String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @param tag section;  has too few @param components.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            String errorMessage2 = string3;
            throw new StacksCommentBuilderException(errorMessage2, this);
        }
        QuotedStacksToken tempName = null;
        try {
            AbstractStacksToken abstractStacksToken = tagContentTokens.get(0);
            Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.QuotedStacksToken");
            tempName = (QuotedStacksToken)abstractStacksToken;
        }
        catch (ClassCastException e) {
            String string4 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @param tag section; expected a quoted parameter type/name.";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
            String errorMessage3 = string5;
            throw new StacksCommentBuilderException(errorMessage3, this);
        }
        QuotedStacksToken tempType = null;
        try {
            AbstractStacksToken abstractStacksToken = tagContentTokens.get(1);
            Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.QuotedStacksToken");
            tempType = (QuotedStacksToken)abstractStacksToken;
        }
        catch (ClassCastException e) {
            String string6 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @param tag section; expected a quoted parameter type/name.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string7, "format(format, *args)");
            String errorMessage4 = string7;
            throw new StacksCommentBuilderException(errorMessage4, this);
        }
        if (tokenCount == 2) {
            this.parameters.add(new StacksParameterTag(tempName, tempType, new StacksDescription(new ArrayList())));
        } else {
            List<? extends AbstractStacksToken> rest = tagContentTokens.subList(2, tokenCount);
            this.parameters.add(new StacksParameterTag(tempName, tempType, new StacksDescription(rest)));
        }
    }

    public final void addStacksRaisesTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens) throws ClassCastException, StacksCommentBuilderException {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        int tokenCount = tagContentTokens.size();
        if (tokenCount < 1) {
            String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @raises tag section; has too few components.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            String errorMessage2 = string3;
            throw new StacksCommentBuilderException(errorMessage2, this);
        }
        QuotedStacksToken tempName = null;
        try {
            AbstractStacksToken abstractStacksToken = tagContentTokens.get(0);
            Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.QuotedStacksToken");
            tempName = (QuotedStacksToken)abstractStacksToken;
        }
        catch (ClassCastException e) {
            String string4 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @raises tag section; expected a quoted exception type immediately following the @raises tag, however no such quoted exception type is listed.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
            String errorMessage3 = string5;
            throw new StacksCommentBuilderException(errorMessage3, this);
        }
        if (tokenCount == 1) {
            this.raises.add(new StacksRaisesTag(tempName, new StacksDescription(new ArrayList())));
        } else {
            List<? extends AbstractStacksToken> rest = tagContentTokens.subList(1, tokenCount);
            this.raises.add(new StacksRaisesTag(tempName, new StacksDescription(rest)));
        }
    }

    public final void addStacksRestrictsTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens) throws ClassCastException, StacksCommentBuilderException {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        int tokenCount = tagContentTokens.size();
        if (tokenCount < 1) {
            String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @restricts tag section; has too few components.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            String errorMessage2 = string3;
            throw new StacksCommentBuilderException(errorMessage2, this);
        }
        QuotedStacksToken tempName = null;
        try {
            AbstractStacksToken abstractStacksToken = tagContentTokens.get(0);
            Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.QuotedStacksToken");
            tempName = (QuotedStacksToken)abstractStacksToken;
        }
        catch (ClassCastException e) {
            String string4 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @restricts tag section; expected a quoted type immediately following the @restricts tag, however no such quoted type is listed.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
            String errorMessage3 = string5;
            throw new StacksCommentBuilderException(errorMessage3, this);
        }
        if (tokenCount == 1) {
            this.restricts.add(new StacksRestrictsTag(tempName, new StacksDescription(new ArrayList())));
        } else {
            List<? extends AbstractStacksToken> rest = tagContentTokens.subList(1, tokenCount);
            this.restricts.add(new StacksRestrictsTag(tempName, new StacksDescription(rest)));
        }
    }

    public final void addStacksReturnsTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens) throws ClassCastException, StacksCommentBuilderException {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        int tokenCount = tagContentTokens.size();
        if (tokenCount < 1) {
            String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @returns tag section; has too few components.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            String errorMessage2 = string3;
            throw new StacksCommentBuilderException(errorMessage2, this);
        }
        RegionStacksToken tempName = null;
        try {
            AbstractStacksToken abstractStacksToken = tagContentTokens.get(0);
            Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.RegionStacksToken");
            tempName = (RegionStacksToken)abstractStacksToken;
        }
        catch (ClassCastException e) {
            String string4 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @returns tag section; expected a quoted return type immediately  following the @returns tag, however no such quoted return type is identifiable.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
            String errorMessage3 = string5;
            throw new StacksCommentBuilderException(errorMessage3, this);
        }
        if (tokenCount == 1) {
            this.returns.add(new StacksReturnTag(tempName, new StacksDescription(new ArrayList())));
        } else {
            List<? extends AbstractStacksToken> rest = tagContentTokens.subList(1, tokenCount);
            this.returns.add(new StacksReturnTag(tempName, new StacksDescription(rest)));
        }
    }

    public final void addStacksSeesTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens) throws ClassCastException, StacksCommentBuilderException {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        if (tagContentTokens.size() == 1) {
            try {
                AbstractStacksToken abstractStacksToken = tagContentTokens.get(0);
                Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.RegionStacksToken");
                this.sees.add(new StacksSeeTag((RegionStacksToken)abstractStacksToken));
            }
            catch (ClassCastException e) {
                String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @sees tag section; expected a semantic link (bracketed {}) or quoted @sees content.</li>";
                Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
                String errorMessage2 = string3;
                throw new StacksCommentBuilderException(errorMessage2, this);
            }
        } else {
            String string4 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @sees tag section; wrong # of @sees components.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
            String errorMessage3 = string5;
            throw new StacksCommentBuilderException(errorMessage3, this);
        }
    }

    public final void addStacksStickyTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens) throws ClassCastException, StacksCommentBuilderException {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        if (!tagContentTokens.isEmpty()) {
            String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @sticky tag section; expected no tokens to follow @sticky tag.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            String errorMessage2 = string3;
            throw new StacksCommentBuilderException(errorMessage2, this);
        }
        this.stickies.add(new StacksStickyTag());
    }

    public final void addStacksSupertypeTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens) throws ClassCastException, StacksCommentBuilderException {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        for (AbstractStacksToken abstractStacksToken : tagContentTokens) {
            try {
                Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.QuotedStacksToken");
                this.supertypes.add(new StacksSuperTypeTag((QuotedStacksToken)abstractStacksToken));
            }
            catch (ClassCastException e) {
                String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @supertype tag section; expected a series of quoted supertype names immediately following the @supertype tag, however does not start with a quoted supertype is listed.</li>";
                Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
                String errorMessage2 = string3;
                throw new StacksCommentBuilderException(errorMessage2, this);
            }
        }
    }

    public final void addStacksTypeTag(@NotNull List<? extends AbstractStacksToken> tagContentTokens) throws ClassCastException, StacksCommentBuilderException {
        Intrinsics.checkNotNullParameter(tagContentTokens, "tagContentTokens");
        if (tagContentTokens.size() == 1) {
            try {
                AbstractStacksToken abstractStacksToken = tagContentTokens.get(0);
                Intrinsics.checkNotNull(abstractStacksToken, "null cannot be cast to non-null type avail.stacks.tokens.QuotedStacksToken");
                this.types.add(new StacksTypeTag((QuotedStacksToken)abstractStacksToken));
            }
            catch (ClassCastException e) {
                String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @returns tag section; expected quoted type.</li>";
                Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
                String errorMessage2 = string3;
                throw new StacksCommentBuilderException(errorMessage2, this);
            }
        } else {
            String string4 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed @type tag section; has wrong # components.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
            String errorMessage3 = string5;
            throw new StacksCommentBuilderException(errorMessage3, this);
        }
    }

    @Nullable
    public final AvailComment createStacksComment() throws StacksCommentBuilderException {
        StacksCategoryTag onlyTag;
        if (!((Collection)this.types).isEmpty() && this.methods.isEmpty() && this.globalVariables.isEmpty() && this.modules.isEmpty()) {
            if (this.types.size() == 1) {
                CommentSignature signature2 = new CommentSignature(this.types.get(0).typeName().getLexeme$avail(), this.moduleName);
                return new ClassComment(signature2, this.commentStartLine, this.authors, this.sees, this.description, this.categories, this.aliases, this.supertypes, this.fields, !((Collection)this.stickies).isEmpty());
            }
            String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed has wrong # of @types identifying tags.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            String errorMessage2 = string3;
            throw new StacksCommentBuilderException(errorMessage2, this);
        }
        if (this.types.isEmpty() && (!((Collection)this.methods).isEmpty() || !((Collection)this.macros).isEmpty()) && this.globalVariables.isEmpty() && this.modules.isEmpty()) {
            if (this.macros.isEmpty()) {
                if (this.methods.size() > 1) {
                    String string4 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed has wrong # of @method identifying tags.</li>";
                    Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
                    String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
                    String errorMessage3 = string5;
                    throw new StacksCommentBuilderException(errorMessage3, this);
                }
                if (!((Collection)this.restricts).isEmpty() && this.parameters.isEmpty() && this.forbids.isEmpty()) {
                    List orderedInputTypes = new ArrayList();
                    for (StacksRestrictsTag restrict : this.restricts) {
                        orderedInputTypes.add(restrict.paramMetaType().getLexeme$avail());
                    }
                    SemanticRestrictionCommentSignature signature3 = new SemanticRestrictionCommentSignature(this.methods.get(0).methodName().getLexeme$avail(), this.moduleName, orderedInputTypes);
                    return new SemanticRestrictionComment(signature3, this.commentStartLine, this.authors, this.sees, this.description, this.categories, this.aliases, this.restricts, this.returns);
                }
                if (this.restricts.isEmpty() && !((Collection)this.parameters).isEmpty() && this.forbids.isEmpty()) {
                    if (this.returns.isEmpty()) {
                        String restrict = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed comment; has no obvious @returns tag.</li>";
                        Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
                        String string6 = String.format(restrict, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue(string6, "format(format, *args)");
                        String errorMessage4 = string6;
                        throw new StacksCommentBuilderException(errorMessage4, this);
                    }
                    List orderedInputTypes = new ArrayList();
                    for (StacksParameterTag param : this.parameters) {
                        orderedInputTypes.add(param.paramType().getLexeme$avail());
                    }
                    MethodCommentSignature signature3 = new MethodCommentSignature(this.methods.get(0).methodName().getLexeme$avail(), this.moduleName, orderedInputTypes, this.returns.get(0).returnType().getLexeme$avail());
                    return new MethodComment(signature3, this.commentStartLine, this.authors, this.sees, this.description, this.categories, this.aliases, this.parameters, this.returns.get(0), this.raises, !((Collection)this.stickies).isEmpty());
                }
                if (this.restricts.isEmpty() && this.parameters.isEmpty() && !this.forbids.isEmpty()) {
                    CommentSignature signature4 = new CommentSignature(this.methods.get(0).methodName().getLexeme$avail(), this.moduleName);
                    return new GrammaticalRestrictionComment(signature4, this.commentStartLine, this.authors, this.sees, this.description, this.categories, this.aliases, (Map<Integer, StacksForbidsTag>)this.forbids);
                }
                if (this.restricts.isEmpty() && this.parameters.isEmpty() && this.forbids.isEmpty() && !((Collection)this.returns).isEmpty()) {
                    List orderedInputTypes = new ArrayList();
                    MethodCommentSignature signature5 = new MethodCommentSignature(this.methods.get(0).methodName().getLexeme$avail(), this.moduleName, orderedInputTypes, this.returns.get(0).returnType().getLexeme$avail());
                    return new MethodComment(signature5, this.commentStartLine, this.authors, this.sees, this.description, this.categories, this.aliases, this.parameters, this.returns.get(0), this.raises, !((Collection)this.stickies).isEmpty());
                }
            } else {
                if (this.macros.size() > 1) {
                    String param = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed has wrong # of @macro identifying tags.</li>";
                    Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
                    String string7 = String.format(param, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string7, "format(format, *args)");
                    String errorMessage5 = string7;
                    throw new StacksCommentBuilderException(errorMessage5, this);
                }
                if (!((Collection)this.restricts).isEmpty() && this.parameters.isEmpty() && this.forbids.isEmpty()) {
                    List orderedInputTypes = new ArrayList();
                    for (StacksRestrictsTag restrict : this.restricts) {
                        orderedInputTypes.add(restrict.paramMetaType().getLexeme$avail());
                    }
                    SemanticRestrictionCommentSignature signature5 = new SemanticRestrictionCommentSignature(this.macros.get(0).methodName().getLexeme$avail(), this.moduleName, orderedInputTypes);
                    return new SemanticRestrictionComment(signature5, this.commentStartLine, this.authors, this.sees, this.description, this.categories, this.aliases, this.restricts, this.returns);
                }
                if (this.restricts.isEmpty() && !((Collection)this.parameters).isEmpty() && this.forbids.isEmpty()) {
                    if (this.returns.isEmpty()) {
                        String restrict = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed comment; has no obvious @returns tag.</li>";
                        Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
                        String string8 = String.format(restrict, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue(string8, "format(format, *args)");
                        String errorMessage6 = string8;
                        throw new StacksCommentBuilderException(errorMessage6, this);
                    }
                    List orderedInputTypes = new ArrayList();
                    for (StacksParameterTag param : this.parameters) {
                        orderedInputTypes.add(param.paramType().getLexeme$avail());
                    }
                    MethodCommentSignature signature6 = new MethodCommentSignature(this.macros.get(0).methodName().getLexeme$avail(), this.moduleName, orderedInputTypes, this.returns.get(0).returnType().getLexeme$avail());
                    return new MacroComment(signature6, this.commentStartLine, this.authors, this.sees, this.description, this.categories, this.aliases, this.parameters, this.returns.get(0), this.raises, !((Collection)this.stickies).isEmpty());
                }
                if (this.restricts.isEmpty() && this.parameters.isEmpty() && !this.forbids.isEmpty()) {
                    CommentSignature signature7 = new CommentSignature(this.macros.get(0).methodName().getLexeme$avail(), this.moduleName);
                    return new GrammaticalRestrictionComment(signature7, this.commentStartLine, this.authors, this.sees, this.description, this.categories, this.aliases, (Map<Integer, StacksForbidsTag>)this.forbids);
                }
                if (this.restricts.isEmpty() && this.parameters.isEmpty() && this.forbids.isEmpty() && !((Collection)this.returns).isEmpty()) {
                    List orderedInputTypes = new ArrayList();
                    MethodCommentSignature signature8 = new MethodCommentSignature(this.macros.get(0).methodName().getLexeme$avail(), this.moduleName, orderedInputTypes, this.returns.get(0).returnType().getLexeme$avail());
                    return new MacroComment(signature8, this.commentStartLine, this.authors, this.sees, this.description, this.categories, this.aliases, this.parameters, this.returns.get(0), this.raises, !((Collection)this.stickies).isEmpty());
                }
            }
        }
        if (this.types.isEmpty() && this.methods.isEmpty() && !((Collection)this.globalVariables).isEmpty() && this.modules.isEmpty()) {
            if (this.globalVariables.size() == 1) {
                GlobalCommentSignature signature9 = new GlobalCommentSignature(this.globalVariables.get(0).globalName().getLexeme$avail(), this.moduleName, this.globalVariables.get(0).globalType().getLexeme$avail());
                return new GlobalComment((CommentSignature)signature9, this.commentStartLine, this.authors, this.sees, this.description, this.categories, this.aliases, this.globalVariables.get(0));
            }
            String string9 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed comment; has wrong # of @global identifying tags.</li>";
            Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
            String string10 = String.format(string9, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string10, "format(format, *args)");
            String errorMessage7 = string10;
            throw new StacksCommentBuilderException(errorMessage7, this);
        }
        if (this.types.isEmpty() && this.methods.isEmpty() && this.globalVariables.isEmpty() && !((Collection)this.modules).isEmpty()) {
            CommentSignature signature10 = new CommentSignature(this.moduleLeafName, this.moduleName);
            ModuleComment moduleComment = new ModuleComment(signature10, this.commentStartLine, this.authors, this.sees, this.description, false);
            this.linkingFileMap.addModuleComment(moduleComment);
            return null;
        }
        if (this.types.isEmpty() && this.methods.isEmpty() && this.globalVariables.isEmpty() && this.authors.isEmpty() && this.fields.isEmpty() && this.forbids.isEmpty() && this.parameters.isEmpty() && this.raises.isEmpty() && this.restricts.isEmpty() && this.returns.isEmpty() && this.sees.isEmpty() && this.supertypes.isEmpty() && this.types.isEmpty() && !((Collection)this.categories).isEmpty() && (onlyTag = this.categories.get(0)).categories().size() == 1) {
            this.linkingFileMap.addCategoryToDescription(onlyTag.categories().get(0).getLexeme$avail(), this.description);
            return null;
        }
        String string11 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Malformed comment has no distinguishing identifying tags that indicate the type of comment.</li>";
        Object[] objectArray = new Object[]{this.moduleLeafName, this.commentStartLine};
        String string12 = String.format(string11, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string12, "format(format, *args)");
        String errorMessage8 = string12;
        throw new StacksCommentBuilderException(errorMessage8, this);
    }

    public /* synthetic */ CommentBuilder(String moduleName2, int commentStartLine, LinkingFileMap linkingFileMap, DefaultConstructorMarker $constructor_marker) {
        this(moduleName2, commentStartLine, linkingFileMap);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lavail/stacks/comment/CommentBuilder$Companion;", "", "()V", "createBuilder", "Lavail/stacks/comment/CommentBuilder;", "moduleName", "", "commentStartLine", "", "linkingFileMap", "Lavail/stacks/LinkingFileMap;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CommentBuilder createBuilder(@NotNull String moduleName2, int commentStartLine, @NotNull LinkingFileMap linkingFileMap) {
            Intrinsics.checkNotNullParameter(moduleName2, "moduleName");
            Intrinsics.checkNotNullParameter(linkingFileMap, "linkingFileMap");
            return new CommentBuilder(moduleName2, commentStartLine, linkingFileMap, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

