/*
 * Decompiled with CFR 0.152.
 */
package avail.tools.bootstrap;

import avail.AvailRuntime;
import avail.AvailRuntimeConfiguration;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.primitive.controlflow.P_InvokeWithTuple;
import avail.interpreter.primitive.general.P_EmergencyExit;
import avail.interpreter.primitive.methods.P_AddSemanticRestriction;
import avail.interpreter.primitive.sets.P_TupleToSet;
import avail.interpreter.primitive.types.P_CreateEnumeration;
import avail.tools.bootstrap.BootstrapGenerator;
import avail.tools.bootstrap.Resources;
import avail.utility.CollectionExtensionsKt;
import avail.utility.Tuple4;
import avail.utility.UTF8ResourceBundleControl;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 ^2\u00020\u0001:\u0002^_B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\tH\u0002J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#J\u0016\u0010$\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#H\u0002J\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002J\u001e\u0010(\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010)\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002J \u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010,\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#H\u0002J\u001e\u0010-\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#2\u0006\u0010&\u001a\u00020'H\u0002J.\u0010.\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#2\u0016\u0010/\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u000601R\u00020\u000000H\u0002J\u0016\u00102\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#H\u0002J&\u00103\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u000601R\u00020\u0000002\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#H\u0002J\u0010\u00104\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u00105\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u00106\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u00107\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u00108\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'H\u0002J%\u0010;\u001a\u00020!2\b\u0010<\u001a\u0004\u0018\u00010=2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#H\u0002\u00a2\u0006\u0002\u0010>J\u0018\u0010?\u001a\u00020!2\u0006\u0010<\u001a\u00020=2\u0006\u0010&\u001a\u00020'H\u0002J-\u0010@\u001a\u00020!2\b\u0010<\u001a\u0004\u0018\u00010=2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#2\u0006\u0010&\u001a\u00020'H\u0002\u00a2\u0006\u0002\u0010AJ(\u0010B\u001a\u00020!2\u0006\u0010C\u001a\u00020\t2\u0006\u0010D\u001a\u00020\t2\u0006\u0010E\u001a\u00020\t2\u0006\u0010F\u001a\u00020\tH\u0002J\u0010\u0010G\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010H\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010I\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#H\u0002J\u001e\u0010J\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010K\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002J\u001e\u0010L\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010M\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#H\u0002J\u0010\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0002J\u0010\u0010R\u001a\u00020\t2\u0006\u0010:\u001a\u00020\u0013H\u0002J\u001c\u0010S\u001a\u00020O2\u0006\u0010:\u001a\u00020\u00132\n\u0010T\u001a\u000601R\u00020\u0000H\u0002J\u0010\u0010U\u001a\u00020\t2\u0006\u0010:\u001a\u00020\u0013H\u0002J\u0018\u0010V\u001a\u00020\t2\u0006\u0010:\u001a\u00020\u00132\u0006\u0010W\u001a\u00020=H\u0002J\u0010\u0010X\u001a\u00020\t2\u0006\u0010:\u001a\u00020\u0013H\u0002J\u0016\u0010Y\u001a\u00020\t2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00130#H\u0002J\u0010\u0010[\u001a\u00020\t2\u0006\u0010\\\u001a\u00020\fH\u0002J\b\u0010]\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00160\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lavail/tools/bootstrap/BootstrapGenerator;", "", "locale", "Ljava/util/Locale;", "(Ljava/util/Locale;)V", "errorCodeBundle", "Ljava/util/ResourceBundle;", "errorCodesByName", "", "", "Lavail/exceptions/AvailErrorCode;", "namesBySpecialObject", "Lavail/descriptor/representation/A_BasicObject;", "preamble", "getPreamble", "()Ljava/util/ResourceBundle;", "primitiveBundle", "primitiveNameMap", "", "Lavail/interpreter/Primitive;", "specialObjectBundle", "specialObjectsByName", "Lavail/descriptor/representation/AvailObject;", "block", "declarations", "statements", "returnType", "errorCodeName", "numericCode", "Lavail/descriptor/numbers/A_Number;", "errorCodesNamesString", "exceptionName", "generate", "", "versions", "", "generateErrorCodesModule", "generateErrorCodesModuleBody", "writer", "Ljava/io/PrintWriter;", "generateErrorCodesModulePreamble", "generateInvokePrimitiveFailureFunctionMethod", "generateMethod", "name", "generateOriginModule", "generateOriginModulePreamble", "generatePrimitiveCoverageTestModules", "testPackageMap", "", "Lavail/tools/bootstrap/BootstrapGenerator$TestPackage;", "generatePrimitiveCoverageTestPackage", "generatePrimitiveCoverageTestRepresentativeModule", "generatePrimitiveEnumMethod", "generatePrimitiveFailureFunction", "generatePrimitiveFailureFunctionGetter", "generatePrimitiveFailureFunctionSetter", "generatePrimitiveFailureMethod", "generatePrimitiveMethod", "primitive", "generatePrimitiveModule", "fallible", "", "(Ljava/lang/Boolean;Ljava/util/List;)V", "generatePrimitiveModuleBody", "generatePrimitiveModulePreamble", "(Ljava/lang/Boolean;Ljava/util/List;Ljava/io/PrintWriter;)V", "generatePrimitiveTestCommonModule", "targetDirectory", "versionString", "names", "body", "generatePrimitiveToSetMethod", "generatePrivateSemanticRestrictionMethod", "generateRepresentativeModule", "generateRepresentativeModulePreamble", "generateSpecialObjectModuleBody", "generateSpecialObjectModulePreamble", "generateSpecialObjectsModule", "moduleFileName", "Ljava/io/File;", "key", "Lavail/tools/bootstrap/Resources$Key;", "primitiveComment", "primitiveCoverageTestModuleFileName", "testPackage", "primitiveCoverageTestModuleName", "primitiveMethodParameterDeclarations", "forSemanticRestriction", "primitiveMethodStatements", "primitivesNamesString", "primitives", "specialObjectName", "specialObject", "specialObjectsNamesString", "Companion", "TestPackage", "avail"})
@SourceDebugExtension(value={"SMAP\nBootstrapGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BootstrapGenerator.kt\navail/tools/bootstrap/BootstrapGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,2116:1\n1855#2,2:2117\n1855#2,2:2119\n1855#2,2:2121\n1855#2,2:2123\n1855#2,2:2125\n1855#2,2:2127\n1045#2:2129\n1045#2:2130\n1855#2,2:2131\n1855#2,2:2135\n1045#2:2137\n1855#2,2:2138\n1549#2:2140\n1620#2,3:2141\n1045#2:2144\n1855#2,2:2145\n1855#2,2:2147\n13309#3,2:2133\n*S KotlinDebug\n*F\n+ 1 BootstrapGenerator.kt\navail/tools/bootstrap/BootstrapGenerator\n*L\n1955#1:2117,2\n1970#1:2119,2\n1980#1:2121,2\n481#1:2123,2\n535#1:2125,2\n592#1:2127,2\n780#1:2129\n931#1:2130\n1355#1:2131,2\n1721#1:2135,2\n1727#1:2137\n1730#1:2138,2\n1828#1:2140\n1828#1:2141,3\n1829#1:2144\n1830#1:2145,2\n1890#1:2147,2\n1458#1:2133,2\n*E\n"})
public final class BootstrapGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Locale locale;
    @NotNull
    private final ResourceBundle preamble;
    @NotNull
    private final ResourceBundle specialObjectBundle;
    @NotNull
    private final ResourceBundle primitiveBundle;
    @NotNull
    private final ResourceBundle errorCodeBundle;
    @NotNull
    private final Map<String, AvailObject> specialObjectsByName;
    @NotNull
    private final Map<A_BasicObject, String> namesBySpecialObject;
    @NotNull
    private final Map<String, Set<Primitive>> primitiveNameMap;
    @NotNull
    private final Map<String, AvailErrorCode> errorCodesByName;
    @NotNull
    private static final Map<A_BasicObject, Integer> specialObjectIndexMap = new LinkedHashMap();

    public BootstrapGenerator(@NotNull Locale locale) {
        String value;
        Intrinsics.checkNotNullParameter(locale, "locale");
        this.locale = locale;
        this.specialObjectsByName = new LinkedHashMap();
        this.namesBySpecialObject = new LinkedHashMap();
        this.primitiveNameMap = new LinkedHashMap();
        this.errorCodesByName = new LinkedHashMap();
        UTF8ResourceBundleControl control = new UTF8ResourceBundleControl();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(Resources.INSTANCE.getPreambleBaseName(), this.locale, BootstrapGenerator.class.getClassLoader(), control);
        Intrinsics.checkNotNullExpressionValue(resourceBundle, "getBundle(...)");
        this.preamble = resourceBundle;
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle(Resources.INSTANCE.getSpecialObjectsBaseName(), this.locale, BootstrapGenerator.class.getClassLoader(), control);
        Intrinsics.checkNotNullExpressionValue(resourceBundle2, "getBundle(...)");
        this.specialObjectBundle = resourceBundle2;
        ResourceBundle resourceBundle3 = ResourceBundle.getBundle(Resources.INSTANCE.getPrimitivesBaseName(), this.locale, BootstrapGenerator.class.getClassLoader(), control);
        Intrinsics.checkNotNullExpressionValue(resourceBundle3, "getBundle(...)");
        this.primitiveBundle = resourceBundle3;
        ResourceBundle resourceBundle4 = ResourceBundle.getBundle(Resources.INSTANCE.getErrorCodesBaseName(), this.locale, BootstrapGenerator.class.getClassLoader(), control);
        Intrinsics.checkNotNullExpressionValue(resourceBundle4, "getBundle(...)");
        this.errorCodeBundle = resourceBundle4;
        Iterable $this$forEach$iv = CollectionsKt.getIndices((Collection)AvailRuntime.Companion.getSpecialObjects());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int i2 = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            AvailObject specialObject = AvailRuntime.Companion.getSpecialObjects().get(i2);
            if (!specialObject.getNotNil()) continue;
            String key = Resources.INSTANCE.specialObjectKey(i2);
            String value2 = this.specialObjectBundle.getString(key);
            Intrinsics.checkNotNull(value2);
            if (!(((CharSequence)value2).length() > 0)) continue;
            this.specialObjectsByName.put(value2, specialObject);
            this.namesBySpecialObject.put(specialObject, value2);
        }
        $this$forEach$iv = BootstrapGenerator.Companion.primitives(null);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Primitive primitive2 = (Primitive)element$iv;
            boolean bl = false;
            value = this.primitiveBundle.getString(primitive2.getSimpleName());
            Intrinsics.checkNotNull(value);
            if (!(((CharSequence)value).length() > 0)) continue;
            this.primitiveNameMap.computeIfAbsent(value, arg_0 -> BootstrapGenerator.lambda$53$lambda$52(2.1.INSTANCE, arg_0)).add(primitive2);
        }
        $this$forEach$iv = BootstrapGenerator.Companion.errorCodes();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AvailErrorCode code = (AvailErrorCode)((Object)element$iv);
            boolean bl = false;
            value = this.errorCodeBundle.getString(Resources.INSTANCE.errorCodeKey(code));
            Intrinsics.checkNotNull(value);
            if (!(((CharSequence)value).length() > 0)) continue;
            this.errorCodesByName.put(value, code);
        }
    }

    @NotNull
    public final ResourceBundle getPreamble() {
        return this.preamble;
    }

    private final String errorCodeName(A_Number numericCode) {
        AvailErrorCode code = AvailErrorCode.Companion.byNumericCode(A_Number.Companion.getExtractInt(numericCode));
        if (code == null) {
            String string2 = "no %s for %s";
            Object[] objectArray = new Object[]{AvailErrorCode.class.getSimpleName(), numericCode};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            String string4 = string3;
            throw new IllegalStateException(string4.toString());
        }
        String string5 = this.errorCodeBundle.getString(Resources.INSTANCE.errorCodeKey(code));
        Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
        return string5;
    }

    private final String exceptionName(A_Number numericCode) {
        AvailErrorCode code = AvailErrorCode.Companion.byNumericCode(A_Number.Companion.getExtractInt(numericCode));
        if (code == null) {
            String string2 = "no %s for %s";
            Object[] objectArray = new Object[]{AvailErrorCode.class.getSimpleName(), numericCode};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            String string4 = string3;
            throw new IllegalStateException(string4.toString());
        }
        String string5 = this.errorCodeBundle.getString(Resources.INSTANCE.errorCodeExceptionKey(code));
        Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
        return string5;
    }

    private final File moduleFileName(Resources.Key key) {
        String string2 = "%s/%s/%s/%s.avail/%s.avail";
        Object[] objectArray = new Object[]{"src/main/resources", StringsKt.replace$default(Resources.INSTANCE.getGeneratedPackageName(), '.', '/', false, 4, null), this.locale.getLanguage(), this.preamble.getString("representativeModuleName"), this.preamble.getString(key.name())};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
        return new File(string3);
    }

    private final void generateOriginModulePreamble(List<String> versions, PrintWriter writer) {
        String string2 = this.preamble.getString("availCopyright");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        Object[] objectArray = new Object[]{this.preamble.getString("originModuleName"), new Date()};
        writer.println(Companion.checkedFormat(string2, objectArray));
        String string3 = this.preamble.getString("generatedModuleNotice");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        objectArray = new Object[]{BootstrapGenerator.class.getName(), new Date()};
        writer.println(Companion.checkedFormat(string3, objectArray));
        String string4 = this.preamble.getString("originModuleHeader");
        Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
        objectArray = new Object[]{this.preamble.getString("originModuleName"), BootstrapGenerator.Companion.moduleVersionString(versions), BootstrapGenerator.Companion.vmVersionString(versions), this.preamble.getString("bootstrapDefiningMethod"), this.preamble.getString("bootstrapSpecialObject"), this.preamble.getString("bootstrapDefineSpecialObjectMacro"), this.preamble.getString("bootstrapMacroNames"), this.preamble.getString("bootstrapMacros")};
        writer.println(Companion.checkedFormat(string4, objectArray));
    }

    private final String specialObjectName(A_BasicObject specialObject) {
        String string2 = this.namesBySpecialObject.get(specialObject);
        if (string2 == null) {
            throw new IllegalStateException(("no special object for " + specialObject).toString());
        }
        return string2;
    }

    private final String specialObjectsNamesString() {
        StringBuilder stringBuilder;
        StringBuilder $this$specialObjectsNamesString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)this.specialObjectsByName.keySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl2 = false;
            A_BasicObject specialObject = this.specialObjectsByName.get(name);
            $this$specialObjectsNamesString_u24lambda_u241.append("\n\t");
            String string2 = "/* %3d */";
            Object[] objectArray = new Object[]{specialObjectIndexMap.get(specialObject)};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            $this$specialObjectsNamesString_u24lambda_u241.append(string3);
            $this$specialObjectsNamesString_u24lambda_u241.append(" \"");
            $this$specialObjectsNamesString_u24lambda_u241.append(name);
            $this$specialObjectsNamesString_u24lambda_u241.append("\",");
        }
        $this$specialObjectsNamesString_u24lambda_u241.setLength($this$specialObjectsNamesString_u24lambda_u241.length() - 1);
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    private final void generateSpecialObjectModulePreamble(List<String> versions, PrintWriter writer) {
        String string2 = this.preamble.getString("availCopyright");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        Object[] objectArray = new Object[]{this.preamble.getString("specialObjectsModuleName"), new Date()};
        writer.println(Companion.checkedFormat(string2, objectArray));
        String string3 = this.preamble.getString("generatedModuleNotice");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        objectArray = new Object[]{BootstrapGenerator.class.getName(), new Date()};
        writer.println(Companion.checkedFormat(string3, objectArray));
        String string4 = this.preamble.getString("generalModuleHeader");
        Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
        objectArray = new Object[5];
        objectArray[0] = this.preamble.getString("specialObjectsModuleName");
        objectArray[1] = BootstrapGenerator.Companion.moduleVersionString(versions);
        String string5 = "%n\t\"%s\"";
        Object[] objectArray2 = new Object[]{this.preamble.getString("originModuleName")};
        Intrinsics.checkNotNullExpressionValue(String.format(string5, Arrays.copyOf(objectArray2, objectArray2.length)), "format(format, *args)");
        objectArray[3] = "";
        objectArray[4] = this.specialObjectsNamesString();
        writer.println(Companion.checkedFormat(string4, objectArray));
    }

    private final void generateSpecialObjectModuleBody(PrintWriter writer) {
        Iterable $this$forEach$iv = CollectionsKt.getIndices((Collection)AvailRuntime.Companion.getSpecialObjects());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            String notAlphaKey;
            int i2;
            block8: {
                block7: {
                    int element$iv;
                    i2 = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl = false;
                    if (!AvailRuntime.Companion.getSpecialObjects().get(i2).getNotNil()) continue;
                    notAlphaKey = Resources.INSTANCE.specialObjectKey(i2);
                    if (!this.specialObjectBundle.containsKey(notAlphaKey)) break block7;
                    String string2 = this.specialObjectBundle.getString(notAlphaKey);
                    Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
                    if (!(((CharSequence)string2).length() == 0)) break block8;
                }
                System.err.println("missing key/value: " + notAlphaKey);
                continue;
            }
            String methodName = this.specialObjectBundle.getString(notAlphaKey);
            String typeKey = Resources.INSTANCE.specialObjectTypeKey(i2);
            String commentKey = Resources.INSTANCE.specialObjectCommentKey(i2);
            if (this.specialObjectBundle.containsKey(commentKey)) {
                String commentTemplate = this.specialObjectBundle.getString(commentKey);
                String type2 = this.specialObjectBundle.getString(typeKey);
                Intrinsics.checkNotNull(type2);
                if (((CharSequence)type2).length() == 0) {
                    Intrinsics.checkNotNull(commentTemplate);
                    var14_14 = new Object[]{methodName};
                    writer.print(Companion.checkedFormat(commentTemplate, var14_14));
                } else {
                    Intrinsics.checkNotNull(commentTemplate);
                    var14_14 = new Object[]{methodName, type2};
                    writer.print(Companion.checkedFormat(commentTemplate, var14_14));
                }
            }
            String string3 = this.preamble.getString("specialObjectUse");
            Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
            Object[] objectArray = new Object[]{i2};
            String use = Companion.checkedFormat(string3, objectArray);
            String string4 = this.preamble.getString("definingSpecialObjectUse");
            Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
            objectArray = new Object[2];
            Intrinsics.checkNotNull(methodName);
            objectArray[0] = Resources.INSTANCE.stringify(methodName);
            objectArray[1] = use;
            writer.println(Companion.checkedFormat(string4, objectArray));
            writer.println();
        }
    }

    private final String primitivesNamesString(List<? extends Primitive> primitives) {
        StringBuilder stringBuilder;
        StringBuilder $this$primitivesNamesString_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Set wanted = CollectionsKt.toSet((Iterable)primitives);
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)this.primitiveNameMap.keySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl2 = false;
            Set<Primitive> set2 = this.primitiveNameMap.get(name);
            Intrinsics.checkNotNull(set2);
            Set set3 = CollectionsKt.intersect((Iterable)set2, wanted);
            if (!(!((Collection)set3).isEmpty())) continue;
            $this$primitivesNamesString_u24lambda_u244.append("\n\t\"");
            $this$primitivesNamesString_u24lambda_u244.append(name);
            $this$primitivesNamesString_u24lambda_u244.append("\",");
        }
        $this$primitivesNamesString_u24lambda_u244.setLength($this$primitivesNamesString_u24lambda_u244.length() - 1);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private final void generatePrimitiveModulePreamble(Boolean fallible, List<String> versions, PrintWriter writer) {
        Object[] objectArray;
        StringBuilder stringBuilder;
        Resources.Key key = fallible == null ? Resources.Key.primitivesModuleName : (fallible != false ? Resources.Key.falliblePrimitivesModuleName : Resources.Key.infalliblePrimitivesModuleName);
        String string2 = this.preamble.getString("availCopyright");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        Object[] objectArray2 = new Object[]{this.preamble.getString(key.name()), new Date()};
        writer.println(Companion.checkedFormat(string2, objectArray2));
        String string3 = this.preamble.getString("generatedModuleNotice");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        objectArray2 = new Object[]{BootstrapGenerator.class.getName(), new Date()};
        writer.println(Companion.checkedFormat(string3, objectArray2));
        StringBuilder $this$generatePrimitiveModulePreamble_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generatePrimitiveModulePreamble_u24lambda_u245.append("\n\t\"");
        $this$generatePrimitiveModulePreamble_u24lambda_u245.append(this.preamble.getString("originModuleName"));
        $this$generatePrimitiveModulePreamble_u24lambda_u245.append('\"');
        if (fallible != null) {
            if (Intrinsics.areEqual(Boolean.TRUE, fallible)) {
                $this$generatePrimitiveModulePreamble_u24lambda_u245.append(",\n\t\"");
                $this$generatePrimitiveModulePreamble_u24lambda_u245.append(this.preamble.getString("errorCodesModuleName"));
                $this$generatePrimitiveModulePreamble_u24lambda_u245.append("\"");
            }
            $this$generatePrimitiveModulePreamble_u24lambda_u245.append(",\n\t\"");
            $this$generatePrimitiveModulePreamble_u24lambda_u245.append(this.preamble.getString("specialObjectsModuleName"));
            $this$generatePrimitiveModulePreamble_u24lambda_u245.append("\",\n\t\"");
            $this$generatePrimitiveModulePreamble_u24lambda_u245.append(this.preamble.getString("primitivesModuleName"));
            $this$generatePrimitiveModulePreamble_u24lambda_u245.append("\" =\n\t(");
            $this$generatePrimitiveModulePreamble_u24lambda_u245.append(StringsKt.replace$default(this.primitivesNamesString(BootstrapGenerator.Companion.primitives(fallible)), "\t", "\t\t", false, 4, null));
            $this$generatePrimitiveModulePreamble_u24lambda_u245.append("\n\t)");
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "StringBuilder().apply(builderAction).toString()");
        String uses2 = string4;
        Object[] $this$generatePrimitiveModulePreamble_u24lambda_u246 = objectArray = new StringBuilder();
        boolean bl2 = false;
        if (fallible == null) {
            $this$generatePrimitiveModulePreamble_u24lambda_u246.append(this.primitivesNamesString(BootstrapGenerator.Companion.primitives(null)));
        } else if (Intrinsics.areEqual(Boolean.TRUE, fallible)) {
            $this$generatePrimitiveModulePreamble_u24lambda_u246.append("\n\t");
            String string5 = this.preamble.getString("primitiveFailureFunctionGetterMethod");
            Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
            $this$generatePrimitiveModulePreamble_u24lambda_u246.append(Resources.INSTANCE.stringify(string5));
            $this$generatePrimitiveModulePreamble_u24lambda_u246.append(",\n\t");
            String string6 = this.preamble.getString("primitiveFailureFunctionSetterMethod");
            Intrinsics.checkNotNullExpressionValue(string6, "getString(...)");
            $this$generatePrimitiveModulePreamble_u24lambda_u246.append(Resources.INSTANCE.stringify(string6));
        }
        String string7 = objectArray.toString();
        Intrinsics.checkNotNullExpressionValue(string7, "StringBuilder().apply(builderAction).toString()");
        String names = string7;
        String string8 = this.preamble.getString("generalModuleHeader");
        Intrinsics.checkNotNullExpressionValue(string8, "getString(...)");
        objectArray = new Object[]{this.preamble.getString(key.name()), BootstrapGenerator.Companion.moduleVersionString(versions), "", uses2, names};
        writer.println(Companion.checkedFormat(string8, objectArray));
    }

    private final String primitiveMethodParameterDeclarations(Primitive primitive2, boolean forSemanticRestriction) {
        StringBuilder stringBuilder;
        A_Type functionType = primitive2.blockTypeRestriction();
        A_Type parameterTypes = A_Type.Companion.getArgsTupleType(functionType);
        A_Type parameterCount = A_Type.Companion.getSizeRange(parameterTypes);
        boolean bl = A_Type.Companion.getLowerBound(parameterCount).equals(A_Type.Companion.getUpperBound(parameterCount));
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-BootstrapGenerator$primitiveMethodParameterDeclarations$22 = false;
            String string2 = "Expected %s to have a fixed parameter count";
            Object[] objectArray = new Object[]{primitive2.getSimpleName()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            String $i$a$-assert-BootstrapGenerator$primitiveMethodParameterDeclarations$22 = string3;
            throw new AssertionError((Object)$i$a$-assert-BootstrapGenerator$primitiveMethodParameterDeclarations$22);
        }
        StringBuilder $this$primitiveMethodParameterDeclarations_u24lambda_u249 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        int i2 = 0;
        int end = A_Number.Companion.getExtractInt(A_Type.Companion.getLowerBound(parameterCount));
        for (i2 = 1; i2 <= end; ++i2) {
            Object object;
            String argNameKey = Resources.INSTANCE.primitiveParameterNameKey(primitive2, i2);
            if (this.primitiveBundle.containsKey(argNameKey)) {
                Object object2;
                String localized = this.primitiveBundle.getString(argNameKey);
                CharSequence charSequence = localized;
                if (charSequence.length() == 0) {
                    boolean bl3 = false;
                    object2 = this.preamble.getString("parameterPrefix") + i2;
                } else {
                    object2 = charSequence;
                }
                object = (String)object2;
            } else {
                object = this.preamble.getString("parameterPrefix") + i2;
            }
            String argName = object;
            A_Type type2 = A_Type.Companion.typeAtIndex(parameterTypes, i2);
            A_Type paramType = forSemanticRestriction ? InstanceMetaDescriptor.Companion.instanceMeta(type2) : type2;
            String typeName = this.specialObjectName(paramType);
            $this$primitiveMethodParameterDeclarations_u24lambda_u249.append('\t');
            $this$primitiveMethodParameterDeclarations_u24lambda_u249.append(argName);
            $this$primitiveMethodParameterDeclarations_u24lambda_u249.append(" : ");
            $this$primitiveMethodParameterDeclarations_u24lambda_u249.append(typeName);
            if (i2 != end) {
                $this$primitiveMethodParameterDeclarations_u24lambda_u249.append(',');
            }
            $this$primitiveMethodParameterDeclarations_u24lambda_u249.append('\n');
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    private final String primitiveMethodStatements(Primitive primitive2) {
        StringBuilder stringBuilder;
        StringBuilder $this$primitiveMethodStatements_u24lambda_u2412 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$primitiveMethodStatements_u24lambda_u2412.append('\t');
        $this$primitiveMethodStatements_u24lambda_u2412.append(this.preamble.getString("primitiveKeyword"));
        $this$primitiveMethodStatements_u24lambda_u2412.append(' ');
        $this$primitiveMethodStatements_u24lambda_u2412.append(primitive2.getName());
        if (!primitive2.hasFlag(Primitive.Flag.CannotFail)) {
            $this$primitiveMethodStatements_u24lambda_u2412.append(" (");
            $this$primitiveMethodStatements_u24lambda_u2412.append(this.preamble.getString("primitiveFailureVariableName"));
            $this$primitiveMethodStatements_u24lambda_u2412.append(" : ");
            A_Type varType = primitive2.getFailureVariableType();
            if (varType.isEnumeration()) {
                if (A_Type.Companion.isSubtypeOf(varType, IntegerRangeTypeDescriptor.Companion.getNaturalNumbers())) {
                    $this$primitiveMethodStatements_u24lambda_u2412.append("{");
                    Iterable $this$sortedBy$iv = A_Type.Companion.getInstances(varType);
                    boolean $i$f$sortedBy = false;
                    List<AvailObject> codes = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                        public final int compare(T a, T b) {
                            AvailObject it = (AvailObject)a;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(A_Number.Companion.getExtractInt(it));
                            it = (AvailObject)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues(comparable2, A_Number.Companion.getExtractInt(it));
                        }
                    });
                    for (AvailObject code : codes) {
                        String errorCodeName = this.errorCodeName(code);
                        $this$primitiveMethodStatements_u24lambda_u2412.append("\n\t\t");
                        $this$primitiveMethodStatements_u24lambda_u2412.append(errorCodeName);
                        $this$primitiveMethodStatements_u24lambda_u2412.append(',');
                    }
                    $this$primitiveMethodStatements_u24lambda_u2412.setLength($this$primitiveMethodStatements_u24lambda_u2412.length() - 1);
                    $this$primitiveMethodStatements_u24lambda_u2412.append("}\u1d40");
                } else {
                    $this$primitiveMethodStatements_u24lambda_u2412.append(this.specialObjectName(PrimitiveTypeDescriptor.Types.ANY.getO()));
                }
            } else {
                $this$primitiveMethodStatements_u24lambda_u2412.append(this.specialObjectName(varType));
            }
            $this$primitiveMethodStatements_u24lambda_u2412.append(')');
        }
        $this$primitiveMethodStatements_u24lambda_u2412.append(";\n");
        if (!primitive2.hasFlag(Primitive.Flag.CannotFail)) {
            $this$primitiveMethodStatements_u24lambda_u2412.append('\t');
            if (primitive2.hasFlag(Primitive.Flag.CatchException)) {
                Object object;
                Object object2;
                String argNameKey = Resources.INSTANCE.primitiveParameterNameKey(primitive2, 1);
                if (this.primitiveBundle.containsKey(argNameKey)) {
                    Object object3;
                    object2 = (Object[])this.primitiveBundle.getString(argNameKey);
                    if (object2.length() == 0) {
                        boolean bl2 = false;
                        object3 = this.preamble.getString("parameterPrefix") + "1";
                    } else {
                        object3 = object2;
                    }
                    object = (String)object3;
                } else {
                    object = this.preamble.getString("parameterPrefix") + "1";
                }
                String argName = object;
                String string2 = this.preamble.getString("invokePrimitiveFailureFunctionMethodUse");
                Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
                object2 = new Object[]{argName, this.namesBySpecialObject.get(TupleDescriptor.Companion.getEmptyTuple())};
                $this$primitiveMethodStatements_u24lambda_u2412.append(Companion.checkedFormat(string2, (Object[])object2));
            } else {
                String string3 = this.preamble.getString("invokePrimitiveFailureFunctionMethodUse");
                Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
                Object[] objectArray = new Object[]{this.preamble.getString("primitiveFailureFunctionName"), this.preamble.getString("primitiveFailureVariableName")};
                $this$primitiveMethodStatements_u24lambda_u2412.append(Companion.checkedFormat(string3, objectArray));
            }
            $this$primitiveMethodStatements_u24lambda_u2412.append("\n");
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    private final String block(String declarations, String statements, A_BasicObject returnType) {
        StringBuilder stringBuilder;
        StringBuilder $this$block_u24lambda_u2413 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$block_u24lambda_u2413.append("\n[\n");
        $this$block_u24lambda_u2413.append(declarations);
        if (((CharSequence)declarations).length() > 0) {
            $this$block_u24lambda_u2413.append("|\n");
        }
        $this$block_u24lambda_u2413.append(statements);
        $this$block_u24lambda_u2413.append(']');
        if (returnType != null) {
            $this$block_u24lambda_u2413.append(" : ");
            $this$block_u24lambda_u2413.append(this.specialObjectName(returnType));
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private final String primitiveComment(Primitive primitive2) {
        StringBuilder stringBuilder;
        StringBuilder $this$primitiveComment_u24lambda_u2416 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String commentKey = Resources.INSTANCE.primitiveCommentKey(primitive2);
        if (this.primitiveBundle.containsKey(commentKey)) {
            int primitiveArgCount = primitive2.getArgCount();
            int templateArgCount = 2 + (primitiveArgCount << 1) + (primitive2.hasFlag(Primitive.Flag.CannotFail) ? 0 : (primitive2.getFailureVariableType().isEnumeration() ? A_Number.Companion.getExtractInt(A_Type.Companion.getInstanceCount(primitive2.getFailureVariableType())) : 1));
            Object[] formatArgs = new Object[templateArgCount];
            formatArgs[0] = this.primitiveBundle.getString(primitive2.getSimpleName());
            A_Type paramsType = A_Type.Companion.getArgsTupleType(primitive2.blockTypeRestriction());
            int i2 = 1;
            if (i2 <= primitiveArgCount) {
                while (true) {
                    Object object;
                    String argNameKey;
                    if (this.primitiveBundle.containsKey(argNameKey = Resources.INSTANCE.primitiveParameterNameKey(primitive2, i2))) {
                        Object object2;
                        CharSequence charSequence = this.primitiveBundle.getString(argNameKey);
                        if (charSequence.length() == 0) {
                            boolean bl2 = false;
                            object2 = this.preamble.getString("parameterPrefix") + i2;
                        } else {
                            object2 = charSequence;
                        }
                        object = (String)object2;
                    } else {
                        object = this.preamble.getString("parameterPrefix") + i2;
                    }
                    String argName = object;
                    formatArgs[i2] = argName;
                    formatArgs[i2 + primitiveArgCount] = A_Type.Companion.typeAtIndex(paramsType, i2);
                    if (i2 == primitiveArgCount) break;
                    ++i2;
                }
            }
            formatArgs[(primitiveArgCount << 1) + 1] = A_Type.Companion.getReturnType(primitive2.blockTypeRestriction());
            if (!primitive2.hasFlag(Primitive.Flag.CannotFail)) {
                int raiseIndex = (primitiveArgCount << 1) + 2;
                A_Type varType = primitive2.getFailureVariableType();
                if (varType.isEnumeration()) {
                    if (A_Type.Companion.isSubtypeOf(varType, IntegerRangeTypeDescriptor.Companion.getNaturalNumbers())) {
                        A_Set instances = A_Type.Companion.getInstances(varType);
                        Iterable $this$sortedBy$iv = instances;
                        boolean $i$f$sortedBy = false;
                        for (AvailObject code : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                            public final int compare(T a, T b) {
                                AvailObject it = (AvailObject)a;
                                boolean bl = false;
                                Comparable comparable = Integer.valueOf(A_Number.Companion.getExtractInt(it));
                                it = (AvailObject)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues(comparable2, A_Number.Companion.getExtractInt(it));
                            }
                        })) {
                            formatArgs[raiseIndex++] = this.exceptionName(code);
                        }
                    } else {
                        formatArgs[raiseIndex] = this.specialObjectName(PrimitiveTypeDescriptor.Types.ANY.getO());
                    }
                } else {
                    formatArgs[raiseIndex] = this.specialObjectName(varType);
                }
            }
            Object[] messagePattern = this.primitiveBundle.getString(commentKey);
            boolean inQuotes = false;
            boolean sawBraces = false;
            boolean isEmpty = true;
            Intrinsics.checkNotNull(messagePattern);
            Object[] objectArray = messagePattern;
            int n = objectArray.length();
            for (int j = 0; j < n; ++j) {
                char element = objectArray.charAt(j);
                char c = element;
                if (c == '\'') {
                    if (inQuotes && !sawBraces && !isEmpty) {
                        Object[] objectArray2 = new Object[]{commentKey};
                        System.err.format("Malformed primitive comment (%s) \u2013 Single-quoted section was not empty but did not contain any brace brackets ('{' or '}').%n", objectArray2);
                    }
                    inQuotes = !inQuotes;
                    sawBraces = false;
                    isEmpty = true;
                    continue;
                }
                if (c == '{' ? true : c == '}') {
                    sawBraces = true;
                    isEmpty = false;
                    continue;
                }
                isEmpty = false;
            }
            if (inQuotes) {
                objectArray = new Object[]{commentKey};
                System.err.format("Malformed primitive comment (%s) \u2013 contains unclosed single-quote character%n", objectArray);
            }
            $this$primitiveComment_u24lambda_u2416.append(Companion.checkedFormat((String)messagePattern, Arrays.copyOf(formatArgs, formatArgs.length)));
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private final void generateMethod(String name, String block, PrintWriter writer) {
        PrintWriter $this$generateMethod_u24lambda_u2417 = writer;
        boolean bl = false;
        String string2 = this.preamble.getString("definingMethodUse");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        Object[] objectArray = new Object[]{Resources.INSTANCE.stringify(name), block};
        $this$generateMethod_u24lambda_u2417.print(Companion.checkedFormat(string2, objectArray));
        $this$generateMethod_u24lambda_u2417.println(';');
        $this$generateMethod_u24lambda_u2417.println();
    }

    private final void generatePrimitiveToSetMethod(PrintWriter writer) {
        StringBuilder stringBuilder;
        Primitive primitive2 = P_TupleToSet.INSTANCE;
        StringBuilder $this$generatePrimitiveToSetMethod_u24lambda_u2418 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generatePrimitiveToSetMethod_u24lambda_u2418.append('\t');
        $this$generatePrimitiveToSetMethod_u24lambda_u2418.append(this.preamble.getString("primitiveKeyword"));
        $this$generatePrimitiveToSetMethod_u24lambda_u2418.append(' ');
        $this$generatePrimitiveToSetMethod_u24lambda_u2418.append(primitive2.getName());
        $this$generatePrimitiveToSetMethod_u24lambda_u2418.append(";\n");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        String statements = string2;
        String block = this.block(this.primitiveMethodParameterDeclarations(primitive2, false), statements, A_Type.Companion.getReturnType(primitive2.blockTypeRestriction()));
        this.generateMethod("{\u00ab_\u2021,\u00bb}", block, writer);
    }

    private final void generatePrimitiveEnumMethod(PrintWriter writer) {
        StringBuilder stringBuilder;
        P_CreateEnumeration primitive2 = P_CreateEnumeration.INSTANCE;
        StringBuilder $this$generatePrimitiveEnumMethod_u24lambda_u2419 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generatePrimitiveEnumMethod_u24lambda_u2419.append('\t');
        $this$generatePrimitiveEnumMethod_u24lambda_u2419.append(this.preamble.getString("primitiveKeyword"));
        $this$generatePrimitiveEnumMethod_u24lambda_u2419.append(' ');
        $this$generatePrimitiveEnumMethod_u24lambda_u2419.append(primitive2.getName());
        $this$generatePrimitiveEnumMethod_u24lambda_u2419.append(";\n");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        String statements = string2;
        String block = this.block(this.primitiveMethodParameterDeclarations(primitive2, false), statements, A_Type.Companion.getReturnType(primitive2.blockTypeRestriction()));
        this.generateMethod("_\u1d40", block, writer);
    }

    private final void generatePrimitiveFailureMethod(PrintWriter writer) {
        StringBuilder stringBuilder;
        P_EmergencyExit primitive2 = P_EmergencyExit.INSTANCE;
        StringBuilder $this$generatePrimitiveFailureMethod_u24lambda_u2420 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generatePrimitiveFailureMethod_u24lambda_u2420.append('\t');
        $this$generatePrimitiveFailureMethod_u24lambda_u2420.append(this.preamble.getString("primitiveKeyword"));
        $this$generatePrimitiveFailureMethod_u24lambda_u2420.append(' ');
        $this$generatePrimitiveFailureMethod_u24lambda_u2420.append(primitive2.getName());
        $this$generatePrimitiveFailureMethod_u24lambda_u2420.append(";\n");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        String statements = string2;
        String block = this.block(this.primitiveMethodParameterDeclarations(primitive2, false), statements, A_Type.Companion.getReturnType(primitive2.blockTypeRestriction()));
        String string3 = this.preamble.getString("primitiveFailureMethod");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        this.generateMethod(string3, block, writer);
    }

    private final void generatePrimitiveFailureFunction(PrintWriter writer) {
        PrintWriter $this$generatePrimitiveFailureFunction_u24lambda_u2421 = writer;
        boolean bl = false;
        A_Type functionType = FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(IntegerRangeTypeDescriptor.Companion.getNaturalNumbers()), BottomTypeDescriptor.Companion.getBottom(), null, 4, null);
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.print(this.preamble.getString("primitiveFailureFunctionName"));
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.print(" : ");
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.print(this.specialObjectName(functionType));
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.println(" :=");
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.println("\t[");
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.print("\t\t");
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.print(this.preamble.getString("parameterPrefix"));
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.print(1);
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.print(" : ");
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.println(this.specialObjectName(PrimitiveTypeDescriptor.Types.ANY.getO()));
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.println("\t|");
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.print("\t\t");
        String string2 = this.preamble.getString("primitiveFailureMethodUse");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        Object[] objectArray = new Object[]{this.preamble.getString("parameterPrefix") + "1"};
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.print(Companion.checkedFormat(string2, objectArray));
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.println("");
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.print("\t] : ");
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.print(this.specialObjectName(BottomTypeDescriptor.Companion.getBottom()));
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.println(';');
        $this$generatePrimitiveFailureFunction_u24lambda_u2421.println();
    }

    private final void generatePrimitiveFailureFunctionGetter(PrintWriter writer) {
        StringBuilder stringBuilder;
        StringBuilder $this$generatePrimitiveFailureFunctionGetter_u24lambda_u2422 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generatePrimitiveFailureFunctionGetter_u24lambda_u2422.append('\t');
        $this$generatePrimitiveFailureFunctionGetter_u24lambda_u2422.append(this.preamble.getString("primitiveFailureFunctionName"));
        $this$generatePrimitiveFailureFunctionGetter_u24lambda_u2422.append("\n");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        String statements = string2;
        String block = this.block("", statements, FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(IntegerRangeTypeDescriptor.Companion.getNaturalNumbers()), BottomTypeDescriptor.Companion.getBottom(), null, 4, null));
        String string3 = this.preamble.getString("primitiveFailureFunctionGetterMethod");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        this.generateMethod(string3, block, writer);
    }

    private final void generatePrimitiveFailureFunctionSetter(PrintWriter writer) {
        StringBuilder stringBuilder;
        String argName = this.preamble.getString("parameterPrefix") + "1";
        StringBuilder $this$generatePrimitiveFailureFunctionSetter_u24lambda_u2423 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generatePrimitiveFailureFunctionSetter_u24lambda_u2423.append('\t');
        $this$generatePrimitiveFailureFunctionSetter_u24lambda_u2423.append(argName);
        $this$generatePrimitiveFailureFunctionSetter_u24lambda_u2423.append(" : ");
        A_Type functionType = FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(IntegerRangeTypeDescriptor.Companion.getNaturalNumbers()), BottomTypeDescriptor.Companion.getBottom(), null, 4, null);
        $this$generatePrimitiveFailureFunctionSetter_u24lambda_u2423.append(this.specialObjectName(functionType));
        $this$generatePrimitiveFailureFunctionSetter_u24lambda_u2423.append('\n');
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        String declarations = string2;
        StringBuilder $this$generatePrimitiveFailureFunctionSetter_u24lambda_u2424 = $this$generatePrimitiveFailureFunctionSetter_u24lambda_u2423 = new StringBuilder();
        boolean bl2 = false;
        $this$generatePrimitiveFailureFunctionSetter_u24lambda_u2424.append('\t');
        $this$generatePrimitiveFailureFunctionSetter_u24lambda_u2424.append(this.preamble.getString("primitiveFailureFunctionName"));
        $this$generatePrimitiveFailureFunctionSetter_u24lambda_u2424.append(" := ");
        $this$generatePrimitiveFailureFunctionSetter_u24lambda_u2424.append(argName);
        $this$generatePrimitiveFailureFunctionSetter_u24lambda_u2424.append(";\n");
        String string3 = $this$generatePrimitiveFailureFunctionSetter_u24lambda_u2423.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
        String statements = string3;
        String block = this.block(declarations, statements, PrimitiveTypeDescriptor.Types.TOP.getO());
        String string4 = this.preamble.getString("primitiveFailureFunctionSetterMethod");
        Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
        this.generateMethod(string4, block, writer);
    }

    private final void generateInvokePrimitiveFailureFunctionMethod(PrintWriter writer) {
        StringBuilder stringBuilder;
        Primitive primitive2 = P_InvokeWithTuple.INSTANCE;
        StringBuilder $this$generateInvokePrimitiveFailureFunctionMethod_u24lambda_u2425 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generateInvokePrimitiveFailureFunctionMethod_u24lambda_u2425.append('\t');
        $this$generateInvokePrimitiveFailureFunctionMethod_u24lambda_u2425.append(this.preamble.getString("primitiveKeyword"));
        $this$generateInvokePrimitiveFailureFunctionMethod_u24lambda_u2425.append(' ');
        $this$generateInvokePrimitiveFailureFunctionMethod_u24lambda_u2425.append(primitive2.getName());
        $this$generateInvokePrimitiveFailureFunctionMethod_u24lambda_u2425.append(" (");
        $this$generateInvokePrimitiveFailureFunctionMethod_u24lambda_u2425.append(this.preamble.getString("primitiveFailureVariableName"));
        $this$generateInvokePrimitiveFailureFunctionMethod_u24lambda_u2425.append(" : ");
        $this$generateInvokePrimitiveFailureFunctionMethod_u24lambda_u2425.append(this.specialObjectName(primitive2.getFailureVariableType()));
        $this$generateInvokePrimitiveFailureFunctionMethod_u24lambda_u2425.append(')');
        $this$generateInvokePrimitiveFailureFunctionMethod_u24lambda_u2425.append(";\n");
        $this$generateInvokePrimitiveFailureFunctionMethod_u24lambda_u2425.append('\t');
        String string2 = this.preamble.getString("primitiveFailureMethodUse");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        Object[] objectArray = new Object[]{this.preamble.getString("primitiveFailureVariableName")};
        $this$generateInvokePrimitiveFailureFunctionMethod_u24lambda_u2425.append(Companion.checkedFormat(string2, objectArray));
        $this$generateInvokePrimitiveFailureFunctionMethod_u24lambda_u2425.append("\n");
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
        String statements = string3;
        String block = this.block(this.primitiveMethodParameterDeclarations(primitive2, false), statements, PrimitiveTypeDescriptor.Types.TOP.getO());
        String string4 = this.preamble.getString("invokePrimitiveFailureFunctionMethod");
        Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
        this.generateMethod(string4, block, writer);
    }

    private final void generatePrivateSemanticRestrictionMethod(PrintWriter writer) {
        Object[] objectArray;
        StringBuilder stringBuilder;
        Primitive primitive2 = P_AddSemanticRestriction.INSTANCE;
        StringBuilder $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2426 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2426.append('\t');
        $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2426.append(this.preamble.getString("primitiveKeyword"));
        $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2426.append(' ');
        $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2426.append(primitive2.getName());
        $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2426.append(" (");
        $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2426.append(this.preamble.getString("primitiveFailureVariableName"));
        $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2426.append(" : ");
        $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2426.append(this.specialObjectName(IntegerRangeTypeDescriptor.Companion.getNaturalNumbers()));
        $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2426.append(')');
        $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2426.append(";\n");
        $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2426.append('\t');
        String string2 = this.preamble.getString("primitiveFailureMethodUse");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        Object[] objectArray2 = new Object[]{this.preamble.getString("primitiveFailureVariableName")};
        $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2426.append(Companion.checkedFormat(string2, objectArray2));
        $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2426.append("\n");
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
        String statements = string3;
        String block = this.block(this.primitiveMethodParameterDeclarations(primitive2, false), statements, PrimitiveTypeDescriptor.Types.TOP.getO());
        String string4 = this.preamble.getString("primitiveSemanticRestriction");
        Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
        this.generateMethod(string4, block, writer);
        Object[] $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2427 = objectArray = new StringBuilder();
        boolean bl2 = false;
        $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2427.append('\t');
        $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2427.append(this.specialObjectName(BottomTypeDescriptor.Companion.getBottom()));
        $this$generatePrivateSemanticRestrictionMethod_u24lambda_u2427.append("\n");
        String string5 = objectArray.toString();
        Intrinsics.checkNotNullExpressionValue(string5, "StringBuilder().apply(builderAction).toString()");
        statements = string5;
        block = this.block(this.primitiveMethodParameterDeclarations(P_InvokeWithTuple.INSTANCE, true), statements, null);
        String string6 = this.preamble.getString("primitiveSemanticRestrictionUse");
        Intrinsics.checkNotNullExpressionValue(string6, "getString(...)");
        objectArray = new Object[2];
        String string7 = this.preamble.getString("invokePrimitiveFailureFunctionMethod");
        Intrinsics.checkNotNullExpressionValue(string7, "getString(...)");
        objectArray[0] = Resources.INSTANCE.stringify(string7);
        objectArray[1] = block;
        writer.append(Companion.checkedFormat(string6, objectArray));
        writer.println(";\n");
    }

    private final void generatePrimitiveMethod(Primitive primitive2, PrintWriter writer) {
        String name;
        block3: {
            block2: {
                name = primitive2.getSimpleName();
                if (!this.primitiveBundle.containsKey(name)) break block2;
                String string2 = this.primitiveBundle.getString(name);
                Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
                if (!(((CharSequence)string2).length() == 0)) break block3;
            }
            System.err.println("missing key/value: " + name);
            return;
        }
        String comment = this.primitiveComment(primitive2);
        String block = this.block(this.primitiveMethodParameterDeclarations(primitive2, false), this.primitiveMethodStatements(primitive2), A_Type.Companion.getReturnType(primitive2.blockTypeRestriction()));
        writer.print(comment);
        String string3 = this.primitiveBundle.getString(name);
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        this.generateMethod(string3, block, writer);
    }

    private final void generatePrimitiveModuleBody(boolean fallible, PrintWriter writer) {
        if (fallible) {
            this.generatePrimitiveToSetMethod(writer);
            this.generatePrimitiveEnumMethod(writer);
            this.generatePrimitiveFailureMethod(writer);
            this.generatePrimitiveFailureFunction(writer);
            this.generatePrimitiveFailureFunctionGetter(writer);
            this.generatePrimitiveFailureFunctionSetter(writer);
            this.generateInvokePrimitiveFailureFunctionMethod(writer);
            this.generatePrivateSemanticRestrictionMethod(writer);
        }
        for (Primitive primitive2 : BootstrapGenerator.Companion.primitives(fallible)) {
            if (primitive2.hasFlag(Primitive.Flag.Private) || primitive2.hasFlag(Primitive.Flag.Bootstrap)) continue;
            this.generatePrimitiveMethod(primitive2, writer);
        }
    }

    private final String errorCodesNamesString() {
        StringBuilder stringBuilder;
        StringBuilder $this$errorCodesNamesString_u24lambda_u2429 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)this.errorCodesByName.keySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl2 = false;
            AvailErrorCode code = this.errorCodesByName.get(name);
            $this$errorCodesNamesString_u24lambda_u2429.append("\n\t");
            String string2 = "/* %3d */";
            Object[] objectArray = new Object[1];
            AvailErrorCode availErrorCode = code;
            Intrinsics.checkNotNull((Object)availErrorCode);
            objectArray[0] = availErrorCode.nativeCode();
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            $this$errorCodesNamesString_u24lambda_u2429.append(string3);
            $this$errorCodesNamesString_u24lambda_u2429.append(" \"");
            $this$errorCodesNamesString_u24lambda_u2429.append(name);
            $this$errorCodesNamesString_u24lambda_u2429.append("\",");
        }
        $this$errorCodesNamesString_u24lambda_u2429.setLength($this$errorCodesNamesString_u24lambda_u2429.length() - 1);
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    private final void generateErrorCodesModulePreamble(List<String> versions, PrintWriter writer) {
        Object[] objectArray;
        PrintWriter $this$generateErrorCodesModulePreamble_u24lambda_u2431 = writer;
        boolean bl = false;
        String string2 = this.preamble.getString("availCopyright");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        Object[] objectArray2 = new Object[]{this.preamble.getString("errorCodesModuleName"), new Date()};
        $this$generateErrorCodesModulePreamble_u24lambda_u2431.println(Companion.checkedFormat(string2, objectArray2));
        String string3 = this.preamble.getString("generatedModuleNotice");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        objectArray2 = new Object[]{BootstrapGenerator.class.getName(), new Date()};
        $this$generateErrorCodesModulePreamble_u24lambda_u2431.println(Companion.checkedFormat(string3, objectArray2));
        Object[] $this$generateErrorCodesModulePreamble_u24lambda_u2431_u24lambda_u2430 = objectArray = new StringBuilder();
        boolean bl2 = false;
        $this$generateErrorCodesModulePreamble_u24lambda_u2431_u24lambda_u2430.append("\n\t\"");
        $this$generateErrorCodesModulePreamble_u24lambda_u2431_u24lambda_u2430.append(this.preamble.getString("originModuleName"));
        $this$generateErrorCodesModulePreamble_u24lambda_u2431_u24lambda_u2430.append('\"');
        String string4 = objectArray.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "StringBuilder().apply(builderAction).toString()");
        String uses2 = string4;
        String string5 = this.preamble.getString("generalModuleHeader");
        Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
        objectArray = new Object[]{this.preamble.getString("errorCodesModuleName"), BootstrapGenerator.Companion.moduleVersionString(versions), "", uses2, this.errorCodesNamesString()};
        $this$generateErrorCodesModulePreamble_u24lambda_u2431.println(Companion.checkedFormat(string5, objectArray));
    }

    private final void generateErrorCodesModuleBody(PrintWriter writer) {
        for (AvailErrorCode code : BootstrapGenerator.Companion.errorCodes()) {
            String key;
            block6: {
                block5: {
                    key = Resources.INSTANCE.errorCodeKey(code);
                    if (!this.errorCodeBundle.containsKey(key)) break block5;
                    String string2 = this.errorCodeBundle.getString(key);
                    Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
                    if (!(((CharSequence)string2).length() == 0)) break block6;
                }
                System.err.println("missing key/value: " + key);
                continue;
            }
            String commentKey = Resources.INSTANCE.errorCodeCommentKey(code);
            if (this.errorCodeBundle.containsKey(commentKey)) {
                writer.print(this.errorCodeBundle.getString(commentKey));
            }
            String string3 = this.preamble.getString("definingMethodUse");
            Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
            Object[] objectArray = new Object[2];
            String string4 = this.errorCodeBundle.getString(key);
            Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
            objectArray[0] = Resources.INSTANCE.stringify(string4);
            objectArray[1] = "\n[\n\t" + code.nativeCode() + "\n];\n";
            writer.println(Companion.checkedFormat(string3, objectArray));
        }
    }

    private final void generateRepresentativeModulePreamble(List<String> versions, PrintWriter writer) {
        Object[] objectArray;
        PrintWriter $this$generateRepresentativeModulePreamble_u24lambda_u2434 = writer;
        boolean bl = false;
        String string2 = this.preamble.getString("availCopyright");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        Object[] objectArray2 = new Object[]{this.preamble.getString("representativeModuleName"), new Date()};
        $this$generateRepresentativeModulePreamble_u24lambda_u2434.println(Companion.checkedFormat(string2, objectArray2));
        String string3 = this.preamble.getString("generatedModuleNotice");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        objectArray2 = new Object[]{BootstrapGenerator.class.getName(), new Date()};
        $this$generateRepresentativeModulePreamble_u24lambda_u2434.println(Companion.checkedFormat(string3, objectArray2));
        Resources.Key[] keyArray = new Resources.Key[]{Resources.Key.originModuleName, Resources.Key.specialObjectsModuleName, Resources.Key.errorCodesModuleName, Resources.Key.primitivesModuleName, Resources.Key.infalliblePrimitivesModuleName, Resources.Key.falliblePrimitivesModuleName};
        Resources.Key[] keys2 = keyArray;
        Object[] $this$generateRepresentativeModulePreamble_u24lambda_u2434_u24lambda_u2433 = objectArray = new StringBuilder();
        boolean bl2 = false;
        Resources.Key[] $this$forEach$iv = keys2;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            Resources.Key element$iv;
            Resources.Key key = element$iv = $this$forEach$iv[j];
            boolean bl3 = false;
            $this$generateRepresentativeModulePreamble_u24lambda_u2434_u24lambda_u2433.append("\n\t\"");
            $this$generateRepresentativeModulePreamble_u24lambda_u2434_u24lambda_u2433.append(this.preamble.getString(key.name()));
            $this$generateRepresentativeModulePreamble_u24lambda_u2434_u24lambda_u2433.append("\",");
        }
        $this$generateRepresentativeModulePreamble_u24lambda_u2434_u24lambda_u2433.setLength($this$generateRepresentativeModulePreamble_u24lambda_u2434_u24lambda_u2433.length() - 1);
        String string4 = objectArray.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "StringBuilder().apply(builderAction).toString()");
        String extendedString = string4;
        String string5 = this.preamble.getString("generalModuleHeader");
        Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
        objectArray = new Object[]{this.preamble.getString("representativeModuleName"), BootstrapGenerator.Companion.moduleVersionString(versions), extendedString, "", ""};
        writer.println(Companion.checkedFormat(string5, objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateOriginModule(List<String> versions) throws IOException {
        File fileName = this.moduleFileName(Resources.Key.originModuleName);
        String string2 = fileName.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "getPath(...)");
        boolean bl = StringsKt.endsWith$default(string2, ".avail", false, 2, null);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        Closeable closeable = new PrintWriter(fileName, StandardCharsets.UTF_8.name());
        Throwable throwable = null;
        try {
            PrintWriter it = (PrintWriter)closeable;
            boolean bl2 = false;
            this.generateOriginModulePreamble(versions, it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateSpecialObjectsModule(List<String> versions) throws IOException {
        File fileName = this.moduleFileName(Resources.Key.specialObjectsModuleName);
        String string2 = fileName.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "getPath(...)");
        boolean bl = StringsKt.endsWith$default(string2, ".avail", false, 2, null);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        Closeable closeable = new PrintWriter(fileName, StandardCharsets.UTF_8.name());
        Throwable throwable = null;
        try {
            PrintWriter it = (PrintWriter)closeable;
            boolean bl2 = false;
            this.generateSpecialObjectModulePreamble(versions, it);
            this.generateSpecialObjectModuleBody(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generatePrimitiveModule(Boolean fallible, List<String> versions) throws IOException {
        Resources.Key key = fallible == null ? Resources.Key.primitivesModuleName : (fallible != false ? Resources.Key.falliblePrimitivesModuleName : Resources.Key.infalliblePrimitivesModuleName);
        File fileName = this.moduleFileName(key);
        String string2 = fileName.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "getPath(...)");
        boolean bl = StringsKt.endsWith$default(string2, ".avail", false, 2, null);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        Closeable closeable = new PrintWriter(fileName, StandardCharsets.UTF_8.name());
        Throwable throwable = null;
        try {
            PrintWriter it = (PrintWriter)closeable;
            boolean bl2 = false;
            this.generatePrimitiveModulePreamble(fallible, versions, it);
            if (fallible != null) {
                this.generatePrimitiveModuleBody(fallible, it);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateErrorCodesModule(List<String> versions) throws IOException {
        File fileName = this.moduleFileName(Resources.Key.errorCodesModuleName);
        String string2 = fileName.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "getPath(...)");
        boolean bl = StringsKt.endsWith$default(string2, ".avail", false, 2, null);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        Closeable closeable = new PrintWriter(fileName, StandardCharsets.UTF_8.name());
        Throwable throwable = null;
        try {
            PrintWriter it = (PrintWriter)closeable;
            boolean bl2 = false;
            this.generateErrorCodesModulePreamble(versions, it);
            this.generateErrorCodesModuleBody(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateRepresentativeModule(List<String> versions) throws IOException {
        File fileName = this.moduleFileName(Resources.Key.representativeModuleName);
        String string2 = fileName.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "getPath(...)");
        boolean bl = StringsKt.endsWith$default(string2, ".avail", false, 2, null);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        Closeable closeable = new PrintWriter(fileName, StandardCharsets.UTF_8.name());
        Throwable throwable = null;
        try {
            PrintWriter it = (PrintWriter)closeable;
            boolean bl2 = false;
            this.generateRepresentativeModulePreamble(versions, it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private final String primitiveCoverageTestModuleName(Primitive primitive2) {
        String string2 = this.preamble.getString("primitiveCoverageTestModuleName");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue(primitive2.getSimpleName().substring(2), "this as java.lang.String).substring(startIndex)");
        return Companion.checkedFormat(string2, objectArray);
    }

    private final File primitiveCoverageTestModuleFileName(Primitive primitive2, TestPackage testPackage) {
        String string2 = "%s/%s/%s/%s.avail/%s.avail/%s.avail";
        Object[] objectArray = new Object[]{"src/main/resources", StringsKt.replace$default(Resources.INSTANCE.getGeneratedPackageName(), '.', '/', false, 4, null), this.locale.getLanguage(), this.preamble.getString("primitiveCoverageTestPackageName"), testPackage.getName(), this.primitiveCoverageTestModuleName(primitive2)};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
        return new File(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generatePrimitiveTestCommonModule(String targetDirectory, String versionString, String names, String body2) throws IOException {
        String moduleName2 = this.preamble.getString("primitiveCommonTestPackageName");
        Object object = "%s/%s.avail";
        Object object2 = new Object[]{targetDirectory, moduleName2};
        String string2 = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
        File fileName = new File(string2);
        Closeable closeable = new PrintWriter(fileName, StandardCharsets.UTF_8.name());
        object = null;
        try {
            PrintWriter writer = (PrintWriter)closeable;
            boolean bl = false;
            String string3 = this.preamble.getString("availCopyright");
            Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
            Object[] objectArray = new Object[]{moduleName2, new Date()};
            writer.println(Companion.checkedFormat(string3, objectArray));
            String string4 = this.preamble.getString("generatedModuleNotice");
            Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
            objectArray = new Object[]{BootstrapGenerator.class.getName(), new Date()};
            writer.println(Companion.checkedFormat(string4, objectArray));
            String string5 = this.preamble.getString("primitiveCommonTestPackageRepresentativeHeader");
            Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
            objectArray = new Object[]{moduleName2, versionString, names};
            writer.println(Companion.checkedFormat(string5, objectArray));
            writer.println(body2);
            object2 = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally(closeable, (Throwable)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, TestPackage> generatePrimitiveCoverageTestRepresentativeModule(List<String> versions) throws IOException {
        String packageName = this.preamble.getString("primitiveCoverageTestPackageName");
        Object object = "%s/%s/%s/%s.avail";
        Object object2 = new Object[]{"src/main/resources", StringsKt.replace$default(Resources.INSTANCE.getGeneratedPackageName(), '.', '/', false, 4, null), this.locale.getLanguage(), packageName};
        String string2 = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
        String targetDirectory = string2;
        object2 = "%s/%s.avail";
        Object object3 = new Object[]{targetDirectory, packageName};
        String string3 = String.format((String)object2, Arrays.copyOf(object3, ((Object[])object3).length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
        File fileName = new File(string3);
        object2 = new PrintWriter(fileName, StandardCharsets.UTF_8.name());
        object3 = null;
        try {
            Object writer = (PrintWriter)object2;
            boolean bl = false;
            String string4 = this.preamble.getString("availCopyright");
            Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
            Object[] objectArray = new Object[]{packageName, new Date()};
            ((PrintWriter)writer).println(Companion.checkedFormat(string4, objectArray));
            String string5 = this.preamble.getString("generatedModuleNotice");
            Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
            objectArray = new Object[]{BootstrapGenerator.class.getName(), new Date()};
            ((PrintWriter)writer).println(Companion.checkedFormat(string5, objectArray));
            StringBuilder used = new StringBuilder().append("\n\t\"").append(this.preamble.getString("availModuleName")).append("\",");
            StringBuilder extendsPrimitiveCommon = new StringBuilder();
            Map testPackageMap = new LinkedHashMap();
            Iterable $this$forEach$iv = BootstrapGenerator.Companion.primitives(null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Primitive primitive2 = (Primitive)element$iv;
                boolean bl2 = false;
                String primitivePackage = primitive2.getClass().getPackage().getName();
                testPackageMap.computeIfAbsent(primitivePackage, arg_0 -> BootstrapGenerator.generatePrimitiveCoverageTestRepresentativeModule$lambda$45$lambda$42$lambda$41(new Function1<String, TestPackage>(this, primitivePackage){
                    final /* synthetic */ BootstrapGenerator this$0;
                    final /* synthetic */ String $primitivePackage;
                    {
                        this.this$0 = $receiver;
                        this.$primitivePackage = $primitivePackage;
                        super(1);
                    }

                    @NotNull
                    public final TestPackage invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        String string2 = this.$primitivePackage;
                        Intrinsics.checkNotNullExpressionValue(string2, "$primitivePackage");
                        return this.this$0.new TestPackage(string2);
                    }
                }, arg_0)).add(primitive2);
            }
            Iterable $this$sortedBy$iv = testPackageMap.values();
            boolean $i$f$sortedBy = false;
            List testPackages = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    TestPackage it = (TestPackage)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (TestPackage)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
                }
            });
            StringBuilder primitiveCommonNames = new StringBuilder();
            StringBuilder primitiveCommonImplementation = new StringBuilder();
            Iterable $this$forEach$iv2 = testPackages;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                TestPackage testPackage = (TestPackage)element$iv;
                boolean bl3 = false;
                used.append("\n\t\"");
                used.append(testPackage.getName());
                used.append("\",");
                extendsPrimitiveCommon.append("\n\t\t\"");
                extendsPrimitiveCommon.append(testPackage.getTestSuiteName());
                extendsPrimitiveCommon.append("\",");
                primitiveCommonNames.append("\n\t\"");
                primitiveCommonNames.append(testPackage.getTestSuiteName());
                primitiveCommonNames.append("\",");
                primitiveCommonImplementation.append(testPackage.getTestSuiteCreationCode());
                primitiveCommonImplementation.append("\n");
            }
            used.setLength(used.length() - 1);
            primitiveCommonNames.setLength(primitiveCommonNames.length() - 1);
            primitiveCommonImplementation.setLength(primitiveCommonImplementation.length() - 2);
            String versionString = BootstrapGenerator.Companion.moduleVersionString(versions);
            String string6 = this.preamble.getString("primitiveCoverageTestPackageRepresentativeHeader");
            Intrinsics.checkNotNullExpressionValue(string6, "getString(...)");
            Object[] objectArray2 = new Object[]{this.preamble.getString("primitiveCoverageTestPackageName"), versionString, used.toString(), this.preamble.getString("primitiveCommonTestPackageName"), extendsPrimitiveCommon.toString()};
            ((PrintWriter)writer).println(Companion.checkedFormat(string6, objectArray2));
            writer = CollectionExtensionsKt.t(versionString, primitiveCommonNames.toString(), primitiveCommonImplementation.toString(), testPackageMap);
        }
        catch (Throwable writer) {
            object3 = writer;
            throw writer;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        object = writer;
        String versionString = (String)((Tuple4)object).component1();
        String primitiveCommonNames = (String)((Tuple4)object).component2();
        String primitiveCommonImplementation = (String)((Tuple4)object).component3();
        Map testPackageMap = (Map)((Tuple4)object).component4();
        Intrinsics.checkNotNull(primitiveCommonNames);
        Intrinsics.checkNotNull(primitiveCommonImplementation);
        this.generatePrimitiveTestCommonModule(targetDirectory, versionString, primitiveCommonNames, primitiveCommonImplementation);
        return testPackageMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void generatePrimitiveCoverageTestModules(List<String> versions, Map<String, TestPackage> testPackageMap) throws IOException {
        for (Primitive primitive2 : BootstrapGenerator.Companion.primitives(null)) {
            TestPackage testPackage;
            Intrinsics.checkNotNullExpressionValue(primitive2.getSimpleName().substring(2), "this as java.lang.String).substring(startIndex)");
            Intrinsics.checkNotNull(testPackageMap.get(primitive2.getClass().getPackage().getName()));
            String moduleName2 = this.primitiveCoverageTestModuleName(primitive2);
            File fileName = this.primitiveCoverageTestModuleFileName(primitive2, testPackage);
            Closeable closeable = new PrintWriter(fileName, StandardCharsets.UTF_8.name());
            Throwable throwable = null;
            try {
                String primitiveName;
                PrintWriter writer = (PrintWriter)closeable;
                boolean bl = false;
                String string2 = this.preamble.getString("availCopyright");
                Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
                Object[] objectArray = new Object[]{moduleName2, new Date()};
                writer.println(Companion.checkedFormat(string2, objectArray));
                String string3 = this.preamble.getString("primitiveCoverageTestModuleHeader");
                Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
                objectArray = new Object[]{moduleName2, BootstrapGenerator.Companion.moduleVersionString(versions), this.preamble.getString("primitiveCommonTestPackageName")};
                writer.println(Companion.checkedFormat(string3, objectArray));
                writer.println();
                String string4 = this.preamble.getString("primitiveCoverageTestCaseOk");
                Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
                objectArray = new Object[]{primitiveName, testPackage.getTestSuiteName()};
                writer.println(Companion.checkedFormat(string4, objectArray));
                if (!primitive2.hasFlag(Primitive.Flag.CannotFail)) {
                    AvailObject varType = primitive2.getFailureVariableType();
                    if (varType.isEnumeration()) {
                        if (A_Type.Companion.isSubtypeOf(varType, IntegerRangeTypeDescriptor.Companion.getNaturalNumbers())) {
                            void $this$forEach$iv;
                            Iterable $this$sortedBy$iv;
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv;
                            var14_16 = A_Type.Companion.getInstances(varType);
                            boolean $i$f$map = false;
                            Iterator iterator2 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void i2;
                                AvailObject availObject = (AvailObject)item$iv$iv;
                                Collection collection2 = destination$iv$iv;
                                boolean bl2 = false;
                                AvailErrorCode availErrorCode = AvailErrorCode.Companion.byNumericCode(A_Number.Companion.getExtractInt((A_Number)i2));
                                Intrinsics.checkNotNull((Object)availErrorCode);
                                collection2.add(availErrorCode);
                            }
                            $this$map$iv = (List)destination$iv$iv;
                            boolean $i$f$sortedBy = false;
                            $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                                public final int compare(T a, T b) {
                                    AvailErrorCode i2 = (AvailErrorCode)((Object)a);
                                    boolean bl = false;
                                    Comparable comparable = Integer.valueOf(i2.getCode());
                                    i2 = (AvailErrorCode)((Object)b);
                                    Comparable comparable2 = comparable;
                                    bl = false;
                                    return ComparisonsKt.compareValues(comparable2, i2.getCode());
                                }
                            });
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                AvailErrorCode code = (AvailErrorCode)((Object)element$iv);
                                boolean bl3 = false;
                                String exceptionKey = Resources.INSTANCE.errorCodeExceptionKey(code);
                                String exceptionName = this.errorCodeBundle.getString(exceptionKey);
                                String string5 = this.preamble.getString("primitiveCoverageTestCaseFailed");
                                Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
                                Object[] objectArray2 = new Object[]{primitiveName, exceptionName, testPackage.getTestSuiteName()};
                                writer.println(Companion.checkedFormat(string5, objectArray2));
                            }
                        } else {
                            String string6 = this.preamble.getString("primitiveCoverageTestCaseFailedSpecial");
                            Intrinsics.checkNotNullExpressionValue(string6, "getString(...)");
                            var14_16 = new Object[]{primitiveName};
                            writer.println(Companion.checkedFormat(string6, var14_16));
                        }
                    } else {
                        String string7 = this.preamble.getString("primitiveCoverageTestCaseFailedSpecial");
                        Intrinsics.checkNotNullExpressionValue(string7, "getString(...)");
                        var14_16 = new Object[]{primitiveName};
                        writer.println(Companion.checkedFormat(string7, var14_16));
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
    }

    private final void generatePrimitiveCoverageTestPackage(List<String> versions) throws IOException {
        String string2 = "%s/%s/%s/%s.avail";
        Object[] objectArray = new Object[]{"src/main/resources", StringsKt.replace$default(Resources.INSTANCE.getGeneratedPackageName(), '.', '/', false, 4, null), this.locale.getLanguage(), this.preamble.getString("primitiveCoverageTestPackageName")};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
        File packageName = new File(string3);
        packageName.mkdir();
        Map<String, TestPackage> testPackageMap = this.generatePrimitiveCoverageTestRepresentativeModule(versions);
        Iterable $this$forEach$iv = testPackageMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestPackage testPackage = (TestPackage)element$iv;
            boolean bl = false;
            testPackage.generatePackageRepresentativeModule(versions);
        }
        this.generatePrimitiveCoverageTestModules(versions, testPackageMap);
    }

    public final void generate(@NotNull List<String> versions) throws IOException {
        Intrinsics.checkNotNullParameter(versions, "versions");
        String string2 = "%s/%s/%s";
        Object object = new Object[]{"src/main/resources", StringsKt.replace$default(Resources.INSTANCE.getGeneratedPackageName(), '.', '/', false, 4, null), this.locale.getLanguage()};
        String string3 = String.format(string2, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
        File languagePath = new File(string3);
        languagePath.mkdir();
        object = "%s/%s/%s/%s.avail";
        Object[] objectArray = new Object[]{"src/main/resources", StringsKt.replace$default(Resources.INSTANCE.getGeneratedPackageName(), '.', '/', false, 4, null), this.locale.getLanguage(), this.preamble.getString("representativeModuleName")};
        String string4 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string4, "format(format, *args)");
        File packageName = new File(string4);
        packageName.mkdir();
        this.generateOriginModule(versions);
        this.generateSpecialObjectsModule(versions);
        this.generatePrimitiveModule(null, versions);
        this.generatePrimitiveModule(false, versions);
        this.generatePrimitiveModule(true, versions);
        this.generateErrorCodesModule(versions);
        this.generateRepresentativeModule(versions);
        this.generatePrimitiveCoverageTestPackage(versions);
    }

    private static final TestPackage generatePrimitiveCoverageTestRepresentativeModule$lambda$45$lambda$42$lambda$41(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (TestPackage)$tmp0.invoke(p0);
    }

    private static final Set lambda$53$lambda$52(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args2) throws Exception {
        Companion.main(args2);
    }

    static {
        int n = AvailRuntime.Companion.getSpecialObjects().size();
        for (int i2 = 0; i2 < n; ++i2) {
            AvailObject specialObject = AvailRuntime.Companion.getSpecialObjects().get(i2);
            if (!specialObject.getNotNil()) continue;
            Integer n2 = i2;
            specialObjectIndexMap.put(specialObject, n2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0016\u0010\n\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000b\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001b\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u0007\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002J\u001d\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lavail/tools/bootstrap/BootstrapGenerator$Companion;", "", "()V", "specialObjectIndexMap", "", "Lavail/descriptor/representation/A_BasicObject;", "", "checkedFormat", "", "pattern", "arguments", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "errorCodes", "", "Lavail/exceptions/AvailErrorCode;", "main", "", "args", "([Ljava/lang/String;)V", "moduleVersionString", "versions", "primitives", "Lavail/interpreter/Primitive;", "fallible", "", "(Ljava/lang/Boolean;)Ljava/util/List;", "vmVersionString", "avail"})
    @SourceDebugExtension(value={"SMAP\nBootstrapGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BootstrapGenerator.kt\navail/tools/bootstrap/BootstrapGenerator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Casts.kt\navail/utility/CastsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,2116:1\n766#2:2117\n857#2,2:2118\n766#2:2120\n857#2,2:2121\n1855#2,2:2123\n1855#2,2:2125\n766#2:2134\n857#2,2:2135\n76#3:2127\n96#3,2:2128\n98#3,3:2131\n59#4:2130\n11400#5,3:2137\n*S KotlinDebug\n*F\n+ 1 BootstrapGenerator.kt\navail/tools/bootstrap/BootstrapGenerator$Companion\n*L\n177#1:2117\n177#1:2118,2\n178#1:2120\n178#1:2121,2\n211#1:2123,2\n232#1:2125,2\n275#1:2134\n275#1:2135,2\n253#1:2127\n253#1:2128,2\n253#1:2131,3\n259#1:2130\n308#1:2137,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String checkedFormat(@NotNull String pattern, Object ... arguments2) throws MissingFormatArgumentException {
            Intrinsics.checkNotNullParameter(pattern, "pattern");
            Intrinsics.checkNotNullParameter(arguments2, "arguments");
            MessageFormat format = new MessageFormat(pattern);
            Object object = format.clone();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type java.text.MessageFormat");
            MessageFormat clone = (MessageFormat)object;
            int n = 0;
            int n2 = arguments2.length;
            Object object2 = new DecimalFormat[n2];
            while (n < n2) {
                int n3 = n++;
                object2[n3] = new DecimalFormat();
            }
            Object[] fakeFormats = object2;
            clone.setFormatsByArgumentIndex((Format[])fakeFormats);
            Object[] captured = clone.getFormatsByArgumentIndex();
            if (!Arrays.equals(captured, fakeFormats)) {
                int i2;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                object2 = ArraysKt.getIndices(fakeFormats);
                boolean $i$f$filter = false;
                Object[] objectArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    i2 = ((Number)element$iv$iv).intValue();
                    boolean bl = false;
                    if (!(i2 >= captured.length || captured[i2] == null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    i2 = ((Number)element$iv$iv).intValue();
                    boolean bl = false;
                    if (!(arguments2[i2] != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List uncaptured = (List)destination$iv$iv;
                if (!((Collection)uncaptured).isEmpty()) {
                    String string2 = "Pattern omits reference to arguments: %s. Pattern =\n\t%s\nArgs = %s";
                    objectArray = new Object[]{uncaptured, StringsKt.replace$default(((Object)StringsKt.trim((CharSequence)pattern)).toString(), "\n", "\n\t", false, 4, null), ArraysKt.toList(arguments2)};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
                    System.err.println(string3);
                }
            }
            String string4 = format.format(arguments2);
            Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
            return string4;
        }

        private final String vmVersionString(List<String> versions) {
            StringBuilder stringBuilder;
            StringBuilder $this$vmVersionString_u24lambda_u243 = stringBuilder = new StringBuilder();
            boolean bl = false;
            Iterable $this$forEach$iv = versions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String version = (String)element$iv;
                boolean bl2 = false;
                $this$vmVersionString_u24lambda_u243.append(version);
                $this$vmVersionString_u24lambda_u243.append(",");
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            String versionString = string2;
            String string3 = versionString.substring(0, versionString.length() - 1);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string3;
        }

        private final String moduleVersionString(List<String> versions) {
            StringBuilder stringBuilder;
            StringBuilder $this$moduleVersionString_u24lambda_u245 = stringBuilder = new StringBuilder();
            boolean bl = false;
            Iterable $this$forEach$iv = versions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String version = (String)element$iv;
                boolean bl2 = false;
                $this$moduleVersionString_u24lambda_u245.append("\n\t\"");
                $this$moduleVersionString_u24lambda_u245.append(version);
                $this$moduleVersionString_u24lambda_u245.append("\",");
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            String versionString = string2;
            String string3 = versionString.substring(0, versionString.length() - 1);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string3;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final List<Primitive> primitives(Boolean fallible) {
            $this$flatMap$iv = Primitive.PrimitiveHolder.Companion.getHoldersByName();
            $i$f$flatMap = false;
            var4_4 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$flatMapTo = false;
            var7_7 = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (var7_7.hasNext()) {
                block4: {
                    block5: {
                        block3: {
                            var9_9 = element$iv$iv = var7_7.next();
                            $i$a$-flatMap-BootstrapGenerator$Companion$primitives$1 = false;
                            holder = (Primitive.PrimitiveHolder)var9_9.getValue();
                            $this$primitives_u24lambda_u248_u24lambda_u247 = holder.getPrimitive();
                            $i$a$-run-BootstrapGenerator$Companion$primitives$1$1 = false;
                            if (!$this$primitives_u24lambda_u248_u24lambda_u247.hasFlag(Primitive.Flag.Private)) break block3;
                            v0 /* !! */  = CollectionsKt.emptyList();
                            break block4;
                        }
                        if (!$this$primitives_u24lambda_u248_u24lambda_u247.hasFlag(Primitive.Flag.Bootstrap)) break block5;
                        v0 /* !! */  = CollectionsKt.emptyList();
                        break block4;
                    }
                    $this$notNullAnd$iv = fallible;
                    $i$f$notNullAnd = false;
                    if ($this$notNullAnd$iv == null) ** GOTO lbl-1000
                    $this$primitives_u24lambda_u248_u24lambda_u247_u24lambda_u246 = $this$notNullAnd$iv;
                    $i$a$-notNullAnd-BootstrapGenerator$Companion$primitives$1$1$1 = false;
                    if (Boolean.valueOf($this$primitives_u24lambda_u248_u24lambda_u247_u24lambda_u246).equals($this$primitives_u24lambda_u248_u24lambda_u247.hasFlag(Primitive.Flag.CannotFail))) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    v0 /* !! */  = v1 ? CollectionsKt.emptyList() : CollectionsKt.listOf($this$primitives_u24lambda_u248_u24lambda_u247);
                }
                list$iv$iv = v0 /* !! */ ;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<AvailErrorCode> errorCodes() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = AvailErrorCode.getEntries();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AvailErrorCode it = (AvailErrorCode)((Object)element$iv$iv);
                boolean bl = false;
                if (!(it.nativeCode() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void main(@NotNull String[] args2) throws Exception {
            Intrinsics.checkNotNullParameter(args2, "args");
            List languages = new ArrayList();
            if (args2.length == 0) {
                String string2 = System.getProperty("user.language");
                Intrinsics.checkNotNullExpressionValue(string2, "getProperty(...)");
                languages.add(string2);
            } else {
                StringTokenizer tokenizer = new StringTokenizer(args2[0], ",");
                while (tokenizer.hasMoreTokens()) {
                    String string3 = tokenizer.nextToken();
                    Intrinsics.checkNotNullExpressionValue(string3, "nextToken(...)");
                    languages.add(string3);
                }
            }
            List versions = new ArrayList();
            if (args2.length < 2) {
                String[] $this$mapTo$iv = AvailRuntimeConfiguration.INSTANCE.getActiveVersions();
                boolean $i$f$mapTo = false;
                int n = $this$mapTo$iv.length;
                for (int j = 0; j < n; ++j) {
                    void it;
                    String item$iv;
                    String string4 = item$iv = $this$mapTo$iv[j];
                    Collection collection2 = versions;
                    boolean bl = false;
                    collection2.add(it);
                }
            } else {
                StringTokenizer tokenizer = new StringTokenizer(args2[1], ",");
                while (tokenizer.hasMoreTokens()) {
                    String string5 = tokenizer.nextToken();
                    Intrinsics.checkNotNullExpressionValue(string5, "nextToken(...)");
                    versions.add(string5);
                }
            }
            for (String language : languages) {
                BootstrapGenerator generator = new BootstrapGenerator(new Locale(language));
                generator.generate(versions);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lavail/tools/bootstrap/BootstrapGenerator$TestPackage;", "", "primitivePackage", "", "(Lavail/tools/bootstrap/BootstrapGenerator;Ljava/lang/String;)V", "name", "getName", "()Ljava/lang/String;", "testSuiteCreationCode", "getTestSuiteCreationCode", "testSuiteName", "getTestSuiteName", "usesModuleNames", "", "getUsesModuleNames", "()Ljava/util/Set;", "add", "", "primitive", "Lavail/interpreter/Primitive;", "generatePackageRepresentativeModule", "versions", "", "avail"})
    @SourceDebugExtension(value={"SMAP\nBootstrapGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BootstrapGenerator.kt\navail/tools/bootstrap/BootstrapGenerator$TestPackage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,2116:1\n1#2:2117\n1855#3,2:2118\n*S KotlinDebug\n*F\n+ 1 BootstrapGenerator.kt\navail/tools/bootstrap/BootstrapGenerator$TestPackage\n*L\n2072#1:2118,2\n*E\n"})
    private final class TestPackage {
        @NotNull
        private final String name;
        @NotNull
        private final String testSuiteName;
        @NotNull
        private final String testSuiteCreationCode;
        @NotNull
        private final Set<String> usesModuleNames;

        /*
         * WARNING - void declaration
         */
        public TestPackage(String primitivePackage) {
            Object[] objectArray;
            String string2;
            Object[] objectArray2;
            boolean bl;
            Intrinsics.checkNotNullParameter(primitivePackage, "primitivePackage");
            this.usesModuleNames = new LinkedHashSet();
            String[] stringArray = new String[]{"."};
            List packagePath = StringsKt.split$default((CharSequence)primitivePackage, stringArray, false, 0, 6, null);
            boolean bl2 = bl = packagePath.size() > 2;
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            Object[] basePackageName = (Object[])packagePath.get(packagePath.size() - 1);
            TestPackage testPackage = this;
            Companion companion = Companion;
            String string4 = BootstrapGenerator.this.getPreamble().getString("primitiveCoverageTestModuleName");
            String string5 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
            Object[] objectArray3 = objectArray2 = new Object[1];
            int n = 0;
            Object[] objectArray4 = basePackageName;
            if (((CharSequence)objectArray4).length() > 0) {
                void p0;
                char c = objectArray4.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = n;
                Object[] objectArray5 = objectArray3;
                String string6 = string5;
                Companion companion2 = companion;
                TestPackage testPackage2 = testPackage;
                boolean bl3 = false;
                String string7 = CharsKt.titlecase((char)p0);
                testPackage = testPackage2;
                companion = companion2;
                string5 = string6;
                objectArray3 = objectArray5;
                n = n2;
                StringBuilder stringBuilder2 = stringBuilder.append((Object)string7);
                string2 = objectArray4;
                int n3 = 1;
                String string8 = string2.substring(n3);
                Intrinsics.checkNotNullExpressionValue(string8, "this as java.lang.String).substring(startIndex)");
                objectArray = stringBuilder2.append(string8).toString();
            } else {
                objectArray = objectArray4;
            }
            objectArray3[n] = objectArray;
            testPackage.name = companion.checkedFormat(string5, objectArray2);
            string2 = "%s/%s/%s/%s.avail/%s.avail";
            Object[] objectArray6 = new Object[]{"src/main/resources", StringsKt.replace$default(Resources.INSTANCE.getGeneratedPackageName(), '.', '/', false, 4, null), BootstrapGenerator.this.locale.getLanguage(), BootstrapGenerator.this.getPreamble().getString("primitiveCoverageTestPackageName"), this.name};
            String string9 = String.format(string2, Arrays.copyOf(objectArray6, objectArray6.length));
            Intrinsics.checkNotNullExpressionValue(string9, "format(format, *args)");
            File packageName = new File(string9);
            packageName.mkdir();
            String string10 = BootstrapGenerator.this.getPreamble().getString("primitiveTestSuiteName");
            Intrinsics.checkNotNullExpressionValue(string10, "getString(...)");
            objectArray4 = new Object[]{basePackageName};
            this.testSuiteName = Companion.checkedFormat(string10, objectArray4);
            String string11 = BootstrapGenerator.this.getPreamble().getString("primitiveTestSuiteImplementation");
            Intrinsics.checkNotNullExpressionValue(string11, "getString(...)");
            objectArray4 = new Object[]{basePackageName, this.testSuiteName};
            this.testSuiteCreationCode = Companion.checkedFormat(string11, objectArray4);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getTestSuiteName() {
            return this.testSuiteName;
        }

        @NotNull
        public final String getTestSuiteCreationCode() {
            return this.testSuiteCreationCode;
        }

        @NotNull
        public final Set<String> getUsesModuleNames() {
            return this.usesModuleNames;
        }

        public final void add(@NotNull Primitive primitive2) {
            Intrinsics.checkNotNullParameter(primitive2, "primitive");
            this.usesModuleNames.add(BootstrapGenerator.this.primitiveCoverageTestModuleName(primitive2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void generatePackageRepresentativeModule(@NotNull List<String> versions) throws IOException {
            Intrinsics.checkNotNullParameter(versions, "versions");
            String packageName = BootstrapGenerator.this.getPreamble().getString("primitiveCoverageTestPackageName");
            Object object = "%s/%s/%s/%s.avail/%s.avail/%s.avail";
            Object object2 = new Object[]{"src/main/resources", StringsKt.replace$default(Resources.INSTANCE.getGeneratedPackageName(), '.', '/', false, 4, null), BootstrapGenerator.this.locale.getLanguage(), packageName, this.name, this.name};
            String string2 = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
            File fileName = new File(string2);
            Closeable closeable = new PrintWriter(fileName, "UTF-8");
            object = BootstrapGenerator.this;
            object2 = null;
            try {
                Object[] objectArray;
                PrintWriter writer = (PrintWriter)closeable;
                boolean bl = false;
                String string3 = ((BootstrapGenerator)object).getPreamble().getString("availCopyright");
                Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
                Object[] objectArray2 = new Object[]{this.name, new Date()};
                writer.println(Companion.checkedFormat(string3, objectArray2));
                String string4 = ((BootstrapGenerator)object).getPreamble().getString("generatedModuleNotice");
                Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
                objectArray2 = new Object[]{BootstrapGenerator.class.getName(), new Date()};
                writer.println(Companion.checkedFormat(string4, objectArray2));
                Object[] $this$generatePackageRepresentativeModule_u24lambda_u242_u24lambda_u241 = objectArray = new StringBuilder();
                boolean bl2 = false;
                $this$generatePackageRepresentativeModule_u24lambda_u242_u24lambda_u241.append("\n\t\"");
                $this$generatePackageRepresentativeModule_u24lambda_u242_u24lambda_u241.append(((BootstrapGenerator)object).getPreamble().getString("availModuleName"));
                $this$generatePackageRepresentativeModule_u24lambda_u242_u24lambda_u241.append("\",");
                Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)this.usesModuleNames);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String usesModule = (String)element$iv;
                    boolean bl3 = false;
                    $this$generatePackageRepresentativeModule_u24lambda_u242_u24lambda_u241.append("\n\t\"");
                    $this$generatePackageRepresentativeModule_u24lambda_u242_u24lambda_u241.append(usesModule);
                    $this$generatePackageRepresentativeModule_u24lambda_u242_u24lambda_u241.append("\",");
                }
                $this$generatePackageRepresentativeModule_u24lambda_u242_u24lambda_u241.setLength($this$generatePackageRepresentativeModule_u24lambda_u242_u24lambda_u241.length() - 1);
                String string5 = objectArray.toString();
                Intrinsics.checkNotNullExpressionValue(string5, "StringBuilder().apply(builderAction).toString()");
                String usedString = string5;
                String string6 = ((BootstrapGenerator)object).getPreamble().getString("primitiveCoverageTestSubPackageRepresentativeHeader");
                Intrinsics.checkNotNullExpressionValue(string6, "getString(...)");
                objectArray = new Object[]{this.name, Companion.moduleVersionString(versions), usedString};
                writer.println(Companion.checkedFormat(string6, objectArray));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally(closeable, (Throwable)object2);
            }
        }
    }
}

