/*
 * Decompiled with CFR 0.152.
 */
package avail.tools.bootstrap;

import avail.tools.bootstrap.BootstrapGenerator;
import avail.tools.bootstrap.Resources;
import avail.utility.UTF8ResourceBundleControl;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lavail/tools/bootstrap/PropertiesFileGenerator;", "", "baseName", "", "locale", "Ljava/util/Locale;", "(Ljava/lang/String;Ljava/util/Locale;)V", "getBaseName", "()Ljava/lang/String;", "getLocale", "()Ljava/util/Locale;", "preambleBundle", "Ljava/util/ResourceBundle;", "getPreambleBundle", "()Ljava/util/ResourceBundle;", "generate", "", "generatePreamble", "writer", "Ljava/io/PrintWriter;", "generateProperties", "properties", "Ljava/util/Properties;", "avail"})
@SourceDebugExtension(value={"SMAP\nPropertiesFileGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertiesFileGenerator.kt\navail/tools/bootstrap/PropertiesFileGenerator\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n37#2,2:177\n1#3:179\n*S KotlinDebug\n*F\n+ 1 PropertiesFileGenerator.kt\navail/tools/bootstrap/PropertiesFileGenerator\n*L\n135#1:177,2\n*E\n"})
public abstract class PropertiesFileGenerator {
    @NotNull
    private final String baseName;
    @NotNull
    private final Locale locale;
    @NotNull
    private final ResourceBundle preambleBundle;

    protected PropertiesFileGenerator(@NotNull String baseName, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(baseName, "baseName");
        Intrinsics.checkNotNullParameter(locale, "locale");
        this.baseName = baseName;
        this.locale = locale;
        ResourceBundle resourceBundle = ResourceBundle.getBundle(Resources.INSTANCE.getPreambleBaseName(), this.locale, Resources.class.getClassLoader(), new UTF8ResourceBundleControl());
        Intrinsics.checkNotNullExpressionValue(resourceBundle, "getBundle(...)");
        this.preambleBundle = resourceBundle;
    }

    @NotNull
    protected final String getBaseName() {
        return this.baseName;
    }

    @NotNull
    protected final Locale getLocale() {
        return this.locale;
    }

    @NotNull
    protected final ResourceBundle getPreambleBundle() {
        return this.preambleBundle;
    }

    protected final void generatePreamble(@NotNull PrintWriter writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        PrintWriter $this$generatePreamble_u24lambda_u240 = writer;
        boolean bl = false;
        String string2 = this.preambleBundle.getString("propertiesCopyright");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        Object[] objectArray = new Object[]{Resources.INSTANCE.localName(this.baseName) + "_" + this.locale.getLanguage(), new Date()};
        $this$generatePreamble_u24lambda_u240.println(BootstrapGenerator.Companion.checkedFormat(string2, objectArray));
        String string3 = this.preambleBundle.getString("generatedPropertiesNotice");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        objectArray = new Object[]{$this$generatePreamble_u24lambda_u240.getClass().getName(), new Date()};
        $this$generatePreamble_u24lambda_u240.println(BootstrapGenerator.Companion.checkedFormat(string3, objectArray));
    }

    protected abstract void generateProperties(@NotNull Properties var1, @NotNull PrintWriter var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generate() throws IOException {
        CharSequence charSequence = "%s/%s_%s.properties";
        Object object = new Object[]{"src/main/resources", StringsKt.replace$default(this.baseName, '.', '/', false, 4, null), this.locale.getLanguage()};
        String string2 = String.format(charSequence, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
        File fileName = new File(string2);
        System.out.println((Object)fileName.getAbsolutePath());
        charSequence = this.baseName;
        object = new Regex("\\.");
        int n = 0;
        Collection $this$toTypedArray$iv = ((Regex)object).split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Object thisCollection$iv22 = $this$toTypedArray$iv;
        String[] components = thisCollection$iv22.toArray(new String[0]);
        thisCollection$iv22 = "%s/%s_%s.propertiesTEMP";
        Object object2 = new Object[]{System.getProperty("java.io.tmpdir"), components[components.length - 1], this.locale.getLanguage()};
        String string3 = String.format((String)thisCollection$iv22, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
        File tempFileName = new File(string3);
        String string4 = fileName.getPath();
        Intrinsics.checkNotNullExpressionValue(string4, "getPath(...)");
        $i$f$toTypedArray = StringsKt.endsWith$default(string4, ".properties", false, 2, null);
        if (_Assertions.ENABLED && !$i$f$toTypedArray) {
            thisCollection$iv22 = "Assertion failed";
            throw new AssertionError(thisCollection$iv22);
        }
        Properties properties2 = new Properties();
        try {
            thisCollection$iv22 = new FileInputStream(fileName);
            object2 = null;
            try {
                Object inputStream = (FileInputStream)thisCollection$iv22;
                boolean bl = false;
                Closeable closeable = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    Reader p0 = (Reader)closeable;
                    boolean bl2 = false;
                    properties2.load(p0);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                inputStream = Unit.INSTANCE;
            }
            catch (Throwable inputStream) {
                object2 = inputStream;
                throw inputStream;
            }
            finally {
                CloseableKt.closeFinally((Closeable)thisCollection$iv22, (Throwable)object2);
            }
        }
        catch (FileNotFoundException thisCollection$iv22) {
            // empty catch block
        }
        thisCollection$iv22 = new PrintWriter(tempFileName, StandardCharsets.UTF_8.name());
        object2 = null;
        try {
            PrintWriter writer = (PrintWriter)thisCollection$iv22;
            boolean bl = false;
            this.generatePreamble(writer);
            this.generateProperties(properties2, writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)thisCollection$iv22, (Throwable)object2);
        }
        boolean worked = fileName.delete();
        if (!worked) {
            System.err.println("deleting the original properties file failed: " + fileName);
        }
        if (!(worked = tempFileName.renameTo(fileName))) {
            throw new RuntimeException("moving the temporary properties file failed: " + tempFileName + " -> " + fileName);
        }
    }
}

