/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.availlang.artifact.AvailArtifactBuildPlan;
import org.availlang.artifact.AvailArtifactException;
import org.availlang.artifact.AvailArtifactType;
import org.availlang.artifact.environment.AvailEnvironment;
import org.availlang.artifact.environment.location.AvailLocation;
import org.availlang.artifact.environment.project.AvailProject;
import org.availlang.artifact.environment.project.AvailProjectRoot;
import org.availlang.artifact.jar.AvailArtifactJarBuilder;
import org.availlang.artifact.manifest.AvailArtifactManifest;
import org.availlang.artifact.roots.AvailRoot;
import org.availlang.json.JSONArray;
import org.availlang.json.JSONData;
import org.availlang.json.JSONFriendly;
import org.availlang.json.JSONObject;
import org.availlang.json.JSONWriter;
import org.availlang.json.UtilityKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b&\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 K2\u00020\u0001:\u0001KB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u00bf\u0001\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u0012\u001a\b\u0002\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\u00130\u0011\u0012\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0011\u0012\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0011\u0012\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0011\u0012\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0018\u00a2\u0006\u0002\u0010\u0019J>\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020?0C2\u001a\u0010D\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010F\u0012\u0004\u0012\u00020?0EJ\b\u0010G\u001a\u00020\u0003H\u0016J\u0010\u0010H\u001a\u00020?2\u0006\u0010I\u001a\u00020JH\u0016R\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R&\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001b\"\u0004\b'\u0010\u001dR \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001b\"\u0004\b-\u0010\u001dR,\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\u00130\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010)\"\u0004\b/\u0010+R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010)\"\u0004\b1\u0010+R\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001b\"\u0004\b3\u0010\u001dR\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010)\"\u0004\b9\u0010+R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u001b\"\u0004\b;\u0010\u001dR \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010)\"\u0004\b=\u0010+\u00a8\u0006L"}, d2={"Lorg/availlang/artifact/AvailArtifactBuildPlan;", "Lorg/availlang/json/JSONFriendly;", "projectDirectory", "", "obj", "Lorg/availlang/json/JSONObject;", "(Ljava/lang/String;Lorg/availlang/json/JSONObject;)V", "version", "outputLocation", "Lorg/availlang/artifact/environment/location/AvailLocation;", "artifactType", "Lorg/availlang/artifact/AvailArtifactType;", "implementationTitle", "jarMainClass", "artifactDescription", "digestAlgorithm", "rootNames", "", "includedFiles", "Lkotlin/Pair;", "jarFileLocations", "zipFileLocations", "directoryLocations", "customManifestItems", "", "(Ljava/lang/String;Lorg/availlang/artifact/environment/location/AvailLocation;Lorg/availlang/artifact/AvailArtifactType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/Map;)V", "getArtifactDescription", "()Ljava/lang/String;", "setArtifactDescription", "(Ljava/lang/String;)V", "getArtifactType", "()Lorg/availlang/artifact/AvailArtifactType;", "setArtifactType", "(Lorg/availlang/artifact/AvailArtifactType;)V", "getCustomManifestItems", "()Ljava/util/Map;", "setCustomManifestItems", "(Ljava/util/Map;)V", "getDigestAlgorithm", "setDigestAlgorithm", "getDirectoryLocations", "()Ljava/util/List;", "setDirectoryLocations", "(Ljava/util/List;)V", "getImplementationTitle", "setImplementationTitle", "getIncludedFiles", "setIncludedFiles", "getJarFileLocations", "setJarFileLocations", "getJarMainClass", "setJarMainClass", "getOutputLocation", "()Lorg/availlang/artifact/environment/location/AvailLocation;", "setOutputLocation", "(Lorg/availlang/artifact/environment/location/AvailLocation;)V", "getRootNames", "setRootNames", "getVersion", "setVersion", "getZipFileLocations", "setZipFileLocations", "buildAvailArtifactJar", "", "project", "Lorg/availlang/artifact/environment/project/AvailProject;", "success", "Lkotlin/Function1;", "failure", "Lkotlin/Function2;", "", "toString", "writeTo", "writer", "Lorg/availlang/json/JSONWriter;", "Companion", "avail-artifact"})
@SourceDebugExtension(value={"SMAP\nAvailArtifactBuildPlan.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvailArtifactBuildPlan.kt\norg/availlang/artifact/AvailArtifactBuildPlan\n+ 2 JSONWriter.kt\norg/availlang/json/JSONWriter\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,305:1\n933#2,4:306\n1667#2,2:310\n1667#2,2:312\n1667#2,2:314\n1667#2,2:316\n1667#2,2:318\n1667#2,2:320\n1667#2,2:322\n1667#2,2:324\n1667#2,2:326\n1667#2,2:328\n1667#2,2:330\n1667#2,2:332\n1667#2,2:334\n940#2:336\n939#2:337\n1549#3:338\n1620#3,3:339\n1855#3,2:342\n1855#3,2:344\n1855#3,2:346\n1855#3,2:348\n1855#3,2:350\n1855#3,2:352\n1855#3,2:354\n1855#3,2:356\n1855#3,2:358\n1855#3,2:360\n1855#3,2:362\n*S KotlinDebug\n*F\n+ 1 AvailArtifactBuildPlan.kt\norg/availlang/artifact/AvailArtifactBuildPlan\n*L\n80#1:306,4\n81#1:310,2\n82#1:312,2\n85#1:314,2\n86#1:316,2\n87#1:318,2\n88#1:320,2\n89#1:322,2\n90#1:324,2\n91#1:326,2\n96#1:328,2\n97#1:330,2\n98#1:332,2\n99#1:334,2\n80#1:336\n80#1:337\n155#1:338\n155#1:339,3\n157#1:342,2\n171#1:344,2\n172#1:346,2\n175#1:348,2\n178#1:350,2\n181#1:352,2\n231#1:354,2\n239#1:356,2\n245#1:358,2\n251#1:360,2\n257#1:362,2\n*E\n"})
public final class AvailArtifactBuildPlan
implements JSONFriendly {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String version;
    @Nullable
    private AvailLocation outputLocation;
    @NotNull
    private AvailArtifactType artifactType;
    @NotNull
    private String implementationTitle;
    @NotNull
    private String jarMainClass;
    @NotNull
    private String artifactDescription;
    @NotNull
    private String digestAlgorithm;
    @NotNull
    private List<String> rootNames;
    @NotNull
    private List<Pair<AvailLocation, String>> includedFiles;
    @NotNull
    private List<AvailLocation> jarFileLocations;
    @NotNull
    private List<AvailLocation> zipFileLocations;
    @NotNull
    private List<AvailLocation> directoryLocations;
    @NotNull
    private Map<String, String> customManifestItems;
    @NotNull
    public static final String ARTIFACT_PLANS_FILE = "artifact-plans.json";

    public AvailArtifactBuildPlan(@NotNull String version, @Nullable AvailLocation outputLocation, @NotNull AvailArtifactType artifactType, @NotNull String implementationTitle, @NotNull String jarMainClass, @NotNull String artifactDescription, @NotNull String digestAlgorithm, @NotNull List<String> rootNames, @NotNull List<Pair<AvailLocation, String>> includedFiles, @NotNull List<AvailLocation> jarFileLocations, @NotNull List<AvailLocation> zipFileLocations, @NotNull List<AvailLocation> directoryLocations, @NotNull Map<String, String> customManifestItems) {
        Intrinsics.checkNotNullParameter(version, "version");
        Intrinsics.checkNotNullParameter((Object)artifactType, "artifactType");
        Intrinsics.checkNotNullParameter(implementationTitle, "implementationTitle");
        Intrinsics.checkNotNullParameter(jarMainClass, "jarMainClass");
        Intrinsics.checkNotNullParameter(artifactDescription, "artifactDescription");
        Intrinsics.checkNotNullParameter(digestAlgorithm, "digestAlgorithm");
        Intrinsics.checkNotNullParameter(rootNames, "rootNames");
        Intrinsics.checkNotNullParameter(includedFiles, "includedFiles");
        Intrinsics.checkNotNullParameter(jarFileLocations, "jarFileLocations");
        Intrinsics.checkNotNullParameter(zipFileLocations, "zipFileLocations");
        Intrinsics.checkNotNullParameter(directoryLocations, "directoryLocations");
        Intrinsics.checkNotNullParameter(customManifestItems, "customManifestItems");
        this.version = version;
        this.outputLocation = outputLocation;
        this.artifactType = artifactType;
        this.implementationTitle = implementationTitle;
        this.jarMainClass = jarMainClass;
        this.artifactDescription = artifactDescription;
        this.digestAlgorithm = digestAlgorithm;
        this.rootNames = rootNames;
        this.includedFiles = includedFiles;
        this.jarFileLocations = jarFileLocations;
        this.zipFileLocations = zipFileLocations;
        this.directoryLocations = directoryLocations;
        this.customManifestItems = customManifestItems;
    }

    public /* synthetic */ AvailArtifactBuildPlan(String string2, AvailLocation availLocation, AvailArtifactType availArtifactType, String string3, String string4, String string5, String string6, List list2, List list3, List list4, List list5, List list6, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        if ((n & 2) != 0) {
            availLocation = null;
        }
        if ((n & 4) != 0) {
            availArtifactType = AvailArtifactType.LIBRARY;
        }
        if ((n & 8) != 0) {
            string3 = "";
        }
        if ((n & 0x10) != 0) {
            string4 = "";
        }
        if ((n & 0x20) != 0) {
            string5 = "";
        }
        if ((n & 0x40) != 0) {
            string6 = "SHA=256";
        }
        if ((n & 0x80) != 0) {
            list2 = new ArrayList();
        }
        if ((n & 0x100) != 0) {
            list3 = new ArrayList();
        }
        if ((n & 0x200) != 0) {
            list4 = new ArrayList();
        }
        if ((n & 0x400) != 0) {
            list5 = new ArrayList();
        }
        if ((n & 0x800) != 0) {
            list6 = new ArrayList();
        }
        if ((n & 0x1000) != 0) {
            map = new LinkedHashMap();
        }
        this(string2, availLocation, availArtifactType, string3, string4, string5, string6, list2, list3, list4, list5, list6, map);
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.version = string2;
    }

    @Nullable
    public final AvailLocation getOutputLocation() {
        return this.outputLocation;
    }

    public final void setOutputLocation(@Nullable AvailLocation availLocation) {
        this.outputLocation = availLocation;
    }

    @NotNull
    public final AvailArtifactType getArtifactType() {
        return this.artifactType;
    }

    public final void setArtifactType(@NotNull AvailArtifactType availArtifactType) {
        Intrinsics.checkNotNullParameter((Object)availArtifactType, "<set-?>");
        this.artifactType = availArtifactType;
    }

    @NotNull
    public final String getImplementationTitle() {
        return this.implementationTitle;
    }

    public final void setImplementationTitle(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.implementationTitle = string2;
    }

    @NotNull
    public final String getJarMainClass() {
        return this.jarMainClass;
    }

    public final void setJarMainClass(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.jarMainClass = string2;
    }

    @NotNull
    public final String getArtifactDescription() {
        return this.artifactDescription;
    }

    public final void setArtifactDescription(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.artifactDescription = string2;
    }

    @NotNull
    public final String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public final void setDigestAlgorithm(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.digestAlgorithm = string2;
    }

    @NotNull
    public final List<String> getRootNames() {
        return this.rootNames;
    }

    public final void setRootNames(@NotNull List<String> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.rootNames = list2;
    }

    @NotNull
    public final List<Pair<AvailLocation, String>> getIncludedFiles() {
        return this.includedFiles;
    }

    public final void setIncludedFiles(@NotNull List<Pair<AvailLocation, String>> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.includedFiles = list2;
    }

    @NotNull
    public final List<AvailLocation> getJarFileLocations() {
        return this.jarFileLocations;
    }

    public final void setJarFileLocations(@NotNull List<AvailLocation> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.jarFileLocations = list2;
    }

    @NotNull
    public final List<AvailLocation> getZipFileLocations() {
        return this.zipFileLocations;
    }

    public final void setZipFileLocations(@NotNull List<AvailLocation> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.zipFileLocations = list2;
    }

    @NotNull
    public final List<AvailLocation> getDirectoryLocations() {
        return this.directoryLocations;
    }

    public final void setDirectoryLocations(@NotNull List<AvailLocation> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.directoryLocations = list2;
    }

    @NotNull
    public final Map<String, String> getCustomManifestItems() {
        return this.customManifestItems;
    }

    public final void setCustomManifestItems(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, "<set-?>");
        this.customManifestItems = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(@NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        JSONWriter this_$iv = writer;
        boolean $i$f$writeObject = false;
        this_$iv.startObject();
        try {
            Unit unit;
            JSONWriter this_$iv2;
            JSONWriter $this$writeTo_u24lambda_u2413 = this_$iv;
            boolean bl = false;
            JSONWriter jSONWriter = $this$writeTo_u24lambda_u2413;
            String key$iv = "version";
            boolean $i$f$at = false;
            this_$iv2.write(key$iv);
            void $this$writeTo_u24lambda_u2413_u24lambda_u240 = this_$iv2;
            boolean bl2 = false;
            $this$writeTo_u24lambda_u2413_u24lambda_u240.write(this.version);
            this_$iv2 = $this$writeTo_u24lambda_u2413;
            key$iv = "outputLocation";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2413_u24lambda_u241 = this_$iv2;
            boolean bl3 = false;
            AvailLocation availLocation = this.outputLocation;
            if (availLocation != null) {
                availLocation.writeTo($this$writeTo_u24lambda_u2413_u24lambda_u241);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                $this$writeTo_u24lambda_u2413_u24lambda_u241.writeNull();
            }
            this_$iv2 = $this$writeTo_u24lambda_u2413;
            key$iv = "artifactType";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2413_u24lambda_u242 = this_$iv2;
            boolean bl4 = false;
            $this$writeTo_u24lambda_u2413_u24lambda_u242.write(this.artifactType.name());
            this_$iv2 = $this$writeTo_u24lambda_u2413;
            key$iv = "implementationTitle";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2413_u24lambda_u243 = this_$iv2;
            boolean bl5 = false;
            $this$writeTo_u24lambda_u2413_u24lambda_u243.write(this.implementationTitle);
            this_$iv2 = $this$writeTo_u24lambda_u2413;
            key$iv = "jarMainClass";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2413_u24lambda_u244 = this_$iv2;
            boolean bl6 = false;
            $this$writeTo_u24lambda_u2413_u24lambda_u244.write(this.jarMainClass);
            this_$iv2 = $this$writeTo_u24lambda_u2413;
            key$iv = "artifactDescription";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2413_u24lambda_u245 = this_$iv2;
            boolean bl7 = false;
            $this$writeTo_u24lambda_u2413_u24lambda_u245.write(this.artifactDescription);
            this_$iv2 = $this$writeTo_u24lambda_u2413;
            key$iv = "digestAlgorithm";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2413_u24lambda_u246 = this_$iv2;
            boolean bl8 = false;
            $this$writeTo_u24lambda_u2413_u24lambda_u246.write(this.digestAlgorithm);
            this_$iv2 = $this$writeTo_u24lambda_u2413;
            key$iv = "rootNames";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2413_u24lambda_u247 = this_$iv2;
            boolean bl9 = false;
            $this$writeTo_u24lambda_u2413_u24lambda_u247.writeStrings((Iterable<String>)this.rootNames);
            this_$iv2 = $this$writeTo_u24lambda_u2413;
            key$iv = "includedFiles";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2413_u24lambda_u248 = this_$iv2;
            boolean bl10 = false;
            $this$writeTo_u24lambda_u2413_u24lambda_u248.writePairsAsArrayOfPairs(this.includedFiles.iterator(), writeTo.1.9.1.INSTANCE);
            this_$iv2 = $this$writeTo_u24lambda_u2413;
            key$iv = "jarFileLocations";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2413_u24lambda_u249 = this_$iv2;
            boolean bl11 = false;
            $this$writeTo_u24lambda_u2413_u24lambda_u249.writeArray((Iterable<? extends JSONFriendly>)this.jarFileLocations);
            this_$iv2 = $this$writeTo_u24lambda_u2413;
            key$iv = "zipFileLocations";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2413_u24lambda_u2410 = this_$iv2;
            boolean bl12 = false;
            $this$writeTo_u24lambda_u2413_u24lambda_u2410.writeArray((Iterable<? extends JSONFriendly>)this.zipFileLocations);
            this_$iv2 = $this$writeTo_u24lambda_u2413;
            key$iv = "directoryLocations";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2413_u24lambda_u2411 = this_$iv2;
            boolean bl13 = false;
            $this$writeTo_u24lambda_u2413_u24lambda_u2411.writeArray((Iterable<? extends JSONFriendly>)this.directoryLocations);
            this_$iv2 = $this$writeTo_u24lambda_u2413;
            key$iv = "customManifestItems";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2413_u24lambda_u2412 = this_$iv2;
            boolean bl14 = false;
            $this$writeTo_u24lambda_u2413_u24lambda_u2412.writeMapString(this.customManifestItems);
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            this_$iv.endObject();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void buildAvailArtifactJar(@NotNull AvailProject project2, @NotNull Function1<? super String, Unit> success2, @NotNull Function2<? super String, ? super Throwable, Unit> failure) {
        Intrinsics.checkNotNullParameter(project2, "project");
        Intrinsics.checkNotNullParameter(success2, "success");
        Intrinsics.checkNotNullParameter(failure, "failure");
        AvailLocation availLocation = this.outputLocation;
        if (availLocation == null) {
            Unit unit;
            Unit $this$buildAvailArtifactJar_u24lambda_u2414 = unit = Unit.INSTANCE;
            boolean bl = false;
            failure.invoke("No artifact output location defined", null);
            return;
        }
        AvailLocation out2 = availLocation;
        Comparable<StringBuilder> comparable = new StringBuilder();
        StringBuilder $this$buildAvailArtifactJar_u24lambda_u2415 = comparable;
        boolean bl = false;
        if (StringsKt.isBlank(this.version)) {
            $this$buildAvailArtifactJar_u24lambda_u2415.append("\n\tMissing version");
        }
        if (StringsKt.isBlank(this.implementationTitle)) {
            $this$buildAvailArtifactJar_u24lambda_u2415.append("\n\tMissing implementationTitle");
        }
        String string2 = ((StringBuilder)comparable).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        String errorString = string2;
        if (!StringsKt.isBlank(errorString)) {
            failure.invoke("Avail Artifact Build Plan Failed Validation:\n" + errorString, null);
            return;
        }
        try {
            void $this$mapTo$iv$iv;
            Comparable<StringBuilder> $this$buildAvailArtifactJar_u24lambda_u2416 = comparable = new File(out2.getFullPathNoPrefix());
            boolean bl2 = false;
            new File(((File)$this$buildAvailArtifactJar_u24lambda_u2416).getParent()).mkdirs();
            ((File)$this$buildAvailArtifactJar_u24lambda_u2416).delete();
            Iterable $this$map$iv = project2.getRoots().values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AvailProjectRoot availProjectRoot = (AvailProjectRoot)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(it.getAvailRoot());
            }
            List roots2 = (List)destination$iv$iv;
            Map manifestMap = new LinkedHashMap();
            Iterable $this$forEach$iv = this.rootNames;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AvailProjectRoot r;
                String it = (String)element$iv;
                boolean bl4 = false;
                if (project2.getRoots().get(it) == null) continue;
                manifestMap.put(r.getName(), AvailProjectRoot.manifest$default(r, this.digestAlgorithm, null, 2, null));
            }
            AvailArtifactJarBuilder jarBuilder = new AvailArtifactJarBuilder(out2.getFullPathNoPrefix(), this.version, this.implementationTitle, AvailArtifactManifest.Companion.manifestFile(this.artifactType, manifestMap, this.artifactDescription), this.jarMainClass, this.customManifestItems);
            Iterable $this$forEach$iv2 = roots2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                AvailRoot it = (AvailRoot)element$iv;
                boolean bl5 = false;
                jarBuilder.addRoot(it);
            }
            $this$forEach$iv2 = this.includedFiles;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Pair it = (Pair)element$iv;
                boolean bl6 = false;
                jarBuilder.addFile(new File(((AvailLocation)it.getFirst()).getFullPathNoPrefix()), (String)it.getSecond());
            }
            $this$forEach$iv2 = this.jarFileLocations;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                AvailLocation it = (AvailLocation)element$iv;
                boolean bl7 = false;
                jarBuilder.addJar(new JarFile(new File(it.getFullPathNoPrefix())));
            }
            $this$forEach$iv2 = this.zipFileLocations;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                AvailLocation it = (AvailLocation)element$iv;
                boolean bl8 = false;
                jarBuilder.addZip(new ZipFile(new File(it.getFullPathNoPrefix())));
            }
            $this$forEach$iv2 = this.directoryLocations;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                AvailLocation it = (AvailLocation)element$iv;
                boolean bl9 = false;
                jarBuilder.addDir(new File(it.getFullPathNoPrefix()));
            }
            jarBuilder.finish();
            success2.invoke(out2.getFullPathNoPrefix());
        }
        catch (Throwable e) {
            failure.invoke("Failed to build " + out2.getFullPathNoPrefix(), e);
        }
    }

    @NotNull
    public String toString() {
        return this.implementationTitle;
    }

    public AvailArtifactBuildPlan(@NotNull String projectDirectory, @NotNull JSONObject obj) {
        block20: {
            JSONData it;
            Iterable<JSONData> iterable;
            String string2;
            String string3;
            String string4;
            String string5;
            AvailLocation availLocation;
            Object it2;
            Intrinsics.checkNotNullParameter(projectDirectory, "projectDirectory");
            Intrinsics.checkNotNullParameter(obj, "obj");
            this(null, null, null, null, null, null, null, null, null, null, null, null, null, 8191, null);
            String string6 = obj.getStringOrNull("version");
            if (string6 == null) {
                string6 = "";
            }
            this.version = string6;
            AvailArtifactBuildPlan availArtifactBuildPlan = this;
            JSONObject jSONObject = obj.getObjectOrNull("outputLocation");
            if (jSONObject != null) {
                JSONObject jSONObject2 = jSONObject;
                AvailArtifactBuildPlan availArtifactBuildPlan2 = availArtifactBuildPlan;
                boolean bl = false;
                availLocation = AvailLocation.Companion.from(projectDirectory, (JSONObject)it2);
                availArtifactBuildPlan = availArtifactBuildPlan2;
            } else {
                availLocation = null;
            }
            availArtifactBuildPlan.outputLocation = availLocation;
            String string7 = obj.getStringOrNull("artifactType");
            if (string7 != null) {
                it2 = string7;
                boolean bl = false;
                try {
                    this.artifactType = AvailArtifactType.valueOf((String)it2);
                }
                catch (IllegalArgumentException e) {
                    new AvailArtifactException("Invalid Avail Artifact Type: " + (String)it2).printStackTrace();
                }
            }
            if ((string5 = obj.getStringOrNull("implementationTitle")) == null) {
                string5 = this.implementationTitle = "";
            }
            if ((string4 = obj.getStringOrNull("jarMainClass")) == null) {
                string4 = this.jarMainClass = "";
            }
            if ((string3 = obj.getStringOrNull("artifactDescription")) == null) {
                string3 = this.artifactDescription = "";
            }
            if ((string2 = obj.getStringOrNull("digestAlgorithm")) == null) {
                string2 = this.digestAlgorithm = "";
            }
            if ((iterable = obj.getArrayOrNull("rootNames")) != null && (iterable = iterable.getStrings()) != null) {
                Object $this$_init__u24lambda_u2426 = it2 = iterable;
                boolean bl = false;
                this.rootNames.addAll((Collection)$this$_init__u24lambda_u2426);
            }
            JSONArray jSONArray = obj.getArrayOrNull("includedFiles");
            if (jSONArray != null) {
                Iterable $this$forEach$iv = jSONArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JSONData arr = (JSONData)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull(arr, "null cannot be cast to non-null type org.availlang.json.JSONArray");
                    JSONArray cfr_ignored_0 = (JSONArray)arr;
                    if (((JSONArray)arr).isEmpty()) continue;
                    this.includedFiles.add(TuplesKt.to(AvailLocation.Companion.from(projectDirectory, JSONArray.getObject$default((JSONArray)arr, 0, null, 2, null)), JSONArray.getString$default((JSONArray)arr, 1, null, 2, null)));
                }
            }
            JSONArray jSONArray2 = obj.getArrayOrNull("jarFileLocations");
            if (jSONArray2 != null) {
                JSONArray arr = jSONArray2;
                boolean bl = false;
                Iterable $this$forEach$iv = arr;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (JSONData)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.availlang.json.JSONObject");
                    this.jarFileLocations.add(AvailLocation.Companion.from(projectDirectory, (JSONObject)it));
                }
            }
            JSONArray jSONArray3 = obj.getArrayOrNull("zipFileLocations");
            if (jSONArray3 != null) {
                JSONArray arr = jSONArray3;
                boolean bl = false;
                Iterable $this$forEach$iv = arr;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (JSONData)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.availlang.json.JSONObject");
                    this.zipFileLocations.add(AvailLocation.Companion.from(projectDirectory, (JSONObject)it));
                }
            }
            JSONArray jSONArray4 = obj.getArrayOrNull("directoryLocations");
            if (jSONArray4 != null) {
                JSONArray arr = jSONArray4;
                boolean bl = false;
                Iterable $this$forEach$iv = arr;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (JSONData)element$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.availlang.json.JSONObject");
                    this.directoryLocations.add(AvailLocation.Companion.from(projectDirectory, (JSONObject)it));
                }
            }
            JSONObject jSONObject3 = obj.getObjectOrNull("customManifestItems");
            if (jSONObject3 == null) break block20;
            JSONObject o = jSONObject3;
            boolean bl = false;
            Iterable $this$forEach$iv = o;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl5 = false;
                String k = (String)entry.getKey();
                JSONData v = (JSONData)entry.getValue();
                this.customManifestItems.put(k, v.getString());
            }
        }
    }

    public AvailArtifactBuildPlan() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null, 8191, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u000e"}, d2={"Lorg/availlang/artifact/AvailArtifactBuildPlan$Companion;", "", "()V", "ARTIFACT_PLANS_FILE", "", "getARTIFACT_PLANS_FILE$annotations", "fileContent", "plans", "", "Lorg/availlang/artifact/AvailArtifactBuildPlan;", "readPlans", "", "projectFileName", "projectPath", "avail-artifact"})
    @SourceDebugExtension(value={"SMAP\nAvailArtifactBuildPlan.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvailArtifactBuildPlan.kt\norg/availlang/artifact/AvailArtifactBuildPlan$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,305:1\n1549#2:306\n1620#2,3:307\n*S KotlinDebug\n*F\n+ 1 AvailArtifactBuildPlan.kt\norg/availlang/artifact/AvailArtifactBuildPlan$Companion\n*L\n298#1:306\n298#1:307,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getARTIFACT_PLANS_FILE$annotations() {
        }

        @NotNull
        public final String fileContent(@NotNull List<AvailArtifactBuildPlan> plans) {
            Intrinsics.checkNotNullParameter(plans, "plans");
            return UtilityKt.jsonPrettyPrintWriter((Function1<? super JSONWriter, Unit>)new Function1<JSONWriter, Unit>(plans){
                final /* synthetic */ List<AvailArtifactBuildPlan> $plans;
                {
                    this.$plans = $plans;
                    super(1);
                }

                public final void invoke(@NotNull JSONWriter $this$jsonPrettyPrintWriter) {
                    Intrinsics.checkNotNullParameter($this$jsonPrettyPrintWriter, "$this$jsonPrettyPrintWriter");
                    $this$jsonPrettyPrintWriter.writeArray((Iterable<? extends JSONFriendly>)this.$plans);
                }
            }).toString();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<AvailArtifactBuildPlan> readPlans(@NotNull String projectFileName, @NotNull String projectPath) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(projectFileName, "projectFileName");
            Intrinsics.checkNotNullParameter(projectPath, "projectPath");
            Iterable $this$map$iv = UtilityKt.jsonArray(FilesKt.readText$default(new File(AvailEnvironment.INSTANCE.projectConfigPath(projectFileName, projectPath) + "/artifact-plans.json"), null, 1, null), (Function1<? super JSONArray, Unit>)readPlans.1.INSTANCE);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JSONData jSONData = (JSONData)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.availlang.json.JSONObject");
                collection2.add(new AvailArtifactBuildPlan(projectPath, (JSONObject)it));
            }
            return CollectionsKt.toMutableList((List)destination$iv$iv);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

