/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact.environment.project;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\t"}, d2={"compactLocalTimestamp", "", "millisUnixEpoch", "", "formattedLocalTimestamp", "formatPattern", "localTimestamp", "zonedDateTime", "Ljava/time/ZonedDateTime;", "avail-artifact"})
public final class ProjectProblemsKt {
    @NotNull
    public static final ZonedDateTime zonedDateTime(long millisUnixEpoch) {
        ZoneId zoneId = ZonedDateTime.now().getZone();
        Instant instant = Instant.ofEpochMilli(millisUnixEpoch);
        ZonedDateTime zonedDateTime = ZonedDateTime.of(instant.atZone(zoneId).toLocalDate(), instant.atZone(zoneId).toLocalTime(), zoneId);
        Intrinsics.checkNotNullExpressionValue(zonedDateTime, "of(...)");
        return zonedDateTime;
    }

    @NotNull
    public static final String formattedLocalTimestamp(long millisUnixEpoch, @NotNull String formatPattern) {
        Intrinsics.checkNotNullParameter(formatPattern, "formatPattern");
        String string2 = DateTimeFormatter.ofPattern(formatPattern).format(ProjectProblemsKt.zonedDateTime(millisUnixEpoch));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public static final String localTimestamp(long millisUnixEpoch) {
        return ProjectProblemsKt.formattedLocalTimestamp(millisUnixEpoch, "yyyy/MM/dd HH:mm:ss'.'SSS z");
    }

    @NotNull
    public static final String compactLocalTimestamp(long millisUnixEpoch) {
        return ProjectProblemsKt.formattedLocalTimestamp(millisUnixEpoch, "yyyyMMddHHmmss");
    }
}

