/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceAnnotationVisitor;

public final class TraceMethodVisitor
extends MethodVisitor {
    public final Printer p;

    public TraceMethodVisitor(Printer printer) {
        this(null, printer);
    }

    public TraceMethodVisitor(MethodVisitor methodVisitor, Printer printer) {
        super(589824, methodVisitor);
        this.p = printer;
    }

    public void visitParameter(String name, int access) {
        this.p.visitParameter(name, access);
        super.visitParameter(name, access);
    }

    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        Printer annotationPrinter = this.p.visitMethodAnnotation(descriptor2, visible);
        return new TraceAnnotationVisitor(super.visitAnnotation(descriptor2, visible), annotationPrinter);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        Printer annotationPrinter = this.p.visitMethodTypeAnnotation(typeRef, typePath, descriptor2, visible);
        return new TraceAnnotationVisitor(super.visitTypeAnnotation(typeRef, typePath, descriptor2, visible), annotationPrinter);
    }

    public void visitAttribute(Attribute attribute) {
        this.p.visitMethodAttribute(attribute);
        super.visitAttribute(attribute);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        Printer annotationPrinter = this.p.visitAnnotationDefault();
        return new TraceAnnotationVisitor(super.visitAnnotationDefault(), annotationPrinter);
    }

    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
        this.p.visitAnnotableParameterCount(parameterCount, visible);
        super.visitAnnotableParameterCount(parameterCount, visible);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor2, boolean visible) {
        Printer annotationPrinter = this.p.visitParameterAnnotation(parameter, descriptor2, visible);
        return new TraceAnnotationVisitor(super.visitParameterAnnotation(parameter, descriptor2, visible), annotationPrinter);
    }

    public void visitCode() {
        this.p.visitCode();
        super.visitCode();
    }

    public void visitFrame(int type2, int numLocal, Object[] local, int numStack, Object[] stack) {
        this.p.visitFrame(type2, numLocal, local, numStack, stack);
        super.visitFrame(type2, numLocal, local, numStack, stack);
    }

    public void visitInsn(int opcode) {
        this.p.visitInsn(opcode);
        super.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.p.visitIntInsn(opcode, operand);
        super.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.p.visitVarInsn(opcode, var);
        super.visitVarInsn(opcode, var);
    }

    public void visitTypeInsn(int opcode, String type2) {
        this.p.visitTypeInsn(opcode, type2);
        super.visitTypeInsn(opcode, type2);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor2) {
        this.p.visitFieldInsn(opcode, owner, name, descriptor2);
        super.visitFieldInsn(opcode, owner, name, descriptor2);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor2, boolean isInterface) {
        if (this.p.api < 327680) {
            if (isInterface != (opcode == 185)) {
                throw new IllegalArgumentException("INVOKESPECIAL/STATIC on interfaces require ASM5");
            }
            this.p.visitMethodInsn(opcode, owner, name, descriptor2);
        } else {
            this.p.visitMethodInsn(opcode, owner, name, descriptor2, isInterface);
        }
        if (this.mv != null) {
            this.mv.visitMethodInsn(opcode, owner, name, descriptor2, isInterface);
        }
    }

    public void visitInvokeDynamicInsn(String name, String descriptor2, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        this.p.visitInvokeDynamicInsn(name, descriptor2, bootstrapMethodHandle, bootstrapMethodArguments);
        super.visitInvokeDynamicInsn(name, descriptor2, bootstrapMethodHandle, bootstrapMethodArguments);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.p.visitJumpInsn(opcode, label);
        super.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        this.p.visitLabel(label);
        super.visitLabel(label);
    }

    public void visitLdcInsn(Object value) {
        this.p.visitLdcInsn(value);
        super.visitLdcInsn(value);
    }

    public void visitIincInsn(int var, int increment) {
        this.p.visitIincInsn(var, increment);
        super.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min2, int max2, Label dflt, Label ... labels) {
        this.p.visitTableSwitchInsn(min2, max2, dflt, labels);
        super.visitTableSwitchInsn(min2, max2, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
        this.p.visitLookupSwitchInsn(dflt, keys2, labels);
        super.visitLookupSwitchInsn(dflt, keys2, labels);
    }

    public void visitMultiANewArrayInsn(String descriptor2, int numDimensions) {
        this.p.visitMultiANewArrayInsn(descriptor2, numDimensions);
        super.visitMultiANewArrayInsn(descriptor2, numDimensions);
    }

    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        Printer annotationPrinter = this.p.visitInsnAnnotation(typeRef, typePath, descriptor2, visible);
        return new TraceAnnotationVisitor(super.visitInsnAnnotation(typeRef, typePath, descriptor2, visible), annotationPrinter);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type2) {
        this.p.visitTryCatchBlock(start, end, handler, type2);
        super.visitTryCatchBlock(start, end, handler, type2);
    }

    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        Printer annotationPrinter = this.p.visitTryCatchAnnotation(typeRef, typePath, descriptor2, visible);
        return new TraceAnnotationVisitor(super.visitTryCatchAnnotation(typeRef, typePath, descriptor2, visible), annotationPrinter);
    }

    public void visitLocalVariable(String name, String descriptor2, String signature2, Label start, Label end, int index2) {
        this.p.visitLocalVariable(name, descriptor2, signature2, start, end, index2);
        super.visitLocalVariable(name, descriptor2, signature2, start, end, index2);
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index2, String descriptor2, boolean visible) {
        Printer annotationPrinter = this.p.visitLocalVariableAnnotation(typeRef, typePath, start, end, index2, descriptor2, visible);
        return new TraceAnnotationVisitor(super.visitLocalVariableAnnotation(typeRef, typePath, start, end, index2, descriptor2, visible), annotationPrinter);
    }

    public void visitLineNumber(int line, Label start) {
        this.p.visitLineNumber(line, start);
        super.visitLineNumber(line, start);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.p.visitMaxs(maxStack, maxLocals);
        super.visitMaxs(maxStack, maxLocals);
    }

    public void visitEnd() {
        this.p.visitMethodEnd();
        super.visitEnd();
    }
}

