/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.core.Environment;
import freemarker.ext.dom.NodeListModel;
import freemarker.ext.dom.NodeModel;
import freemarker.ext.dom.NodeOutputter;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.StringUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ElementModel
extends NodeModel
implements TemplateScalarModel {
    public ElementModel(Element element) {
        super(element);
    }

    public boolean isEmpty() {
        return false;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if (key.equals("*")) {
            NodeListModel ns = new NodeListModel(this);
            TemplateSequenceModel children = this.getChildNodes();
            for (int i = 0; i < children.size(); ++i) {
                NodeModel child = (NodeModel)children.get(i);
                if (child.node.getNodeType() != 1) continue;
                ns.add(child);
            }
            return ns;
        }
        if (key.equals("**")) {
            Element elem = (Element)this.node;
            return new NodeListModel(elem.getElementsByTagName("*"), (NodeModel)this);
        }
        if (key.startsWith("@")) {
            if (key.equals("@@") || key.equals("@*")) {
                return new NodeListModel(this.node.getAttributes(), (NodeModel)this);
            }
            if (key.equals("@@start_tag")) {
                NodeOutputter nodeOutputter = new NodeOutputter(this.node);
                return new SimpleScalar(nodeOutputter.getOpeningTag((Element)this.node));
            }
            if (key.equals("@@end_tag")) {
                NodeOutputter nodeOutputter = new NodeOutputter(this.node);
                return new SimpleScalar(nodeOutputter.getClosingTag((Element)this.node));
            }
            if (key.equals("@@attributes_markup")) {
                StringBuilder buf = new StringBuilder();
                NodeOutputter nu = new NodeOutputter(this.node);
                nu.outputContent(this.node.getAttributes(), buf);
                return new SimpleScalar(buf.toString().trim());
            }
            if (StringUtil.isXMLID(key.substring(1))) {
                Attr att = this.getAttribute(key.substring(1));
                if (att == null) {
                    return new NodeListModel(this);
                }
                return ElementModel.wrap(att);
            }
        }
        if (StringUtil.isXMLID(key)) {
            NodeListModel result2 = ((NodeListModel)this.getChildNodes()).filterByName(key);
            if (result2.size() == 1) {
                return result2.get(0);
            }
            return result2;
        }
        return super.get(key);
    }

    public String getAsString() throws TemplateModelException {
        NodeList nl = this.node.getChildNodes();
        String result2 = "";
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            short nodeType = child.getNodeType();
            if (nodeType == 1) {
                String msg = "Only elements with no child elements can be processed as text.\nThis element with name \"" + this.node.getNodeName() + "\" has a child element named: " + child.getNodeName();
                throw new TemplateModelException(msg);
            }
            if (nodeType != 3 && nodeType != 4) continue;
            result2 = result2 + child.getNodeValue();
        }
        return result2;
    }

    public String getNodeName() {
        String result2 = this.node.getLocalName();
        if (result2 == null || result2.equals("")) {
            result2 = this.node.getNodeName();
        }
        return result2;
    }

    String getQualifiedName() {
        String nodeName = this.getNodeName();
        String nsURI = this.getNodeNamespace();
        if (nsURI == null || nsURI.length() == 0) {
            return nodeName;
        }
        Environment env = Environment.getCurrentEnvironment();
        String defaultNS = env.getDefaultNS();
        String prefix = defaultNS != null && defaultNS.equals(nsURI) ? "" : env.getPrefixForNamespace(nsURI);
        if (prefix == null) {
            return null;
        }
        if (prefix.length() > 0) {
            prefix = prefix + ":";
        }
        return prefix + nodeName;
    }

    private Attr getAttribute(String qname) {
        Element element = (Element)this.node;
        Attr result2 = element.getAttributeNode(qname);
        if (result2 != null) {
            return result2;
        }
        int colonIndex = qname.indexOf(58);
        if (colonIndex > 0) {
            String prefix = qname.substring(0, colonIndex);
            String uri = prefix.equals("D") ? Environment.getCurrentEnvironment().getDefaultNS() : Environment.getCurrentEnvironment().getNamespaceForPrefix(prefix);
            String localName = qname.substring(1 + colonIndex);
            if (uri != null) {
                result2 = element.getAttributeNodeNS(uri, localName);
            }
        }
        return result2;
    }

    boolean matchesName(String name, Environment env) {
        return StringUtil.matchesName(name, this.getNodeName(), this.getNodeNamespace(), env);
    }
}

