/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.core.Environment;
import freemarker.core._UnexpectedTypeErrorExplainerTemplateModel;
import freemarker.ext.dom.ElementModel;
import freemarker.ext.dom.NodeModel;
import freemarker.ext.dom.XPathSupport;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NodeListModel
extends SimpleSequence
implements TemplateHashModel,
_UnexpectedTypeErrorExplainerTemplateModel {
    NodeModel contextNode;
    XPathSupport xpathSupport;
    private static ObjectWrapper nodeWrapper = new ObjectWrapper(){

        public TemplateModel wrap(Object obj) {
            if (obj instanceof NodeModel) {
                return (NodeModel)obj;
            }
            return NodeModel.wrap((Node)obj);
        }
    };

    NodeListModel(Node node) {
        this(NodeModel.wrap(node));
    }

    NodeListModel(NodeModel contextNode) {
        super(nodeWrapper);
        this.contextNode = contextNode;
    }

    NodeListModel(NodeList nodeList, NodeModel contextNode) {
        super(nodeWrapper);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.list.add(nodeList.item(i));
        }
        this.contextNode = contextNode;
    }

    NodeListModel(NamedNodeMap nodeList, NodeModel contextNode) {
        super(nodeWrapper);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.list.add(nodeList.item(i));
        }
        this.contextNode = contextNode;
    }

    NodeListModel(List list, NodeModel contextNode) {
        super(list, nodeWrapper);
        this.contextNode = contextNode;
    }

    NodeListModel filterByName(String name) throws TemplateModelException {
        NodeListModel result2 = new NodeListModel(this.contextNode);
        int size = this.size();
        if (size == 0) {
            return result2;
        }
        Environment env = Environment.getCurrentEnvironment();
        for (int i = 0; i < size; ++i) {
            NodeModel nm = (NodeModel)this.get(i);
            if (!(nm instanceof ElementModel) || !((ElementModel)nm).matchesName(name, env)) continue;
            result2.add(nm);
        }
        return result2;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if (this.size() == 1) {
            NodeModel nm = (NodeModel)this.get(0);
            return nm.get(key);
        }
        if (key.startsWith("@@") && (key.equals("@@markup") || key.equals("@@nested_markup") || key.equals("@@text"))) {
            StringBuilder result2 = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                NodeModel nm = (NodeModel)this.get(i);
                TemplateScalarModel textModel = (TemplateScalarModel)nm.get(key);
                result2.append(textModel.getAsString());
            }
            return new SimpleScalar(result2.toString());
        }
        if (StringUtil.isXMLID(key) || key.startsWith("@") && StringUtil.isXMLID(key.substring(1)) || key.equals("*") || key.equals("**") || key.equals("@@") || key.equals("@*")) {
            NodeListModel result3 = new NodeListModel(this.contextNode);
            for (int i = 0; i < this.size(); ++i) {
                TemplateSequenceModel tsm;
                NodeModel nm = (NodeModel)this.get(i);
                if (!(nm instanceof ElementModel) || (tsm = (TemplateSequenceModel)((ElementModel)nm).get(key)) == null) continue;
                int size = tsm.size();
                for (int j = 0; j < size; ++j) {
                    result3.add(tsm.get(j));
                }
            }
            if (result3.size() == 1) {
                return result3.get(0);
            }
            return result3;
        }
        XPathSupport xps = this.getXPathSupport();
        if (xps != null) {
            List context = this.size() == 0 ? null : this.rawNodeList();
            return xps.executeQuery(context, key);
        }
        throw new TemplateModelException("Key: '" + key + "' is not legal for a node sequence (" + this.getClass().getName() + "). This node sequence contains " + this.size() + " node(s). " + "Some keys are valid only for node sequences of size 1. " + "If you use Xalan (instead of Jaxen), XPath expression keys work only with " + "node lists of size 1.");
    }

    private List rawNodeList() throws TemplateModelException {
        int size = this.size();
        ArrayList<Node> al = new ArrayList<Node>(size);
        for (int i = 0; i < size; ++i) {
            al.add(((NodeModel)this.get((int)i)).node);
        }
        return al;
    }

    XPathSupport getXPathSupport() throws TemplateModelException {
        if (this.xpathSupport == null) {
            if (this.contextNode != null) {
                this.xpathSupport = this.contextNode.getXPathSupport();
            } else if (this.size() > 0) {
                this.xpathSupport = ((NodeModel)this.get(0)).getXPathSupport();
            }
        }
        return this.xpathSupport;
    }

    public Object[] explainTypeError(Class[] expectedClasses) {
        for (int i = 0; i < expectedClasses.length; ++i) {
            Class expectedClass = expectedClasses[i];
            if (TemplateScalarModel.class.isAssignableFrom(expectedClass) || TemplateDateModel.class.isAssignableFrom(expectedClass) || TemplateNumberModel.class.isAssignableFrom(expectedClass) || TemplateBooleanModel.class.isAssignableFrom(expectedClass)) {
                return this.newTypeErrorExplanation("string");
            }
            if (!TemplateNodeModel.class.isAssignableFrom(expectedClass)) continue;
            return this.newTypeErrorExplanation("node");
        }
        return null;
    }

    private Object[] newTypeErrorExplanation(String type) {
        return new Object[]{"This XML query result can't be used as ", type, " because for that it had to contain exactly 1 XML node, but it contains ", this.size(), " nodes. That is, the constructing XML query has found ", this.isEmpty() ? "no matches." : "multiple matches."};
    }
}

