/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.freemarker;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.avaje.freemarker.ModelView;
import org.avaje.freemarker.TemplateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"text/html", "text/html"})
public class ModelViewJaxrsProducer
implements MessageBodyWriter<ModelView> {
    private static final Logger log = LoggerFactory.getLogger(ModelViewJaxrsProducer.class);
    private final TemplateService templateService;

    @Inject
    public ModelViewJaxrsProducer(TemplateService templateService) {
        this.templateService = templateService;
    }

    public long getSize(ModelView modelView, Class<?> cls, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> cls, Type type, Annotation[] annotations, MediaType mediaType) {
        return ModelView.class.isAssignableFrom(cls);
    }

    public void writeTo(ModelView modelView, Class<?> cls, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream os2) throws IOException, WebApplicationException {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os2));
            this.templateService.render(modelView.getView(), modelView.getModel(), writer);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            log.error("Template not found: " + e.getMessage());
            ModelView notFoundView = this.templateService.buildNotFound(modelView.getView());
            Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)notFoundView).type("text/html").build();
            throw new WebApplicationException(response);
        }
        catch (Exception e) {
            log.error("Error rendering template", e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

