/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.avaje.freemarker.ConfigurationBuilder;
import org.avaje.freemarker.ModelView;
import org.avaje.freemarker.TemplateConfig;
import org.avaje.freemarker.TemplateNotFoundBuilder;
import org.avaje.freemarker.layout.InheritLayoutTemplateLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Component
public class TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateService.class);
    private final ServletContext servletContext;
    private final Configuration configuration;
    private final TemplateNotFoundBuilder templateNotFoundBuilder;
    private final String viewSuffix;

    @Inject
    public TemplateService(WebApplicationContext webAppContext, TemplateConfig config2, TemplateNotFoundBuilder notFoundBuilder) {
        this(webAppContext.getServletContext(), config2, notFoundBuilder);
    }

    public TemplateService(ServletContext servletContext, TemplateConfig config2, TemplateNotFoundBuilder templateNotFoundBuilder) {
        this.templateNotFoundBuilder = templateNotFoundBuilder;
        this.servletContext = servletContext;
        this.viewSuffix = config2.getViewSuffix();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        boolean devMode = config2.isDevMode();
        int updateDelay = config2.getUpdateDelay();
        String templatePath = config2.getTemplatePath();
        log.info("templates devMode:{} updateDelay:{} templatePath:{}", devMode, updateDelay, templatePath);
        builder.setUseExceptionHandler(devMode);
        if (!devMode) {
            builder.setTemplateUpdateDelay(updateDelay);
        }
        builder.setTemplateLoader(this.createTemplateLoader(templatePath));
        this.configuration = builder.build();
    }

    private TemplateLoader createTemplateLoader(String templatePath) {
        log.debug("templatePath: {}", (Object)templatePath);
        return InheritLayoutTemplateLoader.createWebappLoader(this.servletContext, templatePath);
    }

    public ModelView buildNotFound(String templateName) {
        return this.templateNotFoundBuilder.buildNotFound(templateName);
    }

    public void render(String templateName, Map<?, ?> model, Writer writer) throws IOException {
        Template template;
        try {
            if (!templateName.endsWith(this.viewSuffix)) {
                templateName = templateName + this.viewSuffix;
            }
            template = this.configuration.getTemplate(templateName);
        }
        catch (IOException e) {
            throw new IOException("Error loading template: " + templateName, e);
        }
        try {
            SimpleHash wrappedModel = new SimpleHash(model);
            template.process(wrappedModel, writer);
        }
        catch (TemplateException e) {
            log.error("Error processing template: " + templateName, e);
        }
    }
}

