/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.freemarker.layout;

class StringHelper {
    StringHelper() {
    }

    public static String replaceString(String source, String match, String replace) {
        return StringHelper.replaceString(source, match, replace, 0);
    }

    public static String replaceString(String source, String match, String replace, int startSearchPos) {
        if (source == null) {
            return null;
        }
        if (replace == null) {
            return source;
        }
        if (match == null) {
            throw new NullPointerException("match is null?");
        }
        if (match.equals(replace)) {
            return source;
        }
        int extra = replace.length() - match.length();
        if (extra < 0) {
            extra = 0;
        }
        return StringHelper.replaceString(source, match, replace, extra, startSearchPos, source.length());
    }

    public static String replaceString(String source, String match, String replace, int additionalSize, int startPos, int endPos) {
        if (source == null) {
            return source;
        }
        char match0 = match.charAt(0);
        int matchLength = match.length();
        if (matchLength == 1 && replace.length() == 1) {
            char replace0 = replace.charAt(0);
            return source.replace(match0, replace0);
        }
        if (matchLength >= replace.length()) {
            additionalSize = 0;
        }
        int sourceLength = source.length();
        int lastMatch = endPos - matchLength;
        StringBuilder sb = new StringBuilder(sourceLength + additionalSize);
        if (startPos > 0) {
            sb.append(source.substring(0, startPos));
        }
        for (int i = startPos; i < sourceLength; ++i) {
            char sourceChar = source.charAt(i);
            if (i > lastMatch || sourceChar != match0) {
                sb.append(sourceChar);
                continue;
            }
            boolean isMatch = true;
            int sourceMatchPos = i;
            for (int j = 1; j < matchLength; ++j) {
                if (source.charAt(++sourceMatchPos) == match.charAt(j)) continue;
                isMatch = false;
                break;
            }
            if (isMatch) {
                i = i + matchLength - 1;
                sb.append(replace);
                continue;
            }
            sb.append(sourceChar);
        }
        return sb.toString();
    }

    static String replaceStringMulti(String source, String[] match, String replace) {
        return StringHelper.replaceStringMulti(source, match, replace, 30, 0, source.length());
    }

    static String replaceStringMulti(String source, String[] match, String replace, int additionalSize, int startPos, int endPos) {
        int shortestMatch = match[0].length();
        char[] match0 = new char[match.length];
        for (int i = 0; i < match0.length; ++i) {
            match0[i] = match[i].charAt(0);
            if (match[i].length() >= shortestMatch) continue;
            shortestMatch = match[i].length();
        }
        StringBuilder sb = new StringBuilder(source.length() + additionalSize);
        int len = source.length();
        int lastMatch = endPos - shortestMatch;
        if (startPos > 0) {
            sb.append(source.substring(0, startPos));
        }
        int matchCount = 0;
        for (int i = startPos; i < len; ++i) {
            char sourceChar = source.charAt(i);
            if (i > lastMatch) {
                sb.append(sourceChar);
                continue;
            }
            matchCount = 0;
            for (int k = 0; k < match0.length; ++k) {
                int j;
                if (matchCount != 0 || sourceChar != match0[k] || match[k].length() + i > len) continue;
                ++matchCount;
                for (j = 1; j < match[k].length(); ++j) {
                    if (source.charAt(i + j) == match[k].charAt(j)) continue;
                    --matchCount;
                    break;
                }
                if (matchCount <= 0) continue;
                i = i + j - 1;
                sb.append(replace);
                break;
            }
            if (matchCount != 0) continue;
            sb.append(sourceChar);
        }
        return sb.toString();
    }

    static String removeChars(String s, char[] chr) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (StringHelper.charMatch(c, chr)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean charMatch(int iChr, char[] chr) {
        for (int i = 0; i < chr.length; ++i) {
            if (iChr != chr[i]) continue;
            return true;
        }
        return false;
    }
}

