/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.freemarker.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class EncodeUtil {
    private EncodeUtil() {
    }

    public static String urlEncode(String string2) {
        if (string2 == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Support for UTF-8 is mandated by the Java spec", e);
        }
    }

    public static String urlDecode(String string2) {
        if (string2 == null) {
            return null;
        }
        try {
            return URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Support for UTF-8 is mandated by the Java spec", e);
        }
    }

    public static byte[] asciiToBytes(String string2) {
        if (string2 == null) {
            return null;
        }
        try {
            return string2.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Support for US-ASCII is mandated by the Java spec", e);
        }
    }

    public static String bytesToAscii(byte[] data) {
        try {
            return new String(data, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Support for US-ASCII is mandated by the Java spec", e);
        }
    }

    public static byte[] utf8ToBytes(String string2) {
        if (string2 == null) {
            return null;
        }
        try {
            return string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Support for UTF-8 is mandated by the Java spec", e);
        }
    }

    public static String bytesToUtf8(byte[] data) {
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Support for UTF-8 is mandated by the Java spec", e);
        }
    }

    public static String decodeBytes(byte[] data, String encoding) {
        try {
            return new String(data, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error decoding bytes with " + encoding, e);
        }
    }
}

