/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.freemarker.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import org.avaje.freemarker.util.EncodeUtil;

public class IOUtil {
    private IOUtil() {
    }

    public static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        IOUtil.pump(in, buffer);
        return buffer.toByteArray();
    }

    public static String readAscii(InputStream in) throws IOException {
        return EncodeUtil.bytesToAscii(IOUtil.read(in));
    }

    public static String readUTF8(InputStream in) throws IOException {
        return EncodeUtil.bytesToUtf8(IOUtil.read(in));
    }

    public static String readUtf8(InputStream in) throws IOException {
        return EncodeUtil.bytesToUtf8(IOUtil.read(in));
    }

    public static String readEncoded(InputStream in, String encoding) throws IOException {
        return EncodeUtil.decodeBytes(IOUtil.read(in), encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            int len;
            char[] buffer = new char[4096];
            while ((len = reader.read(buffer)) >= 0) {
                sb.append(buffer, 0, len);
            }
        }
        finally {
            reader.close();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pump(InputStream in, OutputStream out) throws IOException {
        if (in == null) {
            throw new IOException("Input stream is null");
        }
        if (out == null) {
            throw new IOException("Output stream is null");
        }
        try {
            try {
                int bytes;
                byte[] buffer = new byte[4096];
                while ((bytes = in.read(buffer)) >= 0) {
                    out.write(buffer, 0, bytes);
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            out.close();
        }
    }
}

