/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.website.generator;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;

public class HighlightFields {
    private final String withField = "<span class=\"o\">.</span><span class=\"na field\">";
    private final String withEnd = "</span>";
    private final String startMatch = "<span class=\"o\">.</span><span class=\"na\">";
    private final String endMatch = "</span><span class=\"o\">.</span>";

    public String highlight(String fullHtml) {
        StringReader sr = new StringReader(fullHtml);
        LineNumberReader reader = new LineNumberReader(sr);
        StringBuilder sb = new StringBuilder(fullHtml.length());
        try {
            String line;
            boolean firstLine = true;
            while ((line = reader.readLine()) != null) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    sb.append('\n');
                }
                sb.append(this.process(line));
            }
            return sb.toString();
        }
        catch (IOException e) {
            return fullHtml;
        }
    }

    private String process(String line) {
        StringBuilder sb = new StringBuilder(line.length());
        this.process(0, line, sb);
        return sb.toString();
    }

    private void process(int at, String line, StringBuilder sb) {
        int pos = line.indexOf("<span class=\"o\">.</span><span class=\"na\">", at);
        if (pos == -1) {
            sb.append(line.substring(at));
            return;
        }
        int next = pos + "<span class=\"o\">.</span><span class=\"na\">".length() + 1;
        int pos2 = line.indexOf("<", next);
        if (pos2 == -1) {
            sb.append(line.substring(at));
            return;
        }
        int pos3 = line.indexOf("</span><span class=\"o\">.</span>", next);
        if (pos3 == -1) {
            sb.append(line.substring(at));
            return;
        }
        if (pos2 != pos3) {
            sb.append(line.substring(at, pos2));
            this.process(pos2, line, sb);
        } else {
            String val = line.substring(at, pos);
            sb.append(val);
            sb.append("<span class=\"o\">.</span><span class=\"na field\">");
            int litStart = pos + "<span class=\"o\">.</span><span class=\"na\">".length();
            String literal = line.substring(litStart, pos2);
            sb.append(literal);
            sb.append("</span>");
            int end = pos3 + "</span>".length();
            this.process(end, line, sb);
        }
    }
}

