/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.website.generator;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.avaje.website.generator.SiteWatchRender;

public class Main {
    public static void main(String[] args) throws IOException {
        File destDir;
        String source = System.getProperty("source");
        String dest = System.getProperty("dest");
        if (args.length == 2) {
            source = args[0];
            dest = args[1];
        } else if (args.length > 2) {
            Map<String, String> argMap = Main.parseArgs(args);
            source = argMap.get("source");
            dest = argMap.get("dest");
        }
        if (source == null || dest == null) {
            Main.printUsage(source, dest);
            return;
        }
        source = source.trim();
        dest = dest.trim();
        File sourceDir = new File(source);
        if (!sourceDir.exists()) {
            Main.printError("source directory " + source + " does not exist?");
            System.exit(0);
        }
        if (!sourceDir.isDirectory()) {
            Main.printError("source " + source + " is not a directory?");
            System.exit(0);
        }
        if (!(destDir = new File(dest)).exists()) {
            if (!destDir.mkdirs()) {
                Main.printError("failed to create destination directory " + dest);
                System.exit(0);
            }
        } else if (!destDir.isDirectory()) {
            Main.printError("destination " + dest + " is not a directory?");
            System.exit(0);
        }
        SiteWatchRender site2 = new SiteWatchRender(sourceDir, destDir);
        site2.render();
        site2.run();
    }

    private static void printError(String msg) {
        System.err.println(msg);
    }

    private static Map<String, String> parseArgs(String[] args) {
        LinkedHashMap<String, String> argMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            if (Main.isSource(args[i])) {
                argMap.put("source", args[++i]);
                continue;
            }
            if (!Main.isDest(args[i])) continue;
            argMap.put("dest", args[++i]);
        }
        return argMap;
    }

    private static boolean isSource(String arg) {
        return "-source".equalsIgnoreCase(arg) || "-s".equalsIgnoreCase(arg);
    }

    private static boolean isDest(String arg) {
        return "-dest".equalsIgnoreCase(arg) || "-d".equalsIgnoreCase(arg);
    }

    private static void printUsage(String source, String dest) {
        String noSource = source != null ? "" : "no source specified";
        String noDest = dest != null ? "" : " no destination specified";
        System.out.println("error: " + noSource + noDest);
        System.out.println("usage: -s <source directory> -d <destination directory>");
    }
}

