/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.website.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import org.avaje.website.generator.TemplateRender;
import org.avaje.website.generator.WatchDir;
import org.avaje.website.generator.WatchDirCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteWatchRender {
    public static final Logger log = LoggerFactory.getLogger(SiteWatchRender.class);
    private final Path sourceDirectory;
    private final File destinationDirectory;
    private final TemplateRender renderService;

    public SiteWatchRender(File sourceDirectory, File destinationDirectory) {
        this.sourceDirectory = sourceDirectory.toPath();
        this.destinationDirectory = destinationDirectory;
        this.renderService = new TemplateRender(sourceDirectory);
        this.destinationDirectory.mkdirs();
    }

    public void run() throws IOException {
        WatchDir watchDir = new WatchDir(this.sourceDirectory, true, new Callback(), null);
        watchDir.processEvents();
    }

    public void render() throws IOException {
        log.info("source:{} dest:{}", (Object)this.sourceDirectory, (Object)this.destinationDirectory);
        DirectoryWalkProcessFile fileProcessor = new DirectoryWalkProcessFile();
        Files.walkFileTree(this.sourceDirectory, fileProcessor);
    }

    private boolean isIgnoreFile(Path file) {
        return file.getFileName().toString().startsWith(".");
    }

    private boolean isIgnoreFile(String templateName) {
        return templateName.startsWith(".");
    }

    private void processFileDelete(Path file) {
        if (this.isIgnoreFile(file)) {
            return;
        }
        String templateName = this.sourceDirectory.relativize(file).toString();
        if (this.isIgnoreFile(templateName)) {
            return;
        }
        try {
            File outFile = new File(this.destinationDirectory, templateName);
            if (outFile.exists()) {
                if (outFile.isDirectory()) {
                    this.deleteDirectory(outFile.toPath());
                    log.debug("... deleted directory {}", (Object)outFile.getAbsolutePath());
                } else if (!outFile.delete()) {
                    log.error("failed to delete file from destination: " + outFile.getAbsolutePath());
                } else {
                    log.debug("... deleted file {}", (Object)outFile.getAbsolutePath());
                }
            }
        }
        catch (IOException e) {
            log.error("Error trying to delete file or directory " + file, e);
        }
    }

    private void deleteDirectory(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void processFile(Path file) {
        if (this.isIgnoreFile(file)) {
            return;
        }
        String templateName = this.sourceDirectory.relativize(file).toString();
        if (this.isIgnoreFile(templateName)) {
            return;
        }
        try {
            File outFile = new File(this.destinationDirectory, templateName);
            this.makeParentDirectories(outFile);
            if (!templateName.toLowerCase().endsWith(".html")) {
                if (file.toFile().exists()) {
                    try {
                        Files.copy(file, outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        log.debug("... copy file: {}", (Object)templateName);
                    }
                    catch (NoSuchFileException e) {
                        log.trace("... ignore file not found (IDE removed): {}", (Object)templateName);
                    }
                }
                return;
            }
            log.debug("... render template: {}", (Object)templateName);
            FileWriter writer = new FileWriter(outFile);
            HashMap map = new HashMap();
            this.renderService.render(templateName, map, writer);
        }
        catch (IOException e) {
            log.error("Error processing file " + file, e);
        }
    }

    private boolean makeParentDirectories(File outFile) {
        File parentDir = outFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            log.error("Failed to create parent directories for: " + outFile.getAbsolutePath());
            return false;
        }
        return true;
    }

    private final class DirectoryWalkProcessFile
    extends SimpleFileVisitor<Path> {
        private DirectoryWalkProcessFile() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            SiteWatchRender.this.processFile(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes aAttrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }

    private class Callback
    implements WatchDirCallback {
        private Callback() {
        }

        @Override
        public void event(WatchEvent<Path> event, Path child, String eventKind) {
            log.trace("watch processing event:{} file:{}", (Object)eventKind, (Object)child);
            if (this.isDelete(eventKind)) {
                SiteWatchRender.this.processFileDelete(child);
            } else {
                SiteWatchRender.this.processFile(child);
            }
        }

        private boolean isDelete(String eventKind) {
            return "ENTRY_DELETE".equals(eventKind);
        }
    }
}

