/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.website.generator;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import org.avaje.freemarker.layout.ContentFilter;
import org.avaje.website.generator.HighlightFields;
import org.python.util.PythonInterpreter;

public class SyntaxHighlighter
implements ContentFilter {
    private PythonInterpreter interpreter = new PythonInterpreter();
    private final HighlightFields highlightFields = new HighlightFields();

    @Override
    public String filter(String content) {
        int start = content.indexOf("```");
        if (start == -1) {
            return content;
        }
        int endOfStartLine = content.indexOf(10, start + 3);
        if (endOfStartLine == -1) {
            return content;
        }
        int end = content.indexOf("```", endOfStartLine);
        if (end == -1) {
            return content;
        }
        String language = this.determineLanguage(content, start, endOfStartLine);
        StringBuilder buffer = new StringBuilder(content.length() + 1000);
        String rawSource = content.substring(endOfStartLine + 1, end);
        rawSource = this.trimRawSource(rawSource);
        String highlightedSource = this.formatSource(language, rawSource);
        if ("java".equalsIgnoreCase(language)) {
            highlightedSource = this.highlightFields.highlight(highlightedSource);
        }
        buffer.append(content.substring(0, start));
        buffer.append(highlightedSource);
        String remainder = content.substring(end + 3);
        buffer.append(this.filter(remainder));
        return buffer.toString();
    }

    protected String trimRawSource(String rawSource) {
        int firstChar = this.findFirstChar(rawSource);
        if (firstChar == 0) {
            return rawSource;
        }
        try {
            String line;
            rawSource = rawSource.trim();
            StringBuilder sb = new StringBuilder(rawSource.length());
            LineNumberReader lineReader = new LineNumberReader(new StringReader(rawSource));
            boolean firstLine = true;
            while ((line = lineReader.readLine()) != null) {
                if (firstLine) {
                    sb.append(line);
                    firstLine = false;
                    continue;
                }
                sb.append("\n");
                if (line.length() > firstChar) {
                    sb.append(line.substring(firstChar));
                    continue;
                }
                sb.append(line);
            }
            return sb.toString();
        }
        catch (IOException e) {
            return rawSource;
        }
    }

    private int findFirstChar(String content) {
        int start = 0;
        if (this.startsWithNewLine(content)) {
            start = 1;
        }
        for (int i = start; i < content.length(); ++i) {
            if (Character.isWhitespace(content.charAt(i))) continue;
            return i - start;
        }
        return 0;
    }

    private boolean startsWithNewLine(String content) {
        char ch = content.charAt(0);
        return ch == '\n' || ch == '\r';
    }

    private String determineLanguage(String content, int start, int endOfStartLine) {
        String restOfLine = content.substring(start + 3, endOfStartLine);
        return restOfLine.trim().toLowerCase();
    }

    private String formatSource(String language, String source) {
        if (language.equals("java")) {
            return this.formatCode(source, "JavaLexer", "pygments.lexers.jvm", "java");
        }
        if (language.equals("kotlin")) {
            return this.formatCode(source, "KotlinLexer", "pygments.lexers.jvm", "kotlin");
        }
        if (language.equals("groovy")) {
            return this.formatCode(source, "GroovyLexer", "pygments.lexers.jvm", "groovy");
        }
        if (language.equals("scala")) {
            return this.formatCode(source, "ScalaLexer", "pygments.lexers.jvm", "scala");
        }
        if (language.equals("json")) {
            return this.formatCode(source, "JsonLexer", "pygments.lexers.data", "json");
        }
        if (language.equals("javascript")) {
            return this.formatCode(source, "JavascriptLexer", "pygments.lexers.javascript", "javascript");
        }
        if (language.equals("sql")) {
            return this.formatCode(source, "SqlLexer", "pygments.lexers.sql", "sql");
        }
        if (language.equals("xml")) {
            return this.formatCode(source, "XmlLexer", "pygments.lexers.html", "xml");
        }
        if (language.equals("properties")) {
            return this.formatCode(source, "PropertiesLexer", "pygments.lexers.configs", "properties");
        }
        if (language.equals("sh")) {
            return this.formatCode(source, "BashLexer", "pygments.lexers.shell", "sh");
        }
        return source;
    }

    protected String formatCode(String code2, String lexer, String lexerPackage, String language) {
        this.interpreter.set("code", code2);
        String fromClause = "from " + lexerPackage + " import " + lexer + "\n";
        String command = "from pygments import highlight\n" + fromClause + "from pygments.formatters import HtmlFormatter\n" + "\nresult = highlight(code, " + lexer + "(), HtmlFormatter())";
        this.interpreter.exec(command);
        String codeHighlighted = this.interpreter.get("result", String.class);
        return "<div class=\"syntax " + language + "\">" + codeHighlighted + "</div>";
    }
}

