/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.website.generator;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import org.avaje.website.generator.WatchDirCallback;
import org.avaje.website.generator.WatchDirSkip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchDir {
    private static final Logger log = LoggerFactory.getLogger(WatchDir.class);
    private final WatchService watcher = FileSystems.getDefault().newWatchService();
    private final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();
    private final boolean recursive;
    private boolean trace;
    private final WatchDirCallback callback;
    private final WatchDirSkip skipDir;

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    private void register(Path dir) throws IOException {
        WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        if (this.trace) {
            Path prev = this.keys.get(key);
            if (prev == null) {
                log.info("register: {}", (Object)dir);
            } else if (!dir.equals(prev)) {
                log.info("update: {} -> {}", (Object)prev, (Object)dir);
            }
        }
        this.keys.put(key, dir);
    }

    private void registerAll(Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (WatchDir.this.skipDir != null && WatchDir.this.skipDir.skip(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                WatchDir.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public WatchDir(Path dir, boolean recursive, WatchDirCallback callback) throws IOException {
        this(dir, recursive, callback, null);
    }

    public WatchDir(Path dir, boolean recursive, WatchDirCallback callback, WatchDirSkip skipDir) throws IOException {
        this.recursive = recursive;
        this.callback = callback;
        this.skipDir = skipDir;
        if (recursive) {
            log.info("Scanning {} ...", (Object)dir);
            this.registerAll(dir);
            log.info("Watching...");
        } else {
            this.register(dir);
        }
        this.trace = true;
    }

    public void processEvents() {
        while (true) {
            WatchKey key;
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException x) {
                return;
            }
            Path dir = this.keys.get(key);
            if (dir == null) {
                log.error("WatchKey {} not recognized!!", (Object)key);
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) {
                    log.error("OVERFLOW event is not handled");
                    continue;
                }
                WatchEvent<Path> ev = WatchDir.cast(event);
                Path name = (Path)ev.context();
                Path child = dir.resolve(name);
                if (this.callback != null) {
                    this.callback.event(ev, child, event.kind().toString());
                } else {
                    log.info(" event: {} {}", (Object)event.kind().name(), (Object)child);
                }
                if (!this.recursive || kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                try {
                    if (this.skipDir != null && this.skipDir.skip(child) || !Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) continue;
                    this.registerAll(child);
                }
                catch (IOException e) {
                    log.error("Error registering new directory", e);
                }
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.keys.remove(key);
            if (this.keys.isEmpty()) break;
        }
    }

    static void usage() {
        System.err.println("usage: java WatchDir [-r] dir");
        System.exit(-1);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0 || args.length > 2) {
            WatchDir.usage();
        }
        boolean recursive = false;
        int dirArg = 0;
        if (args[0].equals("-r")) {
            if (args.length < 2) {
                WatchDir.usage();
            }
            recursive = true;
            ++dirArg;
        }
        Path dir = Paths.get(args[dirArg], new String[0]);
        new WatchDir(dir, recursive, null, null).processEvents();
    }
}

