/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean;

import com.avaje.ebean.DelegateAwareEbeanServer;
import com.avaje.ebean.Ebean;
import com.avaje.ebean.EbeanServer;
import java.util.concurrent.Callable;

public class MockiEbean {
    protected final EbeanServer original;
    protected final EbeanServer mock;

    public static MockiEbean start(EbeanServer mock) {
        EbeanServer original = Ebean.mock((String)"$mock", (EbeanServer)mock, (boolean)true);
        if (mock instanceof DelegateAwareEbeanServer) {
            ((DelegateAwareEbeanServer)mock).withDelegateIfRequired(original);
        }
        return new MockiEbean(mock, original);
    }

    public static void runWithMock(EbeanServer mock, Runnable test) {
        MockiEbean.start(mock).run(test);
    }

    public static <V> V runWithMock(EbeanServer mock, Callable<V> test) throws Exception {
        return MockiEbean.start(mock).run(test);
    }

    protected MockiEbean(EbeanServer mock, EbeanServer original) {
        this.mock = mock;
        this.original = original;
    }

    public EbeanServer getOriginal() {
        return this.original;
    }

    public EbeanServer getMock() {
        return this.mock;
    }

    public void run(Runnable testRunnable) {
        try {
            this.beforeRun();
            testRunnable.run();
        }
        finally {
            this.afterRun();
            this.restoreOriginal();
        }
    }

    public <V> V run(Callable<V> testCallable) throws Exception {
        try {
            this.beforeRun();
            V v = testCallable.call();
            return v;
        }
        finally {
            this.afterRun();
            this.restoreOriginal();
        }
    }

    public void beforeRun() {
        if (this.mock instanceof DelegateAwareEbeanServer) {
            ((DelegateAwareEbeanServer)this.mock).beforeRun();
        }
    }

    public void afterRun() {
        if (this.mock instanceof DelegateAwareEbeanServer) {
            ((DelegateAwareEbeanServer)this.mock).afterRun();
        }
    }

    public void restoreOriginal() {
        if (this.original == null) {
            throw new IllegalStateException("Original EbeanServer instance is null");
        }
        if (this.original.getName() == null) {
            throw new IllegalStateException("Original EbeanServer name is null");
        }
        Ebean.mock((String)this.original.getName(), (EbeanServer)this.original, (boolean)true);
    }
}

